/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.FieldEdit;
import kd.fi.arapcommon.consts.BillTypeConsts;

public class ApFinBorrowControlPlugin
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setControl4Borrow();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setControl4Borrow();
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        String key = e.getProperty().getName();
        if ("billtypeid".equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"material", "e_materialname", "spectype", "e_assistantattr"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"expenseitem"});
        }
    }

    private void setControl4Borrow() {
        DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtypeid");
        if (billtype != null && BillTypeConsts.APFIN_BORROW.longValue() == billtype.getLong("id")) {
            String srcBillType = (String)this.getModel().getValue("sourcebilltype");
            OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
            if (ObjectUtils.isEmpty((Object)srcBillType) && (OperationStatus.ADDNEW.equals((Object)opStatus) || OperationStatus.EDIT.equals((Object)opStatus))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"material", "e_materialname", "spectype", "e_assistantattr", "e_materialversion"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"expenseitem"});
            } else if ("ar_finarbill".equals(srcBillType)) {
                Object material = this.getModel().getValue("material");
                Object expenseitem = this.getModel().getValue("expenseitem");
                if (material == null) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"material", "e_materialname", "spectype", "e_assistantattr", "e_materialversion"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"expenseitem"});
                }
            } else if ("ap_finapbill".equals(srcBillType)) {
                boolean isMaterialNull = true;
                boolean isExpenseItemNull = true;
                int entryRowCount = this.getModel().getEntryRowCount("detailentry");
                for (int i = 0; i < entryRowCount; ++i) {
                    Object material = this.getModel().getValue("material", i);
                    Object expenseItem = this.getModel().getValue("expenseitem", i);
                    if (material != null) {
                        isMaterialNull = false;
                    }
                    if (expenseItem != null) {
                        isExpenseItemNull = false;
                    }
                    if (!isMaterialNull && !isExpenseItemNull) break;
                }
                if (isMaterialNull) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"material", "e_materialname", "spectype", "e_assistantattr", "e_materialversion"});
                }
                if (isExpenseItemNull) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"expenseitem"});
                }
            }
        }
        if (billtype != null && BillTypeConsts.APFIN_PUR.longValue() == billtype.getLong("id")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"material", "e_materialname", "spectype", "e_assistantattr", "e_materialversion"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"expenseitem"});
            FieldEdit expense = (FieldEdit)this.getControl("expenseitem");
            expense.setMustInput(false);
        }
    }
}

