/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.BillTypeEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.enums.BillStatusEnum;
import kd.fi.ap.enums.DiscountModeEnum;
import kd.fi.ap.formplugin.ApBaseEdit;
import kd.fi.ap.formplugin.formservice.EnableHandlerFactory;
import kd.fi.ap.formplugin.formservice.IEnableHandler;
import kd.fi.ap.helper.ApHelper;
import kd.fi.ap.helper.FinapPremHelper;
import kd.fi.ap.util.DateUtils;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.ArApCorebillHelper;
import kd.fi.arapcommon.helper.ArApSettleTypeHelper;
import kd.fi.arapcommon.helper.AsstactHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.MaterialFilterHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.intertax.InterTaxGTEHelper;
import kd.fi.arapcommon.service.EditInBulkService;
import kd.fi.arapcommon.util.EmptyUtils;

@Deprecated
public class ApFinCoreBillEdit
extends ApBaseEdit {
    private boolean changed = true;
    private InitHelper init;
    private boolean onlyExit = false;
    private static final String[] HEAD = new String[]{"amount", "tax", "pricetaxtotal", "amountbase", "pricetaxtotalbase", "unverifyamount", "unsettleamount", "unsettleamountbase", "premiumamt", "premiumrate"};
    private static final String[] ENTRY = new String[]{"price", "taxrateid", "pricetax", "discountamount", "discountlocalamt", "actprice", "actpricetax", "e_tax", "e_amount", "e_amountbase", "e_pricetaxtotal", "e_pricetaxtotalbase", "verifyquantity", "unverifyquantity", "verifyamount", "e_unverifyamount", "lockedamt", "unlockamt", "settledamt", "settledamtbase", "unsettleamt", "unsettleamtbase"};
    private static final String[] PLANENTITY = new String[]{"planpricetax", "planpricetaxloc", "planlockedamt", "unplanlockamt", "plansettledamt", "plansettledlocamt", "unplansettleamt", "unplansettlelocamt"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillTypeEdit billType = (BillTypeEdit)this.getControl("billtypeid");
        billType.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (this.isPeriod()) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter qFilter = new QFilter("number", "<>", (Object)"ApFin_borr_BT_S");
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
        BasedataEdit materialF7 = (BasedataEdit)this.getControl("material");
        materialF7.addBeforeF7SelectListener(evt -> {
            DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtypeid");
            if (ObjectUtils.isEmpty((Object)billtype)) {
                return;
            }
            QFilter filter = "ApFin_pur_BT_S".equals(billtype.getString("number")) ? new QFilter("materialtype", "in", (Object)MaterialFilterHelper.getMaterialTypes()) : ("ApFin_service_BT_S".equals(billtype.getString("number")) ? new QFilter("materialtype", "=", (Object)"9") : new QFilter("materialtype", "=", (Object)"7"));
            ListFilterParameter parameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            parameter.getQFilters().add(filter);
        });
        this.filterMaterialVersion();
        this.addClickListeners(new String[]{"payeebanknum"});
        this.addClickListeners(new String[]{"corebilltype"});
        this.addClickListeners(new String[]{"corebillno"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    private void filterMaterialVersion() {
        BasedataEdit materialVersionF7 = (BasedataEdit)this.getControl("e_materialversion");
        materialVersionF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex("detailentry");
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", currentRow);
            if (!ObjectUtils.isEmpty((Object)material)) {
                long materialId = material.getLong("id");
                QFilter filter = new QFilter("material", "=", (Object)materialId);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        this.cacheIsPeriod();
        if (parameter.isInitialized()) {
            this.createNewModel();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        Object primaryKey;
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("viewsettle".equals(key)) {
            primaryKey = this.getModel().getDataEntity().getPkValue();
            QFilter notApTrans = new QFilter("settlerelation", "<>", (Object)SettleRelationEnum.PAYTRANS.getValue());
            notApTrans.and(new QFilter("settlerelation", "<>", (Object)SettleRelationEnum.PREMSETTLE.getValue()));
            boolean exists = QueryServiceHelper.exists((String)"ap_settlerecord", (QFilter[])new QFilter[]{new QFilter("mainbillid", "=", primaryKey).or(new QFilter("entry.billid", "=", primaryKey).and(notApTrans))});
            if (exists) {
                ListShowParameter parameter = new ListShowParameter();
                parameter.setBillFormId("ap_viewsettle");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setLookUp(true);
                parameter.setCustomParam("billId", primaryKey);
                parameter.setCustomParam("billEntity", (Object)"ap_finapbill");
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"ApFinCoreBillEdit_8", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
        } else if ("viewver".equals(key)) {
            primaryKey = this.getModel().getDataEntity().getPkValue();
            QFilter filter = new QFilter("billid", "=", primaryKey);
            filter.or(new QFilter("entry.e_billid", "=", primaryKey));
            boolean exists = QueryServiceHelper.exists((String)"ap_verifyrecord", (QFilter[])filter.toArray());
            if (exists) {
                ListShowParameter parameter = new ListShowParameter();
                parameter.setBillFormId("ap_verifyrecord");
                parameter.setLookUp(true);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setCustomParam("billId", primaryKey);
                parameter.setCustomParam("entity", (Object)"ap_finapbill");
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6838\u9500\u8bb0\u5f55\u3002", (String)"ApFinCoreBillEdit_9", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
        }
        if ("editsettingsinbulk".equals(key)) {
            EditInBulkService editInBulkService = new EditInBulkService(this.getView(), this.getPluginName());
            editInBulkService.showEditSettingsInBulk();
        }
        if ("editinbulk".equals(key)) {
            boolean includeTax = (Boolean)this.getModel().getValue("isincludetax");
            if (includeTax) {
                EditInBulkService editInBulkService = new EditInBulkService(this.getView(), this.getPluginName());
                editInBulkService.showEditInBulk();
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u542b\u7a0e\u573a\u666f\u6682\u4e0d\u652f\u6301\uff0c\u6807\u51c6\u4ea7\u54c1\u5145\u5206\u8c03\u7814\u540e\u518d\u652f\u6301\u3002", (String)"ApFinCoreBillEdit_20", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.cacheIsPeriod();
        this.create4Copy();
        this.getModel().setDataChanged(true);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.cacheIsPeriod();
        DynamicObject srcCurrency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject destCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (destCurrency != null && srcCurrency != null) {
            long srcCurrencyId = srcCurrency.getLong("id");
            long destCurrencyId = destCurrency.getLong("id");
            this.getView().setEnable(Boolean.valueOf(srcCurrencyId != destCurrencyId), new String[]{"exchangerate"});
        }
    }

    @Override
    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        int entryRowCount = this.getModel().getEntryRowCount("detailentry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject baseUnit;
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", i);
            DynamicObject measureUnit = (DynamicObject)this.getModel().getValue("measureunit", i);
            if (material == null || measureUnit == null || (baseUnit = material.getDynamicObject("baseunit")) == null) continue;
            this.getModel().setValue("e_baseunit", baseUnit.getPkValue(), i);
            long baseUnitID = (Long)baseUnit.getPkValue();
            long measureUnitID = (Long)measureUnit.getPkValue();
            long materialID = (Long)material.getPkValue();
            BigDecimal quantity = (BigDecimal)this.getModel().getValue("quantity", i);
            BigDecimal convertRate = UnitConvertHelper.getUnitRateConv((Long)materialID, (Long)measureUnitID, (Long)baseUnitID);
            if (convertRate != null && quantity != null) {
                this.getModel().setValue("e_unitconvertrate", (Object)convertRate, i);
                this.getModel().setValue("e_baseunitqty", (Object)quantity.multiply(convertRate), i);
                continue;
            }
            this.getModel().setValue("e_unitconvertrate", (Object)1, i);
            this.getModel().setValue("e_baseunitqty", (Object)quantity, i);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "payeebanknum": {
                this.assacctShowF7();
                break;
            }
            case "corebillno": {
                this.showCoreBillF7();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Object returnData = e.getReturnData();
        switch (id) {
            case "assaccount": {
                this.closeassaccountF7(returnData);
                break;
            }
            case "coreBill": {
                ArApCorebillHelper.closeCoreBillF7((IDataModel)this.getModel(), (String)"detailentry", (Object)returnData);
                break;
            }
            case "editinbulk": {
                Map returnMap = (Map)returnData;
                if (ObjectUtils.isEmpty((Object)returnMap)) {
                    return;
                }
                DynamicObjectCollection returnEntrys = (DynamicObjectCollection)returnMap.get("entrys");
                Map srcEntryRowMap = (Map)returnMap.get("srcEntryRowMap");
                EditInBulkService editInBulkService = new EditInBulkService(this.getView(), this.getPluginName());
                editInBulkService.returnFillParent(returnEntrys, srcEntryRowMap);
                this.calculateAmt(this.getModel(), -1);
                DynamicObject basecurrency = (DynamicObject)this.getModel().getValue("basecurrency");
                int localprecision = basecurrency.getInt("amtprecision");
                BigDecimal rate = (BigDecimal)this.getModel().getValue("exchangerate");
                editInBulkService.calculateLastRow(returnEntrys, srcEntryRowMap, rate, localprecision);
                this.calculatorHeadAmt();
                this.getPageCache().put("iseditinbulk", "true");
                this.getView().updateView();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if (Objects.equals("writeoff", key)) {
            this.verifyAccess(args);
        } else if (Objects.equals("billmodify", key) && FinapPremHelper.isFinPrem((DynamicObject)this.getModel().getDataEntity())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u5355\u636e\u65e0\u6cd5\u8c03\u6574\u3002", (String)"ApFinCoreBillEdit_11", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void closeassaccountF7(Object returnData) {
        String assacttype = this.getModel().getValue("asstacttype").toString();
        ListSelectedRowCollection returnColl = (ListSelectedRowCollection)returnData;
        if (!ObjectUtils.isEmpty((Object)returnColl)) {
            ListSelectedRow rowInfo = returnColl.get(0);
            Object entryKey = rowInfo.getEntryPrimaryKeyValue();
            Object pk = rowInfo.getPrimaryKeyValue();
            if (assacttype.equals("bd_customer") || assacttype.equals("bd_supplier")) {
                DynamicObject cutstomer = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)assacttype, (String)"bankaccount,accountname,bank,name,entry_bank");
                DynamicObjectCollection bankEntry = cutstomer.getDynamicObjectCollection("entry_bank");
                for (DynamicObject row : bankEntry) {
                    if (!row.getPkValue().equals(entryKey)) continue;
                    String actName = row.getLocaleString("accountname").getLocaleValue();
                    if (!ApHelper.isEmpty((Object)actName)) {
                        actName = cutstomer.getLocaleString("name").getLocaleValue();
                    }
                    this.getModel().setValue("payeebanknum", (Object)row.getString("bankaccount"));
                    this.getModel().setValue("bebank", (Object)row.getLong("bank.id"));
                    break;
                }
            } else if (assacttype.equals("bos_user")) {
                DynamicObject payeerInfo = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"er_payeer", (String)"id,payerbank,payeraccount");
                if (!ObjectUtils.isEmpty((Object)payeerInfo)) {
                    this.getModel().setValue("payeebanknum", (Object)payeerInfo.getString("payeraccount"));
                    this.getModel().setValue("bebank", (Object)payeerInfo.getLong("payerbank"));
                }
            } else {
                DynamicObject account = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"bd_accountbanks", (String)"id,bankaccountnumber,bank.id,bank.bebank");
                if (!ObjectUtils.isEmpty((Object)account)) {
                    this.getModel().setValue("payeebanknum", (Object)account.getString("bankaccountnumber"));
                    this.getModel().setValue("bebank", account.getDynamicObject("bank.bebank").getPkValue());
                }
            }
        }
    }

    private void assacctShowF7() {
        DynamicObject basedata = (DynamicObject)this.getModel().getValue("asstact");
        AsstactHelper.assacctShowF7((DynamicObject)basedata, (IFormView)this.getView(), (String)this.getPluginName());
    }

    private void showCoreBillF7() {
        int currrow = this.getModel().getEntryCurrentRowIndex("detailentry");
        String corebilltype = (String)this.getModel().getValue("corebilltype", currrow);
        ArApCorebillHelper.showCoreBillF7((String)corebilltype, (IFormView)this.getView(), (String)this.getPluginName());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int index = changeData[0].getRowIndex();
        IDataModel m = this.getModel();
        switch (key) {
            case "org": {
                this.orgF7Changed(newValue);
                break;
            }
            case "currency": {
                int n;
                if (newValue == null) {
                    m.setValue("currency", oldValue);
                    return;
                }
                if (ObjectUtils.isEmpty((Object)oldValue)) {
                    return;
                }
                int o = ((DynamicObject)oldValue).getInt("priceprecision");
                if (o > (n = ((DynamicObject)newValue).getInt("priceprecision"))) {
                    for (int i = 0; i < this.getModel().getEntryRowCount("detailentry"); ++i) {
                        this.initPrice(this.getModel(), o, n, i);
                    }
                }
                this.controlAmtFieldVisibility();
                this.setExchange(newValue, oldValue);
                break;
            }
            case "exratedate": {
                if (Objects.isNull(newValue)) {
                    m.setValue("exratedate", (Object)new Date());
                    return;
                }
                this.setExchange(newValue, oldValue);
                break;
            }
            case "exratetable": {
                if (!ObjectUtils.isEmpty((Object)newValue)) {
                    this.setExchange(newValue, oldValue);
                    break;
                }
                m.setValue("exratetable", oldValue);
                break;
            }
            case "exchangerate": {
                this.calculateAmt(m, -1);
                break;
            }
            case "quantity": {
                if (this.changed) {
                    this.entryAmount(e, newValue, oldValue, index);
                    this.calculateBaseQty();
                }
                int i = changeData[0].getRowIndex();
                this.getModel().setValue("unverifyquantity", this.getModel().getValue("quantity", i), i);
                this.getModel().setValue("verifyquantity", (Object)((BigDecimal)this.getModel().getValue("quantity", i)).subtract((BigDecimal)this.getModel().getValue("unverifyquantity", i)), i);
                break;
            }
            case "price": {
                if (!this.changed) break;
                this.entryAmount(e, newValue, oldValue, index);
                break;
            }
            case "bizdate": {
                this.bizDateChanged(e, newValue, oldValue);
                break;
            }
            case "taxrate": {
                if (!this.changed) break;
                this.entryAmount(e, newValue, oldValue, index);
                break;
            }
            case "discountrate": {
                if (!this.changed) break;
                this.entryAmount(e, newValue, oldValue, index);
                break;
            }
            case "discountmode": {
                if (!this.changed) break;
                this.entryAmount(e, newValue, oldValue, index);
                break;
            }
            case "discountamount": {
                this.setEntryLocalAmt(index, newValue, "discountlocalamt");
                break;
            }
            case "ispresent": {
                this.entryAmountToZero(index);
                break;
            }
            case "asstact": {
                this.asstactChanged(e, newValue);
                String asstactType = (String)m.getValue("asstacttype");
                DynamicObject asstact = (DynamicObject)m.getValue("asstact");
                if (ObjectUtils.isEmpty((Object)asstact)) {
                    return;
                }
                long asstactSettleTypeId = ArApSettleTypeHelper.getAsstactSettleType((String)asstactType, (long)asstact.getLong("id"));
                if (asstactSettleTypeId == 0L) {
                    return;
                }
                m.setValue("settlementtype", (Object)asstactSettleTypeId);
                break;
            }
            case "settlementtype": {
                DynamicObject headSettleType = (DynamicObject)m.getValue("settlementtype");
                if (ObjectUtils.isEmpty((Object)headSettleType)) {
                    return;
                }
                int planCount = m.getEntryRowCount("planentity");
                for (int j = 0; j < planCount; ++j) {
                    m.setValue("plansettletype", (Object)headSettleType.getLong("id"), j);
                }
                break;
            }
            case "billstatus": {
                this.fillToolBar();
                break;
            }
            case "material": {
                this.materialChanged(changeData);
                break;
            }
            case "measureunit": {
                this.calculateBaseQty();
                break;
            }
            case "verifyamount": {
                if (!this.changed) break;
                this.entryVerAmt(index, newValue, "e_unverifyamount");
                break;
            }
            case "e_unverifyamount": {
                if (!this.changed) break;
                this.entryVerAmt(index, newValue, "verifyamount");
                break;
            }
            case "unsettleamt": {
                if (this.changed) {
                    this.entryVerAmt(index, newValue, "settledamt");
                }
                this.setLockamt(index, newValue, "unlockamt");
                this.setEntryLocalAmt(index, newValue, "unsettleamtbase");
                break;
            }
            case "settledamt": {
                if (this.changed) {
                    this.entryVerAmt(index, newValue, "unsettleamt");
                }
                this.setLockamt(index, newValue, "lockedamt");
                this.setEntryLocalAmt(index, newValue, "settledamtbase");
                break;
            }
            case "e_pricetaxtotal": {
                this.setEntryLocalAmt(index, newValue, "e_pricetaxtotalbase");
                BigDecimal pricetaxtotal = (BigDecimal)newValue;
                this.getModel().setValue("unsettleamt", (Object)pricetaxtotal, index);
                this.calculatorHeadAmt();
                break;
            }
            case "e_amount": {
                this.setEntryLocalAmt(index, newValue, "e_amountbase");
                int entryrow = this.getModel().getEntryCurrentRowIndex("detailentry");
                this.getModel().setValue("e_unverifyamount", newValue, entryrow);
                this.calculatorHeadAmt();
                break;
            }
            case "pricetaxtotal": {
                this.setHeadLocalAmt("pricetaxtotalbase", (BigDecimal)newValue);
                break;
            }
            case "unsettleamount": {
                this.setHeadLocalAmt("unsettleamountbase", (BigDecimal)newValue);
                break;
            }
            case "amount": {
                this.setHeadLocalAmt("amountbase", (BigDecimal)newValue);
                break;
            }
            case "isincludetax": {
                this.changeIsIncludeTax((Boolean)newValue);
                break;
            }
            case "pricetax": {
                if (!this.changed) break;
                this.entryAmount(e, newValue, oldValue, index);
                break;
            }
            case "e_tax": {
                this.calculateAmt(m, index);
                break;
            }
            case "isfx": {
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("detailentry");
                for (int j = 0; j < entrys.size(); ++j) {
                    if (!((DynamicObject)entrys.get(j)).getBoolean("ispresent")) continue;
                    this.getView().setEnable(Boolean.FALSE, j, new String[]{"e_amount", "e_tax", "e_pricetaxtotal"});
                }
                break;
            }
            case "premiumamt": {
                this.premiumamtChanged(newValue);
                break;
            }
            case "premiumrate": {
                this.premiumRateChanged(newValue);
            }
        }
        InterTaxGTEHelper interTaxGTEHelper = new InterTaxGTEHelper(this.getView(), e);
        interTaxGTEHelper.propertyChanged_taxentry();
    }

    private void premheadAmountChanged(BigDecimal newValue) {
        if (newValue.compareTo(BigDecimal.ZERO) != 0) {
            DecimalFormat df = new DecimalFormat("#.00");
            BigDecimal premiumAmt = (BigDecimal)this.getModel().getValue("premiumamt");
            BigDecimal premiumRate = premiumAmt.multiply(new BigDecimal(100).divide(newValue, 10, RoundingMode.HALF_UP));
            this.getModel().setValue("premiumrate", (Object)df.format(premiumRate));
        } else {
            this.getModel().setValue("premiumamt", (Object)BigDecimal.ZERO);
            this.getModel().setValue("premiumrate", (Object)BigDecimal.ZERO);
        }
    }

    private void calculateAmt(IDataModel m, int index) {
        m.beginInit();
        if (index != -1) {
            if (!((Boolean)this.getModel().getValue("isfx")).booleanValue()) {
                this.calculatorEntryAmt(m, index);
            }
        } else {
            for (int i = 0; i < m.getEntryRowCount("detailentry"); ++i) {
                this.calculatorEntryAmt(m, i);
            }
        }
        m.endInit();
        this.calculatorHeadAmt();
        IFormView v = this.getView();
        if (index != -1) {
            for (String e : ENTRY) {
                v.updateView(e, index);
            }
        } else {
            for (int i = 0; i < m.getEntryRowCount("detailentry"); ++i) {
                String[] stringArray = ENTRY;
                int n = stringArray.length;
                for (int e = 0; e < n; ++e) {
                    String e2 = stringArray[e];
                    v.updateView(e2, i);
                }
            }
        }
        for (String h : HEAD) {
            v.updateView(h);
        }
        for (int i = 0; i < m.getEntryRowCount("planentity"); ++i) {
            for (String p : PLANENTITY) {
                v.updateView(p, i);
            }
        }
    }

    private void initPrice(IDataModel m, int oldPriceprecision, int newPriceprecision, int currentRow) {
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        if (includeTax) {
            BigDecimal oldtaxunitprice = (BigDecimal)m.getValue("pricetax", currentRow);
            m.setValue("pricetax", (Object)oldtaxunitprice.setScale(newPriceprecision, RoundingMode.DOWN), currentRow);
        } else {
            BigDecimal oldUnitprice = (BigDecimal)m.getValue("price", currentRow);
            m.setValue("price", (Object)oldUnitprice.setScale(newPriceprecision, RoundingMode.DOWN), currentRow);
        }
    }

    private void premiumamtChanged(Object newValue) {
        BigDecimal premiumRate = (BigDecimal)this.getModel().getValue("premiumrate");
        if (newValue == null) {
            premiumRate = BigDecimal.ZERO;
        } else {
            if (this.changed) {
                this.changed = false;
                BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("pricetaxtotal");
                if (totalAmt.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal premiumAmt = (BigDecimal)newValue;
                    DecimalFormat df = new DecimalFormat("#.00");
                    premiumRate = premiumAmt.multiply(new BigDecimal(100).divide(totalAmt, 10, RoundingMode.HALF_UP));
                    this.getModel().setValue("premiumrate", (Object)df.format(premiumRate));
                }
            }
            int detailEntryCount = this.getModel().getEntryRowCount("detailentry");
            for (int j = 0; j < detailEntryCount; ++j) {
                this.getModel().setValue("e_premiumrate", (Object)premiumRate.multiply(new BigDecimal(100)), j);
            }
        }
    }

    private void premiumRateChanged(Object newValue) {
        Object totalAmt;
        if (newValue == null) {
            this.getModel().setValue("premiumamt", (Object)0);
        } else if (this.changed && (totalAmt = this.getModel().getValue("pricetaxtotal")) != null) {
            BigDecimal priceTaxTotal = (BigDecimal)totalAmt;
            BigDecimal premiumRate = (BigDecimal)newValue;
            this.getModel().setValue("premiumamt", (Object)priceTaxTotal.multiply(premiumRate.divide(new BigDecimal(100))));
        }
    }

    private void setExchange(Object newValue, Object oldValue) {
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        DynamicObject srcCurrency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject destCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        DynamicObject exratetable = (DynamicObject)this.getModel().getValue("exratetable");
        Date exrateDate = (Date)this.getModel().getValue("exratedate");
        if (destCurrency == null || srcCurrency == null || exratetable == null) {
            return;
        }
        long srcCurrencyId = srcCurrency.getLong("id");
        long destCurrencyId = destCurrency.getLong("id");
        long exratetableId = exratetable.getLong("id");
        this.getView().setEnable(Boolean.valueOf(srcCurrencyId != destCurrencyId), new String[]{"exchangerate"});
        BigDecimal exchangeRate = BaseDataHelper.getExchangeRate((Long)exratetableId, (Long)srcCurrencyId, (Long)destCurrencyId, (Date)exrateDate);
        this.getModel().setValue("exchangerate", (Object)exchangeRate);
        if (exchangeRate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"ApFinCoreBillEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
    }

    private void controlAmtFieldVisibility() {
        boolean currencyDifferent = this.isCurrencyDifferent();
        this.getView().setVisible(Boolean.valueOf(currencyDifferent), this.defineLocalAmtFields().toArray(new String[0]));
    }

    private boolean isCurrencyDifferent() {
        return true;
    }

    private List<String> defineLocalAmtFields() {
        ArrayList<String> localAmtFields = new ArrayList<String>();
        localAmtFields.add("pricetaxtotalbase");
        localAmtFields.add("amountbase");
        localAmtFields.add("unsettleamountbase");
        localAmtFields.add("e_amountbase");
        localAmtFields.add("e_pricetaxtotalbase");
        localAmtFields.add("settledamtbase");
        localAmtFields.add("unsettleamtbase");
        localAmtFields.add("planpricetaxloc");
        localAmtFields.add("plansettledlocamt");
        localAmtFields.add("unplansettlelocamt");
        localAmtFields.add("discountlocalamt");
        return localAmtFields;
    }

    private void calculateBaseQty() {
        int rowIndex;
        IDataModel model = this.getModel();
        DynamicObject measureUnit = (DynamicObject)model.getValue("measureunit", rowIndex = model.getEntryCurrentRowIndex("detailentry"));
        if (measureUnit == null) {
            return;
        }
        DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
        if (material == null) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)model.getValue("e_baseunit", rowIndex);
        if (baseUnit == null && (baseUnit = material.getDynamicObject("baseunit")) != null) {
            model.setValue("e_baseunit", baseUnit.getPkValue(), rowIndex);
        }
        if (baseUnit == null) {
            return;
        }
        long baseUnitID = (Long)baseUnit.getPkValue();
        long measureUnitID = (Long)measureUnit.getPkValue();
        long materialID = (Long)material.getPkValue();
        BigDecimal convertRate = UnitConvertHelper.getUnitRateConv((Long)materialID, (Long)measureUnitID, (Long)baseUnitID);
        BigDecimal quantity = (BigDecimal)model.getValue("quantity", rowIndex);
        if (convertRate != null) {
            model.setValue("e_unitconvertrate", (Object)convertRate, rowIndex);
            if (quantity != null) {
                model.setValue("e_baseunitqty", (Object)convertRate.multiply(quantity), rowIndex);
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        DynamicObject asstact;
        BillShowParameter parameter;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        if (this.init == null) {
            this.init = new InitHelper(org.getLong("id"), "ap_init");
        }
        boolean isBotpNew = this.isBotpNew();
        boolean isPeriod = this.isPeriod();
        String sourceBillType = this.getModel().getDataEntity().getString("sourcebilltype");
        if (isBotpNew) {
            String iseditinbulk;
            isPeriod = this.init.isFinishInit() ? false : (Boolean)this.getModel().getValue("isperiod");
            this.getModel().setValue("isperiod", (Object)isPeriod);
            this.verifyInit(isPeriod);
            if (!"ap_finapbill".equals(sourceBillType) && !"true".equals(iseditinbulk = this.getPageCache().get("iseditinbulk"))) {
                IDataModel m = this.getModel();
                this.calculateAmt(m, -1);
            }
        }
        if ((parameter = (BillShowParameter)this.getView().getFormShowParameter()).getStatus() != OperationStatus.ADDNEW) {
            this.cacheIsPeriod();
            this.fillToolBar();
            DateEdit bizdate = (DateEdit)this.getControl("bizdate");
            if (((Boolean)model.getValue("isperiod")).booleanValue()) {
                Date startDate = this.init.getStartDate();
                bizdate.setMaxDate(DateUtils.getLastDay((Date)startDate, (int)1));
            } else {
                Date currentDate = this.init.getCurrentDate();
                if (ObjectUtils.isEmpty((Object)currentDate)) {
                    currentDate = this.init.getStartDate();
                }
                bizdate.setMinDate(currentDate);
            }
            this.changeIsIncludeTax((Boolean)this.getModel().getValue("isincludetax"));
            this.setEntryEnable(!this.checkIsPresent());
        }
        this.setLocalAmt();
        if ("ap_invoice".equals(sourceBillType)) {
            IFormView view = this.getView();
            view.setEnable(Boolean.FALSE, new String[]{"newentry"});
            view.setEnable(Boolean.FALSE, new String[]{"deleteentry"});
            view.setEnable(Boolean.FALSE, new String[]{"moveentryup"});
            view.setEnable(Boolean.FALSE, new String[]{"moveentrydown"});
        }
        this.fillToolBar();
        if (!this.isPeriod()) {
            this.writeOff(false);
            IEnableHandler handler = EnableHandlerFactory.getHandler(sourceBillType, this.getView());
            handler.execute();
        }
        if ((asstact = (DynamicObject)this.getModel().getValue("asstact")) != null) {
            this.getModel().setValue("asstactname", (Object)asstact.getLocaleString("name"));
        }
        this.controlAmtFieldVisibility();
        Date billDate = (Date)this.getModel().getValue("bizdate");
        if (billDate != null) {
            DateEdit date = (DateEdit)this.getControl("premduedate");
            date.setMinDate(billDate);
        }
        if (this.isOtherPay() && !"cas_recbill".equals(sourceBillType)) {
            BasedataEdit expenseItemEdit = (BasedataEdit)this.getControl("expenseitem");
            expenseItemEdit.setMustInput(true);
        }
    }

    private boolean isOtherPay() {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtypeid");
        if (billType == null) {
            return false;
        }
        return BillTypeConsts.APFIN_OTR.longValue() == billType.getLong("id");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean isWrittenOff;
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("submit".equals(key) || "unsubmit".equals(key) || "save".equals(key) || "unaudit".equals(key) || "audit".equals(key)) {
            this.fillToolBar();
        }
        if (Objects.equals(key, "save") && (isWrittenOff = ((Boolean)this.getModel().getValue("iswrittenoff")).booleanValue())) {
            this.writeOff(true);
            this.getView().invokeOperation("refresh");
            this.getModel().setDataChanged(false);
            IFormView parentView = this.getView().getParentView();
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
        if ("transpay".equals(key) && args.getOperationResult().isSuccess()) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("transferpaybill");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam("pkIds", (Object)args.getOperationResult().getSuccessPkIds());
            this.getView().showForm(fsp);
        }
        if ("unaudit".equals(key)) {
            this.getView().invokeOperation("refresh");
        }
        InterTaxGTEHelper interTaxGTEHelper = new InterTaxGTEHelper(this.getView(), key);
        interTaxGTEHelper.afterDoOperation();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        int count = this.getModel().getEntryRowCount("detailentry");
        if (count < 1) {
            this.getModel().createNewEntryRow("detailentry");
            return;
        }
        this.calculatorHeadAmt();
    }

    private void createNewModel() {
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ApFinCoreBillEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            this.onlyExit = true;
            return;
        }
        long orgId = (Long)org.getPkValue();
        if (this.init == null) {
            this.init = new InitHelper(orgId, "ap_init");
        }
        if (ObjectUtils.isEmpty((Object)this.init.getStartDate())) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u201c%s\u201d\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"ApFinCoreBillEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()});
            this.getView().showErrorNotification(msg);
            this.onlyExit = true;
            return;
        }
        boolean flag = true;
        boolean isPeriod = this.isPeriod();
        boolean isFinishInit = this.init.isFinishInit();
        if (isPeriod) {
            this.getModel().setValue("isperiod", (Object)Boolean.TRUE);
            flag = this.verify4Period(org, isFinishInit);
        } else {
            flag = this.verify4NoPeriod(org, isFinishInit);
        }
        boolean bl = this.onlyExit = !flag;
        if (flag) {
            if (org.getBoolean("fisbankroll")) {
                model.setValue("payorg", (Object)orgId);
            }
            if (org.getBoolean("fispurchase")) {
                model.setValue("purorg", (Object)orgId);
            }
            DynamicObject cur = this.init.getStandardCurrency();
            this.getModel().setValue("currency", cur.getPkValue());
            this.getModel().setValue("basecurrency", cur.getPkValue());
            this.getModel().setValue("exchangerate", (Object)1);
            this.getView().setEnable(Boolean.FALSE, new String[]{"exchangerate"});
            this.getModel().setValue("exratetable", this.init.getExrateTable().getPkValue());
            long settleTypeId = ArApSettleTypeHelper.getDefaultSettleType();
            if (settleTypeId != 0L) {
                this.getModel().setValue("settlementtype", (Object)settleTypeId);
                this.getModel().setValue("plansettletype", (Object)settleTypeId, 0);
            }
            this.changeIsIncludeTax((Boolean)this.getModel().getValue("isincludetax"));
            this.fillToolBar();
        }
    }

    protected boolean verifyInit(boolean isPeriod) {
        boolean flag = true;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ApFinCoreBillEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            flag = false;
        } else {
            long orgId = (Long)org.getPkValue();
            if (this.init == null) {
                this.init = new InitHelper(orgId, "ap_init");
            }
            boolean isFinishInit = this.init.isFinishInit();
            if (isPeriod) {
                this.getModel().setValue("isperiod", (Object)Boolean.TRUE);
                flag = this.verify4Period(org, isFinishInit);
            } else {
                flag = this.verify4NoPeriod(org, isFinishInit);
            }
        }
        this.onlyExit = !flag;
        return flag;
    }

    private void create4Copy() {
        IBillModel model = (IBillModel)this.getModel();
        if (this.verifyInit(this.isPeriod())) {
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            DynamicObject baseCurrency = (DynamicObject)model.getValue("basecurrency");
            if (currency != null && baseCurrency != null) {
                this.getView().setEnable(Boolean.valueOf(currency.getLong("id") != baseCurrency.getLong("id")), new String[]{"exchangerate"});
            }
            BigDecimal headTotalPriceTax = (BigDecimal)model.getValue("pricetaxtotal");
            BigDecimal headTotalPrice = (BigDecimal)model.getValue("amount");
            BigDecimal exchangerate = (BigDecimal)model.getValue("exchangerate");
            model.setValue("unsettleamount", (Object)headTotalPriceTax);
            model.setValue("unsettleamountbase", (Object)headTotalPriceTax.multiply(exchangerate));
            model.setValue("unverifyamount", (Object)headTotalPrice);
            int count = model.getEntryRowCount("detailentry");
            for (int i = 0; i < count; ++i) {
                BigDecimal entryTotalPriceTax = (BigDecimal)model.getValue("e_pricetaxtotal", i);
                BigDecimal entryamount = (BigDecimal)model.getValue("e_amount", i);
                BigDecimal quantity = (BigDecimal)model.getValue("quantity", i);
                model.setValue("unverifyquantity", (Object)quantity, i);
                model.setValue("unlockamt", (Object)entryTotalPriceTax, i);
                model.setValue("unlockamt", (Object)entryTotalPriceTax, i);
                model.setValue("unsettleamt", (Object)entryTotalPriceTax, i);
                model.setValue("unsettleamtbase", (Object)entryTotalPriceTax.multiply(exchangerate), i);
                model.setValue("e_unverifyamount", (Object)entryamount, i);
            }
            this.fillToolBar();
        }
    }

    private void changeIsIncludeTax(boolean enable) {
        int i = this.getModel().getEntryRowCount("detailentry");
        for (int r = 0; r < i; ++r) {
            this.getView().setEnable(Boolean.valueOf(!enable), i, new String[]{"price"});
            this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"pricetax"});
        }
    }

    private void orgF7Changed(Object newValue) {
        this.verifyInit(this.isPeriod());
    }

    private void setLocalAmt() {
        DynamicObject srcCurrency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject destCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (destCurrency != null && srcCurrency != null) {
            this.getView().setVisible(Boolean.valueOf(srcCurrency.getLong("id") != destCurrency.getLong("id")), new String[]{"amountbase", "pricetaxtotalbase", "unsettleamountbase", "discountlocalamt", "e_amountbase", "e_pricetaxtotalbase", "unsettleamtbase", "settledamtbase", "planpricetaxloc", "unplansettlelocamt", "plansettledlocamt"});
        }
    }

    private void setHeadLocalAmt(String headField, BigDecimal newValue) {
        BigDecimal rate = this.getExRate();
        this.getModel().setValue(headField, (Object)rate.multiply(newValue));
    }

    private BigDecimal getExRate() {
        BigDecimal rate = (BigDecimal)this.getModel().getValue("exchangerate");
        if (rate == null) {
            rate = BigDecimal.ONE;
        }
        return rate;
    }

    private void entryAmount(PropertyChangedArgs e, Object newValue, Object oldValue, int i) {
        IDataModel m = this.getModel();
        this.changed = false;
        if (e.getProperty().getName().equals("discountrate") || e.getProperty().getName().equals("discountmode")) {
            BigDecimal discountrate = (BigDecimal)m.getValue("discountrate", i);
            if (discountrate.compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6b63\u6570\u3002", (String)"ApFinCoreBillEdit_4", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                m.setValue("discountrate", oldValue, i);
                return;
            }
            if (DiscountModeEnum.PERCENT.getValue().equals(this.getModel().getValue("discountmode")) && discountrate.compareTo(new BigDecimal(100)) > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4e0d\u8d85\u8fc7100\u7684\u6570\u5b57\u3002", (String)"ApFinCoreBillEdit_5", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                m.setValue("discountrate", (Object)BigDecimal.ZERO, i);
                return;
            }
            if (DiscountModeEnum.NULL.getValue().equals(this.getModel().getValue("discountmode"))) {
                m.setValue("discountrate", (Object)BigDecimal.ZERO, i);
            }
        }
        this.calculateAmt(m, i);
    }

    private boolean checkIsPresent() {
        int i = this.getModel().getEntryCurrentRowIndex("detailentry");
        return (Boolean)this.getModel().getValue("ispresent", i);
    }

    private void calculatorEntryAmt(IDataModel m, int index) {
        PriceLocalCalculator localCalculator = null;
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        DynamicObject currency = (DynamicObject)m.getValue("currency");
        if (currency == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u7ed3\u7b97\u5e01\u3002", (String)"ApFinCoreBillEdit_12", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        int precision = currency.getInt("amtprecision");
        DynamicObject basecurrency = (DynamicObject)m.getValue("basecurrency");
        int localprecision = basecurrency.getInt("amtprecision");
        BigDecimal rate = (BigDecimal)m.getValue("exchangerate");
        BigDecimal qty = (BigDecimal)m.getValue("quantity", index);
        BigDecimal taxRate = (BigDecimal)m.getValue("taxrate", index);
        String discountMode = (String)m.getValue("discountmode", index);
        BigDecimal discountRate = (BigDecimal)m.getValue("discountrate", index);
        TaxUnitPriceCalculator calculator = null;
        if (includeTax) {
            BigDecimal taxUnitPrice = (BigDecimal)m.getValue("pricetax", index);
            calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision);
        } else {
            BigDecimal unitPrice = (BigDecimal)m.getValue("price", index);
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision);
        }
        localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, localprecision);
        localCalculator.calculate();
        this.resetEntryProp(m, localCalculator, index);
    }

    private void resetEntryProp(IDataModel m, PriceLocalCalculator localCalculator, int index) {
        m.setValue("pricetax", (Object)localCalculator.getTaxunitprice(), index);
        m.setValue("actprice", (Object)localCalculator.getActunitprice(), index);
        m.setValue("actpricetax", (Object)localCalculator.getActtaxunitprice(), index);
        BigDecimal amount = localCalculator.getAmount();
        m.setValue("e_amount", (Object)amount, index);
        m.setValue("e_amountbase", (Object)localCalculator.getAmountlocal(), index);
        m.setValue("e_tax", (Object)localCalculator.getTax(), index);
        m.setValue("discountamount", (Object)localCalculator.getDiscountamount(), index);
        BigDecimal recamount = localCalculator.getPricetaxtotal();
        m.setValue("e_pricetaxtotal", (Object)recamount, index);
        BigDecimal reclocalamt = localCalculator.getPricetaxtotallocal();
        m.setValue("e_pricetaxtotalbase", (Object)reclocalamt, index);
        m.setValue("e_unverifyamount", (Object)amount, index);
        m.setValue("unlockamt", (Object)recamount, index);
        m.setValue("unsettleamt", (Object)recamount, index);
        m.setValue("unsettleamtbase", (Object)reclocalamt, index);
        m.setValue("discountlocalamt", (Object)localCalculator.getDiscountamountlocal(), index);
        m.setValue("price", (Object)localCalculator.getUnitprice(), index);
    }

    protected void calculatorHeadAmt() {
        int count = this.getModel().getEntryRowCount("detailentry");
        BigDecimal sumunveramt = BigDecimal.ZERO;
        BigDecimal sumunsettleamt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
        BigDecimal unsettleamtbase = BigDecimal.ZERO;
        BigDecimal amountbase = BigDecimal.ZERO;
        for (int i = 0; i < count; ++i) {
            sumunveramt = sumunveramt.add((BigDecimal)this.getModel().getValue("e_unverifyamount", i));
            sumunsettleamt = sumunsettleamt.add((BigDecimal)this.getModel().getValue("unsettleamt", i));
            amount = amount.add((BigDecimal)this.getModel().getValue("e_amount", i));
            taxAmount = taxAmount.add((BigDecimal)this.getModel().getValue("e_tax", i));
            pricetaxtotal = pricetaxtotal.add((BigDecimal)this.getModel().getValue("e_pricetaxtotal", i));
            pricetaxtotalbase = pricetaxtotalbase.add((BigDecimal)this.getModel().getValue("e_pricetaxtotalbase", i));
            unsettleamtbase = unsettleamtbase.add((BigDecimal)this.getModel().getValue("unsettleamtbase", i));
            amountbase = amountbase.add((BigDecimal)this.getModel().getValue("e_amountbase", i));
        }
        this.getModel().setValue("unverifyamount", (Object)sumunveramt);
        this.getModel().setValue("unsettleamount", (Object)sumunsettleamt);
        this.getModel().setValue("amount", (Object)amount);
        this.getModel().setValue("tax", (Object)taxAmount);
        this.getModel().setValue("pricetaxtotal", (Object)pricetaxtotal);
        this.getModel().setValue("pricetaxtotalbase", (Object)pricetaxtotalbase);
        this.getModel().setValue("unsettleamountbase", (Object)unsettleamtbase);
        this.getModel().setValue("amountbase", (Object)amountbase);
        this.premheadAmountChanged(pricetaxtotal);
    }

    private void bizDateChanged(PropertyChangedArgs e, Object newValue, Object oldValue) {
    }

    private void setEntryLocalAmt(int index, Object newValue, String entrykey) {
        BigDecimal rate = this.getExRate();
        BigDecimal value = rate.multiply((BigDecimal)newValue);
        this.getModel().setValue(entrykey, (Object)value, index);
    }

    private void entryAmountToZero(int row) {
        IDataModel m = this.getModel();
        this.setEntryEnable(!this.checkIsPresent());
        m.setValue("price", (Object)BigDecimal.ZERO, row);
    }

    private void asstactChanged(PropertyChangedArgs e, Object newValue) {
        if (newValue == null) {
            this.getModel().setValue("asstactname", null);
            this.getModel().setValue("payeebanknum", null);
            this.getModel().setValue("bebank", null);
        } else {
            DynamicObject asstact = (DynamicObject)newValue;
            Map map = AsstactHelper.getaccbebankMap((DynamicObject)asstact);
            this.getModel().setValue("payeebanknum", map.get("account"));
            this.getModel().setValue("bebank", map.get("bebank"));
            this.getModel().setValue("asstactname", asstact.get("name"));
        }
    }

    private void fillToolBar() {
        String billStatus;
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit", "bar_track", "bar_generatevoucher"});
        if (this.onlyExit) {
            return;
        }
        if (!this.isPeriod()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_track"});
        }
        if ((billStatus = this.getModel().getDataEntity().getString("billstatus")).equals(BillStatusEnum.SAVE.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_del"});
        } else if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
            if (!((Boolean)this.getModel().getValue("isperiod")).booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unsubmit", "bar_audit"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unsubmit"});
            }
        } else if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_generatevoucher"});
            if (!((Boolean)this.getModel().getValue("isperiod")).booleanValue()) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_unaudit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_unaudit"});
            }
        }
    }

    private void materialChanged(ChangeData[] data) {
        int row = data[0].getRowIndex();
        Object propValue = data[0].getNewValue();
        if (propValue != null) {
            IDataModel model;
            DynamicObject material = (DynamicObject)propValue;
            this.getModel().setValue("spectype", (Object)material.getString("modelnum"), row);
            if (material.getDynamicObject("baseunit") != null) {
                Object unitID = material.getDynamicObject("baseunit").getPkValue();
                model = this.getModel();
                model.setValue("measureunit", unitID, row);
                model.setValue("e_baseunit", unitID, row);
                model.setValue("e_unitconvertrate", (Object)BigDecimal.ONE, row);
                model.setValue("e_baseunitqty", model.getValue("quantity", row), row);
            }
            if (material.getDynamicObject("taxrate") != null) {
                Object taxrateId = material.getDynamicObject("taxrate").getPkValue();
                model = this.getModel();
                model.setValue("taxrateid", taxrateId, row);
            }
        } else {
            this.getModel().setValue("spectype", null, row);
            this.getModel().setValue("measureunit", null, row);
            this.getModel().setValue("e_baseunit", null, row);
        }
    }

    private void entryVerAmt(int index, Object newValue, String KEY) {
        this.changed = false;
        BigDecimal amt = (BigDecimal)this.getModel().getValue("e_pricetaxtotal", index);
        this.getModel().setValue(KEY, (Object)amt.subtract((BigDecimal)newValue), index);
        this.calculatorHeadAmt();
    }

    private void setLockamt(int index, Object newValue, String entrykey) {
        this.getModel().setValue(entrykey, newValue, index);
    }

    private void setEntryEnable(boolean enable) {
        int i = this.getModel().getEntryCurrentRowIndex("detailentry");
        this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"price"});
        this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"e_pricetaxtotal"});
        this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"e_tax"});
        this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"actpricetax"});
        this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"e_noninvamount"});
        this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"discountrate"});
        this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"taxrate"});
        this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"pricetax"});
        this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"verifyamount"});
        this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"discountamount"});
        this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"verifyamount"});
        this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"e_unverifyamount"});
        this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"lockedamt"});
        this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"unlockamt"});
        this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"settledamt"});
        this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"unsettleamt"});
    }

    protected boolean verify4Period(DynamicObject org, boolean isFinishInit) {
        boolean flag = true;
        if (isFinishInit) {
            String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u65e0\u6cd5\u65b0\u589e\u671f\u521d\u5355\u636e\u3002", (String)"ApFinCoreBillEdit_6", (String)"fi-ap-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()});
            this.getView().showErrorNotification(msg);
            this.hideAllButton();
            return false;
        }
        Date startDate = this.init.getStartDate();
        Date lastDay = DateUtils.getLastDay((Date)startDate, (int)1);
        DateEdit bizdate = (DateEdit)this.getControl("bizdate");
        bizdate.setMaxDate(lastDay);
        this.getModel().setValue("bizdate", (Object)lastDay);
        if (EmptyUtils.isEmpty((Object)this.getModel().getValue("duedate"))) {
            this.getModel().setValue("duedate", (Object)lastDay);
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_submitandnew"});
        return flag;
    }

    protected boolean verify4NoPeriod(DynamicObject org, boolean isFinishInit) {
        boolean flag = true;
        Date currentDate = this.init.getCurrentDate();
        if (ObjectUtils.isEmpty((Object)currentDate)) {
            currentDate = this.init.getStartDate();
        }
        DateEdit bizdate = (DateEdit)this.getControl("bizdate");
        bizdate.setMinDate(currentDate);
        if (new Date().after(currentDate)) {
            this.getModel().setValue("bizdate", (Object)new Date());
            if (EmptyUtils.isEmpty((Object)this.getModel().getValue("duedate"))) {
                this.getModel().setValue("duedate", (Object)new Date());
            }
        } else {
            this.getModel().setValue("bizdate", (Object)currentDate);
            if (EmptyUtils.isEmpty((Object)this.getModel().getValue("duedate"))) {
                this.getModel().setValue("duedate", (Object)currentDate);
            }
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit"});
        return flag;
    }

    private void writeOff(boolean isAfterOp) {
        boolean isWriteOff = (Boolean)this.getModel().getValue("iswrittenoff");
        boolean hadWrittenOff = (Boolean)this.getModel().getValue("hadwrittenoff");
        if (!isWriteOff && !hadWrittenOff) {
            return;
        }
        IFormView view = this.getView();
        long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue == 0L) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_save4writeoff"});
            if (!isAfterOp) {
                IDataModel model = this.getModel();
                model.beginInit();
                model.setValue("bizdate", (Object)new Date());
                if (EmptyUtils.isEmpty((Object)model.getValue("duedate"))) {
                    model.setValue("duedate", (Object)new Date());
                }
                model.endInit();
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_save4writeoff"});
        }
        view.setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_del", "bar_del1", "bar_save", "bar_submit", "bar_unaudit", "bar_audit", "bar_unsubmit", "bar_more"});
        view.setVisible(Boolean.TRUE, new String[]{"bar_close"});
        view.setEnable(Boolean.FALSE, new String[]{"newentry", "deleteentry", "moveentryup", "moveentrydown", "advconbaritemap", "advconbaritemap1", "moveentryup1", "moveentrydown1"});
    }

    protected void hideAllButton() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit"});
    }

    protected void cacheIsPeriod() {
        this.getPageCache().put("isPeriod", "false");
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (parameter.getCustomParam("isPeriod") != null) {
            String value = Boolean.toString((Boolean)parameter.getCustomParam("isPeriod"));
            this.getPageCache().put("isPeriod", value);
        }
    }

    protected boolean isPeriod() {
        return "true".equals(this.getPageCache().get("isPeriod"));
    }

    private void verifyAccess(BeforeDoOperationEventArgs args) {
        HashSet apBillSet;
        Iterator iterator;
        DynamicObject tarBill;
        DynamicObject finApBill = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)"ap_finapbill");
        if (FinapPremHelper.isFinPrem((DynamicObject)finApBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u5355\u636e\u65e0\u6cd5\u51b2\u9500\u3002", (String)"ApFinCoreBillEdit_13", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String verifyStatus = finApBill.getString("verifystatus");
        if (verifyStatus == null || !Objects.equals(verifyStatus, "10")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u51b2\u9500\u5931\u8d25\uff0c\u8bf7\u53cd\u6838\u9500\u540e\u91cd\u8bd5\u3002", (String)"ApFinCoreBillEdit_14", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (finApBill.getBoolean("iswrittenoff")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u51b2\u9500\u5355\u636e\u65e0\u6cd5\u518d\u6b21\u51b2\u9500\u3002", (String)"ApFinCoreBillEdit_15", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObjectCollection entries = finApBill.getDynamicObjectCollection("detailentry");
        for (DynamicObject entry : entries) {
            BigDecimal lockedAmt = entry.getBigDecimal("lockedamt");
            BigDecimal settledAmt = entry.getBigDecimal("settledamt");
            if (lockedAmt == null || settledAmt == null || lockedAmt.compareTo(settledAmt) == 0) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u5904\u4e8e\u5728\u9014\u72b6\u6001\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"ApFinCoreBillEdit_16", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Map targetBills = BOTPHelper.findTargetBills((String)"ap_finapbill", (Long)finApBill.getLong("id"));
        Set keySet = targetBills.keySet();
        if (keySet.contains("ap_liquidation")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u8fdb\u884c\u201c\u6e05\u7406\u201d\u64cd\u4f5c\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"ApFinCoreBillEdit_17", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (keySet.contains("ap_finapbill") && (tarBill = BusinessDataServiceHelper.loadSingle((iterator = (apBillSet = (HashSet)targetBills.get("ap_finapbill")).iterator()).next(), (String)"ap_finapbill", (String)"istanspay")).getBoolean("istanspay")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u8f6c\u4ed8\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"ApFinCoreBillEdit_18", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        List finprems = FinapPremHelper.gettargetFinPrem((DynamicObject)finApBill);
        if (finprems != null && finprems.size() > 0) {
            for (DynamicObject finprem : finprems) {
                DynamicObjectCollection prmentries = finprem.getDynamicObjectCollection("detailentry");
                for (DynamicObject entry : prmentries) {
                    BigDecimal lockedAmt = entry.getBigDecimal("lockedamt");
                    BigDecimal settledAmt = entry.getBigDecimal("settledamt");
                    if (lockedAmt == null || settledAmt == null || lockedAmt.compareTo(settledAmt) == 0) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u8d28\u4fdd\u91d1\u5355\u636e\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u5904\u4e8e\u5728\u9014\u72b6\u6001\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"ApFinCoreBillEdit_19", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
        }
    }
}

