/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.helper.FinApBillHelper;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.helper.OperationConfirmHelper;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.OperationUtils;
import kd.fi.arapcommon.util.StringUtils;

public class ApplyPayListPlugin
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        OperationResult operationResult = e.getOperationResult();
        switch (e.getOperateKey()) {
            case "closepay": 
            case "unclosepay": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "updatevalidator": {
                boolean success = e.getOperationResult().isSuccess();
                if (!success) break;
                this.getView().invokeOperation("pushupdate");
                break;
            }
            case "submit": 
            case "assign": {
                String waring;
                List pks;
                if (operationResult == null || (pks = e.getOperationResult().getSuccessPkIds()) == null || !StringUtils.isNotEmpty((String)(waring = FinApBillHelper.supplierWarnTips((String)"ap_payapply", (List)pks, (String)e.getOperateKey())))) break;
                this.getView().showSuccessNotification(waring, Integer.valueOf(10000));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationUtils.setListButtonUnvisibleByAppId((String)"ap_payapply", (IFormView)this.getView());
    }

    public void setFilter(SetFilterEvent e) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Object checkKey = listShowParameter.getCustomParam("checkKey");
        if (!EmptyUtils.isEmpty((Object)checkKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap"});
            List qFilters = e.getQFilters();
            e.setMainOrgQFilter(null);
            qFilters.removeIf(filter -> !"billno".equals(filter.getProperty()));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = e.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] billNos = selectedRows.stream().map(selectedRow -> selectedRow.getBillNo()).toArray();
            LogUtil.addOpLog((String)"ap_payapply", (Object)(billNos.length > 0 ? billNos[0] : null), (String)operateKey, (String)("billnos\uff1a" + JSONObject.toJSONString((Object)billNos) + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        } else if (Objects.equals(callBackID, "executeClose") && isOK) {
            this.getView().invokeOperation("closepay");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)"SZJK-PRE-0057");
        }
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if ("pay".equals(key)) {
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)billList.getEntityType().getName(), (String)"billno,entry.e_asstact,entry.e_asstacttype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())});
            this.checkPayhold(args, bills);
        }
    }

    private void checkPayhold(BeforeDoOperationEventArgs args, DynamicObject[] bills) {
        String operateKey = ResManager.loadKDString((String)"\u4ed8\u6b3e", (String)"ApplyPayListPlugin_5", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        String errorTitle = ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25", (String)"ApplyPayListPlugin_6", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        String errorMessageTemplate = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u7b2c%2$d\u884c\uff0c\u6536\u6b3e\u4f9b\u5e94\u5546\u201c%3$s\u201d\u5df2\u4ed8\u6b3e\u51bb\u7ed3\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8%4$s\u5355\u3002", (String)"ApplyPayListPlugin_7", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        ArrayList<Long> asstactList = new ArrayList<Long>(8);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                if (!"bd_supplier".equals(entry.getString("e_asstacttype"))) {
                    return;
                }
                DynamicObject asstact = entry.getDynamicObject("e_asstact");
                if (ObjectUtils.isEmpty((Object)asstact)) continue;
                Long id = asstact.getLong("id");
                asstactList.add(id);
            }
        }
        if (ObjectUtils.isEmpty(asstactList)) {
            return;
        }
        Boolean asstactRes = QueryServiceHelper.exists((String)"bd_supplier", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactList), new QFilter("payhold", "=", (Object)Boolean.FALSE)});
        if (asstactRes.booleanValue()) {
            return;
        }
        ArrayList<String> errorMsgs = new ArrayList<String>(1);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                DynamicObject asstact = entry.getDynamicObject("e_asstact");
                if (ObjectUtils.isEmpty((Object)asstact)) continue;
                String billno = bill.getString("billno");
                String asstactName = asstact.getString("name");
                String message = String.format(errorMessageTemplate, billno, i + 1, asstactName, operateKey);
                errorMsgs.add(message);
            }
        }
        if (errorMsgs.size() > 1) {
            HashMap<String, Object> customParam = new HashMap<String, Object>(2);
            customParam.put("title", errorTitle);
            customParam.put("errorMsg", errorMsgs);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bos_operationresult");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.getCustomParams().putAll(customParam);
            parameter.setShowTitle(false);
            this.getView().showForm(parameter);
        } else {
            this.getView().showErrorNotification((String)errorMsgs.get(0));
        }
        args.setCancel(true);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] pks = selectedRows.getPrimaryKeyValues();
        if ("tblsubmit".equals(key) || "tblcheck".equals(key)) {
            Object[] applyBills = BusinessDataServiceHelper.load((String)"ap_payapply", (String)"id,billno,settleorg,settlecurrency,entry.e_paymenttype,entry.e_asstacttype,entry.e_asstact,entry.e_approvedamt,entry.e_paidamt", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
            List result = (List)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0080", null, (Object[])applyBills);
            if (result != null && result.size() > 0) {
                String submitTitle = ResManager.loadKDString((String)"\u63d0\u4ea4\u6b64\u5355\u636e\uff0c\u4f1a\u5bfc\u81f4\u8d85\u8fc7\u4f9b\u5e94\u5546\u4f59\u989d\u4ed8\u6b3e\uff0c\u8bf7\u68c0\u67e5\u5e76\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"ApplyPayListPlugin_8", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                String auditTitle = ResManager.loadKDString((String)"\u5ba1\u6838\u6b64\u5355\u636e\uff0c\u4f1a\u5bfc\u81f4\u8d85\u8fc7\u4f9b\u5e94\u5546\u4f59\u989d\u4ed8\u6b3e\uff0c\u8bf7\u68c0\u67e5\u5e76\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"ApplyPayListPlugin_9", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                String title = "tblsubmit".equals(key) ? submitTitle : auditTitle;
                String url = "https://vip.kingdee.com/article/542281522032911872?productLineId=2&isKnowledge=2";
                OperationConfirmHelper operationConfirmHelper = new OperationConfirmHelper(this.getView(), (IFormPlugin)this);
                operationConfirmHelper.openOperateConfirmByActionId(title, "", result, false, key, url);
            } else if ("tblsubmit".equals(key)) {
                this.getView().invokeOperation("submit");
            } else {
                this.getView().invokeOperation("audit");
            }
        } else if ("closepay".equals(key)) {
            this.showCloseConfirm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        String actionId = e.getActionId();
        if ("tblsubmit".equals(actionId)) {
            if (returnData != null) {
                this.getView().invokeOperation("submit");
            }
        } else if ("tblcheck".equals(actionId) && returnData != null) {
            this.getView().invokeOperation("audit");
        }
    }

    private void showCloseConfirm() {
        DynamicObjectCollection invEntry;
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Set billIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        if (billIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ApplyPayListPlugin_12", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] applyBills = BusinessDataServiceHelper.load((String)"ap_payapply", (String)"lockedamt,invid", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        HashSet<Long> invoiceIds = new HashSet<Long>(8);
        for (DynamicObject applyBill : applyBills) {
            DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
            long payRowNumber = entry.stream().filter(applyRow -> applyRow.getBigDecimal("lockedamt").compareTo(BigDecimal.ZERO) != 0).count();
            if (payRowNumber != 0L) continue;
            invEntry = applyBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                invoiceIds.add(invRow.getLong("invid"));
            }
        }
        String confirmMessage = ResManager.loadKDString((String)"\u5173\u95ed\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ApplyPayListPlugin_10", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        if (invoiceIds.isEmpty()) {
            this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("executeClose"));
            return;
        }
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"ap_invoice", (String)"id,isreffin,businesssource,unrelatedamt,pricetaxtotal,isvoucher,ismatched", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
        Map invoiceMap = invoices.stream().collect(Collectors.toMap(inv -> inv.getLong("id"), Function.identity()));
        for (DynamicObject applyBill : applyBills) {
            invEntry = applyBill.getDynamicObjectCollection("inventry");
            if (invEntry.isEmpty()) continue;
            int matchInvoiceNumber = 0;
            for (DynamicObject invRow : invEntry) {
                DynamicObject invoice = (DynamicObject)invoiceMap.get(invRow.getLong("invid"));
                if (invoice == null || !"ap_payapply".equals(invoice.getString("businesssource")) || invoice.getBigDecimal("unrelatedamt").compareTo(invoice.getBigDecimal("pricetaxtotal")) != 0 || invoice.getBoolean("isvoucher") || invoice.getBoolean("ismatched")) continue;
                ++matchInvoiceNumber;
            }
            if (matchInvoiceNumber <= 0) continue;
            confirmMessage = ResManager.loadKDString((String)"\u5173\u95ed\u64cd\u4f5c\u4e0d\u53ef\u9006\uff0c\u4e14\u5173\u95ed\u540e\u5c06\u91ca\u653e\u53d1\u7968\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ApplyPayListPlugin_11", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            break;
        }
        this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("executeClose"));
    }
}

