/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Label;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.formplugin.BizCountGroup;
import kd.fi.ap.util.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class BizCountAnalysisPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        this.fillDefaultValue();
        this.drawChart();
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.fillDefaultValue();
            this.drawChart();
        }
    }

    private void fillDefaultValue() {
        String startDateStr = this.getFromParentPageCache("startdate");
        String endDateStr = this.getFromParentPageCache("enddate");
        if (!StringUtils.isBlank((CharSequence)startDateStr) && !StringUtils.isBlank((CharSequence)endDateStr)) {
            this.getModel().setValue("startdate", (Object)new Date(Long.parseLong(startDateStr)));
            this.getModel().setValue("enddate", (Object)new Date(Long.parseLong(endDateStr)));
        } else {
            Date defaultEndDate = DateUtils.getMaxMonthDate((Date)new Date());
            Date defaultStartDate = org.apache.commons.lang.time.DateUtils.addMonths((Date)defaultEndDate, (int)-2);
            defaultStartDate = DateUtils.getMinMonthDate((Date)defaultStartDate);
            this.getModel().setValue("startdate", (Object)defaultStartDate);
            this.getModel().setValue("enddate", (Object)defaultEndDate);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date date;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (("startdate".equals(key) || "enddate".equals(key)) && (date = (Date)this.getModel().getValue(key)) != null) {
            this.putIntoParentPageCache(key, String.valueOf(date.getTime()));
        }
        if ("enddate".equals(key)) {
            this.drawChart();
        }
    }

    private void drawChart() {
        HistogramChart customchart = (HistogramChart)this.getControl("histogramchartap");
        customchart.clearData();
        Axis categoryAxis = this.createCategoryAxis(ResManager.loadKDString((String)"\u6708", (String)"BizCountAnalysisPlugin_0", (String)"fi-ap-formplugin", (Object[])new Object[0]), true);
        this.createValueAxis(ResManager.loadKDString((String)"\u6570\u76ee/\u7b14", (String)"BizCountAnalysisPlugin_1", (String)"fi-ap-formplugin", (Object[])new Object[0]), false);
        List<Date> startDateOfAnalysisMonths = this.getStartDateOfAnalysisMonths();
        ArrayList categories = new ArrayList();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        startDateOfAnalysisMonths.forEach(monthStartDate -> {
            SimpleDateFormat simpleDateFormat = format;
            synchronized (simpleDateFormat) {
                categories.add(format.format((Date)monthStartDate));
            }
        });
        categoryAxis.setCategorys(categories);
        Map<BizCountGroup, List<Number>> sortedData = this.getData(startDateOfAnalysisMonths);
        sortedData.forEach((group, data) -> this.createBarSeries(group.groupName, (List<Number>)data, group.color));
        customchart.setMargin(Position.left, "20px");
        customchart.setMargin(Position.right, "55px");
        customchart.setMargin(Position.top, "50px");
        customchart.refresh();
    }

    private Map<BizCountGroup, List<Number>> getData(List<Date> startDateOfAnalysisMonths) {
        Date startDate = startDateOfAnalysisMonths.get(0);
        Date endDate = DateUtils.getMaxMonthDate((Date)startDateOfAnalysisMonths.get(startDateOfAnalysisMonths.size() - 1));
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)RequestContext.get().getOrgId()), new QFilter("bizdate", ">=", (Object)DateUtils.getMinMonthDate((Date)startDate)), new QFilter("bizdate", "<=", (Object)DateUtils.getMaxMonthDate((Date)endDate)), new QFilter("billstatus", "=", (Object)"C")};
        LinkedHashMap<BizCountGroup, List<Number>> summaryResult = new LinkedHashMap<BizCountGroup, List<Number>>();
        try (DataSet rawDatas = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"ap_finapbill", (String)"pricetaxtotal,bizdate", (QFilter[])filters, (String)"bizdate desc");){
            List<BizCountGroup> bizCountGroups = this.getBizCountGroups();
            for (BizCountGroup group : bizCountGroups) {
                ArrayList<Integer> initialBillCountList = new ArrayList<Integer>(startDateOfAnalysisMonths.size());
                for (int i = 0; i < startDateOfAnalysisMonths.size(); ++i) {
                    initialBillCountList.add(0);
                }
                summaryResult.put(group, initialBillCountList);
            }
            BigDecimal summaryOfAmount = BigDecimal.ZERO;
            int summaryOfBill = 0;
            Iterator iterator = rawDatas.iterator();
            block11: while (iterator.hasNext()) {
                ++summaryOfBill;
                Row finBill = (Row)iterator.next();
                BigDecimal amount = finBill.getBigDecimal("pricetaxtotal");
                summaryOfAmount = summaryOfAmount.add(amount);
                Date minMonthDate = DateUtils.getMinMonthDate((Date)finBill.getDate("bizdate"));
                BizCountGroup group = this.matchAmountGroup(bizCountGroups, amount);
                List billCountList = (List)summaryResult.get(group);
                for (int i = 0; i < startDateOfAnalysisMonths.size(); ++i) {
                    Date date = startDateOfAnalysisMonths.get(i);
                    if (!date.equals(minMonthDate)) continue;
                    Integer count = (Integer)billCountList.get(i);
                    count = count + 1;
                    billCountList.set(i, count);
                    continue block11;
                }
            }
            if (summaryOfBill > 0) {
                BigDecimal averageAmount = summaryOfAmount.divide(new BigDecimal(summaryOfBill), 2, RoundingMode.HALF_UP).divide(new BigDecimal(10000), 2, RoundingMode.HALF_UP);
                Label averageLabel = (Label)this.getControl("average");
                averageLabel.setText(averageAmount.toPlainString());
            }
        }
        return summaryResult;
    }

    private BizCountGroup matchAmountGroup(List<BizCountGroup> groups, BigDecimal amount) {
        for (BizCountGroup group : groups) {
            if (!group.match(amount)) continue;
            return group;
        }
        return null;
    }

    private List<BizCountGroup> getBizCountGroups() {
        return BizCountGroup.getDefaultGroups();
    }

    private List<Date> getStartDateOfAnalysisMonths() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        ArrayList<Date> startDateOfAnalysisMonths = new ArrayList<Date>();
        if (startDate != null && endDate != null) {
            Date monthStartDate = DateUtils.getMinMonthDate((Date)startDate);
            Date startDateofLastMonth = DateUtils.getMinMonthDate((Date)endDate);
            do {
                startDateOfAnalysisMonths.add(monthStartDate);
            } while (startDateofLastMonth.compareTo(monthStartDate = org.apache.commons.lang.time.DateUtils.addMonths((Date)monthStartDate, (int)1)) >= 0);
        } else {
            Date today = new Date();
            for (int i = -2; i <= 0; ++i) {
                Date monthStartDate = DateUtils.getMinMonthDate((Date)org.apache.commons.lang.time.DateUtils.addMonths((Date)today, (int)i));
                startDateOfAnalysisMonths.add(monthStartDate);
            }
        }
        return startDateOfAnalysisMonths;
    }

    private HistogramChart getMainChart() {
        return (HistogramChart)this.getControl("histogramchartap");
    }

    private Axis createCategoryAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.category) : this.getMainChart().createYAxis(name, AxisType.category);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private Axis createValueAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.value) : this.getMainChart().createYAxis(name, AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#999999");
        this.getMainChart().setShowTooltip(true);
        return axis;
    }

    private void createBarSeries(String name, List<Number> values, String color) {
        BarSeries barSeries = this.getMainChart().createBarSeries(name);
        barSeries.setBarWidth("8px");
        barSeries.setColor(color);
        barSeries.setAnimationDuration(2000);
        barSeries.setData(values.toArray(new Number[0]));
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private String getFromParentPageCache(String key) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            return pageCache.get(((Object)((Object)this)).getClass().getSimpleName() + "-" + key);
        }
        return null;
    }

    private void putIntoParentPageCache(String key, String value) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            pageCache.put(((Object)((Object)this)).getClass().getSimpleName() + "-" + key, value);
        }
    }
}

