/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.business.fin.BusApEditInBulkService;
import kd.fi.ap.enums.BillStatusEnum;
import kd.fi.ap.enums.DiscountModeEnum;
import kd.fi.ap.formplugin.formservice.bus.BusApBillFormHelper;
import kd.fi.ap.formplugin.formservice.bus.BusApBillImportHelper;
import kd.fi.ap.formplugin.formservice.bus.BusApBillRevaluationHelper;
import kd.fi.ap.helper.FinApBillHelper;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.form.ArApBaseAllocationPlugin;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.ArApCorebillHelper;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.helper.ArApSettleTypeHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.DiscountAmtHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.LineTypeHelper;
import kd.fi.arapcommon.helper.MTOHelper;
import kd.fi.arapcommon.helper.MaterialFilterHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.helper.PrecisionHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.BillStatusCtrlService;
import kd.fi.arapcommon.service.EditInBulkService;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.OperationUtils;
import org.apache.commons.lang.StringUtils;

public class BusApBillEdit
extends ArApBaseAllocationPlugin
implements EntryGridBindDataListener {
    private InitHelper init;
    private boolean onlyExit = false;
    private boolean isCopyEntryRow = false;
    private Map<String, Object> suppliersMap;
    private BillStatusCtrlService billStatusCtrlService = new BillStatusCtrlService();
    private static final Log logger = LogFactory.getLog(BusApBillEdit.class);
    private BusApBillImportHelper importHelper;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.filterMaterial();
        this.filterMaterialVersion();
        this.filterMeasureUnit();
        this.configuredCodeFilter();
        this.taxratefilter();
        this.addClickListeners(new String[]{"e_corebillno", "sameinfo_view", "sameinfo_ignore"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.asstactFilter();
        this.invoiceBizType();
        this.filterPayproperty();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    private void invoiceBizType() {
        BasedataEdit biztypeF7 = (BasedataEdit)this.getControl("invoicebiztype");
        biztypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter filter = new QFilter("mulbiz.fbasedataid", "=", (Object)"83bfebc8000002ac");
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
        });
    }

    private void asstactFilter() {
        ItemClassEdit asstactF7 = (ItemClassEdit)this.getControl("asstact");
        asstactF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String asstactType = this.getModel().getValue("asstacttype").toString();
            if ("bd_supplier".equals(asstactType)) {
                QFilter filter = new QFilter("bizfunction", "ilike", (Object)"%2%");
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter);
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int currentindex = changeData[0].getRowIndex();
        IDataModel m = this.getModel();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!this.billStatusCtrlService.isCanChange(billStatus)) {
            return;
        }
        switch (key) {
            case "org": {
                if (newValue != null) break;
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"org", (Object)oldValue);
                break;
            }
            case "billtype": {
                if (newValue != null) break;
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"billtype", (Object)oldValue);
                return;
            }
            case "currency": {
                int newPrecision;
                if (newValue == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"currency", (Object)oldValue);
                    return;
                }
                if (ObjectUtils.isEmpty((Object)oldValue)) {
                    return;
                }
                int oldPrecision = ((DynamicObject)oldValue).getInt("amtprecision");
                if (oldPrecision != (newPrecision = ((DynamicObject)newValue).getInt("amtprecision"))) {
                    this.calculateAllRow(m);
                }
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                break;
            }
            case "exratetable": 
            case "exratedate": {
                if (newValue == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)key, (Object)oldValue);
                    return;
                }
                if (oldValue != null) break;
                return;
            }
            case "bizdate": {
                if (newValue == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"bizdate", (Object)oldValue);
                    return;
                }
                BookDateHelper.setBookDateAndRange((IFormView)this.getView(), (boolean)false);
                this.bizDateChanged();
                break;
            }
            case "exchangerate": {
                if (EmptyUtils.isEmpty((Object)newValue)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"BusApBillEdit_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.calculateAllRow(m);
                break;
            }
            case "e_measureunit": {
                this.calculateBaseQty(currentindex);
                this.calculateQty(currentindex);
                break;
            }
            case "e_quantity": {
                DynamicObject payproperty = (DynamicObject)m.getValue("payproperty");
                if (payproperty != null && payproperty.getBoolean("isbasedonamt") && ((BigDecimal)newValue).abs().compareTo(BigDecimal.ONE) != 0) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"e_quantity", (Object)oldValue, (int)currentindex);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u91d1\u989d\u57fa\u51c6\u4e1a\u52a1\u7684\u6570\u91cf\u5e94\u4e3a1\u6216-1\u3002", (String)"BusApBillEdit_5", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (((BigDecimal)newValue).compareTo(BigDecimal.ZERO) == 0) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"e_quantity", (Object)oldValue, (int)currentindex);
                    break;
                }
                m.setValue("e_unwoffqty", newValue, currentindex);
                m.setValue("e_uninvoicedqty", newValue, currentindex);
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(currentindex, this.getModel(), key, BillModelFactory.getModel((String)"ap_busbill"));
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                this.calculateBaseQty(currentindex);
            }
            case "e_pricetaxtotal": 
            case "e_amount": 
            case "e_taxrate": {
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(currentindex, this.getModel(), key, BillModelFactory.getModel((String)"ap_busbill"));
            }
            case "e_discountrate": {
                this.calculateRow(m, currentindex, key, oldValue, false);
                break;
            }
            case "e_unitprice": 
            case "e_taxunitprice": {
                boolean isPresent = (Boolean)this.getModel().getValue("e_ispresent", currentindex);
                if (isPresent) {
                    BigDecimal price = (BigDecimal)newValue;
                    if (BigDecimal.ZERO.compareTo(price) == 0) {
                        m.setValue("e_discountmode", (Object)"NULL", currentindex);
                    } else {
                        m.setValue("e_discountmode", (Object)"PERCENT", currentindex);
                        m.setValue("e_discountrate", (Object)new BigDecimal(100), currentindex);
                    }
                }
                this.calculateRow(m, currentindex, key, oldValue, false);
                break;
            }
            case "e_discountamount": {
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(currentindex, this.getModel(), key, BillModelFactory.getModel((String)"ap_busbill"));
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                break;
            }
            case "e_discountmode": {
                m.setValue("e_discountrate", (Object)BigDecimal.ZERO, currentindex);
                if ("TOTAL".equals(newValue)) {
                    m.setValue("e_discountamount", (Object)BigDecimal.ZERO, currentindex);
                }
                this.calculateRow(m, currentindex, key, oldValue, false);
                break;
            }
            case "e_ispresent": {
                boolean isPriceTotal = (Boolean)this.getModel().getValue("ispricetotal");
                boolean curIsPresent = (Boolean)newValue;
                BigDecimal rice = (BigDecimal)m.getValue("e_unitprice", currentindex);
                BigDecimal priceTax = (BigDecimal)m.getValue("e_taxunitprice", currentindex);
                if (isPriceTotal) {
                    this.getModel().beginInit();
                    if (curIsPresent && (BigDecimal.ZERO.compareTo(rice) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0)) {
                        this.getModel().setValue("e_discountmode", (Object)"PERCENT", currentindex);
                        this.getModel().setValue("e_discountrate", (Object)new BigDecimal(100), currentindex);
                    } else {
                        this.getModel().setValue("e_discountmode", (Object)"NULL", currentindex);
                        this.getModel().setValue("e_discountrate", (Object)BigDecimal.ZERO, currentindex);
                        this.getModel().setValue("e_discountamount", (Object)BigDecimal.ZERO, currentindex);
                        this.getModel().setValue("e_discountlocalamt", (Object)BigDecimal.ZERO, currentindex);
                    }
                    this.getModel().endInit();
                    this.calculateRow(m, currentindex, key, oldValue, true);
                    this.getView().updateView("entry", currentindex);
                    break;
                }
                if (curIsPresent && (BigDecimal.ZERO.compareTo(rice) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0)) {
                    m.setValue("e_discountmode", (Object)"PERCENT", currentindex);
                    m.setValue("e_discountrate", (Object)new BigDecimal(100), currentindex);
                    break;
                }
                m.setValue("e_discountmode", (Object)"NULL", currentindex);
                break;
            }
            case "e_material": {
                m.setValue("deductiblerate", null, currentindex);
                m.setValue("e_materialversion", null, currentindex);
                m.setValue("configuredcode", null, currentindex);
                m.setValue("tracknumber", null, currentindex);
                this.materialChanged(newValue, currentindex);
                break;
            }
            case "asstact": {
                long asstactSettleTypeId;
                this.asstactChanged(newValue);
                String asstactType = (String)m.getValue("asstacttype");
                DynamicObject asstact = (DynamicObject)m.getValue("asstact");
                if (ObjectUtils.isEmpty((Object)asstact)) {
                    this.clearAssLinkSupplier();
                    return;
                }
                if ("bd_supplier".equals(asstactType)) {
                    this.suppliersMap = FinApBillHelper.setSuppliersToViewCash((IDataModel)this.getModel(), (IPageCache)this.getPageCache());
                    if (this.suppliersMap != null && this.suppliersMap.size() > 0) {
                        m.setValue("invoicebiztype", this.suppliersMap.get("invoicebiztype"));
                        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
                        if (entrys != null && entrys.size() > 0) {
                            for (int i = 0; i < entrys.size(); ++i) {
                                this.getModel().setValue("e_invoicesupplierid", this.suppliersMap.get("invoiceSupplierId"), i);
                                this.getModel().setValue("e_deliversupplierid", this.suppliersMap.get("deliverSupplierId"), i);
                            }
                        }
                    }
                }
                if ((asstactSettleTypeId = ArApSettleTypeHelper.getAsstactSettleType((String)asstactType, (long)asstact.getLong("id"))) == 0L) {
                    return;
                }
                m.setValue("settlementtype", (Object)asstactSettleTypeId);
                break;
            }
            case "payproperty": {
                FormServiceHelper.paypropertyChanged((IDataModel)m, (String)"entry", (String)"e_quantity");
                break;
            }
            case "e_corebilltype": {
                m.setValue("e_corebillno", null, currentindex);
                m.setValue("e_corebillentryseq", null, currentindex);
                break;
            }
            case "biztype": {
                DynamicObject supplier;
                if (Objects.equals(newValue, oldValue)) break;
                DynamicObject oldBizType = (DynamicObject)oldValue;
                String type = (String)m.getValue("asstacttype");
                String message = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u660e\u7ec6\u884c\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"BusApBillEdit_6", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                if ("bd_supplier".equals(type) && !this.isVmi((DynamicObject)newValue, supplier = (DynamicObject)m.getValue("asstact"))) {
                    message = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u5f80\u6765\u6237\u4fe1\u606f\u53ca\u660e\u7ec6\u884c\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"BusApBillEdit_8", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                }
                this.getPageCache().put("OLDBIZTYPEID", String.valueOf(oldValue == null ? Long.valueOf(0L) : oldBizType.getPkValue()));
                this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this));
                break;
            }
            case "duedate": {
                this.setPlanDuedateRange();
                if (newValue != null) break;
                this.getModel().setValue("duedate", this.getModel().getValue("bizdate"));
                break;
            }
            case "taxrateid": {
                DynamicObject material = (DynamicObject)this.getModel().getValue("e_material", currentindex);
                BigDecimal e_taxrate = (BigDecimal)this.getModel().getValue("e_taxrate", currentindex);
                if (EmptyUtils.isNotEmpty((Object)material)) {
                    boolean isFarm = material.getBoolean("farmproducts");
                    if (isFarm) break;
                    this.getModel().setValue("deductiblerate", (Object)e_taxrate, currentindex);
                    break;
                }
                this.getModel().setValue("deductiblerate", (Object)e_taxrate, currentindex);
                break;
            }
            case "e_farmproducts": {
                boolean farmProducts = (Boolean)this.getModel().getValue("e_farmproducts", currentindex);
                DynamicObject material = (DynamicObject)this.getModel().getValue("e_material", currentindex);
                if (!farmProducts || !EmptyUtils.isNotEmpty((Object)material)) break;
                boolean isFarm = material.getBoolean("farmproducts");
                if (isFarm) {
                    BigDecimal deRate = material.getBigDecimal("deductiblerate");
                    this.getModel().setValue("deductiblerate", (Object)deRate, currentindex);
                    break;
                }
                BigDecimal taxrate = (BigDecimal)this.getModel().getValue("e_taxrate", currentindex);
                this.getModel().setValue("deductiblerate", (Object)taxrate, currentindex);
                break;
            }
            case "asstacttype": {
                this.setAsstactCaption();
                this.clearAssLinkSupplier();
                break;
            }
            case "e_prepaid": {
                boolean prePaid = (Boolean)newValue;
                if (!prePaid) break;
                this.getModel().setValue("e_contractcost", (Object)Boolean.FALSE, currentindex);
                break;
            }
            case "e_contractcost": {
                boolean contractCost = (Boolean)newValue;
                if (!contractCost) break;
                this.getModel().setValue("e_prepaid", (Object)Boolean.FALSE, currentindex);
            }
        }
    }

    private void clearAssLinkSupplier() {
        this.getModel().setValue("receivingsupplierid", null);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        if (entrys != null && entrys.size() > 0) {
            for (int i = 0; i < entrys.size(); ++i) {
                this.getModel().setValue("e_invoicesupplierid", null, i);
                this.getModel().setValue("e_deliversupplierid", null, i);
            }
        }
    }

    private boolean isVmi(DynamicObject bizType, DynamicObject asstact) {
        boolean isMatch = true;
        if (ObjectUtils.isEmpty((Object)bizType) || ObjectUtils.isEmpty((Object)asstact)) {
            return isMatch;
        }
        String domain = bizType.getString("domain");
        DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"enablevmi", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstact.getLong("id"))});
        boolean enableVmi = supplier.getBoolean("enablevmi");
        if (!enableVmi && "6".equals(domain)) {
            isMatch = false;
        }
        return isMatch;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("biztype".equals(messageBoxClosedEvent.getCallBackId())) {
            String biztypeId;
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                String type = (String)this.getModel().getValue("asstacttype");
                if ("bd_supplier".equals(type)) {
                    DynamicObject supplier = (DynamicObject)this.getModel().getValue("asstact");
                    DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
                    if (!this.isVmi(bizType, supplier)) {
                        this.getModel().setValue("asstact", null);
                    }
                }
                this.clearEntry();
                this.calculateAllRow(this.getModel());
            } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(biztypeId = this.getPageCache().get("OLDBIZTYPEID")))) {
                this.getModel().beginInit();
                this.getModel().setValue("biztype", (Object)Long.parseLong(biztypeId));
                this.getModel().endInit();
                this.getView().updateView("biztype");
            }
            this.getPageCache().remove("OLDBIZTYPEID");
        }
        String callBackID = messageBoxClosedEvent.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, messageBoxClosedEvent.getResult());
        if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = messageBoxClosedEvent.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            Object billNo = this.getModel().getValue("billno");
            LogUtil.addOpLog((String)"ap_busbill", (Object)billNo, (String)operateKey, (String)("billnos\uff1a" + billNo + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        }
    }

    private void clearEntry() {
        this.getModel().deleteEntryData("subentryentity");
        this.getModel().deleteEntryData("entry");
        this.getModel().createNewEntryRow("entry");
    }

    private void asstactChanged(Object newValue) {
        if (newValue == null) {
            this.getModel().setValue("paycond", null);
        } else {
            DynamicObject asstact = (DynamicObject)newValue;
            DynamicObject asstactFieldValue = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"paycond", (QFilter[])new QFilter[]{new QFilter("id", "=", asstact.getPkValue())});
            if (asstactFieldValue == null) {
                this.getModel().setValue("paycond", null);
                return;
            }
            long paycondId = asstactFieldValue.getLong("paycond");
            if (paycondId == 0L) {
                this.getModel().setValue("paycond", null);
                return;
            }
            DynamicObject paycondition = QueryServiceHelper.queryOne((String)"bd_paycondition", (String)"paybill,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)paycondId)});
            if (paycondition == null) {
                this.getModel().setValue("paycond", null);
                return;
            }
            if (paycondition.getBoolean("paybill") && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"1", (CharSequence)((String)paycondition.get("enable")))) {
                this.getModel().setValue("paycond", (Object)paycondId);
            } else {
                this.getModel().setValue("paycond", null);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        EditInBulkService editInBulkService = new EditInBulkService(this.getView(), this.getPluginName());
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "bar_save4woff": {
                OperateOption option = OperateOption.create();
                option.setVariableValue("isselfwoff", "true");
                this.getView().invokeOperation("save", option);
                break;
            }
            case "editsettingsinbulk": {
                editInBulkService.showEditSettingsInBulk();
                break;
            }
            case "editinbulk": {
                boolean includeTax = (Boolean)this.getModel().getValue("isincludetax");
                if (!includeTax) break;
                editInBulkService.showEditInBulk();
                break;
            }
            case "totaldiscount": {
                DiscountAmtHelper totalService = new DiscountAmtHelper();
                totalService.discountShowForm(this.getView(), (AbstractBillPlugIn)this, BillModelFactory.getModel((String)"ap_busbill"));
                break;
            }
            case "tblbatchwoff": {
                this.woffBusBIlls();
            }
        }
    }

    private void materialChanged(Object newValue, int currentindex) {
        if (newValue != null) {
            DynamicObject material = (DynamicObject)newValue;
            boolean isFarm = material.getBoolean("farmproducts");
            if (isFarm) {
                BigDecimal deRate = material.getBigDecimal("deductiblerate");
                this.getModel().setValue("deductiblerate", (Object)deRate, currentindex);
                this.getModel().setValue("e_farmproducts", (Object)isFarm, currentindex);
            } else {
                BigDecimal e_taxrate = (BigDecimal)this.getModel().getValue("e_taxrate", currentindex);
                this.getModel().setValue("deductiblerate", (Object)e_taxrate, currentindex);
                this.getModel().setValue("e_farmproducts", (Object)isFarm, currentindex);
            }
            if (material.getDynamicObject("baseunit") != null) {
                this.getModel().setValue("e_spectype", (Object)material.getString("modelnum"), currentindex);
                this.getModel().setValue("e_measureunit", material.getDynamicObject("baseunit").getPkValue(), currentindex);
                this.getModel().setValue("e_baseunit", material.getDynamicObject("baseunit").getPkValue(), currentindex);
                this.getModel().setValue("e_baseunitqty", this.getModel().getValue("e_quantity", currentindex), currentindex);
                this.getModel().setValue("e_unitcoefficient", (Object)BigDecimal.ONE, currentindex);
            }
            if (material.getDynamicObject("taxrate") != null) {
                Object taxrateId = material.getDynamicObject("taxrate").getPkValue();
                IDataModel model = this.getModel();
                model.setValue("taxrateid", taxrateId, currentindex);
            }
        } else {
            this.getModel().setValue("e_spectype", null, currentindex);
        }
    }

    private void calculateAllRow(IDataModel m) {
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocal = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localAmt = BigDecimal.ZERO;
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalLocal = BigDecimal.ZERO;
        int entryRowCount = m.getEntryRowCount("entry");
        for (int i = 0; i < entryRowCount; ++i) {
            PriceLocalCalculator calculator = this.buildCalculator(m, i, false);
            this.setRowValue(m, calculator, i);
            tax = tax.add(calculator.getTax());
            taxLocal = taxLocal.add(calculator.getTaxlocal());
            amount = amount.add(calculator.getAmount());
            localAmt = localAmt.add(calculator.getAmountlocal());
            priceTaxTotal = priceTaxTotal.add(calculator.getPricetaxtotal());
            priceTaxTotalLocal = priceTaxTotalLocal.add(calculator.getPricetaxtotallocal());
        }
        m.setValue("tax", (Object)tax);
        m.setValue("taxlocamt", (Object)taxLocal);
        m.setValue("amount", (Object)amount);
        m.setValue("localamt", (Object)localAmt);
        m.setValue("unwoffamt", (Object)priceTaxTotal);
        m.setValue("uninvoicedamt", (Object)priceTaxTotal);
        m.setValue("pricetaxtotalbase", (Object)priceTaxTotalLocal);
        m.setValue("unwofflocamt", (Object)priceTaxTotalLocal);
        m.setValue("uninvoicedlocamt", (Object)priceTaxTotalLocal);
        m.setValue("unwoffnotaxamt", (Object)amount);
        m.setValue("unwoffnotaxlocamt", (Object)localAmt);
        m.setValue("unwofftax", (Object)tax);
        m.setValue("unwofftaxlocal", (Object)taxLocal);
        m.setValue("pricetaxtotal", (Object)priceTaxTotal);
    }

    private void calculateRow(IDataModel m, int index, String changeKey, Object oldValue, boolean isPresent) {
        BigDecimal oldEntryPriceTaxTotalLocal;
        BigDecimal oldEntryTax = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_tax", index);
        BigDecimal oldEntryTaxLocal = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_taxlocalamt", index);
        BigDecimal oldEntryAmount = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_amount", index);
        BigDecimal oldEntryAmountLocal = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_localamt", index);
        BigDecimal oldEntryPriceTaxTotal = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_pricetaxtotal", index);
        BigDecimal bigDecimal = oldEntryPriceTaxTotalLocal = this.isCopyEntryRow ? BigDecimal.ZERO : (BigDecimal)m.getValue("e_pricetaxtotalbase", index);
        if ("e_pricetaxtotal".equals(changeKey)) {
            oldEntryPriceTaxTotal = (BigDecimal)oldValue;
        }
        if ("e_amount".equals(changeKey)) {
            oldEntryAmount = (BigDecimal)oldValue;
        }
        PriceLocalCalculator calculator = this.buildCalculator(m, index, isPresent);
        this.setRowValue(m, calculator, index);
        BigDecimal tax = ((BigDecimal)m.getValue("tax")).subtract(oldEntryTax).add(calculator.getTax());
        BigDecimal taxlocamt = ((BigDecimal)m.getValue("taxlocamt")).subtract(oldEntryTaxLocal).add(calculator.getTaxlocal());
        BigDecimal amount = ((BigDecimal)m.getValue("amount")).subtract(oldEntryAmount).add(calculator.getAmount());
        BigDecimal localamt = ((BigDecimal)m.getValue("localamt")).subtract(oldEntryAmountLocal).add(calculator.getAmountlocal());
        m.setValue("tax", (Object)tax);
        m.setValue("taxlocamt", (Object)taxlocamt);
        m.setValue("amount", (Object)amount);
        m.setValue("localamt", (Object)localamt);
        BigDecimal priceTaxTotal = ((BigDecimal)m.getValue("pricetaxtotal")).subtract(oldEntryPriceTaxTotal).add(calculator.getPricetaxtotal());
        m.setValue("unwoffamt", (Object)priceTaxTotal);
        m.setValue("uninvoicedamt", (Object)priceTaxTotal);
        BigDecimal priceTaxTotalLocal = ((BigDecimal)m.getValue("pricetaxtotalbase")).subtract(oldEntryPriceTaxTotalLocal).add(calculator.getPricetaxtotallocal());
        m.setValue("pricetaxtotalbase", (Object)priceTaxTotalLocal);
        m.setValue("unwofflocamt", (Object)priceTaxTotalLocal);
        m.setValue("uninvoicedlocamt", (Object)priceTaxTotalLocal);
        m.setValue("pricetaxtotal", (Object)priceTaxTotal);
        m.setValue("unwoffnotaxamt", (Object)amount);
        m.setValue("unwoffnotaxlocamt", (Object)localamt);
        m.setValue("unwofftax", (Object)tax);
        m.setValue("unwofftaxlocal", (Object)taxlocamt);
    }

    protected PriceLocalCalculator buildCalculator(IDataModel m, int index, boolean isPresent) {
        isPresent = !isPresent ? (Boolean)m.getValue("e_ispresent", index) : isPresent;
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        boolean isPriceTotal = (Boolean)m.getValue("ispricetotal");
        BigDecimal qty = (BigDecimal)m.getValue("e_quantity", index);
        BigDecimal taxRate = (BigDecimal)m.getValue("e_taxrate", index);
        String discountMode = (String)m.getValue("e_discountmode", index);
        BigDecimal discountRate = (BigDecimal)m.getValue("e_discountrate", index);
        BigDecimal discountAmt = (BigDecimal)m.getValue("e_discountamount", index);
        BigDecimal exchangeRate = (BigDecimal)m.getValue("exchangerate");
        String quotation = (String)m.getValue("quotation");
        if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        int precision = 2;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            precision = currency.getInt("amtprecision");
        }
        int localPrecision = this.getLocalPrecision();
        TaxUnitPriceCalculator calculator = null;
        if (includeTax) {
            if (isPriceTotal && !isPresent) {
                BigDecimal priceTaxTotal = (BigDecimal)m.getValue("e_pricetaxtotal", index);
                calculator = new PriceTaxTotalCalculator(qty, priceTaxTotal, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
            } else {
                BigDecimal taxUnitPrice = (BigDecimal)m.getValue("e_taxunitprice", index);
                calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
            }
        } else if (isPriceTotal && !isPresent) {
            BigDecimal amount = (BigDecimal)m.getValue("e_amount", index);
            calculator = new PriceTotalCalculator(qty, amount, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        } else {
            BigDecimal unitPrice = (BigDecimal)m.getValue("e_unitprice", index);
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, exchangeRate, localPrecision, quotation);
        localCalculator.calculate();
        return localCalculator;
    }

    protected void setRowValue(IDataModel m, PriceLocalCalculator calculator, int index) {
        m.beginInit();
        m.setValue("e_unitprice", (Object)calculator.getUnitprice(), index);
        m.setValue("e_taxunitprice", (Object)calculator.getTaxunitprice(), index);
        m.setValue("e_tax", (Object)calculator.getTax(), index);
        m.setValue("e_discountamount", (Object)calculator.getDiscountamount(), index);
        m.endInit();
        this.getView().updateView("e_unitprice", index);
        this.getView().updateView("e_taxunitprice", index);
        this.getView().updateView("e_tax", index);
        this.getView().updateView("e_discountamount", index);
        m.setValue("e_actunitprice", (Object)calculator.getActunitprice(), index);
        m.setValue("e_acttaxunitprice", (Object)calculator.getActtaxunitprice(), index);
        m.setValue("e_discountlocalamt", (Object)calculator.getDiscountamountlocal(), index);
        m.setValue("e_taxlocalamt", (Object)calculator.getTaxlocal(), index);
        m.setValue("e_unwofftax", (Object)calculator.getTax(), index);
        m.setValue("e_unwofftaxlocal", (Object)calculator.getTaxlocal(), index);
        this.assigendEntryAmount(m, index, calculator.getAmount(), calculator.getAmountlocal(), calculator.getPricetaxtotal(), calculator.getPricetaxtotallocal());
    }

    protected void assigendEntryAmount(IDataModel m, int index, BigDecimal amount, BigDecimal amountlocal, BigDecimal pricetaxtotal, BigDecimal pricetaxtotallocal) {
        m.beginInit();
        m.setValue("e_amount", (Object)amount, index);
        m.setValue("e_pricetaxtotal", (Object)pricetaxtotal, index);
        m.endInit();
        this.getView().updateView("e_amount", index);
        this.getView().updateView("e_pricetaxtotal", index);
        m.setValue("e_localamt", (Object)amountlocal, index);
        m.setValue("e_unwoffamt", (Object)pricetaxtotal, index);
        m.setValue("e_uninvoicedamt", (Object)pricetaxtotal, index);
        m.setValue("e_pricetaxtotalbase", (Object)pricetaxtotallocal, index);
        m.setValue("e_unwofflocamt", (Object)pricetaxtotallocal, index);
        m.setValue("e_uninvoicedlocamt", (Object)pricetaxtotallocal, index);
        m.setValue("e_unwoffnotaxamt", (Object)amount, index);
        m.setValue("e_unwoffnotaxlocamt", (Object)amountlocal, index);
        m.setValue("e_uninvnotaxamt", (Object)amount, index);
        m.setValue("e_uninvnotaxlocalamt", (Object)amountlocal, index);
    }

    private void calculateBaseQty(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject measureUnit = (DynamicObject)model.getValue("e_measureunit", rowIndex);
        if (measureUnit == null) {
            return;
        }
        DynamicObject material = (DynamicObject)model.getValue("e_material", rowIndex);
        if (material == null) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)model.getValue("e_baseunit", rowIndex);
        if (baseUnit == null && (baseUnit = material.getDynamicObject("baseunit")) != null) {
            model.setValue("e_baseunit", baseUnit.getPkValue(), rowIndex);
        }
        if (baseUnit == null) {
            return;
        }
        long baseUnitID = (Long)baseUnit.getPkValue();
        long measureUnitID = (Long)measureUnit.getPkValue();
        long materialID = (Long)material.getPkValue();
        BigDecimal convertRate = UnitConvertHelper.getUnitRateConv((Long)materialID, (Long)measureUnitID, (Long)baseUnitID);
        BigDecimal quantity = (BigDecimal)model.getValue("e_quantity", rowIndex);
        if (convertRate != null) {
            model.setValue("e_unitcoefficient", (Object)convertRate, rowIndex);
            if (quantity != null) {
                model.setValue("e_baseunitqty", (Object)convertRate.multiply(quantity), rowIndex);
            }
        }
    }

    private void calculateQty(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject measureUnit = (DynamicObject)model.getValue("e_measureunit", rowIndex);
        if (measureUnit == null) {
            return;
        }
        BigDecimal quantity = (BigDecimal)model.getValue("e_quantity", rowIndex);
        if (quantity != null) {
            model.setValue("e_quantity", (Object)quantity.setScale(measureUnit.getInt("precision"), 4), rowIndex);
        }
    }

    private void bizDateChanged() {
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        Date dueDate = (Date)this.getModel().getValue("duedate");
        if (dueDate != null && bizDate != null && dueDate.compareTo(bizDate) < 0) {
            this.getModel().setValue("duedate", (Object)bizDate);
        }
    }

    private void filterMaterial() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!ObjectUtils.isEmpty((Object)org) && LineTypeHelper.getParam((long)org.getLong("id"), (boolean)false).booleanValue()) {
            return;
        }
        BasedataEdit materialF7 = (BasedataEdit)this.getControl("e_material");
        materialF7.addBeforeF7SelectListener(evt -> {
            DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtype");
            String number = billtype.getString("number");
            QFilter filter = null;
            if ("ap_busbill_stadpur_BT_S".equals(number)) {
                filter = new QFilter("materialtype", "=", (Object)"1");
            } else if ("ap_busbill_feepur_BT_S".equals(number)) {
                filter = new QFilter("materialtype", "=", (Object)"7");
            } else if ("ap_busbill_serpur_BT_S".equals(number)) {
                filter = new QFilter("materialtype", "=", (Object)"9");
            } else if ("ap_busbill_asset_BT_S".equals(number)) {
                filter = new QFilter("materialtype", "=", (Object)"8");
            } else if ("ap_busbill_om_BT_S".equals(number)) {
                filter = new QFilter("materialtype", "in", (Object)MaterialFilterHelper.getMaterialTypes());
            }
            if (filter != null) {
                ListFilterParameter parameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                parameter.getQFilters().add(filter);
            }
        });
    }

    private void filterMaterialVersion() {
        BasedataEdit materialVersionF7 = (BasedataEdit)this.getControl("e_materialversion");
        materialVersionF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject material = (DynamicObject)this.getModel().getValue("e_material", currentRow);
            if (!ObjectUtils.isEmpty((Object)material)) {
                long materialId = material.getLong("id");
                QFilter filter = new QFilter("material", "=", (Object)materialId);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    private void configuredCodeFilter() {
        BasedataEdit billTypeF7 = (BasedataEdit)this.getControl("configuredcode");
        billTypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject material = (DynamicObject)this.getModel().getValue("e_material", currentRow);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (EmptyUtils.isNotEmpty((Object)material)) {
                long materialId = material.getLong("id");
                QFilter filter = new QFilter("material.id", "=", (Object)materialId);
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    private void filterMeasureUnit() {
        BasedataEdit measureUnitEdit = (BasedataEdit)this.getControl("e_measureunit");
        FormServiceHelper.addMeasureUnitFilter((IDataModel)this.getModel(), (String)"e_material", (String)"entry", (BasedataEdit)measureUnitEdit);
    }

    private void taxratefilter() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        BasedataEdit taxrateF7 = (BasedataEdit)this.getControl("taxrateid");
        BaseDataHelper.taxratefilter((Date)bizdate, (BasedataEdit)taxrateF7);
    }

    private BusApBillImportHelper getImportHelper() {
        if (this.importHelper == null) {
            this.importHelper = new BusApBillImportHelper(this.getModel(), this.getPageCache());
        }
        return this.importHelper;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        this.getImportHelper().initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        this.getImportHelper().beforeImportData(e);
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.getImportHelper().afterImportData(e);
    }

    protected void calculatorEntryAmt(IDataModel m, boolean includeTax, BigDecimal rate, int precision, int localprecision, int index) {
    }

    public void afterCreateNewData(EventObject e) {
        long settleTypeId;
        super.afterCreateNewData(e);
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        BookDateHelper.setBookDateAndRange((IFormView)this.getView(), (boolean)false);
        if (parameter.getCustomParam("isPeriod") != null) {
            this.getModel().setValue("isperiod", parameter.getCustomParam("isPeriod"));
        }
        if ((settleTypeId = ArApSettleTypeHelper.getDefaultSettleType()) != 0L) {
            this.getModel().setValue("settlementtype", (Object)settleTypeId);
        }
        if (!"true".equals(this.getPageCache().get("isWebApi"))) {
            this.createNewModel();
        }
    }

    private void createNewModel() {
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org) && !ObjectUtils.isEmpty((Object)(org = OrgHelper.getAuthorizedBankOrg((String)"ap", (String)"ap_busbill", (String)"47150e89000000ac")))) {
            this.getModel().setValue("org", (Object)org.getLong("id"));
        }
        if (ObjectUtils.isEmpty((Object)org)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ApFinCoreBillEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        long orgId = (Long)org.getPkValue();
        if (ObjectUtils.isEmpty((Object)this.getModel().getValue("payorg")) && org.getBoolean("fisbankroll")) {
            this.getModel().setValue("payorg", (Object)orgId);
        }
        if (!((Boolean)model.getValue("isPeriod")).booleanValue()) {
            this.init = new InitHelper(orgId, "ap_init");
            if (this.checkInit(org)) {
                BusApBillFormHelper.createByInit(this.getModel(), this.getPageCache(), this.init);
                model.setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
            }
        }
    }

    private boolean checkInit(DynamicObject org) {
        if (ObjectUtils.isEmpty((Object)this.init.getStartDate())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u201c%s\u201d\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"BusApBillEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()}));
            this.onlyExit = true;
            return false;
        }
        return true;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPlanDuedateRange();
        BookDateHelper.setBookDateRange((IFormView)this.getView(), (boolean)false);
        if (((Boolean)this.getModel().getValue("isPeriod")).booleanValue()) {
            return;
        }
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            this.fillToolBar();
            return;
        }
        long orgId = (Long)org.getPkValue();
        if (this.init == null) {
            this.init = new InitHelper(orgId, "ap_init");
        }
        this.binddata();
        this.fillToolBar();
        OperationUtils.setButtonUnvisibleByAppId((String)this.getModel().getDataEntityType().getName(), (IFormView)this.getView());
        this.setAsstactCaption();
        PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
    }

    private void setAsstactCaption() {
        ItemClassEdit asstact;
        String asstName;
        String asstactType = (String)this.getModel().getValue("asstacttype");
        String customerCaption = ResManager.loadKDString((String)"\u7ed3\u7b97\u4f9b\u5e94\u5546", (String)"BusApBillEdit_9", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        String asstactCaption = ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"BusApBillEdit_10", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        if (!asstactCaption.equals(asstName = (asstact = (ItemClassEdit)this.getControl("asstact")).getProperty().getDisplayName().getLocaleValue())) {
            return;
        }
        if ("bd_supplier".equals(asstactType)) {
            asstact.setCaption(new LocaleString(customerCaption));
        } else {
            asstact.setCaption(new LocaleString(asstactCaption));
        }
    }

    public void initialize() {
        super.initialize();
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List entities = e.getRows();
        this.controlEnableForMTO(entities);
    }

    private void controlEnableForMTO(List<RowDataEntity> entries) {
        String sourceBillType = (String)this.getModel().getValue("sourcebilltype");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)sourceBillType)) {
            for (int i = 0; i < entries.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"configuredcode"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"tracknumber"});
            }
        }
    }

    public void changeMtoEnable(DynamicObject material, int row) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String configproperties = material.getString("configproperties");
        Long masterid = material.getLong("masterid");
        HashSet<Long> masterids = new HashSet<Long>(1);
        masterids.add(masterid);
        Map tracewayMap = MTOHelper.getMaterialToTraceWayMap(masterids, (DynamicObject)org);
        List tracewayNumbers = (List)tracewayMap.get(masterid);
        if ("2".equals(configproperties)) {
            this.getView().setEnable(Boolean.TRUE, row, new String[]{"configuredcode"});
        } else {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"configuredcode"});
        }
        if (EmptyUtils.isNotEmpty((Object)tracewayNumbers) && tracewayNumbers.contains("GZ001")) {
            this.getView().setEnable(Boolean.TRUE, row, new String[]{"tracknumber"});
        } else {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"tracknumber"});
        }
    }

    private void binddata() {
        Date startDate = this.init.getStartDate();
        if (startDate == null) {
            return;
        }
        DateEdit bizdate = (DateEdit)this.getControl("bizdate");
        bizdate.setMinDate(startDate);
    }

    private void setPlanDuedateRange() {
        DateEdit plandutedate = (DateEdit)this.getView().getControl("planduedate");
        Date maxDate = (Date)this.getModel().getValue("duedate");
        if (maxDate != null) {
            plandutedate.setMaxDate(maxDate);
        }
    }

    private void fillToolBar() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_unsubmit", "bar_del", "bar_audit", "bar_unaudit", "bar_track", "bar_generatevoucher", "bar_submitandnew", "bar_woff", "bar_push"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_track"});
        if (this.isOpenByHyperlink()) {
            this.onlyExit = true;
        }
        if (this.onlyExit) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submitandnew"});
            return;
        }
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            if (((Boolean)this.getModel().getValue("isselfwoff")).booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_submitandnew"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"bar_submit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_del", "bar_submitandnew"});
            }
        } else if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_audit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unsubmit", "bar_audit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"calculatetaxcbtn"});
            boolean isPeriod = (Boolean)this.getModel().getValue("isPeriod");
            if (isPeriod) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submitandnew"});
            }
        } else if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_generatevoucher"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_unaudit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_audit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_unaudit", "bar_audit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_woff", "bar_push"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"calculatetaxcbtn"});
        }
        if (((Boolean)this.getModel().getValue("isadjust")).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_unaudit"});
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.create4Copy();
        Date currentDate = ObjectUtils.isEmpty((Object)this.init.getCurrentDate()) ? this.init.getStartDate() : this.init.getCurrentDate();
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        this.getModel().setValue("bizdate", (Object)(currentDate.after(bizDate) ? currentDate : bizDate));
        BookDateHelper.setBookDateAndRange((IFormView)this.getView(), (boolean)false);
        this.getModel().setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
    }

    private void create4Copy() {
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            this.init = new InitHelper(org.getLong("id"), "ap_init");
            this.getModel().setValue("basecurrency", this.init.getStandardCurrency().getPkValue());
        }
        BigDecimal headTotalPriceTax = (BigDecimal)model.getValue("pricetaxtotal");
        BigDecimal headTotalPriceTaxLoc = (BigDecimal)model.getValue("pricetaxtotalbase");
        model.setValue("unwoffamt", (Object)headTotalPriceTax);
        model.setValue("unwofflocamt", (Object)headTotalPriceTaxLoc);
        model.setValue("uninvoicedamt", (Object)headTotalPriceTax);
        model.setValue("uninvoicedlocamt", (Object)headTotalPriceTaxLoc);
        int entryCount = this.getModel().getEntryRowCount("entry");
        for (int row = 0; row < entryCount; ++row) {
            BigDecimal quantity = (BigDecimal)this.getModel().getValue("e_quantity", row);
            this.getModel().setValue("e_unwoffqty", (Object)quantity, row);
            this.getModel().setValue("e_uninvoicedqty", (Object)quantity, row);
            BigDecimal payAmt = (BigDecimal)this.getModel().getValue("e_pricetaxtotal", row);
            BigDecimal payLocalAmt = (BigDecimal)this.getModel().getValue("e_pricetaxtotalbase", row);
            this.getModel().setValue("e_unwoffamt", (Object)payAmt, row);
            this.getModel().setValue("e_uninvoicedamt", (Object)payAmt, row);
            this.getModel().setValue("e_unwofflocamt", (Object)payLocalAmt, row);
            this.getModel().setValue("e_uninvoicedlocamt", (Object)payLocalAmt, row);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)"SZJK-PRE-0057");
        }
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("copyentryrow".equals(key)) {
            EntryGrid grid = (EntryGrid)this.getControl("entry");
            int length = grid.getSelectRows().length;
            if (length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u5206\u5f55\u590d\u5236\u3002", (String)"EntryCopyMsg_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            boolean isPriceTotal = (Boolean)this.getModel().getValue("ispricetotal");
            String discountType = (String)this.getModel().getValue("e_discountmode", entryCurrentRowIndex);
            BigDecimal discountRate = (BigDecimal)this.getModel().getValue("e_discountrate", entryCurrentRowIndex);
            boolean isPresent = (Boolean)this.getModel().getValue("e_ispresent", entryCurrentRowIndex);
            if (!isPresent && isPriceTotal && "PERCENT".equals(discountType) && new BigDecimal("100").compareTo(discountRate) == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u542b\u7a0e\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539", (String)"PriceTaxTotalCalculator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.isCopyEntryRow = true;
        } else if ("save".equals(key) || "submit".equals(key)) {
            DynamicObjectCollection hadRevalSrcBusbills;
            boolean existsOtherRevalBus;
            Long revalSrcBusId = (Long)this.getModel().getValue("revaluasrcbusbillid");
            String busNo = (String)this.getModel().getValue("billno");
            String revalSrcBusNo = (String)this.getModel().getValue("revaluasrcbusbillno");
            if (revalSrcBusId != null && revalSrcBusId != 0L && !(existsOtherRevalBus = QueryServiceHelper.exists((String)"ap_busbill", (Object)this.getModel().getValue("id"))) && (hadRevalSrcBusbills = QueryServiceHelper.query((String)"ap_busbill", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)revalSrcBusId), new QFilter("hadrevaluation", "=", (Object)Boolean.TRUE)})).size() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u9700\u91cd\u4f30\u7684\u6682\u4f30\u5e94\u4ed8\u5355%2$s\u5df2\u91cd\u4f30\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u91cd\u4f30\u3002", (String)"RevalSave_0", (String)"fi-ap-formplugin", (Object[])new Object[0]), busNo, revalSrcBusNo));
                args.setCancel(true);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        if (this.isCopyEntryRow && "entry".equals(entryProp.getName())) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                int rowIndex = row.getRowIndex();
                this.calculateRow(this.getModel(), rowIndex, "", BigDecimal.ZERO, false);
                BigDecimal qty = (BigDecimal)this.getModel().getValue("e_quantity", rowIndex);
                this.getModel().setValue("e_unwoffqty", (Object)qty, rowIndex);
                this.getModel().setValue("e_uninvoicedqty", (Object)qty, rowIndex);
            }
        }
        if (!this.isCopyEntryRow && "entry".equals(entryProp.getName())) {
            if (this.suppliersMap == null || this.suppliersMap.size() == 0) {
                this.suppliersMap = FinApBillHelper.setSuppliersToViewCash((IDataModel)this.getModel(), (IPageCache)this.getPageCache());
            }
            Object invoiceSupplierId = this.suppliersMap.get("invoiceSupplierId");
            Object deliverSupplierId = this.suppliersMap.get("deliverSupplierId");
            for (RowDataEntity row : e.getRowDataEntities()) {
                int rowIndex = row.getRowIndex();
                if (EmptyUtils.isNotEmpty((Object)invoiceSupplierId) && !"0".equals(invoiceSupplierId)) {
                    this.getModel().setValue("e_invoicesupplierid", invoiceSupplierId, rowIndex);
                }
                if (!EmptyUtils.isNotEmpty((Object)deliverSupplierId) || "0".equals(deliverSupplierId)) continue;
                this.getModel().setValue("e_deliversupplierid", deliverSupplierId, rowIndex);
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        int i = e.getRowIndex();
        switch (key) {
            case "e_discountrate": {
                if (value == null) break;
                this.verifDiscount(new BigDecimal(value.toString()), i, e);
                break;
            }
            case "currency": 
            case "exratetable": 
            case "exratedate": {
                this.verifHeadNull(value, key, e);
            }
        }
    }

    private void verifHeadNull(Object value, String key, BeforeFieldPostBackEvent e) {
        if (value == null) {
            e.setCancel(true);
            this.getView().updateView(key);
        }
    }

    private void verifDiscount(BigDecimal value, int i, BeforeFieldPostBackEvent e) {
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6b63\u6570\u3002", (String)"BusApBillEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            this.getView().updateView("e_discountrate", i);
            return;
        }
        if (DiscountModeEnum.PERCENT.getValue().equals(this.getModel().getValue("e_discountmode"))) {
            if (value.compareTo(new BigDecimal(100)) == 0 && ((Boolean)this.getModel().getValue("ispricetotal")).booleanValue()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539", (String)"BusApBillEdit_7", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView("e_discountrate", i);
                return;
            }
            if (value.compareTo(new BigDecimal(100)) > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4e0d\u8d85\u8fc7100\u7684\u6570\u5b57\u3002", (String)"BusApBillEdit_4", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView("e_discountrate", i);
                return;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (e.getEntryProp().getName().equals("entry")) {
            this.deleteEntry(e);
        }
        super.beforeDeleteRow(e);
    }

    private void deleteEntry(BeforeDeleteRowEventArgs e) {
        HashMap<String, String> matchKey = new HashMap<String, String>();
        matchKey.put("e_amount", "amount");
        matchKey.put("e_localamt", "localamt");
        matchKey.put("e_pricetaxtotal", "pricetaxtotal");
        matchKey.put("e_pricetaxtotalbase", "pricetaxtotalbase");
        matchKey.put("e_uninvoicedamt", "uninvoicedamt");
        matchKey.put("e_uninvoicedlocamt", "uninvoicedlocamt");
        matchKey.put("e_tax", "tax");
        matchKey.put("e_taxlocalamt", "taxlocamt");
        matchKey.put("e_unwoffamt", "unwoffamt");
        matchKey.put("e_unwofflocamt", "unwofflocamt");
        matchKey.put("e_unwoffnotaxamt", "unwoffnotaxamt");
        matchKey.put("e_unwoffnotaxlocamt", "unwoffnotaxlocamt");
        matchKey.put("e_unwofftax", "unwofftax");
        matchKey.put("e_unwofftaxlocal", "unwofftaxlocal");
        int length = e.getRowIndexs().length;
        for (int i = 0; i < length; ++i) {
            for (Map.Entry entry : matchKey.entrySet()) {
                BigDecimal oldValue = (BigDecimal)this.getModel().getValue((String)entry.getKey(), e.getRowIndexs()[i]);
                this.summaryToHeader(BigDecimal.ZERO, oldValue, (String)entry.getValue());
            }
        }
    }

    private void summaryToHeader(BigDecimal newValue, BigDecimal oldValue, String key) {
        BigDecimal difamount = newValue.subtract(oldValue);
        BigDecimal headAmount = (BigDecimal)this.getModel().getValue(key);
        this.getModel().setValue(key, (Object)headAmount.add(difamount));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("reval".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            Long billId = (Long)this.getModel().getValue("id");
            IFormView parentView = this.getView();
            BusApBillRevaluationHelper.validator(billId, parentView);
        }
        if ("submit".equals(operateKey) || "unsubmit".equals(operateKey) || "save".equals(operateKey) || "unaudit".equals(operateKey) || "audit".equals(operateKey)) {
            this.fillToolBar();
        }
        if (Arrays.asList("save", "submit").contains(operateKey)) {
            this.getView().updateView("allocationentry");
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                this.getView().invokeOperation("refresh");
            }
        }
        if ("unaudit".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
        if ("woff".contains(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isselfwoff", "true");
            option.setVariableValue("woffmode", "part");
            this.getView().invokeOperation("pushwoff", option);
        }
        if ("batchwoff".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if (!"refresh".equals(operateKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
        }
        if ("submit".equals(operateKey) || "save".equals(operateKey)) {
            Map sameBillInfo = (Map)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0023", new HashMap(2), (Object[])new Object[]{this.getModel().getDataEntity(true)});
            this.sameBillWarn(sameBillInfo);
        }
        if ("submit".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            List revalMessages;
            List billIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds();
            List warnMessages = (List)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0067", new ArrayList(2), (Object[])new Object[]{billIds});
            if (!ObjectUtils.isEmpty((Object)warnMessages)) {
                this.getView().showTipNotification(StringUtils.join((Collection)warnMessages, (String)"\n"), Integer.valueOf(30000));
            }
            if (!ObjectUtils.isEmpty((Object)(revalMessages = (List)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0124", new ArrayList(2), (Object[])new Object[]{billIds})))) {
                this.getView().showTipNotification(StringUtils.join((Collection)revalMessages, (String)"\n"), Integer.valueOf(30000));
            }
        }
        OperationUtils.setButtonUnvisibleByAppId((String)this.getModel().getDataEntityType().getName(), (IFormView)this.getView());
    }

    private void woffBusBIlls() {
        Date bookDate = (Date)this.getModel().getValue("bookdate");
        Long billId = (Long)this.getModel().getValue("id");
        ArrayList<Object> billIds = new ArrayList<Object>(2);
        billIds.add(billId);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = org.getLong("id");
        DynamicObject closeAccount = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_closeaccount", (String)"currentdate", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        HashMap<Long, Date> orgIdToCurDateMap = new HashMap<Long, Date>(2);
        orgIdToCurDateMap.put(orgId, closeAccount.getDate("currentdate"));
        Date orgCurDate = closeAccount.getDate("currentdate");
        Date currentDate = new Date();
        ArrayList woffBillBizDates = new ArrayList(2);
        HashMap<String, Comparable<Long>> dateMap = new HashMap<String, Comparable<Long>>(2);
        DynamicObject apInit = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_init", (String)"isfinishinit", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        boolean isfinishinit = apInit.getBoolean("isfinishinit");
        if (!isfinishinit) {
            if (bookDate.before(currentDate)) {
                dateMap.put("id", billId);
                dateMap.put("bizdate", currentDate);
                dateMap.put("bookdate", currentDate);
                woffBillBizDates.add(dateMap);
                String bizDate = SerializationUtils.toJsonString(woffBillBizDates);
                this.invokeWoff(billIds, bizDate);
            } else {
                dateMap.put("id", billId);
                dateMap.put("bizdate", bookDate);
                dateMap.put("bookdate", bookDate);
                woffBillBizDates.add(dateMap);
                String bizDate = SerializationUtils.toJsonString(woffBillBizDates);
                this.invokeWoff(billIds, bizDate);
            }
        } else if (!bookDate.before(currentDate) && !bookDate.before(orgCurDate)) {
            dateMap.put("id", billId);
            dateMap.put("bizdate", bookDate);
            dateMap.put("bookdate", bookDate);
            woffBillBizDates.add(dateMap);
            String bizDate = SerializationUtils.toJsonString(woffBillBizDates);
            this.invokeWoff(billIds, bizDate);
        } else if (!orgCurDate.before(bookDate) && !orgCurDate.before(currentDate)) {
            dateMap.put("id", billId);
            dateMap.put("bizdate", orgCurDate);
            dateMap.put("bookdate", orgCurDate);
            woffBillBizDates.add(dateMap);
            String bizDate = SerializationUtils.toJsonString(woffBillBizDates);
            this.invokeWoff(billIds, bizDate);
        } else if (!currentDate.before(orgCurDate) && !currentDate.before(bookDate)) {
            if (!orgCurDate.before(bookDate)) {
                if (DateUtils.isSameMonth((Date)currentDate, (Date)orgCurDate)) {
                    dateMap.put("id", billId);
                    dateMap.put("bizdate", currentDate);
                    dateMap.put("bookdate", currentDate);
                    woffBillBizDates.add(dateMap);
                    String bizDate = SerializationUtils.toJsonString(woffBillBizDates);
                    this.invokeWoff(billIds, bizDate);
                } else {
                    HashMap<Long, Date> needSelect = new HashMap<Long, Date>(2);
                    needSelect.put(billId, bookDate);
                    HashMap<Long, Date> billOrgDate = new HashMap<Long, Date>(2);
                    billOrgDate.put(billId, orgCurDate);
                    this.showWoffConfirm("needselect1", needSelect, billIds, billOrgDate, orgIdToCurDateMap);
                }
            } else if (DateUtils.isSameMonth((Date)currentDate, (Date)orgCurDate)) {
                dateMap.put("id", billId);
                dateMap.put("bizdate", currentDate);
                dateMap.put("bookdate", currentDate);
                woffBillBizDates.add(dateMap);
                String bizDate = SerializationUtils.toJsonString(woffBillBizDates);
                this.invokeWoff(billIds, bizDate);
            } else if (DateUtils.isSameMonth((Date)currentDate, (Date)bookDate)) {
                dateMap.put("id", billId);
                dateMap.put("bizdate", currentDate);
                dateMap.put("bookdate", currentDate);
                woffBillBizDates.add(dateMap);
                String bizDate = SerializationUtils.toJsonString(woffBillBizDates);
                this.invokeWoff(billIds, bizDate);
            } else {
                HashMap<Long, Date> needSelect = new HashMap<Long, Date>(2);
                needSelect.put(billId, bookDate);
                HashMap<Long, Date> billOrgDate = new HashMap<Long, Date>(2);
                billOrgDate.put(billId, orgCurDate);
                this.showWoffConfirm("needselect2", needSelect, billIds, billOrgDate, orgIdToCurDateMap);
            }
        }
    }

    private void showWoffConfirm(String type, Map<Long, Date> bookDate, List<Object> ids, Map<Long, Date> billOrgDate, Map<Long, Date> orgIdToCurDateMap) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        if ("needselect1".equals(type)) {
            parameter.setCustomParam("needSettle1", bookDate);
        } else {
            parameter.setCustomParam("needSettle2", bookDate);
        }
        parameter.setCustomParam("billorgdate", billOrgDate);
        parameter.setCustomParam("ids", ids);
        parameter.setFormId("ap_offset_date");
        parameter.setCustomParam("operation", (Object)"batchwoff");
        parameter.setCustomParam("orgcurdate", orgIdToCurDateMap);
        parameter.setCustomParam("entityflag", (Object)"ap");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "woff"));
        this.getView().showForm(parameter);
    }

    private void invokeWoff(List<Object> busIds, String bizDate) {
        String ids = SerializationUtils.toJsonString(busIds);
        OperateOption option = OperateOption.create();
        option.setVariableValue("entity", "ap_busbill");
        option.setVariableValue("ids", ids);
        option.setVariableValue("bizdate", bizDate);
        this.getView().invokeOperation("batchwoff", option);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "e_corebillno": {
                int row = this.getModel().getEntryCurrentRowIndex("entry");
                String coreBillType = (String)this.getModel().getValue("e_corebilltype", row);
                ArApCorebillHelper.showCoreBillF7((String)coreBillType, (IFormView)this.getView(), (String)this.getPluginName());
                break;
            }
            case "sameinfo_view": {
                Map sameBillInfo = (Map)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0023", new HashMap(2), (Object[])new Object[]{this.getModel().getDataEntity(true)});
                if (sameBillInfo != null && !sameBillInfo.isEmpty()) {
                    ArrayList sameBillNos = new ArrayList(sameBillInfo.values());
                    ListShowParameter parameter = new ListShowParameter();
                    parameter.setBillFormId("ap_busbill");
                    parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    QFilter qFilter = new QFilter("billno", "in", sameBillNos.get(0));
                    parameter.getListFilterParameter().setFilter(qFilter);
                    parameter.setCustomParam("checkKey", (Object)Boolean.TRUE);
                    this.getView().showForm((FormShowParameter)parameter);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
                    break;
                }
            }
            case "sameinfo_ignore": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Object returnData = e.getReturnData();
        switch (id) {
            case "coreBill": {
                ArApCorebillHelper.closeCoreBillF7((IDataModel)this.getModel(), (String)"entry", (Object)returnData);
                this.getView().updateView("entry");
                break;
            }
            case "editinbulk": {
                Map returnMap = (Map)returnData;
                if (ObjectUtils.isEmpty((Object)returnMap)) {
                    return;
                }
                DynamicObjectCollection returnEntrys = (DynamicObjectCollection)returnMap.get("entrys");
                Map srcEntryRowMap = (Map)returnMap.get("srcEntryRowMap");
                BusApEditInBulkService editInBulkService = new BusApEditInBulkService(this.getView(), this.getPluginName());
                editInBulkService.returnParent(returnEntrys, srcEntryRowMap);
                this.getPageCache().put("iseditinbulk", "true");
                this.getView().updateView();
                break;
            }
            case "woff": {
                if (returnData == null) {
                    return;
                }
                Map woffMap = (Map)returnData;
                List busIds = (List)woffMap.get("ids");
                String bizDate = (String)woffMap.get("bizdate");
                this.invokeWoff(busIds, bizDate);
                break;
            }
            case "ap_totaldiscount": {
                Map discountMap = (Map)returnData;
                if (!EmptyUtils.isNotEmpty((Object)discountMap)) break;
                this.setEntryDiscountAmt(discountMap);
            }
        }
    }

    private void setEntryDiscountAmt(Map<String, Object> discountMap) {
        IDataModel m = this.getModel();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        if (entrys != null && entrys.size() > 0) {
            for (int i = 0; i < entrys.size(); ++i) {
                if (((DynamicObject)entrys.get(i)).getBoolean("e_ispresent")) continue;
                m.beginInit();
                m.setValue("e_discountamount", (Object)BigDecimal.ZERO, i);
                m.setValue("e_discountmode", (Object)"TOTAL", i);
                m.endInit();
                this.calculateRow(this.getModel(), i, "e_discountamount", this.getModel().getValue("e_discountamount", i), false);
            }
        }
        DiscountAmtHelper discountService = new DiscountAmtHelper();
        discountService.setEntryDiscountAmt(BillModelFactory.getModel((String)"ap_busbill"), m, discountMap);
        entrys = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < entrys.size(); ++i) {
            this.calculateRow(this.getModel(), i, "e_discountamount", this.getModel().getValue("e_discountamount", i), false);
        }
        this.calculateAllocationDetail();
        this.getView().updateView("fs_amtinfo");
        this.getView().updateView("entry");
        this.getView().updateView("allocationentry");
        PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
    }

    protected int getLocalPrecision() {
        int localPrecision = 2;
        DynamicObject baseCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)baseCurrency)) {
            localPrecision = baseCurrency.getInt("amtprecision");
        }
        return localPrecision;
    }

    private boolean isOpenByHyperlink() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter == null) {
            return false;
        }
        Object customParam = formShowParameter.getCustomParam("isOpenByHyperLink");
        if (customParam == null) {
            return false;
        }
        if (customParam instanceof Boolean) {
            return (Boolean)customParam;
        }
        if (customParam instanceof String) {
            return "true".equals(customParam);
        }
        return false;
    }

    private void filterPayproperty() {
        BasedataEdit paypropertyF7 = (BasedataEdit)this.getControl("payproperty");
        paypropertyF7.addBeforeF7SelectListener(evt -> {
            String billStatus = (String)this.getModel().getValue("billstatus");
            if (!"A".equals(billStatus)) {
                DynamicObject payproperty = (DynamicObject)this.getModel().getValue("payproperty");
                Boolean isbasedonamt = payproperty.getBoolean("isbasedonamt");
                ListFilterParameter lfp = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                lfp.getQFilters().add(new QFilter("isbasedonamt", "=", (Object)isbasedonamt));
            }
        });
    }

    public void afterLoadData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"sameinfoflex"});
        Object billStatus = this.getModel().getValue("billstatus");
        if ("B".equals(billStatus) || "A".equals(billStatus)) {
            Map sameBillInfo = (Map)ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0023", new HashMap(2), (Object[])new Object[]{this.getModel().getDataEntity(true)});
            this.sameBillWarn(sameBillInfo);
        }
    }

    private void sameBillWarn(Map<String, List<String>> sameBillInfo) {
        if (sameBillInfo == null || sameBillInfo.isEmpty()) {
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"sameinfoflex"});
        ArrayList<List<String>> sameBillNos = new ArrayList<List<String>>(sameBillInfo.values());
        Label label = (Label)this.getView().getControl("sameinfo_labelap");
        String message = ResManager.loadKDString((String)"\u91cd\u590d\u4ed8\u6b3e\u98ce\u9669\u63d0\u9192\uff1a", (String)"FinApBillEdit_31", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        String billName = ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u4ed8\u5355", (String)"FinApBillEdit_57", (String)"fi-ap-formplugin", (Object[])new Object[0]);
        label.setText(message.concat(ExecCtrlHelper.getSameBillMessage((List)((List)sameBillNos.get(0)), (String)billName)));
    }
}

