/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.DateEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.util.DateUtils;
import kd.fi.arapcommon.util.StringUtils;

public class CloseAccountSettingPlugin
extends AbstractFormPlugin
implements ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirm", "cancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List pks = (List)this.getView().getFormShowParameter().getCustomParam("pks");
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)pks)};
        DynamicObject[] closeAccountInfos = BusinessDataServiceHelper.load((String)"ap_closeaccount", (String)this.getSelectors(), (QFilter[])filters);
        Long[] orgIds = new Long[closeAccountInfos.length];
        for (int i = 0; i < closeAccountInfos.length; ++i) {
            orgIds[i] = closeAccountInfos[i].getDynamicObject("org").getLong("id");
        }
        this.getModel().setValue("org", (Object)orgIds);
        if (this.isCloseAcountOperation()) {
            this.closeAccountFormInit(closeAccountInfos);
        } else {
            this.antiCloseAccountFormInit(closeAccountInfos);
        }
    }

    private void closeAccountFormInit(DynamicObject[] closeAccountInfos) {
        Date maxCurrentDate = this.getMaxDate(closeAccountInfos, "currentdate");
        Date defaultCloseDate = DateUtils.getMaxMonthDate((Date)maxCurrentDate);
        this.getModel().setValue("closedate", (Object)defaultCloseDate);
        if (closeAccountInfos.length == 1) {
            DateEdit closeDateEdit = (DateEdit)this.getControl("closedate");
            closeDateEdit.setMinDate(maxCurrentDate);
        }
        Label notice = (Label)this.getControl("notice");
        notice.setText(ResManager.loadKDString((String)"\u63d0\u793a\uff1a\u6240\u9009\u7ec4\u7ec7\u6267\u884c\u5173\u8d26\u540e\uff0c\u5c06\u65e0\u6cd5\u7ef4\u62a4\u5173\u8d26\u65e5\u671f\u4e4b\u524d\u7684\u4e1a\u52a1\u3002", (String)"CloseAccountSettingPlugin_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
    }

    private void antiCloseAccountFormInit(DynamicObject[] closeAccountInfos) {
        Date minMonthDate;
        Date maxStartDate = this.getMaxDate(closeAccountInfos, "startdate");
        Date minCurrentDate = this.getMinDate(closeAccountInfos, "currentdate");
        minCurrentDate = DateUtils.getLastDay((Date)minCurrentDate, (int)1);
        maxStartDate = DateUtils.getLastDay((Date)maxStartDate, (int)1);
        Date defaultAntiCloseDate = null;
        defaultAntiCloseDate = minCurrentDate.before(maxStartDate) ? maxStartDate : (maxStartDate.after(defaultAntiCloseDate = DateUtils.getLastDay((Date)(minMonthDate = DateUtils.getMinMonthDate((Date)minCurrentDate)), (int)1)) ? maxStartDate : defaultAntiCloseDate);
        this.getModel().setValue("closedate", (Object)defaultAntiCloseDate);
        if (closeAccountInfos.length == 1) {
            DateEdit aimDateEdit = (DateEdit)this.getControl("closedate");
            aimDateEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53cd\u5173\u8d26\u65e5\u671f", (String)"CloseAccountSettingPlugin_1", (String)"fi-ap-formplugin", (Object[])new Object[0])));
            aimDateEdit.setMinDate(maxStartDate);
            aimDateEdit.setMaxDate(minCurrentDate);
        }
        Label notice = (Label)this.getControl("notice");
        notice.setText(ResManager.loadKDString((String)"\u63d0\u793a\uff1a\u6240\u9009\u7ec4\u7ec7\u6267\u884c\u53cd\u5173\u8d26\u540e\uff0c\u5f53\u524d\u65e5\u671f\u5c06\u66f4\u65b0\u5230\u53cd\u5173\u8d26\u65e5\u671f\u540e\u9762\u4e00\u5929\uff0c\u53ef\u8fdb\u884c\u76f8\u5173\u64cd\u4f5c\u3002", (String)"CloseAccountSettingPlugin_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
    }

    private Date getMinDate(DynamicObject[] closeAccountInfos, String dateName) {
        return this.getExtremeDate(closeAccountInfos, dateName, false);
    }

    private Date getMaxDate(DynamicObject[] closeAccountInfos, String dateName) {
        return this.getExtremeDate(closeAccountInfos, dateName, true);
    }

    private Date getExtremeDate(DynamicObject[] closeAccountInfos, String dateName, boolean getMax) {
        Date aimDate = null;
        for (DynamicObject info : closeAccountInfos) {
            Date date = info.getDate(dateName);
            if (aimDate != null && date != null) {
                if (getMax) {
                    aimDate = aimDate.after(date) ? aimDate : date;
                    continue;
                }
                aimDate = aimDate.before(date) ? aimDate : date;
                continue;
            }
            aimDate = date;
        }
        return aimDate;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("confirm".equals(key)) {
            this.confirm();
        } else if ("cancel".equals(key)) {
            this.getView().close();
        }
    }

    private void confirm() {
        Date aimDate = (Date)this.getModel().getValue("closedate");
        this.getView().returnDataToParent((Object)aimDate);
        this.getView().close();
    }

    private boolean isCloseAcountOperation() {
        Object operation = this.getView().getFormShowParameter().getCustomParam("operation");
        return "closeaccount".equals(operation);
    }

    private String getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("org");
        selectors.add("billno");
        selectors.add("isfinishinit");
        selectors.add("currentdate");
        selectors.add("startdate");
        selectors.add("failedmessage");
        selectors.add("billtype");
        selectors.add("count");
        selectors.add("status");
        selectors.add("duedate");
        return StringUtils.listToString(selectors);
    }
}

