/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.business.invoice.InvoiceAdjustDiffService;
import kd.fi.ap.business.invoice.InvoiceAssignService;
import kd.fi.ap.business.invoice.collect.ICollectInvoiceService;
import kd.fi.ap.enums.InvoiceAdjustEnum;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.piaozone.ReplaceInvoiceHelper;
import kd.fi.ap.piaozone.ShowInvoiceCloudPageUtil;
import kd.fi.ap.vo.InvoiceAdjustParam;
import kd.fi.ap.vo.InvoiceCollectParam;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.util.StringUtils;

public class FinApBillEdit4Inv
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final String INVOICE_PAGE_SELECT_INVOICE = "selectInvoice";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("inventry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap4"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey().toLowerCase();
        if ("bar_assign".equals(key)) {
            DynamicObject finbill = this.getModel().getDataEntity(false);
            Set replaceBillIds = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_finapbill", (long)finbill.getLong("org.id"), (long)finbill.getLong("id"));
            if (!replaceBillIds.isEmpty()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u64cd\u4f5c\u5931\u8d25\u3002\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6362\u7968\u8bb0\u5f55\uff0c\u8bf7\u901a\u8fc7\u8054\u67e5-\u67e5\u770b\u6362\u7968\u8bb0\u5f55\u5220\u9664\u6216\u5ba1\u6838\u6362\u7968\u8bb0\u5f55\u540e\u91cd\u8bd5\u3002", (String)"FinApBillList4Inv_5", (String)"fi-ap-formplugin", (Object[])new Object[0]), finbill.getString("billno")));
                return;
            }
            HashSet<Long> finPks = new HashSet<Long>(2);
            finPks.add(finbill.getLong("id"));
            this.getPageCache().put("finPks", JsonUtils.objToJson(finPks));
            InvoiceAssignService assignService = (InvoiceAssignService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.ASSGININVOICE.getValue());
            ListShowParameter lsp = assignService.showInvoiceF7(this.getView(), new DynamicObject[]{finbill});
            if (lsp != null) {
                lsp.setCustomParam("apassign", (Object)"true");
                lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "invoiceF7"));
                this.getView().showForm((FormShowParameter)lsp);
            }
        } else if ("bar_collect".equals(key)) {
            Object org = this.getModel().getValue("org");
            Object asstact = this.getModel().getValue("asstact");
            if (EmptyUtils.isEmpty((Object)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinApBillEdit4Inv_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            } else if (EmptyUtils.isEmpty((Object)asstact)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f80\u6765\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinApBillEdit4Inv_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            } else {
                CallCloudHelper.showInvoiceAssistant((AbstractFormPlugin)this);
            }
        } else if ("i_deleteentry".equals(key)) {
            this.deleteInvEntry();
        } else if ("i_sysinvstatus".equals(key)) {
            this.sysInvStatus();
        } else if ("i_replaceinvoice".equals(key)) {
            this.replaceInvoice();
        } else if ("bar_viewreplaceinv".equals(key)) {
            long billId = this.getModel().getDataEntity().getLong("id");
            HashSet<Long> orgIds = new HashSet<Long>(2);
            orgIds.add(this.getModel().getDataEntity().getLong("org.id"));
            ReplaceInvoiceHelper.viewReplaceInvoiceList((IFormView)this.getView(), orgIds, Collections.singletonList(billId));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }

    private void setInvStatusEntry() {
        IDataModel m = this.getModel();
        DynamicObjectCollection invEntry = m.getEntryEntity("inventry");
        if (!ObjectUtils.isEmpty((Object)invEntry)) {
            Long invId;
            Set invIds = invEntry.stream().filter(t -> t.getLong("invid") > 0L).map(t -> t.getLong("invid")).collect(Collectors.toSet());
            DataSet invDataSet = QueryServiceHelper.queryDataSet((String)"invoiceselectbyid", (String)"ap_invoice", (String)"id,invoicestatus,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", invIds)}, (String)"id");
            HashMap<Long, String> orderBillMap = new HashMap<Long, String>(8);
            for (Row row : invDataSet) {
                invId = row.getLong("id");
                String invStatus = row.getString("invoicestatus");
                orderBillMap.put(invId, invStatus);
            }
            for (DynamicObject inv : invEntry) {
                invId = inv.getLong("invid");
                inv.set("i_invoicestatus", orderBillMap.get(invId));
            }
        }
    }

    private void sysInvStatus() {
        EntryGrid invEntryGrid = (EntryGrid)this.getControl("inventry");
        int[] selectRows = invEntryGrid.getSelectRows();
        Set<Object> invIds = new HashSet(8);
        IDataModel m = this.getModel();
        DynamicObjectCollection invEntrys = m.getEntryEntity("inventry");
        if (selectRows != null && selectRows.length > 0) {
            for (int row : selectRows) {
                DynamicObject invEntry = (DynamicObject)invEntrys.get(row);
                long invId = invEntry.getLong("invid");
                if (invId == 0L) continue;
                invIds.add(invId);
            }
        } else if (invEntrys.size() > 0) {
            invIds = invEntrys.stream().filter(t -> t.getLong("invid") > 0L).map(t -> t.getLong("invid")).collect(Collectors.toSet());
        }
        if (invEntrys.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5173\u8054\u6536\u7968\u5355\u65e0\u9700\u540c\u6b65\u3002", (String)"FinApBillEdit4Inv_6", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"ap_invoice", (String)"id,invoicestatus,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", invIds)});
        if (invoices.isEmpty() || invIds.size() != invoices.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\uff0c\u518d\u540c\u6b65\u72b6\u6001\u3002", (String)"FinApBillEdit4Inv_13", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> errorInfos = new ArrayList<String>(10);
        HashSet<Long> errInvSet = new HashSet<Long>(8);
        for (DynamicObject row : invoices) {
            String invBillno = row.getString("billno");
            String invStatus = row.getString("invoicestatus");
            Long invId = row.getLong("id");
            if (StringUtils.isEmpty((String)invStatus)) {
                errorInfos.add(String.format(ResManager.loadKDString((String)"\u6536\u7968\u5355\u201c%s\u201d\u53d1\u7968\u72b6\u6001\u4e3a\u7a7a\u65e0\u9700\u540c\u6b65\u72b6\u6001\u3002", (String)"FinApBillEdit4Inv_2", (String)"fi-ap-formplugin", (Object[])new Object[0]), invBillno));
                errInvSet.add(invId);
            }
            if (!StringUtils.isNotEmpty((String)invStatus) || "0".equals(invStatus)) continue;
            errorInfos.add(String.format(ResManager.loadKDString((String)"\u6536\u7968\u5355\u201c%s\u201d \u975e\u6b63\u5e38\u53d1\u7968\u72b6\u6001\u65e0\u9700\u540c\u6b65\u72b6\u6001\u3002", (String)"FinApBillEdit4Inv_3", (String)"fi-ap-formplugin", (Object[])new Object[0]), invBillno));
            errInvSet.add(invId);
        }
        invIds.removeAll(errInvSet);
        if (invIds.size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("sendwarnmsg", "false");
            OperationResult result = OperationServiceHelper.executeOperate((String)"updateinvstatus", (String)"ap_invoice", (Object[])invIds.toArray(new Object[0]), (OperateOption)option);
            if (result.isSuccess() && errorInfos.size() == 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"FinApBillEdit4Inv_4", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                DataSet latestInvoiceDataSet = QueryServiceHelper.queryDataSet((String)"query_invoice_status", (String)"ap_invoice", (String)"id,invoicestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", invIds)}, (String)"");
                HashMap<Long, String> latestInvStatusMap = new HashMap<Long, String>(8);
                for (Row invoice : latestInvoiceDataSet) {
                    latestInvStatusMap.put(invoice.getLong("id"), invoice.getString("invoicestatus"));
                }
                DynamicObjectCollection invEntry = this.getModel().getEntryEntity("inventry");
                for (int i = 0; i < invEntry.size(); ++i) {
                    long invId = ((DynamicObject)invEntry.get(i)).getLong("invid");
                    if (!invIds.contains(invId)) continue;
                    this.getModel().setValue("i_invoicestatus", latestInvStatusMap.get(invId), i);
                }
            }
            if (!result.isSuccess()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u72b6\u6001\u5931\u8d25\uff0c\u8bf7\u5173\u6ce8\u53d1\u7968\u72b6\u6001\u53d8\u5316\u3002", (String)"FinApBillEdit4Inv_5", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
        }
        if (errorInfos.size() > 0) {
            this.showMessage(errorInfos);
        }
    }

    private void showMessage(List<String> errorInfos) {
        StringBuilder sb = new StringBuilder();
        for (String errorInfo : errorInfos) {
            sb.append(errorInfo).append('\n');
        }
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53d1\u7968\u72b6\u6001\u540c\u6b65\u5b8c\u6210\u3002", (String)"FinApBillEdit4Inv_7", (String)"fi-ap-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if ("invoiceF7".equalsIgnoreCase(actionId)) {
            InvoiceAssignService assignService = (InvoiceAssignService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.ASSGININVOICE.getValue());
            assignService.closedCallBack((AbstractFormPlugin)this, actionId, e.getReturnData());
        }
        if (actionId.startsWith(INVOICE_PAGE_SELECT_INVOICE) && !ObjectUtils.isEmpty((Object)returnData)) {
            InvoiceCollectParam collectParam = new InvoiceCollectParam();
            collectParam.setActionId(actionId);
            collectParam.setFormView(this.getView());
            collectParam.setReturnData((Map)returnData);
            ICollectInvoiceService collectService = (ICollectInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPCOLLECT.getValue());
            collectService.collectInvoice(collectParam);
        }
        if ("replaceinvconfirm".equals(actionId) && !ObjectUtils.isEmpty((Object)returnData)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("inventry");
            int[] selectRows = entryGrid.getSelectRows();
            ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
            for (int selectRow : selectRows) {
                invoiceIds.add((Long)this.getModel().getValue("invid", selectRow));
            }
            this.openReplaceInvPage(invoiceIds, Boolean.parseBoolean(String.valueOf(returnData)));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String key = e.getFieldName();
        if ("i_billno".equals(key)) {
            BillShowParameter param = new BillShowParameter();
            param.setPkId(this.getModel().getValue("invid", e.getRowIndex()));
            param.setStatus(OperationStatus.VIEW);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setFormId("ap_invoice");
            this.getView().showForm((FormShowParameter)param);
        } else if ("i_invoiceno".equals(key)) {
            int rowIndex = e.getRowIndex();
            this.viewInvoiceByInvoiceNo(rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        DynamicObjectCollection invEntry;
        super.beforeDoOperation(e);
        AbstractOperate op = (AbstractOperate)e.getSource();
        String key = op.getOperateKey();
        if ("toviewinvoice".equals(key) && (invEntry = this.getModel().getEntryEntity("inventry")).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5173\u8054\u53d1\u7968\u3002", (String)"FinApBillEdit4Inv_9", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
        if ("invdiffadjust".equals(key) || "antiassign".equals(key)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            switch (key) {
                case "invdiffadjust": 
                case "antiassign": 
                case "assign": 
                case "deleteinventry": {
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "toviewinvoice": {
                    ShowInvoiceCloudPageUtil.viewInvoice((IFormView)this.getView(), (long)this.getModel().getDataEntity().getLong("id"));
                }
            }
        }
        if ("assignsave".equals(key)) {
            this.getView().invokeOperation("refresh");
        }
        if (("save".equals(key) || "submit".equals(key)) && operationResult != null && !operationResult.isSuccess()) {
            InvoiceAdjustDiffService adjustDiffService = (InvoiceAdjustDiffService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.INVOCIEADJUST.getValue());
            DynamicObject[] entities = new DynamicObject[]{this.getModel().getDataEntity(true)};
            InvoiceAdjustParam invoiceAdjustParam = new InvoiceAdjustParam(InvoiceAdjustEnum.ROLLBACK);
            adjustDiffService.executeAdjustDiff(entities, invoiceAdjustParam);
        }
    }

    private void deleteInvEntry() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("inventry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"FinApBillEdit4Inv_10", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        Long invPk = (Long)this.getModel().getValue("invid", selectRows[0]);
        String billno = (String)this.getModel().getValue("i_billno", selectRows[0]);
        String srctype = (String)this.getModel().getValue("i_srctype", selectRows[0]);
        String invoicecode = (String)this.getModel().getValue("i_invoicecode", selectRows[0]);
        String invoiceno = (String)this.getModel().getValue("i_invoiceno", selectRows[0]);
        HashSet<String> canDeleteInvRowTypes = new HashSet<String>(8);
        canDeleteInvRowTypes.add(InvoiceSrcTypeEnum.INVOICECOLLECT.getValue());
        canDeleteInvRowTypes.add(InvoiceSrcTypeEnum.ASSIGNINVOICE.getValue());
        canDeleteInvRowTypes.add(InvoiceSrcTypeEnum.COORDINATEINVOICE.getValue());
        List extendRowType = InvoiceHelper.getExtendSrcTypes();
        canDeleteInvRowTypes.addAll(extendRowType);
        if (!canDeleteInvRowTypes.contains(srctype)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s\uff0c\u53d1\u7968\u4ee3\u7801%2$s\uff1a\u884c\u6765\u6e90\u662f\u53d1\u7968\u91c7\u96c6\u3001\u5e94\u4ed8\u6307\u5b9a\u53d1\u7968\u3001\u5e94\u6536\u534f\u540c\u65f6\u624d\u53ef\u5220\u9664\u3002", (String)"FinApBillEdit4Inv_11", (String)"fi-ap-formplugin", (Object[])new Object[0]), invoiceno, invoicecode));
            return;
        }
        if (EmptyUtils.isNotEmpty((Object)billno)) {
            if ("B".equals(this.getModel().getValue("billstatus"))) {
                this.getView().invokeOperation("refresh");
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("invPk", String.valueOf(invPk));
            OperationResult result = this.getView().invokeOperation("deleteinventry", operateOption);
            OperationHelper.assertResult((OperationResult)result);
        } else {
            this.getModel().deleteEntryRow("inventry", selectRows[0]);
        }
    }

    private void replaceInvoice() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("inventry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"FinApBillEdit4Inv_14", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> invoiceIds = new ArrayList<Long>(8);
        boolean isCanReplaceInv = true;
        for (int selectRow : selectRows) {
            Object srcType = this.getModel().getValue("i_srctype", selectRow);
            if (InvoiceSrcTypeEnum.SUPPLIERCOORDINATE.getValue().equals(srcType) || InvoiceSrcTypeEnum.INVOICEMATCH.getValue().equals(srcType) || InvoiceSrcTypeEnum.BYINVOICE.getValue().equals(srcType)) {
                isCanReplaceInv = false;
                break;
            }
            if (!"C".equals(this.getModel().getValue("billstatus"))) {
                isCanReplaceInv = false;
                break;
            }
            if (BigDecimal.ZERO.compareTo((BigDecimal)this.getModel().getValue("i_usedamt", selectRow)) == 0) {
                isCanReplaceInv = false;
                break;
            }
            invoiceIds.add((Long)this.getModel().getValue("invid", selectRow));
        }
        String errorMessage = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6ee1\u8db3\u4ee5\u4e0b\u6761\u4ef6\u624d\u5141\u8bb8\u6362\u7968\uff1a1.\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\uff1b2.\u53d1\u7968\u660e\u7ec6\u4e0d\u4e3a\u7a7a\u5e76\u4e14\u884c\u6765\u6e90\u4e0d\u4e3a\u4f9b\u5e94\u5546\u534f\u540c\u6216\u53d1\u7968\u5339\u914d\u6216\u53d1\u7968\u4e0b\u63a8\uff1b3.\u5e94\u4ed8\u5173\u8054\u7684\u6362\u7968\u8bb0\u5f55\u5df2\u5ba1\u6838\uff1b4.\u6240\u9009\u53d1\u7968\u5173\u8054\u7684\u6362\u7968\u8bb0\u5f55\u5df2\u5ba1\u6838\uff1b5.\u6536\u7968\u5355\u5360\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u672c\u6b21\u5360\u7528\u91d1\u989d\u4e0d\u4e3a0\u3002", (String)"FinApBillEdit4Inv_15", (String)"fi-ap-formplugin", (Object[])new Object[0]), this.getModel().getValue("billno"));
        if (!isCanReplaceInv) {
            this.getView().showErrorNotification(errorMessage);
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        HashSet<Long> orgIds = new HashSet<Long>(2);
        orgIds.add(org.getLong("id"));
        long billId = this.getModel().getDataEntity().getLong("id");
        Map onTheWayFinApIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_finapbill", orgIds, Collections.singletonList(billId));
        if (!onTheWayFinApIdsMap.isEmpty()) {
            this.getView().showErrorNotification(errorMessage);
            return;
        }
        Map onTheWayInvoiceIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_invoice", orgIds, invoiceIds);
        if (!onTheWayInvoiceIdsMap.isEmpty()) {
            this.getView().showErrorNotification(errorMessage);
            return;
        }
        DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"query_finap", (String)"ap_finapbill", (String)"id,inventry.invid", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("inventry.invid", "in", invoiceIds), new QFilter("billstatus", "=", (Object)"C"), new QFilter("inventry.i_usedamt", "!=", (Object)BigDecimal.ZERO)}, (String)"");
        HashMap<Long, List> inv4FinApIdsMap = new HashMap<Long, List>(8);
        for (Object row : finApDataSet) {
            Long l = row.getLong("inventry.invid");
            Long finApId = row.getLong("id");
            List finApBillIds = inv4FinApIdsMap.getOrDefault(l, new ArrayList(8));
            finApBillIds.add(finApId);
            inv4FinApIdsMap.put(l, finApBillIds);
        }
        ArrayList moreFinApInvIds = new ArrayList(8);
        for (Map.Entry entry : inv4FinApIdsMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            moreFinApInvIds.add(entry.getKey());
        }
        if (moreFinApInvIds.isEmpty()) {
            this.openReplaceInvPage(invoiceIds, true);
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ap_replaceinvconfirm");
            showParameter.setShowTitle(false);
            showParameter.setShowClose(false);
            showParameter.getCustomParams().put("invoiceids", JsonUtils.objToJson(moreFinApInvIds));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "replaceinvconfirm"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private void openReplaceInvPage(List<Long> oldInvIds, boolean isReplaceAllAp) {
        InvoiceHelper.updateInvoiceStatus((Long[])oldInvIds.toArray(new Long[0]));
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setFormId("ap_replaceinvapply");
        billShowParameter.setStatus(OperationStatus.ADDNEW);
        billShowParameter.setCustomParam("oldinvids", (Object)JsonUtils.objToJson(oldInvIds));
        if (!isReplaceAllAp) {
            billShowParameter.setCustomParam("finapbillid", (Object)this.getModel().getDataEntity().getLong("id"));
        }
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void viewInvoiceByInvoiceNo(int rowIndex) {
        HashSet<String> serialNoSet = new HashSet<String>(2);
        String serialNo = (String)this.getModel().getValue("i_serialno", rowIndex);
        if (EmptyUtils.isNotEmpty((Object)serialNo)) {
            String[] split = org.apache.commons.lang3.StringUtils.split((String)serialNo, (String)",");
            serialNoSet.addAll(Arrays.asList(split));
        }
        ShowInvoiceCloudPageUtil.viewInvoice((IFormView)this.getView(), (long)this.getModel().getDataEntity().getLong("id"), serialNoSet);
    }

    public void afterLoadData(EventObject e) {
        this.setInvStatusEntry();
    }
}

