/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.DateEdit;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.enums.BillStatusEnum;
import kd.fi.ap.formplugin.formservice.fin.FinApBillPlanEntryHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.ArApSettleTypeHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.service.plan.split.helper.ConditionServiceHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

@Deprecated
public class FinApPeriodBillEdit
extends AbstractBillPlugIn {
    private InitHelper initInfo;
    private boolean isValidatePass = true;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IBillModel model = (IBillModel)this.getModel();
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (!((Boolean)parameter.getCustomParam("isPeriod")).booleanValue()) {
            return;
        }
        if (model.isFromImport()) {
            return;
        }
        this.setDefaultOrg();
        boolean isHasAuthOrg = this.checkHasAuthOrg();
        if (!isHasAuthOrg) {
            return;
        }
        boolean isOrgInit = this.checkOrgIsInitAndNotFinish();
        if (!isOrgInit) {
            return;
        }
        this.setHeadDefaultValue();
        this.setPlanEntryDefaultValue();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IBillModel model = (IBillModel)this.getModel();
        if (!((Boolean)model.getValue("isperiod")).booleanValue()) {
            return;
        }
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        this.fillToolBar();
        this.loadInitInfo();
        this.setDatePropRange();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IBillModel model = (IBillModel)this.getModel();
        boolean isPreiod = (Boolean)model.getValue("isperiod");
        if (!isPreiod) {
            return;
        }
        this.loadInitInfo();
        Date startDate = this.initInfo.getStartDate();
        Date lastDay = DateUtils.getLastDay((Date)startDate, (int)1);
        model.setValue("exratedate", (Object)lastDay);
        model.setValue("bizdate", (Object)lastDay);
        if (this.initInfo.isFinishInit()) {
            this.isValidatePass = false;
            DynamicObject org = (DynamicObject)model.getValue("org");
            String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u4e0d\u80fd\u590d\u5236\u671f\u521d\u5355\u636e\u3002", (String)"FinApPeriodBillEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()});
            this.getView().showErrorNotification(msg);
        }
    }

    private void setDefaultOrg() {
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org) && !ObjectUtils.isEmpty((Object)(org = OrgHelper.getAuthorizedBankOrg((String)"ap", (String)"ap_finapbill", (String)"47156aff000000ac")))) {
            model.setValue("org", (Object)org.getLong("id"));
        }
    }

    private boolean checkHasAuthOrg() {
        boolean checkResult = true;
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            checkResult = false;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6743\u9650\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"ApFinCoreBillEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        return checkResult;
    }

    private boolean checkOrgIsInitAndNotFinish() {
        boolean checkResult = true;
        this.loadInitInfo();
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (ObjectUtils.isEmpty((Object)this.initInfo.getInitId())) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u201c%s\u201d\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"FinApPeriodBillEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()});
            this.getView().showErrorNotification(msg);
            this.isValidatePass = false;
            checkResult = false;
        } else {
            boolean isFinishInit = this.initInfo.isFinishInit();
            if (isFinishInit) {
                String msg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u4e0d\u80fd\u65b0\u589e\u671f\u521d\u5355\u636e\u3002", (String)"FinApPeriodBillEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[]{org.getLocaleString("name").getLocaleValue()});
                this.getView().showErrorNotification(msg);
                this.isValidatePass = false;
                checkResult = false;
            }
        }
        return checkResult;
    }

    private void loadInitInfo() {
        if (this.initInfo == null) {
            IBillModel model = (IBillModel)this.getModel();
            DynamicObject org = (DynamicObject)model.getValue("org");
            long orgId = (Long)org.getPkValue();
            this.initInfo = new InitHelper(orgId, "ap_init");
        }
    }

    private void setHeadDefaultValue() {
        DynamicObject org;
        long orgId;
        DynamicObject payorg;
        IBillModel model = (IBillModel)this.getModel();
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (parameter.getCustomParam("isPeriod") != null) {
            model.setValue("isperiod", parameter.getCustomParam("isPeriod"));
        }
        DynamicObject cur = this.initInfo.getStandardCurrency();
        model.setValue("currency", cur.getPkValue());
        model.setValue("basecurrency", cur.getPkValue());
        model.setValue("exchangerate", (Object)1);
        model.setValue("exratetable", this.initInfo.getExrateTable().getPkValue());
        Date startDate = this.initInfo.getStartDate();
        Date lastDay = DateUtils.getLastDay((Date)startDate, (int)1);
        model.setValue("bizdate", (Object)lastDay);
        model.setValue("exratedate", (Object)lastDay);
        long settleTypeId = ArApSettleTypeHelper.getDefaultSettleType();
        if (settleTypeId != 0L) {
            model.setValue("settlementtype", (Object)settleTypeId);
        }
        DynamicObject finBill = this.getModel().getDataEntity(true);
        DynamicObject splitScheme = PlanSplitSchemeServiceHelper.matchSingleScheme((DynamicObject)finBill);
        model.setValue("splitscheme", (Object)splitScheme);
        Date basicDate = ConditionServiceHelper.getBasicDate((DynamicObject)finBill);
        model.setValue("termsdate", (Object)basicDate);
        if (EmptyUtils.isEmpty((Object)this.getModel().getValue("payorg")) && (payorg = BusinessDataServiceHelper.loadSingleFromCache((Object)(orgId = ((Long)(org = (DynamicObject)model.getValue("org")).getPkValue()).longValue()), (DynamicObjectType)org.getDynamicObjectType())).getBoolean("fisbankroll")) {
            this.getModel().setValue("payorg", (Object)payorg);
        }
        this.getModel().setValue("billsrctype", (Object)BillSrcTypeEnum.MANUAL.getValue());
    }

    private void setPlanEntryDefaultValue() {
        this.calculatePlanEntryAndSetHeadDueDate();
    }

    private void calculatePlanEntryAndSetHeadDueDate() {
        FinApBillPlanEntryHelper.calculatePlanEntryAndSetHeadDueDate(this.getView());
    }

    private void setDatePropRange() {
        if (this.initInfo.getStartDate() == null) {
            return;
        }
        Date startDate = this.initInfo.getStartDate();
        Date lastDay = DateUtils.getLastDay((Date)startDate, (int)1);
        DateEdit bizdate = (DateEdit)this.getControl("bizdate");
        bizdate.setMaxDate(lastDay);
        DateEdit bookDate = (DateEdit)this.getControl("bookdate");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        bookDate.setMinDate(bizDate);
        bookDate.setMaxDate(lastDay);
        DateEdit premDueDate = (DateEdit)this.getControl("premduedate");
        premDueDate.setMinDate(bizDate);
        DateEdit headDueDate = (DateEdit)this.getControl("duedate");
        headDueDate.setMinDate(bizDate);
        DateEdit planDueDate = (DateEdit)this.getControl("planduedate");
        planDueDate.setMinDate(bizDate);
        planDueDate.setMaxDate((Date)this.getModel().getValue("duedate"));
    }

    private void fillToolBar() {
        IFormView view = this.getView();
        view.setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit", "bar_track", "bar_generatevoucher", "bar_save4writeoff", "bar_freeze", "bar_unfreeze"});
        if (!this.isValidatePass) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_save", "bar_submit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_print", "bar_audit", "bar_unaudit", "bar_track", "bar_generatevoucher", "bar_save4writeoff", "bar_collect"});
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{"bar_new", "bar_track"});
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit", "bar_unsubmit", "bar_del", "bar_submitandnew"});
        } else if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_unsubmit"});
            view.setVisible(Boolean.FALSE, new String[]{"bar_audit", "bar_track", "bar_more"});
        } else if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_generatevoucher"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_unaudit"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_track"});
            view.setVisible(Boolean.TRUE, new String[]{"bar_unaudit"});
            view.setVisible(Boolean.FALSE, new String[]{"bar_new"});
        }
        if (((Boolean)this.getModel().getValue("iswrittenoff")).booleanValue()) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_submit", "bar_unaudit"});
        }
        view.setVisible(Boolean.FALSE, new String[]{"bar_assign"});
    }
}

