/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.ap.business.invoice.Invoice4CloudResolveService;
import kd.fi.ap.business.pojo.InvoiceResolveParam;
import kd.fi.ap.errorcode.SystemErrorCode;
import kd.fi.arapcommon.business.piaozone.exception.PZAuthException;
import kd.fi.arapcommon.business.piaozone.info.InvoiceCloudCfg;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.business.piaozone.info.QueryInvoiceDetailInfo;
import kd.fi.arapcommon.business.piaozone.kingdee.APIHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public class InvDownloadEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        OrgEdit orgF7 = (OrgEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List orgIds = OrgHelper.getAuthorizedBankOrgIds((String)showParameter.getAppId(), (String)"ap_invoice", (String)"47156aff000000ac");
            if (!orgIds.isEmpty()) {
                showParameter.setCustomParam("range", (Object)orgIds);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object orgPk = this.getView().getFormShowParameter().getCustomParam("orgPk");
        this.getModel().setValue("org", orgPk);
        this.getModel().setValue("begindate", (Object)InvDownloadEdit.getMonthFirstDay());
        this.getModel().setValue("enddate", (Object)new Date());
    }

    public static Date getMonthFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, 1);
        calendar.add(2, 0);
        return calendar.getTime();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("btnok".equals(key)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (this.btnokValidator()) {
                if (EmptyUtils.isEmpty((Object)this.getModel().getValue("org"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"InvDownloadEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                } else if (!this.codeRuleIsExist(org.getString("id"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u201c\u6536\u7968\u5355\u7f16\u7801\u89c4\u5219\u201d\uff0c\u518d\u4e0b\u8f7d\u53d1\u7968\u3002", (String)"InvDownloadEdit_7", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                } else {
                    long orgPk = org.getLong("id");
                    InitHelper init = new InitHelper(orgPk, "ap_init");
                    if (ObjectUtils.isEmpty((Object)init.getStartDate())) {
                        this.getView().showErrorNotification(String.format(SystemErrorCode.ORGNAME_NOT_FINISHSET().getMessage(), org.getLocaleString("name").getLocaleValue()));
                    } else {
                        try {
                            this.downloadInvoice();
                        }
                        catch (PZAuthException e) {
                            this.getView().showTipNotification(e.getMessage());
                        }
                    }
                }
            }
        }
    }

    private boolean btnokValidator() {
        String invoiceno;
        boolean flag = true;
        IDataModel m = this.getModel();
        String downloadType = (String)m.getValue("mode");
        if ("supplier".equals(downloadType)) {
            String salertaxno = (String)m.getValue("salertaxno");
            DynamicObject supplier = (DynamicObject)m.getValue("supplier");
            if (!EmptyUtils.isEmpty((Object)supplier) && EmptyUtils.isEmpty((Object)salertaxno)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9500\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u201d\u3002", (String)"InvDownloadEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                flag = false;
            }
        } else if ("invNo".equals(downloadType) && EmptyUtils.isEmpty((Object)(invoiceno = (String)m.getValue("invoiceno")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53d1\u7968\u53f7\u7801\u201d\u3002", (String)"InvDownloadEdit_4", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            flag = false;
        }
        return flag;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (key) {
            case "supplier": {
                this.setSalertaxno4Supplier();
                break;
            }
            case "begindate": 
            case "enddate": {
                if (newValue != null) break;
                this.getModel().beginInit();
                this.getModel().setValue(key, oldValue);
                this.getModel().endInit();
            }
        }
    }

    private void downloadInvoice() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        InvoiceCloudCfg config = null;
        try {
            config = KingdeeInvoiceCloudConfig.getConfig((DynamicObject)org);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        String buyerTaxNo = config.getTaxRegnum();
        HashMap<String, Object> param = new HashMap<String, Object>();
        List invoiceVOs = new ArrayList();
        param.put("buyerTaxNo", buyerTaxNo);
        String invoiceTypes = StdConfig.get((String)"invoicecloud.invoiceTypes");
        String mode = (String)this.getModel().getValue("mode");
        if ("invNo".equals(mode)) {
            param.put("invoicecode", this.getModel().getValue("invoicecode"));
            param.put("invoiceno", this.getModel().getValue("invoiceno"));
            APIHelper.invDownloadByNo(param, invoiceVOs);
            if (!invoiceVOs.isEmpty()) {
                String serialNo = ((InvoiceVO)invoiceVOs.get(0)).getSerialNo();
                QueryInvoiceDetailInfo queryInvoiceDetail = this.buildQueryInvoiceDetail(org, serialNo);
                invoiceVOs = APIHelper.queryInvoiceDetailBySerialNo((QueryInvoiceDetailInfo)queryInvoiceDetail);
            }
        } else {
            param.put("pageNo", 1);
            param.put("pageSize", 50);
            param.put("startTime", (Date)this.getModel().getValue("begindate"));
            param.put("endTime", (Date)this.getModel().getValue("enddate"));
            param.put("invoiceTypes", invoiceTypes != null ? invoiceTypes : "1,2,3,4,5");
            param.put("salerTaxNo", (String)this.getModel().getValue("salertaxno"));
            String invoiceStatus = StdConfig.get((String)"invoicecloud.invoiceStatus");
            param.put("invoiceStatus", invoiceStatus != null ? invoiceStatus : "0,1,2,3,4");
            APIHelper.invDownload(param, invoiceVOs);
        }
        if (!invoiceVOs.isEmpty()) {
            Invoice4CloudResolveService resolveService = (Invoice4CloudResolveService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.CLOUDJSONRESOLVE.getValue());
            InvoiceResolveParam resolveParam = new InvoiceResolveParam();
            resolveParam.setOrgId(org.getLong("id")).setBizType((String)this.getModel().getValue("biztype")).setAppId(this.getView().getFormShowParameter().getAppId());
            List downloadInv = resolveService.genInvoice(resolveParam, invoiceVOs);
            if (downloadInv.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u9700\u8981\u7684\u53d1\u7968\u6570\u636e\u5df2\u4e0b\u8f7d\u3002", (String)"InvDownloadEdit_5", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().close();
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u60a8\u9700\u8981\u7684\u53d1\u7968\u6570\u636e\u3002", (String)"InvDownloadEdit_6", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
    }

    private void setSalertaxno4Supplier() {
        DynamicObject sup;
        DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
        String taxNo = "";
        if (!ObjectUtils.isEmpty((Object)supplier) && ObjectUtils.isEmpty((Object)(taxNo = (sup = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)supplier.getDataEntityType().getName(), (String)"tx_register_no,societycreditcode")).getString("tx_register_no")))) {
            taxNo = sup.getString("societycreditcode");
        }
        this.getModel().setValue("salertaxno", (Object)taxNo);
    }

    private QueryInvoiceDetailInfo buildQueryInvoiceDetail(DynamicObject org, String serialNosStr) {
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig((Long)org.getLong("id"));
        QueryInvoiceDetailInfo info = new QueryInvoiceDetailInfo();
        info.setTaxNo(config.getTaxRegnum());
        info.setSerialNo(serialNosStr);
        info.setCompanyName(config.getFirmname());
        info.setOrgId(Long.valueOf(org.getLong("id")));
        info.setBxdKey(null);
        return info;
    }

    private boolean codeRuleIsExist(String orgPk) {
        DynamicObject inv = BusinessDataServiceHelper.newDynamicObject((String)"ap_invoice");
        return CodeRuleServiceHelper.isExist((String)"ap_invoice", (DynamicObject)inv, (String)orgPk);
    }
}

