/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.ap.business.helper.InvoiceCardHelper;
import kd.fi.ap.helper.OrgHelper;

public class InvoiceBuyerEdit
extends AbstractBillPlugIn {
    private static final String btnok = "btnok";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        IDataModel model = this.getModel();
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if (parentModel.getProperty(propName) == null) continue;
            Object propValue = parentModel.getValue(propName);
            if (propValue instanceof DynamicObject) {
                DynamicObject obj = (DynamicObject)propValue;
                model.setValue(propName, obj.getPkValue());
                continue;
            }
            model.setValue(propName, propValue);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buyerbank", "buyername"});
        this.addClickListeners(new String[]{btnok});
        this.initF7();
    }

    private void initF7() {
        this.fillOrg();
    }

    private void fillOrg() {
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("buyer");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("orgpattern", "in", (Object)OrgHelper.getOrgPattern());
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        BasedataEdit control = null;
        switch (key) {
            case "buyername": {
                control = (BasedataEdit)this.getControl("buyer");
                control.click();
                break;
            }
            case "buyerbank": {
                control = (BasedataEdit)this.getControl("buyerbankf7");
                control.click();
                break;
            }
            case "btnok": {
                this.btnOk();
                break;
            }
        }
    }

    private void btnOk() {
        Map resultMap = InvoiceCardHelper.initBuyerParamMap((IDataModel)this.getModel());
        this.getView().returnDataToParent((Object)resultMap);
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "buyer": {
                this.buyerOrgChanged(newValue);
                break;
            }
            case "buyername": {
                if (!"".equals(newValue)) break;
                this.getModel().setValue("buyer", null);
                break;
            }
            case "buyerbankf7": {
                this.buyerbankf7Changed(newValue);
                break;
            }
        }
    }

    private void buyerOrgChanged(Object newValue) {
        DynamicObject org = (DynamicObject)newValue;
        if (org != null) {
            InvoiceCardHelper.fillBuyerInfo((IDataModel)this.getModel(), (DynamicObject)org);
        }
    }

    private void buyerbankf7Changed(Object newValue) {
        DynamicObject bank = (DynamicObject)newValue;
        if (bank != null) {
            this.getModel().setValue("buyerbank", bank.get("name"));
        }
    }
}

