/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.business.helper.InvoiceCardHelper;
import kd.fi.ap.enums.BillStatusEnum;
import kd.fi.ap.enums.DiscountModeEnum;
import kd.fi.ap.errorcode.SystemErrorCode;
import kd.fi.ap.formplugin.ApBaseEdit;
import kd.fi.ap.formplugin.formservice.invoice.ApInvoiceBillImportHelper;
import kd.fi.ap.helper.ApHelper;
import kd.fi.ap.helper.FinApBillHelper;
import kd.fi.ap.helper.OrgHelper;
import kd.fi.ap.helper.SystemParameterHelper;
import kd.fi.ap.piaozone.ShowInvoiceCloudPageUtil;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.ArApCorebillHelper;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.helper.DiscountAmtHelper;
import kd.fi.arapcommon.helper.DynamicListHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;
import kd.fi.arapcommon.helper.PrecisionHelper;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.BillStatusCtrlService;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.OperationUtils;
import kd.fi.arapcommon.util.StdConfig;
import org.apache.commons.lang3.StringUtils;

public class InvoiceEdit
extends ApBaseEdit {
    private static final Log logger = LogFactory.getLog(InvoiceEdit.class);
    private boolean changed = true;
    private boolean changeType = true;
    private static final String INVOICETYPE = "invoiceType";
    private InitHelper init;
    private boolean isCopyEntryRow = false;
    private static final String[] s = new String[]{"receivablesacct", "asstact", "sellertin", "selleraddr", "sellertel", "sellerbank", "selleracct", "selleracct", "asstactname"};
    private static final String[] ENTRY = new String[]{"price", "e_amount", "e_amountbase", "e_tax", "discountamt", "discountlocalamt", "e_pricetaxtotal", "e_pricetaxtotalbase", "e_relatedamt", "e_unrelatedamt", "e_unmatchamt", "e_unmatchqty"};
    private static final String[] HEAD = new String[]{"pricetaxtotal", "pricetaxtotalbase", "amount", "amountbase", "tax", "unrelatedamt", "unmatchamt"};
    private BillStatusCtrlService billStatusCtrlService = new BillStatusCtrlService();
    private ApInvoiceBillImportHelper importHelper;

    public void afterCreateNewData(EventObject e) {
        QFilter[] qFilters;
        super.afterCreateNewData(e);
        this.setDefaultOrg();
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit"});
        try {
            this.createNewModel();
        }
        catch (Exception err) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_submitandnew"});
            if (err instanceof KDBizException) {
                this.getView().showErrorNotification(err.getMessage());
            }
            logger.error("other unknow exception! " + err);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5176\u4ed6\u672a\u77e5\u5f02\u5e38\uff1a%s\u3002", (String)"InvoiceEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[]{err.getMessage()}));
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (status.equals((Object)OperationStatus.EDIT) && org != null) {
            this.setBaseCurrency(org.getLong("id"));
        }
        if (status.equals((Object)OperationStatus.ADDNEW) && org != null && QueryServiceHelper.exists((String)"bos_org", (QFilter[])(qFilters = new QFilter[]{new QFilter("orgpattern", "in", (Object)OrgHelper.getOrgPattern()), new QFilter("id", "=", org.getPkValue())}))) {
            InvoiceCardHelper.fillBuyerInfo((IDataModel)this.getModel(), (DynamicObject)org);
        }
        this.dateChanged(this.getModel().getValue("issuedate"));
        this.setReceivedate(this.getModel().getValue("issuedate"));
        if (EmptyUtils.isEmpty((Object)this.getModel().getValue("serialno"))) {
            this.setTaxDeduction(this.getModel().getValue("invoicetype"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)"SZJK-PRE-0057");
        }
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("copyentryrow".equals(key)) {
            EntryGrid grid = (EntryGrid)this.getControl("entry");
            int length = grid.getSelectRows().length;
            if (length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u5206\u5f55\u590d\u5236\u3002", (String)"EntryCopyMsg_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            boolean isPriceTotal = (Boolean)this.getModel().getValue("isincludetax");
            String discountType = (String)this.getModel().getValue("discountmode", entryCurrentRowIndex);
            BigDecimal discountRate = (BigDecimal)this.getModel().getValue("discountrate", entryCurrentRowIndex);
            if (isPriceTotal && "PERCENT".equals(discountType) && new BigDecimal("100").compareTo(discountRate) == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u542b\u7a0e\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539", (String)"PriceTaxTotalCalculator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.isCopyEntryRow = true;
        }
    }

    private void setDefaultOrg() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            long orgID = OrgHelper.getOrgIDApp((FormShowParameter)fsp, (String)fsp.getFormId(), (String)fsp.getAppId());
            this.getModel().setValue("org", (Object)orgID);
        }
    }

    private void createNewModel() {
        boolean isBankOrg;
        IBillModel model = (IBillModel)this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        long orgId = (Long)org.getPkValue();
        this.init = new InitHelper(org.getLong("id"), "ap_init");
        if (ObjectUtils.isEmpty((Object)this.init.getStartDate())) {
            throw new KDBizException(SystemErrorCode.ORGNAME_NOT_FINISHSET(), new Object[]{org.getLocaleString("name").getLocaleValue()});
        }
        model.setValue("org", (Object)orgId);
        boolean ispurchase = org.getBoolean("fispurchase");
        if (ispurchase) {
            model.setValue("purorg", (Object)orgId);
        }
        if (isBankOrg = org.getBoolean("fisbankroll")) {
            model.setValue("payorg", (Object)orgId);
        }
        this.setBaseCurrency(orgId);
        this.getModel().setValue("exratetable", this.init.getExrateTable().getPkValue());
        this.getModel().setValue("exchangerate", (Object)1);
        this.getModel().setValue("drawer", (Object)RequestContext.get().getUserName());
        this.switchOtherInvoice();
    }

    private void setBaseCurrency(long orgId) {
        DynamicObject cur = this.getInit(orgId).getStandardCurrency();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        if (ObjectUtils.isEmpty((Object)cur)) {
            throw new KDBizException(SystemErrorCode.ORGNAME_NOT_FINISHSET(), new Object[]{org.getLocaleString("name").getLocaleValue()});
        }
        this.getModel().setValue("currency", cur.getPkValue());
        this.getModel().setValue("basecurrency", cur.getPkValue());
        Date currentDate = this.billDateCtrl();
        this.getModel().setValue("issuedate", (Object)(currentDate.compareTo(new Date()) > 0 ? currentDate : new Date()));
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object operate = billShowParameter.getCustomParam(INVOICETYPE);
        if ("OTHER".equals(operate)) {
            this.changeType = false;
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        DynamicObjectCollection entryEntity;
        super.afterBindData(e);
        if (!ObjectUtils.isEmpty((Object)this.init) && ObjectUtils.isEmpty((Object)this.init.getInitId())) {
            return;
        }
        if (this.getModel().getValue("issuedate") != null) {
            Date issueDate = (Date)this.getModel().getValue("issuedate");
            DateEdit dateEdit = (DateEdit)this.getControl("lastpaydate");
            dateEdit.setMinDate(issueDate);
        }
        this.clearSrc4Copy();
        if (this.isBotpNew()) {
            entryEntity = this.getModel().getEntryEntity("entry");
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.calculatorEntryAmt(this.getModel(), i, true);
            }
            this.setHeadAmount();
        }
        InvoiceCardHelper.setBuyerLabel((AbstractBillPlugIn)this);
        InvoiceCardHelper.setSellerLabel((AbstractBillPlugIn)this);
        entryEntity = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (!kd.fi.arapcommon.util.StringUtils.isNotEmpty((String)((DynamicObject)entryEntity.get(i)).getString("e_sourcebillid"))) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"material"});
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit"});
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u6709\u6743\u9650\u201d\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"InvoiceEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        String status = ((BillView)e.getSource()).getFormShowParameter().getStatus().name();
        if (!"ADDNEW".equals(status)) {
            this.getModel().setDataChanged(false);
        }
        this.switchOtherInvoice();
        this.fillToolBarByInvoice();
        this.fillToolBar();
        Object issuedate = this.getModel().getValue("issuedate");
        if (issuedate != null) {
            DateEdit dateEdit = (DateEdit)this.getControl("receivedate");
            dateEdit.setMinDate((Date)issuedate);
        }
        OperationUtils.setButtonUnvisibleByAppId((String)this.getModel().getDataEntityType().getName(), (IFormView)this.getView());
        PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
    }

    public void afterCopyData(EventObject e) {
        this.getModel().setDataChanged(true);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            this.init = new InitHelper(org.getLong("id"), "ap_init");
            this.getModel().setValue("basecurrency", this.init.getStandardCurrency().getPkValue());
        }
        this.getModel().setValue("unrelatedamt", this.getModel().getValue("pricetaxtotal"));
        this.getModel().setValue("unmatchamt", this.getModel().getValue("pricetaxtotal"));
        int count = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < count; ++i) {
            this.getModel().setValue("e_unrelatedamt", this.getModel().getValue("e_pricetaxtotal", i), i);
            this.getModel().setValue("e_unmatchamt", this.getModel().getValue("e_pricetaxtotal", i), i);
            this.getModel().setValue("e_unmatchqty", this.getModel().getValue("quantity", i), i);
        }
        this.getModel().deleteEntryData("finentry");
        this.setReceivedate(this.getModel().getValue("issuedate"));
        this.setTaxDeduction(this.getModel().getValue("invoicetype"));
    }

    private void clearSrc4Copy() {
        if (this.isCopy()) {
            this.getModel().setValue("sourcebillid", null);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
            for (int i = 0; i < entryEntity.size(); ++i) {
                ((DynamicObject)entryEntity.get(i)).set("e_sourcebillid", null);
                ((DynamicObject)entryEntity.get(i)).set("e_sourcebillentryid", null);
            }
            this.switchOtherInvoice();
        }
    }

    private boolean isCopy() {
        boolean isCopy = false;
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object operate = billShowParameter.getCustomParam("iscopy");
        if (operate instanceof Boolean) {
            isCopy = (Boolean)operate;
        }
        return isCopy;
    }

    private Date billDateCtrl() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            Date currentDate = this.getInit(org.getLong("id")).getCurrentDate();
            if (currentDate == null) {
                currentDate = this.getInit(org.getLong("id")).getStartDate();
            }
            return currentDate;
        }
        return new Date();
    }

    private void switchOtherInvoice() {
        Object type;
        if (this.isOtrType()) {
            this.getModel().setValue("biztype", (Object)"FEE");
            this.getModel().setValue("invoicetype", (Object)"OTHER");
            if (this.getModel().getEntryRowCount("entry") == 0) {
                this.getModel().createNewEntryRow("entry");
            }
        }
        if ("OTHER".equals(type = this.getModel().getValue("invoicetype"))) {
            this.setCollapsible("fs_baseinfo", false);
            this.setCollapsible("fs_amountinfo", false);
            FieldEdit ptt = (FieldEdit)this.getControl("pricetaxtotal");
            ptt.setMustInput(true);
            FieldEdit expense = (FieldEdit)this.getControl("expense");
            expense.setMustInput(true);
        } else if (!this.isAllType()) {
            InvoiceType[] invoiceTypeArr;
            ComboEdit item = (ComboEdit)this.getControl("invoicetype");
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            for (InvoiceType invoiceType : invoiceTypeArr = InvoiceType.values()) {
                String invoiceTypeValue = invoiceType.getValue();
                if ("OTHER".equals(invoiceType.getValue())) continue;
                items.add(new ComboItem(new LocaleString(invoiceType.getName()), invoiceTypeValue));
            }
            item.setComboItems(items);
        }
    }

    private boolean isOtrType() {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object operate = billShowParameter.getCustomParam(INVOICETYPE);
        return "OTHER".equals(operate);
    }

    private boolean isAllType() {
        String ignore = StdConfig.get((String)"ignoreInvoiceType");
        return kd.fi.arapcommon.util.StringUtils.isNotEmpty((String)ignore) && ignore.contains("ap");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"withtax1", "withtax2", "addbuyer1", "addbuyer2", "addseller1", "addseller2", "changebuyer", "changeseller", "receivablessupp", "receivablesacct", "asstactname"});
        this.addClickListeners(new String[]{"corebillno"});
        this.initF7();
        this.filterMaterialVersion();
        this.filterMeasureUnit();
        this.taxratefilter();
    }

    private void filterMeasureUnit() {
        BasedataEdit measureUnitEdit = (BasedataEdit)this.getControl("measureunit");
        FormServiceHelper.addMeasureUnitFilter((IDataModel)this.getModel(), (String)"material", (String)"entry", (BasedataEdit)measureUnitEdit);
    }

    private void filterMaterialVersion() {
        BasedataEdit materialVersionF7 = (BasedataEdit)this.getControl("e_materialversion");
        materialVersionF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            int currentRow = this.getModel().getEntryCurrentRowIndex("entry");
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", currentRow);
            if (!ObjectUtils.isEmpty((Object)material)) {
                long materialId = material.getLong("id");
                QFilter filter = new QFilter("material", "=", (Object)materialId);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    private void initF7() {
        this.payeerF7();
    }

    private void taxratefilter() {
        Date issuedate = (Date)this.getModel().getValue("issuedate");
        BasedataEdit taxrateF7 = (BasedataEdit)this.getControl("taxrateid");
        BaseDataHelper.taxratefilter((Date)issuedate, (BasedataEdit)taxrateF7);
    }

    private void payeerF7() {
        BasedataEdit payeerF7 = (BasedataEdit)this.getControl("payeerf7");
        payeerF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject supp = (DynamicObject)this.getModel().getValue("receivablessupp");
            if (supp != null) {
                QFilter qFilter = new QFilter("payer", "=", supp.getPkValue());
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "asstactname": {
                ((BasedataEdit)this.getControl("asstact")).click();
                break;
            }
            case "receivablesacct": {
                this.receivablesAcctF7();
                break;
            }
            case "addseller1": 
            case "addseller2": 
            case "changeseller": {
                this.changeSellerPage();
                break;
            }
            case "addbuyer1": 
            case "addbuyer2": 
            case "changebuyer": {
                this.changeBuyerPage();
                break;
            }
            case "withtax1": {
                this.getModel().setValue("isincludetax", (Object)Boolean.TRUE);
                break;
            }
            case "withtax2": {
                this.getModel().setValue("isincludetax", (Object)Boolean.FALSE);
                break;
            }
            case "corebillno": {
                this.showCoreBillF7();
                break;
            }
        }
    }

    private void showCoreBillF7() {
        int currrow = this.getModel().getEntryCurrentRowIndex("entry");
        String corebilltype = (String)this.getModel().getValue("corebilltype", currrow);
        ArApCorebillHelper.showCoreBillF7((String)corebilltype, (IFormView)this.getView(), (String)this.getPluginName());
    }

    private void receivablesAcctF7() {
        DynamicObject basedata = (DynamicObject)this.getModel().getValue("receivablessupp");
        if (basedata != null) {
            String asstactType = this.getModel().getValue("asstacttype").toString();
            if ("bos_user".equals(asstactType)) {
                BasedataEdit erpayeef7 = (BasedataEdit)this.getControl("payeerf7");
                erpayeef7.click();
            } else {
                String entityId = "bd_supplier".equals(asstactType) ? "bd_supplier" : "bd_customer";
                DynamicObjectCollection coll = DynamicListHelper.getBankCollInfo((Object)basedata.getPkValue(), (String)asstactType);
                if (coll != null) {
                    ListShowParameter lsp = null;
                    lsp = entityId.equals("bd_supplier") ? DynamicListHelper.getSupplierBankInfoShowParameter((Object)basedata.getPkValue()) : DynamicListHelper.getCustomerBankInfoShowParameter((Object)basedata.getPkValue());
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "accountbank");
                    lsp.setCloseCallBack(closeCallBack);
                    BizExtendHelper.payeeBankInfoFilter((ListFilterParameter)lsp.getListFilterParameter(), (IFormView)this.getView());
                    this.getView().showForm((FormShowParameter)lsp);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"InvoiceEdit_5", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f80\u6765\u6237\u3002", (String)"InvoiceEdit_6", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
    }

    private void changeBuyerPage() {
        if (this.getModel().getValue("billstatus").equals(BillStatusEnum.SAVE.getValue())) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("ap_chagebuyer");
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "changeBuyer"));
            this.getView().showForm(parameter);
        }
    }

    private void changeSellerPage() {
        if (this.getModel().getValue("billstatus").equals(BillStatusEnum.SAVE.getValue())) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("ap_addseller");
            parameter.setStatus(OperationStatus.ADDNEW);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            parameter.setCustomParam("orgId", (Object)String.valueOf(org.getPkValue()));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "changeSeller"));
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Object returnData = e.getReturnData();
        switch (id) {
            case "changeBuyer": {
                Map buyerMap = (Map)e.getReturnData();
                if (buyerMap == null) break;
                InvoiceCardHelper.setBuyerInfo((AbstractBillPlugIn)this, (Map)buyerMap);
                break;
            }
            case "changeSeller": {
                Map sellerMap = (Map)e.getReturnData();
                if (sellerMap == null) break;
                InvoiceCardHelper.setSellerInfo((AbstractBillPlugIn)this, (Map)sellerMap);
                break;
            }
            case "accountbank": {
                if (returnData == null) break;
                this.closedBankInfo(returnData);
                break;
            }
            case "coreBill": {
                ArApCorebillHelper.closeCoreBillF7((IDataModel)this.getModel(), (String)"entry", (Object)returnData);
                break;
            }
        }
    }

    private void closedBankInfo(Object returnData) {
        ListSelectedRowCollection returnColl = (ListSelectedRowCollection)returnData;
        ListSelectedRow rowInfo = returnColl.get(0);
        Object entryKey = rowInfo.getEntryPrimaryKeyValue();
        Object pk = rowInfo.getPrimaryKeyValue();
        DynamicObject cutstomer = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)this.getModel().getValue("asstacttype").toString(), (String)"bankaccount,accountname,bank,name,entry_bank");
        DynamicObjectCollection bankEntry = cutstomer.getDynamicObjectCollection("entry_bank");
        for (DynamicObject row : bankEntry) {
            if (!row.getPkValue().equals(entryKey)) continue;
            String actName = row.getLocaleString("accountname").getLocaleValue();
            if (ApHelper.isEmpty((Object)actName)) {
                actName = cutstomer.getLocaleString("name").getLocaleValue();
            }
            this.getModel().setValue("receivablesacct", (Object)row.getString("bankaccount"));
            break;
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if (this.isCopyEntryRow && "entry".equals(e.getEntryProp().getName())) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                this.calculateAmt(this.getModel(), row.getRowIndex());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int rowIndex = changeData[0].getRowIndex();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!this.billStatusCtrlService.isCanChange(billStatus)) {
            return;
        }
        switch (key) {
            case "asstacttype": {
                this.asstactTypeChanged(newValue);
                break;
            }
            case "asstact": {
                this.asstactChanged(newValue);
                break;
            }
            case "receivablessupp": {
                this.receivablessuppF7Changed(newValue, this.getModel());
                break;
            }
            case "payeerf7": {
                this.erPayeeF7Changed((DynamicObject)newValue);
                break;
            }
            case "exratedate": {
                if (!Objects.isNull(newValue)) break;
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"exratedate", (Object)oldValue);
                return;
            }
            case "exratetable": {
                if (!ObjectUtils.isEmpty((Object)newValue)) break;
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"exratetable", (Object)oldValue);
                break;
            }
            case "currency": {
                int n;
                if (newValue == null) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"currency", (Object)oldValue);
                    return;
                }
                if (ObjectUtils.isEmpty((Object)oldValue)) {
                    return;
                }
                int o = ((DynamicObject)oldValue).getInt("priceprecision");
                if (o != (n = ((DynamicObject)newValue).getInt("priceprecision"))) {
                    for (int i = 0; i < this.getModel().getEntryRowCount("entry"); ++i) {
                        this.initPrice(this.getModel(), o, n, i);
                    }
                }
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                break;
            }
            case "invoicetypeview": {
                this.getModel().setValue("invoicetype", this.getModel().getValue("invoicetypeview"));
                this.setTaxDeduction(newValue);
                break;
            }
            case "invoicetype": {
                this.setTaxDeduction(newValue);
                String type = (String)newValue;
                String typeNo = InvoiceType.getTypeNo((String)type);
                if (typeNo == null) {
                    typeNo = type;
                }
                Long invoiceTypePK = InvoiceTypeHelper.getInvoiceTypePK((String)typeNo);
                this.getModel().setValue("invoicetypef7", (Object)invoiceTypePK);
                if (invoiceTypePK != 0L) break;
                this.getModel().beginInit();
                this.getModel().setValue("invoicetypef7", null);
                this.getModel().endInit();
                this.getView().updateView("invoicetypef7");
                break;
            }
            case "invoicetypef7": {
                DynamicObject invoicetype = (DynamicObject)newValue;
                if (invoicetype != null) {
                    String number = invoicetype.getString("number");
                    String value = InvoiceType.getValue((String)number);
                    if (value == null) {
                        value = number;
                    }
                    this.getModel().setValue("invoicetype", (Object)value);
                    break;
                }
                this.getModel().setValue("invoicetype", null);
                break;
            }
            case "biztype": {
                this.bizTypeChanged(changeData[0]);
                break;
            }
            case "issuedate": {
                if (ObjectUtils.isEmpty((Object)newValue)) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"issuedate", (Object)oldValue);
                }
                this.dateChanged(newValue);
                this.setReceivedate(newValue);
                break;
            }
            case "material": {
                this.getModel().setValue("e_materialversion", null);
                this.materialChanged(changeData[0]);
                break;
            }
            case "measureunit": {
                this.calculateQty(rowIndex);
                break;
            }
            case "quantity": {
                if (BigDecimal.ZERO.compareTo((BigDecimal)newValue) == 0) {
                    FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)"quantity", (Object)oldValue, (int)rowIndex);
                    return;
                }
                if (oldValue instanceof BigDecimal && BigDecimal.ZERO.compareTo((BigDecimal)oldValue) == 0) {
                    return;
                }
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(rowIndex, this.getModel(), key, BillModelFactory.getModel((String)"ap_invoice"));
            }
            case "taxrate": {
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(rowIndex, this.getModel(), key, BillModelFactory.getModel((String)"ap_invoice"));
            }
            case "discountrate": {
                this.calculateAmt(this.getModel(), rowIndex);
                break;
            }
            case "price": {
                boolean isPresent = (Boolean)this.getModel().getValue("ispresent", rowIndex);
                if (isPresent) {
                    BigDecimal price = (BigDecimal)newValue;
                    if (BigDecimal.ZERO.compareTo(price) == 0) {
                        this.getModel().setValue("discountmode", (Object)"NULL", rowIndex);
                    } else {
                        this.getModel().setValue("discountmode", (Object)"PERCENT", rowIndex);
                        this.getModel().setValue("discountrate", (Object)new BigDecimal(100), rowIndex);
                    }
                }
                this.calculateAmt(this.getModel(), rowIndex);
                break;
            }
            case "discountamt": {
                DiscountAmtHelper discountService = new DiscountAmtHelper();
                discountService.setRowDiscountRate(rowIndex, this.getModel(), key, BillModelFactory.getModel((String)"ap_invoice"));
                PrecisionHelper.setDiscountRatePrecision((IFormView)this.getView());
                break;
            }
            case "discountmode": {
                this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
                if ("TOTAL".equals(newValue)) {
                    this.getModel().setValue("discountamt", (Object)BigDecimal.ZERO, rowIndex);
                }
                this.calculateAmt(this.getModel(), rowIndex);
                break;
            }
            case "ispresent": {
                boolean curIsPresent = (Boolean)newValue;
                BigDecimal rice = (BigDecimal)this.getModel().getValue("price", rowIndex);
                if (curIsPresent && BigDecimal.ZERO.compareTo(rice) != 0) {
                    this.getModel().setValue("discountmode", (Object)"PERCENT", rowIndex);
                    this.getModel().setValue("discountrate", (Object)new BigDecimal(100), rowIndex);
                    break;
                }
                this.getModel().setValue("discountmode", (Object)"NULL", rowIndex);
                break;
            }
            case "e_pricetaxtotal": {
                Object oldVal = changeData[0].getOldValue();
                BigDecimal newVal = (BigDecimal)newValue;
                BigDecimal val = (BigDecimal)this.getModel().getValue("pricetaxtotal");
                if (ObjectUtils.isEmpty((Object)oldVal)) {
                    oldVal = new BigDecimal(0);
                } else {
                    this.getModel().setValue("pricetaxtotal", (Object)val.subtract((BigDecimal)oldVal).add(newVal));
                }
                if (!this.changed) break;
                this.calculateAmt(this.getModel(), rowIndex);
                break;
            }
            case "pricetaxtotal": {
                this.pricetaxtotalChanged(newValue);
                break;
            }
            case "exchangerate": {
                if (EmptyUtils.isEmpty((Object)newValue)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"InvoiceEdit_8", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.calculateAmt(this.getModel(), -1);
                break;
            }
            case "expense": {
                if (!this.isOtrType() && !"OTHER".equals(this.getModel().getValue("invoicetype"))) break;
                this.getModel().setValue("expenseitem", newValue, 0);
                break;
            }
            case "e_tax": {
                this.changeTax(newValue, changeData[0].getRowIndex());
                break;
            }
            case "corebilltype": {
                this.getModel().setValue("corebillno", null, rowIndex);
                this.getModel().setValue("corebillentryseq", null, rowIndex);
                break;
            }
        }
    }

    private void setTaxDeduction(Object invoiceType) {
        if ("SP".equals(invoiceType) || "SE".equals(invoiceType) || "MAELETIC".equals(invoiceType)) {
            this.getModel().setValue("istaxdeduction", (Object)Boolean.TRUE);
        } else {
            this.getModel().setValue("istaxdeduction", (Object)Boolean.FALSE);
        }
    }

    private void changeTax(Object newValue, int rowIndex) {
        if (ObjectUtils.isEmpty((Object)newValue)) {
            return;
        }
        IDataModel m = this.getModel();
        BigDecimal e_pricetaxtotal = (BigDecimal)m.getValue("e_pricetaxtotal", rowIndex);
        BigDecimal exchangerate = (BigDecimal)m.getValue("exchangerate");
        String quotation = (String)m.getValue("quotation");
        if ("1".equals(quotation) && exchangerate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        if (ObjectUtils.isEmpty((Object)exchangerate)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"InvoiceEdit_8", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal e_amount = e_pricetaxtotal.subtract((BigDecimal)newValue);
        m.setValue("e_amount", (Object)e_amount, rowIndex);
        DynamicObject basecurrency = (DynamicObject)m.getValue("basecurrency");
        if (basecurrency == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u7ed3\u7b97\u5e01\u3002", (String)"InvoiceEdit_9", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        int localprecision = basecurrency.getInt("amtprecision");
        BigDecimal amountbase = BigDecimal.ZERO;
        amountbase = "1".equals(quotation) ? e_amount.divide(exchangerate, localprecision, RoundingMode.HALF_UP) : e_amount.multiply(exchangerate).setScale(localprecision, RoundingMode.HALF_UP);
        m.setValue("e_amountbase", (Object)amountbase, rowIndex);
        this.setHeadAmount();
    }

    private void initPrice(IDataModel m, int oldPriceprecision, int newPriceprecision, int currentRow) {
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        if (includeTax) {
            BigDecimal oldpricetaxtotal = (BigDecimal)m.getValue("e_pricetaxtotal", currentRow);
            m.setValue("e_pricetaxtotal", (Object)oldpricetaxtotal.setScale(newPriceprecision, RoundingMode.DOWN), currentRow);
        } else {
            BigDecimal oldUnitprice = (BigDecimal)m.getValue("price", currentRow);
            m.setValue("price", (Object)oldUnitprice.setScale(newPriceprecision, RoundingMode.DOWN), currentRow);
        }
    }

    private void calculateAmt(IDataModel m, int index) {
        m.beginInit();
        if (index != -1) {
            this.calculatorEntryAmt(m, index, false);
        } else {
            for (int i = 0; i < m.getEntryRowCount("entry"); ++i) {
                this.calculatorEntryAmt(m, i, false);
            }
        }
        this.setHeadAmount();
        m.endInit();
        IFormView v = this.getView();
        if (index != -1) {
            for (String e : ENTRY) {
                v.updateView(e, index);
            }
        } else {
            for (int i = 0; i < m.getEntryRowCount("entry"); ++i) {
                String[] stringArray = ENTRY;
                int n = stringArray.length;
                for (int e = 0; e < n; ++e) {
                    String e2 = stringArray[e];
                    v.updateView(e2, i);
                }
            }
        }
        for (String h : HEAD) {
            v.updateView(h);
        }
    }

    private void calculatorEntryAmt(IDataModel m, int index, boolean isbotpPush) {
        if (isbotpPush && ((Boolean)m.getValue("ispresent", index)).booleanValue()) {
            DynamicObject basecurrency = (DynamicObject)m.getValue("basecurrency");
            int localprecision = ObjectUtils.isEmpty((Object)basecurrency) ? 2 : basecurrency.getInt("amtprecision");
            BigDecimal rate = (BigDecimal)m.getValue("exchangerate");
            String quotation = (String)m.getValue("quotation");
            if ("1".equals(quotation) && rate.compareTo(BigDecimal.ZERO) == 0) {
                quotation = "0";
            }
            BigDecimal discountAmt = (BigDecimal)m.getValue("discountamt", index);
            BigDecimal amount = (BigDecimal)m.getValue("e_amount", index);
            BigDecimal priceTaxTotal = (BigDecimal)m.getValue("e_pricetaxtotal", index);
            BigDecimal discountAmtBase = BigDecimal.ZERO;
            BigDecimal amtBase = BigDecimal.ZERO;
            BigDecimal priceTotalBase = BigDecimal.ZERO;
            if ("1".equals(quotation)) {
                discountAmtBase = discountAmt.divide(rate, localprecision, RoundingMode.HALF_UP);
                amtBase = amount.divide(rate, localprecision, RoundingMode.HALF_UP);
                priceTotalBase = priceTotalBase.divide(rate, localprecision, RoundingMode.HALF_UP);
            } else {
                discountAmtBase = discountAmt.multiply(rate).setScale(localprecision, RoundingMode.HALF_UP);
                amtBase = amount.multiply(rate).setScale(localprecision, RoundingMode.HALF_UP);
                priceTotalBase = priceTaxTotal.multiply(rate).setScale(localprecision, RoundingMode.HALF_UP);
            }
            m.setValue("discountlocalamt", (Object)discountAmtBase, index);
            m.setValue("e_amountbase", (Object)amtBase, index);
            m.setValue("e_pricetaxtotalbase", (Object)priceTotalBase, index);
        } else {
            boolean includeTax = (Boolean)m.getValue("isincludetax");
            DynamicObject currency = (DynamicObject)m.getValue("currency");
            int precision = ObjectUtils.isEmpty((Object)currency) ? 2 : currency.getInt("amtprecision");
            DynamicObject basecurrency = (DynamicObject)m.getValue("basecurrency");
            int localprecision = ObjectUtils.isEmpty((Object)basecurrency) ? 2 : basecurrency.getInt("amtprecision");
            BigDecimal rate = (BigDecimal)m.getValue("exchangerate");
            String quotation = (String)m.getValue("quotation");
            if ("1".equals(quotation) && rate.compareTo(BigDecimal.ZERO) == 0) {
                quotation = "0";
            }
            BigDecimal qty = (BigDecimal)m.getValue("quantity", index);
            BigDecimal taxRate = (BigDecimal)m.getValue("taxrate", index);
            String discountMode = (String)m.getValue("discountmode", index);
            BigDecimal discountRate = (BigDecimal)m.getValue("discountrate", index);
            BigDecimal discountAmt = (BigDecimal)m.getValue("discountamt", index);
            BigDecimal unitPrice = (BigDecimal)m.getValue("price", index);
            UnitPriceCalculator calculator = null;
            if (includeTax) {
                BigDecimal pricetaxtotal = (BigDecimal)m.getValue("e_pricetaxtotal", index);
                calculator = new PriceTaxTotalCalculator(isbotpPush, unitPrice, BigDecimal.ZERO, qty, pricetaxtotal, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
            } else {
                calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
            }
            PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, localprecision, quotation);
            localCalculator.calculate();
            this.resetEntryProp(m, localCalculator, index);
        }
    }

    private void resetEntryProp(IDataModel m, PriceLocalCalculator localCalculator, int index) {
        m.setValue("price", (Object)localCalculator.getUnitprice(), index);
        m.setValue("actprice", (Object)localCalculator.getActunitprice(), index);
        m.setValue("actpricetax", (Object)localCalculator.getActtaxunitprice(), index);
        m.setValue("e_tax", (Object)localCalculator.getTax(), index);
        m.setValue("discountamt", (Object)localCalculator.getDiscountamount(), index);
        m.setValue("discountlocalamt", (Object)localCalculator.getDiscountamountlocal(), index);
        m.setValue("e_amount", (Object)localCalculator.getAmount(), index);
        m.setValue("e_amountbase", (Object)localCalculator.getAmountlocal(), index);
        BigDecimal priceTaxTotal = localCalculator.getPricetaxtotal();
        m.setValue("e_pricetaxtotal", (Object)priceTaxTotal, index);
        m.setValue("e_unrelatedamt", (Object)priceTaxTotal, index);
        m.setValue("e_unmatchamt", (Object)priceTaxTotal, index);
        m.setValue("e_unmatchqty", (Object)localCalculator.getQuantity(), index);
        m.setValue("e_pricetaxtotalbase", (Object)localCalculator.getPricetaxtotallocal(), index);
    }

    private void setHeadAmount() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("entry");
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountbase = BigDecimal.ZERO;
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        BigDecimal unrelatedamt = BigDecimal.ZERO;
        BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            amount = amount.add((BigDecimal)model.getValue("e_amount", rowIndex));
            amountbase = amountbase.add((BigDecimal)model.getValue("e_amountbase", rowIndex));
            pricetaxtotal = pricetaxtotal.add((BigDecimal)model.getValue("e_pricetaxtotal", rowIndex));
            pricetaxtotalbase = pricetaxtotalbase.add((BigDecimal)model.getValue("e_pricetaxtotalbase", rowIndex));
            tax = tax.add((BigDecimal)model.getValue("e_tax", rowIndex));
            unrelatedamt = unrelatedamt.add((BigDecimal)model.getValue("e_unrelatedamt", rowIndex));
        }
        model.setValue("amount", (Object)amount);
        model.setValue("amountbase", (Object)amountbase);
        model.setValue("pricetaxtotal", (Object)pricetaxtotal);
        model.setValue("unrelatedamt", (Object)unrelatedamt);
        model.setValue("unmatchamt", (Object)unrelatedamt);
        model.setValue("pricetaxtotalbase", (Object)pricetaxtotalbase);
        model.setValue("tax", (Object)tax);
    }

    private void pricetaxtotalChanged(Object newValue) {
        if (this.isOtrType() || "OTHER".equals(this.getModel().getValue("invoicetype"))) {
            IDataModel m = this.getModel();
            m.beginInit();
            m.setValue("isincludetax", (Object)Boolean.TRUE);
            m.setValue("e_amount", newValue, 0);
            m.setValue("e_pricetaxtotal", newValue, 0);
            this.calculatorEntryAmt(this.getModel(), 0, false);
            this.setHeadAmount();
            m.endInit();
            this.getView().updateView();
        }
    }

    private void erPayeeF7Changed(DynamicObject erPayee) {
        if (erPayee != null) {
            QFilter filter;
            Map userMap;
            DynamicObject user = (DynamicObject)this.getModel().getValue("receivablessupp");
            if (user == null && (userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id, name, number", (QFilter[])new QFilter[]{filter = new QFilter("name", "=", (Object)erPayee.getString("name"))})) != null && userMap.size() > 0) {
                this.getModel().setValue("receivablessupp", (Object)userMap.values().toArray(new DynamicObject[0])[0]);
            }
            this.getModel().setValue("receivablesacct", (Object)erPayee.getString("payeraccount"));
        } else {
            this.getModel().setValue("receivablesacct", null);
        }
    }

    private void asstactTypeChanged(Object newValue) {
        if (newValue != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_sellerinfo"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flex_addseller"});
            for (String string : s) {
                this.getModel().setValue(string, null);
            }
        }
    }

    private void asstactChanged(Object newValue) {
        if (newValue == null) {
            this.getModel().setValue("asstactname", this.getModel().getValue("asstactname"));
        } else {
            this.getModel().setValue("asstactname", (Object)((DynamicObject)newValue).getLocaleString("name").getLocaleValue());
        }
    }

    private void receivablessuppF7Changed(Object newValue, IDataModel model) {
        DynamicObject supp = (DynamicObject)newValue;
        if (!ObjectUtils.isEmpty((Object)model.getValue("serialno"))) {
            return;
        }
        if (supp != null) {
            if ("bos_user".equals(this.getModel().getValue("asstacttype"))) {
                DynamicObject erPayeeInfo = this.getErPayeeInfo(supp.getLong("id"), supp.getLocaleString("name").getLocaleValue());
                if (erPayeeInfo != null) {
                    this.getModel().setValue("payeerf7", erPayeeInfo.getPkValue());
                } else if (this.getModel().getValue("payeerf7") != null) {
                    this.getModel().setValue("payeerf7", null);
                } else {
                    this.getModel().setValue("receivablesacct", null);
                }
            } else {
                supp = BusinessDataServiceHelper.loadSingleFromCache((Object)supp.getPkValue(), (String)this.getModel().getValue("asstacttype").toString());
                String acctBank = null;
                DynamicObjectCollection bankColls = supp.getDynamicObjectCollection("entry_bank");
                if (bankColls != null && bankColls.size() > 0) {
                    if (bankColls.size() == 1) {
                        DynamicObject bankInfo = (DynamicObject)bankColls.get(0);
                        acctBank = bankInfo.getString("bankaccount");
                    } else {
                        for (int i = 0; i < bankColls.size(); ++i) {
                            DynamicObject bankInfo = (DynamicObject)bankColls.get(i);
                            if (bankInfo.getBoolean("isdefault_bank")) {
                                acctBank = bankInfo.getString("bankaccount");
                                break;
                            }
                            if (i != 0) continue;
                            acctBank = bankInfo.getString("bankaccount");
                        }
                    }
                }
                this.getModel().setValue("receivablesacct", acctBank);
            }
        }
    }

    private DynamicObject getErPayeeInfo(long userId, String name) {
        DynamicObject defaultAccount = null;
        QFilter uFilter = new QFilter("name", "=", (Object)name);
        uFilter = uFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        uFilter.and(new QFilter("payer", "=", (Object)userId));
        QFilter[] qFilters = new QFilter[]{uFilter};
        String selectFields = "id,name,payer,payeraccount,payeraccount01,payeraccount02,payerbank_id,payerbank.name,payerbank.number,isdefault";
        Map defaultAccountMap = BusinessDataServiceHelper.loadFromCache((String)"er_payeer", (String)selectFields, (QFilter[])qFilters);
        if (defaultAccountMap != null && defaultAccountMap.size() > 0) {
            ArrayList accountList = new ArrayList(defaultAccountMap.values());
            defaultAccount = (DynamicObject)accountList.get(0);
            for (DynamicObject account : accountList) {
                if (!account.getBoolean("isdefault")) continue;
                defaultAccount = account;
                break;
            }
        }
        return defaultAccount;
    }

    private void dateChanged(Object newValue) {
        Date issueDate = (Date)newValue;
        if (issueDate == null) {
            return;
        }
        DateEdit dateEdit = (DateEdit)this.getControl("lastpaydate");
        dateEdit.setMinDate(issueDate);
        Date lastpayDate = (Date)this.getModel().getValue("lastpaydate");
        if (lastpayDate != null && lastpayDate.before(issueDate)) {
            this.getModel().setValue("lastpaydate", (Object)issueDate);
        }
    }

    private void setReceivedate(Object newValue) {
        Date issuedate = (Date)newValue;
        if (issuedate == null) {
            return;
        }
        Date receivedate = (Date)this.getModel().getValue("receivedate");
        if (EmptyUtils.isEmpty((Object)receivedate) || receivedate.before(issuedate)) {
            this.getModel().setValue("receivedate", (Object)issuedate);
        }
        DateEdit dateEdit = (DateEdit)this.getControl("receivedate");
        dateEdit.setMinDate(issuedate);
    }

    private void calculateQty(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject measureUnit = (DynamicObject)model.getValue("measureunit", rowIndex);
        if (measureUnit == null) {
            return;
        }
        BigDecimal quantity = (BigDecimal)model.getValue("quantity", rowIndex);
        if (quantity != null) {
            model.setValue("quantity", (Object)quantity.setScale(measureUnit.getInt("precision"), 4), rowIndex);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.setHeadAmount();
    }

    private void bizTypeChanged(ChangeData bizType) {
        String newValue = bizType.getNewValue().toString();
        if (newValue != null) {
            if ("PUR".equals(newValue)) {
                this.getModel().setValue("asstacttype", (Object)"bd_supplier");
            }
            this.getPageCache().put("bizType", bizType.getOldValue().toString());
            if (this.changeType && this.getModel().getEntryRowCount("entry") != 0 && !this.isOtrType()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u4e1a\u52a1\u7c7b\u578b\u5c06\u5220\u9664\u6240\u6709\u5206\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InvoiceEdit_7", (String)"fi-ap-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("clearEntry"));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("clearEntry".equals(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getModel().deleteEntryData("entry");
                this.getView().updateView();
                this.getModel().createNewEntryRow("entry");
                this.getModel().setEntryCurrentRowIndex("entry", 0);
                this.getModel().setValue("pricetaxtotal", (Object)BigDecimal.ZERO);
                this.getModel().setValue("amount", (Object)BigDecimal.ZERO);
                this.getModel().setValue("tax", (Object)BigDecimal.ZERO);
                this.getModel().setValue("unrelatedamt", (Object)BigDecimal.ZERO);
                this.getModel().setValue("unmatchamt", (Object)BigDecimal.ZERO);
                this.getModel().setValue("pricetaxtotalbase", (Object)BigDecimal.ZERO);
                this.getModel().setValue("amountbase", (Object)BigDecimal.ZERO);
            } else {
                this.changeType = false;
                this.getModel().setValue("biztype", (Object)this.getPageCache().get("bizType"));
            }
        }
        String callBackID = messageBoxClosedEvent.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, messageBoxClosedEvent.getResult());
        if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = messageBoxClosedEvent.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            Object billNo = this.getModel().getValue("billno");
            LogUtil.addOpLog((String)"ap_invoice", (Object)billNo, (String)operateKey, (String)("billnos\uff1a" + billNo + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        }
    }

    private void materialChanged(ChangeData changeData) {
        int currentIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        DynamicObject material = (DynamicObject)newValue;
        if (material != null) {
            this.getModel().setValue("spectype", (Object)material.getLocaleString("modelnum").getLocaleValue(), currentIndex);
            if (material.getDynamicObject("baseunit") != null) {
                this.getModel().setValue("measureunit", material.getDynamicObject("baseunit").getPkValue(), currentIndex);
            }
            String serialNo = this.getModel().getValue("serialno").toString();
            if (material.getDynamicObject("taxrate") != null && kd.fi.arapcommon.util.StringUtils.isEmpty((String)serialNo)) {
                Object taxrateId = material.getDynamicObject("taxrate").getPkValue();
                IDataModel model = this.getModel();
                model.setValue("taxrateid", taxrateId, currentIndex);
            }
        } else {
            this.getModel().setValue("measureunit", (Object)"", currentIndex);
            this.getModel().setValue("spectype", (Object)"", currentIndex);
        }
    }

    private InitHelper getInit(long orgId) {
        if (this.init != null) {
            return this.init;
        }
        return new InitHelper(orgId, "ap_init");
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        if (this.getModel().getValue("org") == null) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        int para = SystemParameterHelper.getParameterNull((long)org.getLong("id"), (String)"ap_001");
        String status = (String)this.getModel().getValue("billstatus");
        if (para == 0 && "C".equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_assign", "bar_antiassign"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("audit".equals(key) && operationResult.isSuccess()) {
            this.fillToolBarByInvoice();
        }
        if (!ObjectUtils.isEmpty((Object)operationResult) && operationResult.isSuccess() && ("audit".equals(key) || "unaudit".equals(key) || "assign".equals(key) || "antiassign".equals(key) || "pushandsave".equals(key))) {
            this.getView().getFormShowParameter().getCustomParams().remove("iscopy");
            this.getView().invokeOperation("refresh");
        }
        switch (key) {
            case "save": 
            case "submit": {
                String waring;
                if (ObjectUtils.isEmpty((Object)operationResult) || !operationResult.isSuccess() || !kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(waring = FinApBillHelper.supplierWarnTips((String)"ap_invoice", (List)operationResult.getSuccessPkIds(), (String)key)))) break;
                this.getView().showSuccessNotification(waring, Integer.valueOf(10000));
                break;
            }
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.fillToolBar();
                break;
            }
            case "toviewinvoice": {
                String serialno = (String)this.getModel().getValue("serialno");
                String[] serialnos = StringUtils.split((String)serialno, (String)",");
                ShowInvoiceCloudPageUtil.viewInvoice((IFormView)this.getView(), (long)this.getModel().getDataEntity().getLong("id"), Arrays.asList(serialnos));
                break;
            }
            case "assign": {
                String waring;
                if (ObjectUtils.isEmpty((Object)operationResult) || !operationResult.isSuccess() || !kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(waring = FinApBillHelper.supplierWarnTips((String)"ap_invoice", (List)operationResult.getSuccessPkIds(), (String)key)))) break;
                this.getView().showSuccessNotification(waring, Integer.valueOf(10000));
            }
        }
        OperationUtils.setButtonUnvisibleByAppId((String)this.getModel().getDataEntityType().getName(), (IFormView)this.getView());
        if (("submit".equals(key) || "save".equals(key)) && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        String finBillUpdateTaxDeduction = (String)ConfigCache.get((String)"finBillUpdateTaxDeduction", (String)"finBillUpdateTaxDeduction", String.class);
        if (operationResult != null && operationResult.isSuccess() && "assign".equals(key) && "true".equals(finBillUpdateTaxDeduction)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6839\u636e\u7ec4\u7ec7\u7684\u7eb3\u7a0e\u8d44\u8d28\u548c\u53d1\u7968\u7c7b\u522b\u66f4\u65b0\u53d1\u7968\u7684\u53ef\u62b5\u6263\u6807\u8bc6\uff0c\u8bf7\u6ce8\u610f\u3002", (String)"FinApBillEdit_19", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            operationResult.setShowMessage(false);
            ConfigCache.remove((String)"finBillUpdateTaxDeduction", (String)"finBillUpdateTaxDeduction");
        }
    }

    private void fillToolBarByInvoice() {
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        Long orgPk = this.getModel().getDataEntity().getLong("org.id");
        int para = SystemParameterHelper.getParameterNull((long)orgPk, (String)"ap_001");
        if (para == 0 && billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_assign", "bar_antiassign", "bar_pushap"});
        }
        if (para == 1 && billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_pushap"});
        }
    }

    private void fillToolBar() {
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_pushap"});
        if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit", "bar_unsubmit", "bar_apgeneratevoucher"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_submitandnew"});
        } else if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submitandnew", "bar_unaudit", "bar_apgeneratevoucher"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_audit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_unsubmit", "bar_audit"});
        } else if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit", "bar_submitandnew"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_audit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_unaudit", "bar_apgeneratevoucher"});
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            boolean ap001 = SystemParameterHelper.getParameterBoolean((long)((Long)org.getPkValue()), (String)"ap_001");
            this.getView().setVisible(Boolean.valueOf(!ap001), new String[]{"bar_pushap"});
        }
    }

    private ApInvoiceBillImportHelper getImportHelper() {
        if (this.importHelper == null) {
            this.importHelper = new ApInvoiceBillImportHelper(this.getView(), this.getPageCache());
        }
        return this.importHelper;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        this.getImportHelper().initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        this.getImportHelper().beforeImportData(e);
    }

    @Override
    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.getImportHelper().afterImportData(e);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        int rowIndex = e.getRowIndex();
        switch (key) {
            case "discountrate": {
                if (!DiscountModeEnum.PERCENT.getValue().equals(this.getModel().getValue("discountmode"))) break;
                if (value == null) {
                    return;
                }
                BigDecimal discountrate = new BigDecimal(value.toString());
                if (discountrate.compareTo(BigDecimal.valueOf(100L)) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%s\u884c\uff1a\u201c\u5355\u4f4d\u6298\u6263(\u7387)\u201d\u5f55\u5165\u7684\u6570\u5b57\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"InvoiceEdit_11", (String)"fi-ap-formplugin", (Object[])new Object[]{rowIndex + 1}));
                    e.setCancel(true);
                    this.getView().updateView("discountrate", rowIndex);
                    return;
                }
                if (!((Boolean)this.getModel().getValue("isincludetax")).booleanValue() || discountrate.compareTo(BigDecimal.valueOf(100L)) != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539", (String)"InvoiceEdit_15", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView("discountrate", rowIndex);
                return;
            }
        }
    }
}

