/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.formplugin.ApCoreBillList;
import kd.fi.ap.helper.FinApBillHelper;
import kd.fi.ap.helper.SystemParameterHelper;
import kd.fi.ap.piaozone.ShowInvoiceCloudPageUtil;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.OperationUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;

public class InvoiceList
extends ApCoreBillList {
    private static final String invoiceType = "invoiceType";
    private List<Object> invoiceTypes = new ArrayList<Object>(8);

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        evt.setCancel(true);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = e.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] billNos = selectedRows.stream().map(selectedRow -> selectedRow.getBillNo()).toArray();
            LogUtil.addOpLog((String)"ap_invoice", (Object)(billNos.length > 0 ? billNos[0] : null), (String)operateKey, (String)("billnos\uff1a" + JSONObject.toJSONString((Object)billNos) + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)e, (String)"SZJK-PRE-0057");
        }
        AbstractOperate source = (AbstractOperate)e.getSource();
        String key = source.getOperateKey();
        if ("copy".equals(key)) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            if (selectedRows != null) {
                Object[] pks = selectedRows.getPrimaryKeyValues();
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pks[0], (String)"ap_invoice");
                boolean isPriceTotal = obj.getBoolean("isincludetax");
                DynamicObjectCollection detailEntries = obj.getDynamicObjectCollection("entry");
                for (DynamicObject entry : detailEntries) {
                    String discountType = entry.getString("discountmode");
                    BigDecimal discountRate = entry.getBigDecimal("discountrate");
                    if (!isPriceTotal || !"PERCENT".equals(discountType) || new BigDecimal("100").compareTo(discountRate) != 0) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e3a100\uff0c\u65e0\u6cd5\u53cd\u7b97\u542b\u7a0e\u5355\u4ef7\uff0c\u8bf7\u4fee\u6539", (String)"PriceTaxTotalCalculator_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
            }
        } else if ("toviewinvoice".equals(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Set billIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            if (billIds.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"InvoiceList_10", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            } else if (billIds.size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5355\u636e\u67e5\u770b\u3002", (String)"InvoiceList_11", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String firstOrgId = null;
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Iterator commonIterator = commonFilterColumns.iterator();
        while (commonIterator.hasNext()) {
            CommonFilterColumn filterColumn = (CommonFilterColumn)commonIterator.next();
            String fieldName = filterColumn.getFieldName();
            List items = filterColumn.getComboItems();
            if (fieldName.startsWith("org") && items != null && items.size() > 0) {
                String loginOrg = String.valueOf(RequestContext.get().getOrgId());
                for (int i = 0; i < items.size(); ++i) {
                    ComboItem item = (ComboItem)items.get(i);
                    if (!item.getValue().equals(loginOrg)) continue;
                    firstOrgId = loginOrg;
                    break;
                }
                if (firstOrgId == null) {
                    firstOrgId = ((ComboItem)items.get(0)).getValue();
                }
            }
            if (!"biztype".equals(fieldName) && !"invoicetype".equals(fieldName) || items == null || items.size() <= 0 || !this.isOtrInvoice()) continue;
            commonIterator.remove();
        }
        List schemeFilterColumns = args.getFilterContainerInitEvent().getSchemeFilterColumns();
        Iterator schemeIterator = schemeFilterColumns.iterator();
        while (schemeIterator.hasNext()) {
            SchemeFilterColumn filterColumn = (SchemeFilterColumn)schemeIterator.next();
            String fieldName = filterColumn.getFieldName();
            List items = filterColumn.getComboItems();
            if (!"biztype".equals(fieldName) && !"invoicetype".equals(fieldName) || items == null || items.size() <= 0) continue;
            if (this.isOtrInvoice()) {
                schemeIterator.remove();
                continue;
            }
            if (this.isAllType() || items.size() != 3) continue;
            Iterator typeIterator = items.iterator();
            while (typeIterator.hasNext()) {
                ComboItem next = (ComboItem)typeIterator.next();
                if (!"OTHER".equals(next.getValue())) continue;
                typeIterator.remove();
            }
        }
        String apInvFilterInit = this.getPageCache().get("apinvfilterinit");
        if (StringUtils.isNotEmpty(firstOrgId) && StringUtils.isEmpty((String)apInvFilterInit)) {
            boolean invoiceRecognitionVisible = this.getInvoiceRecognition(Long.parseLong(firstOrgId), "ap_001");
            this.getView().setVisible(Boolean.valueOf(invoiceRecognitionVisible), new String[]{"tblpushap"});
            this.getPageCache().put("apinvfilterinit", "true");
        }
    }

    private boolean getInvoiceRecognition(long orgId, String key) {
        int i = SystemParameterHelper.getParameterNull((long)orgId, (String)key);
        return i == 0;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("synchrocloud".equals(key)) {
            if (operationResult.isSuccess()) {
                if ("updateCloud_is_success".equals(operationResult.getMessage())) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u5168\u7968\u6c60\u6210\u529f\u3002", (String)"InvoiceList_13", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u6b65\u72b6\u6001\u4e3a\u65e0\u9700\u540c\u6b65\u6216\u5df2\u540c\u6b65\uff0c\u4ee5\u53ca\u975e\u53d1\u7968\u91c7\u96c6\u6216\u4e0b\u8f7d\u53d1\u7968\u751f\u6210\u7684\u6536\u7968\u5355\u65e0\u9700\u540c\u6b65\u5168\u7968\u6c60\u3002", (String)"InvoiceList_12", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                }
                operationResult.setShowMessage(false);
            }
            this.getView().invokeOperation("refresh");
        } else if (operationResult != null && operationResult.isSuccess() && "toviewinvoice".equals(key)) {
            List successIds = operationResult.getSuccessPkIds();
            ShowInvoiceCloudPageUtil.viewInvoice((IFormView)this.getView(), (long)Long.parseLong(String.valueOf(successIds.get(0))));
        }
        String finBillUpdateTaxDeduction = (String)ConfigCache.get((String)"finBillUpdateTaxDeduction", (String)"finBillUpdateTaxDeduction", String.class);
        if (operationResult != null && operationResult.isSuccess() && "assign".equals(key) && "true".equals(finBillUpdateTaxDeduction)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6839\u636e\u7ec4\u7ec7\u7684\u7eb3\u7a0e\u8d44\u8d28\u548c\u53d1\u7968\u7c7b\u522b\u66f4\u65b0\u53d1\u7968\u7684\u53ef\u62b5\u6263\u6807\u8bc6\uff0c\u8bf7\u6ce8\u610f\u3002", (String)"FinApBillEdit_19", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            operationResult.setShowMessage(false);
            ConfigCache.remove((String)"finBillUpdateTaxDeduction", (String)"finBillUpdateTaxDeduction");
        }
        if ("updateinvstatus".equals(key) && operationResult != null && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if (operationResult != null) {
            String waring;
            List pks = operationResult.getSuccessPkIds();
            if (("submit".equals(key) || "assign".equals(key)) && pks != null && StringUtils.isNotEmpty((String)(waring = FinApBillHelper.supplierWarnTips((String)"ap_invoice", (List)pks, (String)key)))) {
                this.getView().showSuccessNotification(waring, Integer.valueOf(10000));
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List schemefilter;
        super.filterContainerSearchClick(args);
        List customfilter = (List)args.getSearchClickEvent().getFilterValues().get("customfilter");
        Object isHyper = this.getView().getFormShowParameter().getCustomParam("isopenbyhyperlink");
        if (customfilter != null) {
            for (Map filteritem : customfilter) {
                String fieldName = ((List)filteritem.get("FieldName")).get(0).toString();
                List values = (List)filteritem.get("Value");
                if (fieldName.startsWith("org") && values != null && !values.isEmpty()) {
                    ArrayList<Long> orgIdList = new ArrayList<Long>(8);
                    for (Object value : values) {
                        if ("".equals(value)) continue;
                        Long org2 = Long.valueOf(value.toString());
                        orgIdList.add(org2);
                    }
                    this.setAutoApVisible(orgIdList);
                }
                if (isHyper == null || !((Boolean)isHyper).booleanValue() || !"invoicetype".equals(fieldName)) continue;
                this.invoiceTypes = values;
            }
        }
        if ((schemefilter = (List)args.getSearchClickEvent().getFilterValues().get("schemefilter")) != null) {
            boolean queryAllOrg = true;
            for (Map filteritem : schemefilter) {
                DynamicObjectCollection orgCol;
                List<Long> orgIdList;
                String fieldName = ((List)filteritem.get("FieldName")).get(0).toString();
                List values = (List)filteritem.get("Value");
                if (fieldName.startsWith("org") && values != null && !values.isEmpty() && !ObjectUtils.isEmpty(orgIdList = (orgCol = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "in", (Object)values)})).stream().map(org -> org.getLong("id")).collect(Collectors.toList()))) {
                    queryAllOrg = false;
                    this.setAutoApVisible(orgIdList);
                }
                if (isHyper == null || !((Boolean)isHyper).booleanValue() || !"invoicetype".equals(fieldName)) continue;
                this.invoiceTypes = values;
            }
            if (queryAllOrg) {
                this.setAutoApVisible(new ArrayList<Long>(1));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("listoperation".equals(e.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(!this.isOtrInvoice()), new String[]{"tblnew"});
        this.getView().setVisible(Boolean.valueOf(this.isOtrInvoice()), new String[]{"tblnew4otr"});
        String apAssign = (String)this.getView().getFormShowParameter().getCustomParam("apassign");
        String applyAssign = (String)this.getView().getFormShowParameter().getCustomParam("applyassign");
        String replaceAssign = (String)this.getView().getFormShowParameter().getCustomParam("replaceassign");
        if ("true".equals(apAssign)) {
            String apAssignContiansPartRedInv = (String)this.getView().getFormShowParameter().getCustomParam("apassigncontianspartredinv");
            if ("true".equals(apAssignContiansPartRedInv)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u53d1\u7968\u72b6\u6001\u4e3a\u201c\u90e8\u5206\u7ea2\u51b2\u201d\u7684\u6536\u7968\u5355\uff0c\u8bf7\u4e0e\u5176\u7ea2\u51b2\u53d1\u7968\u4e00\u8d77\u53c2\u4e0e\u6307\u5b9a\u3002", (String)"InvoiceList_27", (String)"fi-ap-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5173\u6ce8\u6240\u9009\u6536\u7968\u5355\u7684\u53d1\u7968\u72b6\u6001\u662f\u5426\u4e3a\u6700\u65b0\u72b6\u6001\uff0c\u907f\u514d\u9020\u6210\u53d1\u7968\u72b6\u6001\u5f02\u5e38\u4f46\u4ecd\u80fd\u88ab\u8d22\u52a1\u5e94\u4ed8\u5355\u6307\u5b9a\u7684\u60c5\u51b5\u3002", (String)"InvoiceList_15", (String)"fi-ap-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
            }
        } else if ("true".equals(applyAssign)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5173\u6ce8\u6240\u9009\u6536\u7968\u5355\u7684\u53d1\u7968\u72b6\u6001\u662f\u5426\u4e3a\u6700\u65b0\u72b6\u6001\uff0c\u907f\u514d\u9020\u6210\u53d1\u7968\u72b6\u6001\u5f02\u5e38\u4f46\u4ecd\u80fd\u88ab\u4ed8\u6b3e\u7533\u8bf7\u5355\u6307\u5b9a\u7684\u60c5\u51b5\u3002", (String)"InvoiceList_20", (String)"fi-ap-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
        } else if ("true".equals(replaceAssign)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5173\u6ce8\u6240\u9009\u6536\u7968\u5355\u7684\u53d1\u7968\u72b6\u6001\u662f\u5426\u4e3a\u6700\u65b0\u72b6\u6001\uff0c\u907f\u514d\u9020\u6210\u53d1\u7968\u72b6\u6001\u5f02\u5e38\u4f46\u4ecd\u80fd\u88ab\u6307\u5b9a\u7684\u60c5\u51b5\u3002", (String)"InvoiceList_26", (String)"fi-ap-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
        }
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        Object isHyper;
        super.setFilter(e);
        List qFilters = e.getQFilters();
        if (!"botp_trackerlist".equals(this.getView().getFormShowParameter().getFormId())) {
            if (this.isOtrInvoice()) {
                qFilters.add(new QFilter("invoicetype", "=", (Object)"OTHER"));
            } else if (!this.isAllType()) {
                qFilters.add(new QFilter("invoicetype", "!=", (Object)"OTHER"));
            }
        }
        if ((isHyper = this.getView().getFormShowParameter().getCustomParam("isopenbyhyperlink")) != null && ((Boolean)isHyper).booleanValue() && EmptyUtils.isNotEmpty(this.invoiceTypes)) {
            qFilters.add(new QFilter("invoicetype", "in", this.invoiceTypes));
        }
    }

    private boolean isOtrInvoice() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            return false;
        }
        Object target = customParams.get(invoiceType);
        if (target == null) {
            return false;
        }
        return "OTHER".equals(target);
    }

    private boolean isAllType() {
        String ignore = StdConfig.get((String)"ignoreInvoiceType");
        return StringUtils.isNotEmpty((String)ignore) && ignore.contains("ap");
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
        parameter.setHasRight(true);
        if (this.isOtrInvoice()) {
            e.getParameter().setCaption(ResManager.loadKDString((String)"\u5176\u4ed6\u53d1\u7968", (String)"InvoiceList_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            parameter.getCustomParams().put(invoiceType, "OTHER");
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        if (this.isOtrInvoice()) {
            List columns = args.getListColumns();
            Iterator iterator = columns.iterator();
            while (iterator.hasNext()) {
                IListColumn iListColumn = (IListColumn)iterator.next();
                String key = iListColumn.getListFieldKey();
                if (!"purorg.name".equals(key) && !"amount".equals(key) && !"tax".equals(key) && !"asstactname".equals(key) && !"buyer.name".equals(key)) continue;
                iterator.remove();
            }
        }
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        super.itemClick(e);
        switch (key = e.getItemKey()) {
            case "tblclose": {
                ConfigCache.clear();
            }
        }
        if (Arrays.asList("tblbillmatch", "tblentrymatch", "tblmatchrecord").contains(key)) {
            this.invoiceMatch(key);
        }
    }

    private void invoiceMatch(String key) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"InvoiceList_6", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        Set invids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        OperationResult result = OperationServiceHelper.executeOperate((String)"inv4matchinv", (String)"ap_invoice", (Object[])invids.toArray(), (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u5339\u914d\u5931\u8d25, %s", (String)"InvoiceList_14", (String)"fi-ap-formplugin", (Object[])new Object[]{result.getMessage()}));
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        HashMap customParams = new HashMap();
        formShowParameter.setFormId("ap_matchinvoice");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u53d1\u7968\u667a\u80fd\u5339\u914d", (String)"InvoiceMatchEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        customParams.put("invids", invids);
        formShowParameter.setCustomParams(customParams);
        this.getView().showForm(formShowParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationUtils.setListButtonUnvisibleByAppId((String)"ap_invoice", (IFormView)this.getView());
    }

    private void setAutoApVisible(List<Long> orgIdList) {
        if (ObjectUtils.isEmpty(orgIdList)) {
            orgIdList = OrgHelper.getAuthorizedInitializedOrgIds((String)"ap_invoice", (String)"47150e89000000ac", (boolean)false);
        }
        Map enableOrgParam = kd.fi.arapcommon.helper.SystemParameterHelper.batchGetAppParameter((Boolean)false, (List)orgIdList, (String)"ap_001");
        HashSet<Boolean> orgParamSet = new HashSet<Boolean>(2);
        for (Map.Entry entry : enableOrgParam.entrySet()) {
            Object param = entry.getValue();
            if (param == null) continue;
            orgParamSet.add((Boolean)param);
        }
        if (orgParamSet.contains(false)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tblpushap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblpushap"});
        }
    }
}

