/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.vo.CloudInvoiceResultVO;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.util.JsonUtils;

public class InvoiceList4Cloud
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(InvoiceList4Cloud.class);

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey().toLowerCase();
        if ("tblcollect".equals(key)) {
            this.collect();
        } else if ("tbldownload".equals(key)) {
            this.download();
        } else if ("tblclearcache".equals(key)) {
            ConfigCache.clear();
            this.getView().showSuccessNotification("Success");
        }
    }

    private void download() {
        long orgPk = RequestContext.get().getOrgId();
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        if (!selectedMainOrgIds.isEmpty()) {
            orgPk = (Long)selectedMainOrgIds.get(0);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ap_invdownload");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "invDownload"));
        parameter.getCustomParams().put("orgPk", orgPk);
        this.getView().showForm(parameter);
    }

    private void collect() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.showInvCollect();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u91c7\u96c6\u65e0\u9700\u9009\u62e9\u5355\u636e\uff0c\u8bf7\u53d6\u6d88\u52fe\u9009\u540e\u91cd\u8bd5\u3002", (String)"InvoiceList4Cloud_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
    }

    private void showInvCollect() {
        long orgPk = RequestContext.get().getOrgId();
        IListView listView = (IListView)this.getView();
        List selectedMainOrgIds = listView.getSelectedMainOrgIds();
        if (!selectedMainOrgIds.isEmpty()) {
            orgPk = (Long)selectedMainOrgIds.get(0);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getCustomParams().put("orgPk", orgPk);
        parameter.setFormId("ap_invcollect");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "invCollect"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("invCollect".equals(actionId) && !ObjectUtils.isEmpty((Object)returnData)) {
            CloudInvoiceResultVO resultVO = (CloudInvoiceResultVO)JsonUtils.jsonToObj((String)String.valueOf(returnData), CloudInvoiceResultVO.class);
            if (resultVO == null || resultVO.isEmpty()) {
                logger.info("---failure---\u5bfc\u5165\u53d1\u7968\u5931\u8d25\uff01");
            } else {
                logger.info("---success---\u5bfc\u5165\u53d1\u7968\u6210\u529f\uff01");
                IListView listView = (IListView)this.getView();
                listView.refresh();
                List hasExistInvoices = resultVO.getHasExistInvoices();
                if (ObjectUtils.isEmpty((Object)hasExistInvoices)) {
                    return;
                }
                DynamicObjectCollection invoices = QueryServiceHelper.query((String)"ap_invoice", (String)"invoicecode,invoiceno", (QFilter[])new QFilter[]{new QFilter("serialno", "in", (Object)hasExistInvoices)});
                StringBuilder builder = new StringBuilder();
                for (DynamicObject invoice : invoices) {
                    builder.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%1$s,\u53d1\u7968\u4ee3\u7801%2$s\uff1a\u53d1\u7968\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91c7\u96c6\u3002", (String)"InvoiceList4Cloud_2", (String)"fi-ap-formplugin", (Object[])new Object[0]), invoice.getString("invoiceno"), invoice.getString("invoicecode")));
                    builder.append('\n');
                }
                if (builder.length() > 0) {
                    this.getView().showErrorNotification(String.valueOf(builder));
                }
            }
        }
    }
}

