/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.business.invoicematch.ApInvoiceMatchBillLoader;
import kd.fi.ap.business.invoicematch.IMatchBillLoader;
import kd.fi.ap.business.invoicematch.MatchBillLoaderFactory;
import kd.fi.ap.business.invoicematch.helper.EnumMatchAction;
import kd.fi.ap.business.invoicematch.helper.MatchBillChainHelper;
import kd.fi.ap.business.invoicematch.helper.MatchBillLoaderParam;
import kd.fi.ap.business.invoicematch.helper.MutexLockHelper;
import kd.fi.ap.enums.EnumDirection;
import kd.fi.ap.enums.InvMatchType;
import kd.fi.ap.enums.MatchRuleType;
import kd.fi.ap.vo.InvoiceMatchParam;
import kd.fi.ap.vo.MatchActionParam;
import kd.fi.ap.vo.MatchBillChain;
import kd.fi.ap.vo.MatchResult;
import kd.fi.ap.vo.MatchResultItem;
import kd.fi.ap.vo.Relation;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceMatchPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        LinkedList chains = MatchBillChainHelper.getChainData((IPageCache)this.getPageCache()).getChains();
        String[] toolbarKeys = (String[])chains.stream().map(MatchBillChain.MatchChain::getToolbarIdentify).toArray(String[]::new);
        this.addItemClickListeners(toolbarKeys);
        this.addItemClickListeners(new String[]{"toolbarap"});
        final IFormView view = this.getView();
        final AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        entryGrid.addSelectRowsListener(new SelectRowsEventListener(){

            public void selectRowsChange(SelectRowsEvent evt) {
                super.selectRowsChange(evt);
                EnumMatchAction.INV_SEL_CHANGE.action(new MatchActionParam(model, view, (Object)evt, InvoiceMatchPlugin.this.getParam().isViewMode()));
            }
        });
    }

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        Object invMatch;
        Object chooseRule;
        Object matchType;
        super.afterCreateNewData(e);
        MatchBillChainHelper.initPageChainData((IPageCache)this.getView().getPageCache());
        InvoiceMatchParam param = this.getParam();
        boolean matchRec = true;
        DynamicObject[] matchRecords = this.queryMatchRecord();
        if (EmptyUtils.isNotEmpty((Object)matchRecords)) {
            DynamicObject matchRecord = matchRecords[0];
            matchType = matchRecord.get("matchtype");
            chooseRule = matchRecord.get("chooserule");
            invMatch = matchRecord.get("invmatch");
            matchRec = (Boolean)matchRecord.get("matchrec");
            if (!param.isViewMode()) {
                String entryString = ResManager.loadKDString((String)"\u660e\u7ec6", (String)"InvoiceMatchPlugin_1", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                String billString = ResManager.loadKDString((String)"\u6574\u5355", (String)"InvoiceMatchPlugin_2", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                String tipString = ResManager.loadKDString((String)"\u6839\u636e\u201c\u6536\u7968\u5355\u5339\u914d\u201d\u7684\u64cd\u4f5c\u5386\u53f2\uff0c\u5df2\u4e3a\u60a8\u5207\u6362\u5230\u201c%s\u5339\u914d\u201d\u6a21\u5f0f\u3002", (String)"InvoiceMatchPlugin_0", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(tipString, invMatch.equals(InvMatchType.ENTRY.name()) ? entryString : billString));
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"chooserule", "matchtype", "matchrec"});
        } else {
            String bizType = param.getBizType();
            boolean isFee = bizType.equals("FEE");
            matchType = isFee ? "AMT" : "QTY";
            chooseRule = "ORDER";
            invMatch = param.getMatchType();
        }
        this.getModel().setValue("matchtype", matchType);
        this.getModel().setValue("chooserule", chooseRule);
        this.getModel().setValue("invmatch", invMatch);
        this.getModel().setValue("invoicebill", (Object)param.getInvoicePk());
        this.getModel().setValue("viewmode", (Object)param.isViewMode());
        this.getModel().setValue("matchrec", (Object)matchRec);
        if (!matchRec) {
            MatchBillChainHelper.removeChain((IPageCache)this.getView().getPageCache(), (String)"im_purreceivebill");
        }
        this.loadInvoiceEntry();
        MatchActionParam matchParam = new MatchActionParam((AbstractFormDataModel)this.getModel(), this.getView(), (Object)e, this.getParam().isViewMode());
        EnumMatchAction.CHOOSE_RULE_CHANGE.action(matchParam);
        if (param.isViewMode()) {
            EnumMatchAction.VIEW_MODE.action(matchParam);
        }
    }

    private DynamicObject[] queryMatchRecord() {
        String matchRecordCache = this.getPageCache().get("matchRecordCache");
        if (StringUtils.isNotEmpty((CharSequence)matchRecordCache)) {
            return (DynamicObject[])SerializationUtils.deSerializeFromBase64((String)matchRecordCache);
        }
        DynamicObject[] matchRecords = BusinessDataServiceHelper.load((String)"invoice_match_record", (String)String.join((CharSequence)",", "invmatch", "chooserule", "matchtype", "matchrec", "matchentry.bill_type", "matchentry.invpk", "matchentry.matchtype", "matchentry.matchqty", "matchentry.matchamt", "matchentry.billentryid", "matchentry.billid", "matchentry.apbillid", "matchentry.apbillentryid"), (QFilter[])new QFilter("invoicebill", "=", (Object)this.getParam().getInvoicePk()).toArray());
        if (EmptyUtils.isNotEmpty((Object)matchRecords)) {
            this.getPageCache().put("matchRecordCache", SerializationUtils.serializeToBase64((Object)matchRecords));
        }
        return matchRecords;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String invMatch = (String)this.getModel().getValue("invmatch");
        HashMap<String, Boolean> args = new HashMap<String, Boolean>(64);
        if (invMatch.equals(InvMatchType.BILL.name())) {
            args.put("selchexkbox", Boolean.FALSE);
        } else {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry");
            entryGrid.selectRows(0);
        }
        this.getView().updateControlMetadata("entry", args);
    }

    private void loadInvoiceEntry() {
        MatchBillLoaderParam matchParam = MatchBillLoaderParam.New().setMatchChain(MatchBillChain.mainChain).setView(this.getView()).setModel((AbstractFormDataModel)this.getModel()).setMatchParam(this.getParam());
        ApInvoiceMatchBillLoader loader = new ApInvoiceMatchBillLoader(matchParam);
        loader.loadDatas();
    }

    private InvoiceMatchParam getParam() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        JSONObject customParamJson = (JSONObject)formShowParameter.getCustomParam("param");
        return (InvoiceMatchParam)JSON.toJavaObject((JSON)customParamJson, InvoiceMatchParam.class);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String tipMessage;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        LinkedList chains = MatchBillChainHelper.getChainData((IPageCache)this.getPageCache()).getChains();
        List amtKeys = chains.stream().map(MatchBillChain.MatchChain::getMatchAmtKey).collect(Collectors.toList());
        List qtyKeys = chains.stream().map(MatchBillChain.MatchChain::getMatchQtyKey).collect(Collectors.toList());
        if ("chooserule".equals(key)) {
            tipMessage = ResManager.loadKDString((String)"\u66f4\u6539\u9009\u5355\u89c4\u5219\u5c06\u6e05\u7a7a\u5f53\u524d\u5df2\u7ecf\u5339\u914d\u7684\u5206\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InvoiceMatchPlugin_3", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(tipMessage, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("chooserulechange"));
        } else if (key.equals("matchtype")) {
            tipMessage = ResManager.loadKDString((String)"\u5207\u6362\u5339\u914d\u57fa\u51c6\u5c06\u6e05\u7a7a\u5f53\u524d\u5df2\u7ecf\u5339\u914d\u7684\u5206\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InvoiceMatchPlugin_4", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(tipMessage, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("matchtypechange"));
        } else if (amtKeys.contains(key) || qtyKeys.contains(key)) {
            EnumMatchAction.MODIFY_ENTRY.action(new MatchActionParam((AbstractFormDataModel)this.getModel(), this.getView(), (Object)e, this.getParam().isViewMode()));
        }
        if ("matchrec".equals(key)) {
            Optional<DynamicObject> any;
            boolean newValue = (Boolean)e.getChangeSet()[0].getNewValue();
            if (BooleanUtils.isFalse((Boolean)newValue) && (any = this.getModel().getEntryEntity("entry").stream().filter(entry -> entry.getString("invmatchrule").equals(MatchRuleType.REC.name())).findAny()).isPresent()) {
                int seq = any.get().getInt("seq");
                String tipMessage2 = ResManager.loadKDString((String)"\u6536\u7968\u5355\u7b2c%d\u884c\u5339\u914d\u89c4\u5219\u4e3a\u5339\u914d\u6536\u8d27\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u5339\u914d\u6536\u8d27\u8282\u70b9\u3002", (String)"InvoiceMatchPlugin_5", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(tipMessage2, seq));
                this.getModel().setValue("matchrec", (Object)Boolean.TRUE);
                return;
            }
            String tipMessage3 = ResManager.loadKDString((String)"\u5c06\u6e05\u7a7a\u5df2\u7ecf\u5339\u914d\u7684\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InvoiceMatchPlugin_6", (String)"fi-ap-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(tipMessage3, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("matchrecchange"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, evt.getResult());
        if (isOK && "chooserulechange".equals(callBackId)) {
            EnumMatchAction.CHOOSE_RULE_CHANGE.action(new MatchActionParam((AbstractFormDataModel)this.getModel(), this.getView()));
        } else if (isOK && "matchtypechange".equals(callBackId)) {
            EnumMatchAction.MATCH_TYPE_CHANGE.action(new MatchActionParam((AbstractFormDataModel)this.getModel(), this.getView()));
        } else if (isOK && "matchrecchange".equals(callBackId)) {
            EnumMatchAction.MATCH_REC_CHANGE.action(new MatchActionParam((AbstractFormDataModel)this.getModel(), this.getView()));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Tab control = (Tab)this.getControl("chainbilltab");
        String currentTab = control.getCurrentTab();
        Map chainMap = MatchBillChainHelper.getChainData((IPageCache)this.getPageCache()).getChainMap();
        MatchBillChain.MatchChain currentChain = (MatchBillChain.MatchChain)chainMap.get(currentTab);
        String showBillEntity = currentChain.getBillEntity();
        Object returnData = evt.getReturnData();
        if (showBillEntity != null && returnData != null) {
            ListSelectedRowCollection collection = (ListSelectedRowCollection)returnData;
            Object[] entryPks = collection.stream().map(ListSelectedRow::getEntryPrimaryKeyValue).toArray(Object[]::new);
            String chooseRule = (String)this.getModel().getValue("chooserule");
            EnumDirection direction = "ORDER".equals(chooseRule) ? EnumDirection.DOWN : EnumDirection.UP;
            MatchBillLoaderParam matchParam = MatchBillLoaderParam.New().setView(this.getView()).setModel((AbstractFormDataModel)this.getModel()).setMatchChain(currentChain).setMatchParam(this.getParam()).setEntryPks(entryPks).setDirection(direction);
            IMatchBillLoader chainLoader = MatchBillLoaderFactory.getChainLoaders((String)showBillEntity, (MatchBillLoaderParam)matchParam);
            chainLoader.loadDatas();
            this.initLoaderDataValue();
        }
    }

    private void initLoaderDataValue() {
        String matchType = (String)this.getModel().getValue("matchtype");
        MatchBillChain.MatchChain activeChain = MatchBillChainHelper.getActiveChain((IPageCache)this.getPageCache());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(activeChain.getEntryIdentify());
        for (DynamicObject entry : entryEntity) {
            int iRow = entry.getInt("seq") - 1;
            this.getModel().setValue(activeChain.getMatchAmtKey(), (Object)entry.getBigDecimal(activeChain.getUnMatchAmtKey()), iRow);
            this.getModel().setValue(activeChain.getMatchQtyKey(), (Object)(matchType.equals("AMT") ? BigDecimal.ONE : entry.getBigDecimal(activeChain.getUnMatchQtyKey())), iRow);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.getView().invokeOperation("refresh");
        } else if ("viewapbill".equals(itemKey)) {
            ListShowParameter lsp = new ListShowParameter();
            lsp.setBillFormId("ap_finapbill");
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ListFilterParameter lfp = new ListFilterParameter();
            Object[] apBillPks = Stream.of(this.queryMatchRecord()).map(record -> record.getDynamicObjectCollection("matchentry")).flatMap(Collection::stream).map(entry -> entry.getLong("apbillid")).toArray();
            QFilter filter = new QFilter("id", "in", (Object)apBillPks);
            lfp.setFilter(filter);
            lsp.setListFilterParameter(lfp);
            lsp.setCustomParam("clearinitfilterflag", (Object)Boolean.TRUE);
            this.getView().showForm((FormShowParameter)lsp);
        } else if (itemKey.endsWith("addrow")) {
            MatchBillChain matchBillChain = MatchBillChainHelper.getChainData((IPageCache)this.getPageCache());
            Map chainMap = matchBillChain.getChainMap();
            MatchBillChain.MatchChain matchChain = (MatchBillChain.MatchChain)chainMap.get(itemKey);
            String billEntity = matchChain.getBillEntity();
            MatchBillChain.MatchChain currentChain = (MatchBillChain.MatchChain)chainMap.get(matchBillChain.getActiveMatchTab());
            MatchBillLoaderParam param = MatchBillLoaderParam.New().setMatchChain(currentChain).setView(this.getView()).setModel((AbstractFormDataModel)this.getModel()).setMatchParam(this.getParam());
            IMatchBillLoader loader = MatchBillLoaderFactory.getLoader((String)billEntity, (MatchBillLoaderParam)param);
            loader.showBillSelectView((IFormPlugin)this);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        MatchBillChain.MatchChain matchChain = MatchBillChainHelper.getActiveChain((IPageCache)this.getPageCache());
        if (matchChain.getEntryIdentify().equals(e.getEntryProp().getName())) {
            EnumMatchAction.DELETE_ENTRY.action(new MatchActionParam((AbstractFormDataModel)this.getModel(), this.getView(), (Object)e, this.getParam().isViewMode()));
            e.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (operateKey.equals("match")) {
            operate.getOption().setVariableValue("pagechaindata", JSON.toJSONString((Object)MatchBillChainHelper.getChainData((IPageCache)this.getPageCache())));
            Map<String, Long> relationMap = this.getRelationInfo();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
            this.getModel().deleteEntryData("resultentry");
            for (DynamicObject dyb : entryEntity) {
                String redisKey = "matchresultcache_" + dyb.getString("invpk");
                MatchResult matchResult = (MatchResult)JSON.parseObject((String)this.getPageCache().get(redisKey), MatchResult.class);
                if (!Objects.nonNull(matchResult)) continue;
                Long invPk = matchResult.getInvPk();
                List items = matchResult.getItems();
                for (MatchResultItem item : items) {
                    if (item.getMatchAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
                    int insertRow = this.getModel().createNewEntryRow("resultentry");
                    Long upEntryPk = relationMap.get(String.join((CharSequence)",", invPk.toString(), item.getBillEntity(), item.getEntryId().toString()));
                    this.getModel().setValue("rs_invpk", (Object)invPk, insertRow);
                    this.getModel().setValue("rs_entity", (Object)item.getBillEntity(), insertRow);
                    this.getModel().setValue("rs_billid", item.getBillId(), insertRow);
                    this.getModel().setValue("rs_entryid", item.getEntryId(), insertRow);
                    this.getModel().setValue("rs_amt", (Object)item.getMatchAmt(), insertRow);
                    this.getModel().setValue("rs_qty", (Object)item.getMatchQty(), insertRow);
                    this.getModel().setValue("rs_type", (Object)item.getMatchType(), insertRow);
                    this.getModel().setValue("rs_upentrypk", (Object)upEntryPk, insertRow);
                    this.getModel().setValue("rs_seq", (Object)item.getSeq(), insertRow);
                }
            }
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        InvoiceMatchParam param = this.getParam();
        MutexLockHelper.batchRelease((String)"ap_invoice", Collections.singleton(param.getInvoicePk()), (String)"invoicematch");
    }

    private Map<String, Long> getRelationInfo() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("relentry");
        Set relations = collection.stream().map(e -> new Relation(e.getString("relsrcentity"), Long.valueOf(e.getLong("relsrcentryid")), e.getString("reltgtentity"), Long.valueOf(e.getLong("reltgtentryid")), e.getString("reldirection"), Long.valueOf(e.getLong("relinvpk")))).collect(Collectors.toSet());
        return relations.stream().collect(Collectors.toMap(Relation::getGroupKey, Relation::getGroupValue));
    }
}

