/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.fi.ap.formplugin.ApAbstractImport;
import kd.fi.ap.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.InitHelper;

public class PeriodBillImport
extends ApAbstractImport {
    private InitHelper init = null;

    @Override
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        super.beforeImportData(data, option, importlogs);
        try {
            super.checkOrg();
            data.put("billtype", "Standardpay");
            data.remove("billstatus");
            if (this.init == null) {
                this.init = new InitHelper(this.orgId, "ap_init");
            }
            this.checkDate("bizdate", ResManager.loadKDString((String)"\u4ed8\u6b3e\u65e5\u671f", (String)"PeriodBillImport_0", (String)"fi-ap-formplugin", (Object[])new Object[0]), true, null, this.init.getStartDate(), null);
            data.put("asstacttype", "bd_supplier");
            this.checkAsstAct();
            data.put("purmode", "credit");
            this.checkF7("currency", ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01", (String)"PeriodBillImport_1", (String)"fi-ap-formplugin", (Object[])new Object[0]), false, "CNY");
            JSONObject currencyData = (JSONObject)data.get("currency");
            Optional<DynamicObject> currencyOptional = this.getDynamicObjectByNumberOrName("bd_currency", currencyData, "id,number,name");
            if (!currencyOptional.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7ed3\u7b97\u5e01\u201d\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"PeriodBillImport_7", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
            currencyData.put("number", (Object)currencyOptional.get().getString("number"));
            this.checkExchangeRate(currencyOptional.get().getLong("id"));
            data.put("isperiod", "1");
            JSONArray entryList = (JSONArray)data.get("entry");
            for (int i = 0; i < entryList.size(); ++i) {
                JSONObject entry = (JSONObject)entryList.get(i);
                this.checkEntryNull("quantity", ResManager.loadKDString((String)"\u6570\u91cf", (String)"PeriodBillImport_2", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i);
                this.checkEntryNull("price", ResManager.loadKDString((String)"\u5355\u4ef7", (String)"PeriodBillImport_3", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i);
                this.checkEntryEnum("discountmode", ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f", (String)"PeriodBillImport_4", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i, false, new String[]{"PERCENT", "PERUNIT", "NULL"}, "NULL");
                this.checkEntryPriceTaxTotal(entry, i);
                this.checkEntryEnum("corebilltype", ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b", (String)"PeriodBillImport_5", (String)"fi-ap-formplugin", (Object[])new Object[0]), entry, i, false, new String[]{"PO"}, "PO");
            }
        }
        catch (Exception exc) {
            importlogs.add(new ImportLogger.ImportLog(exc.getMessage()));
            return false;
        }
        return true;
    }

    private void checkEntryPriceTaxTotal(JSONObject entry, int seq) {
        BigDecimal unitPrice = this.parseBigDecimal(entry.get((Object)"price"));
        BigDecimal quantity = this.parseBigDecimal(entry.get((Object)"quantity"));
        String discountType = (String)entry.get((Object)"discountmode");
        BigDecimal discountRate = this.parseBigDecimal(entry.get((Object)"discountrate"));
        BigDecimal taxRate = this.parseBigDecimal(entry.get((Object)"taxrate"));
        BigDecimal realPrice = this.parseBigDecimal(entry.get((Object)"actprice"));
        if (unitPrice.compareTo(new BigDecimal(0)) > 0) {
            realPrice = "PERCENT".equals(discountType) ? unitPrice.multiply(new BigDecimal(1).subtract(discountRate.divide(new BigDecimal(100), 4))) : ("PERUNIT".equals(discountType) ? unitPrice.subtract(discountRate) : unitPrice);
            entry.put("actprice", (Object)realPrice.toPlainString());
        }
        BigDecimal actualPrice = this.parseBigDecimal(entry.get((Object)"actpricetax"));
        if (realPrice.compareTo(new BigDecimal(0)) > 0) {
            actualPrice = realPrice.multiply(new BigDecimal(1).add(taxRate.divide(new BigDecimal(100), 4)));
            entry.put("actpricetax", (Object)actualPrice.toPlainString());
        }
        BigDecimal price = this.parseBigDecimal(entry.get((Object)"e_amount"));
        if (realPrice.compareTo(new BigDecimal(0)) > 0) {
            price = realPrice.multiply(quantity);
            entry.put("e_amount", (Object)price.toPlainString());
        }
        BigDecimal priceTax = this.parseBigDecimal(entry.get((Object)"e_pricetaxtotal"));
        if (actualPrice.compareTo(new BigDecimal(0)) > 0) {
            price = actualPrice.multiply(quantity);
            entry.put("e_pricetaxtotal", (Object)priceTax.toPlainString());
        }
        BigDecimal tax = this.parseBigDecimal(entry.get((Object)"e_tax"));
        if (realPrice.compareTo(new BigDecimal(0)) > 0) {
            price = realPrice.multiply(quantity).multiply(taxRate.divide(new BigDecimal(100), 4));
            entry.put("e_tax", (Object)tax);
        }
        entry.put("e_noninvamount", (Object)priceTax.toPlainString());
        BigDecimal priceTotal = BigDecimal.ZERO;
        BigDecimal taxTotal = BigDecimal.ZERO;
        BigDecimal noticketTotal = BigDecimal.ZERO;
        if (seq == ((JSONArray)this.data.get("entry")).size() - 1) {
            JSONArray entryList = (JSONArray)this.data.get("entry");
            for (int i = 0; i < entryList.size(); ++i) {
                JSONObject row = (JSONObject)entryList.get(i);
                BigDecimal ePriceTax = this.parseBigDecimal(row.get((Object)"e_pricetaxtotal"));
                BigDecimal eTax = this.parseBigDecimal(row.get((Object)"e_tax"));
                BigDecimal eNoticket = this.parseBigDecimal(row.get((Object)"e_noninvamount"));
                priceTotal = priceTotal.add(ePriceTax);
                taxTotal = taxTotal.add(eTax);
                noticketTotal = noticketTotal.add(eNoticket);
            }
            this.data.put("pricetaxtotal", priceTotal.toPlainString());
            this.data.put("tax", taxTotal.toPlainString());
            this.data.put("noninvamount", noticketTotal.toPlainString());
        }
    }

    private void checkAsstAct() {
        JSONObject value = (JSONObject)this.data.get("asstact");
        if (value == null) {
            return;
        }
        Optional<DynamicObject> assactTypeOptional = this.getDynamicObjectByNumberOrName(this.data.get("asstacttype").toString(), value, "id,number,name");
        if (!assactTypeOptional.isPresent()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"PeriodBillImport_6", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        value.put("number", (Object)assactTypeOptional.get().getString("number"));
        String number = (String)value.get((Object)"number");
        this.data.put("asstactname", ((DynamicObject)((Map)this.cachedF7.get("bd_supplier")).get(number)).get("name"));
    }

    private void checkExchangeRate(long currencyId) throws ParseException {
        JSONObject currency = (JSONObject)this.data.get("currency");
        JSONObject baseCurrency = (JSONObject)this.data.get("basecurrency");
        if (currency.get((Object)"number").equals(baseCurrency.get((Object)"number"))) {
            this.data.put("exchangerate", "1");
            return;
        }
        BigDecimal value = this.parseBigDecimal(this.data.get("exchangerate"));
        if (BigDecimal.ZERO.compareTo(value) == 0) {
            String strValue = (String)this.data.get("bizdate");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Date bizDate = df.parse(strValue);
            BigDecimal exchangeRate = BaseDataHelper.getExchangeRate((Long)currencyId, (Long)this.baseCurrencyId, (Long)this.orgId, (Date)bizDate);
            this.data.put("exchangerate", exchangeRate);
        }
    }
}

