/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.helper.SystemParameterHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.enums.SettleBillTypeEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class SettleRecordList
extends AbstractListPlugin {
    private Map<Long, Boolean> ap032ParamMap = new HashMap<Long, Boolean>(8);
    private Map<Long, InitHelper> initMap = new HashMap<Long, InitHelper>(8);

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("updateSettleDate".equals(e.getActionId()) && e.getReturnData() != null) {
            Map returnData = (Map)e.getReturnData();
            Date newDate = (Date)returnData.get("newdate");
            Date currentDate = (Date)returnData.get("currentdate");
            OperateOption option = OperateOption.create();
            option.setVariableValue("newdate", SerializationUtils.toJsonString((Object)newDate));
            option.setVariableValue("currentdate", SerializationUtils.toJsonString((Object)currentDate));
            this.getView().invokeOperation("updatesettledate", option);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String orgId = (String)listShowParameter.getCustomParam("org");
        String asstactType = (String)listShowParameter.getCustomParam("asstacttype");
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn column : filterColumnList) {
            if (orgId != null && "org.id".equals(column.getFieldName())) {
                column.setDefaultValue(orgId);
                continue;
            }
            if (asstactType == null || !"mainasstacttype".equals(column.getFieldName())) continue;
            column.setDefaultValue(asstactType);
        }
        Object checkKey = listShowParameter.getCustomParam("checkKey");
        Object settleSeq = listShowParameter.getCustomParam("settleseq");
        if (!EmptyUtils.isEmpty((Object)checkKey) || !EmptyUtils.isEmpty((Object)settleSeq)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap"});
            filterColumnList.clear();
            args.getFilterContainerInitEvent().getSchemeFilterColumns().clear();
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("mainasstactid.name".equals(fieldName) || "asstactid.name".equals(fieldName)) {
            args.getQfilters().add(new QFilter("status", "=", (Object)"C"));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("unsettle".equals(key)) {
            evt.setCancel(this.unSettleVerify());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("unsettle".equals(args.getOperateKey())) {
            if (args.getOperationResult().getSuccessPkIds().size() > 0) {
                this.getView().getPageCache().put("iswriteoff", "true");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u6210\u529f\u3002", (String)"SettleRecordList_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        } else if ("updatesettledate".equals(args.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        } else if ("modifysettledate".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.openModifySettleDateView();
        }
    }

    public boolean unSettleVerify() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] pks = selectedRows.getPrimaryKeyValues();
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"ap_settlerecord", (String)"id,org,settledate,isvoucher,settleseq", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())});
        Boolean isVcherOrClose = Boolean.FALSE;
        for (DynamicObject data : datas) {
            Date currentDate;
            boolean isvoucher = data.getBoolean("isvoucher");
            long orgId = data.getLong("org");
            Boolean ap032 = this.getSystemParameter(orgId, "ap_032");
            if (ap032.booleanValue() && isvoucher) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"SettleRecordList_6", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
            InitHelper init = this.getInitInfo(orgId);
            Date date = currentDate = init.getCurrentDate() != null ? init.getCurrentDate() : init.getStartDate();
            if (!isvoucher && DateUtils.getDiffDays((Date)data.getDate("settledate"), (Date)currentDate) <= 0) continue;
            isVcherOrClose = Boolean.TRUE;
        }
        if (isVcherOrClose.booleanValue() && selectedRows.size() > 1) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u8de8\u671f\u6216\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u6570\u636e\uff0c\u53cd\u7ed3\u7b97\u5c06\u751f\u6210\u7ea2\u51b2\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SettleRecordList_1", (String)"fi-ar-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("unsettleCallBack"));
        } else if (isVcherOrClose.booleanValue() && selectedRows.size() == 1) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u5df2\u8de8\u671f\u6216\u751f\u6210\u51ed\u8bc1\uff0c\u53cd\u7ed3\u7b97\u5c06\u751f\u6210\u7ea2\u51b2\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SettleRecordList_1", (String)"fi-ar-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("unsettleCallBack"));
        }
        return isVcherOrClose;
    }

    private Boolean getSystemParameter(long orgId, String param) {
        Boolean ap032 = this.ap032ParamMap.get(orgId);
        if (ap032 == null) {
            ap032 = SystemParameterHelper.getParameterBoolean((long)orgId, (String)param);
            this.ap032ParamMap.put(orgId, ap032);
        }
        return ap032;
    }

    private InitHelper getInitInfo(long orgId) {
        InitHelper init = this.initMap.get(orgId);
        if (EmptyUtils.isEmpty((Object)init)) {
            init = new InitHelper(orgId, "ap_init");
            this.initMap.put(orgId, init);
        }
        return init;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (Objects.equals(callBackID, "unsettleCallBack") && isOK) {
            this.getView().invokeOperation("unsettle");
        }
    }

    private void openModifySettleDateView() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] pks = selectedRows.getPrimaryKeyValues();
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"ap_settlerecord", (String)"id,org,settledate,isvoucher,settleseq,mainbizdate,billentity,mainbillid,entry.billdate,entry.billid,entry.e_billentity", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
        HashSet<Long> orgPks = new HashSet<Long>();
        ArrayList<String> settleSeqList = new ArrayList<String>(64);
        Date maxDate = ((DynamicObject)datas.get(0)).getDate("mainbizdate");
        HashMap<String, Set<Long>> billIdsMap = new HashMap<String, Set<Long>>(16);
        for (DynamicObject data : datas) {
            orgPks.add(data.getLong("org"));
            boolean isVoucher = data.getBoolean("isvoucher");
            String settleSeq = data.getString("settleseq");
            if (isVoucher) {
                settleSeqList.add(settleSeq);
            }
            maxDate = this.getMaxBizDate(data, billIdsMap, maxDate);
        }
        this.getMaxBookDate(billIdsMap, maxDate);
        if (orgPks.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u7ec4\u7ec7\u4e0b\u7684\u6570\u636e\u6267\u884c\u3002", (String)"SettleRecordList_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            return;
        }
        if (EmptyUtils.isNotEmpty(settleSeqList)) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c%2$s\u5f20\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"SettleRecordList_3", (String)"fi-ap-formplugin", (Object[])new Object[0]), datas.size(), settleSeqList.size()), String.join((CharSequence)"", settleSeqList.stream().distinct().map(seq -> ResManager.loadKDString((String)"\u7ed3\u7b97\u5e8f\u53f7%s\uff1a\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u7ed3\u7b97\u8bb0\u5f55\u4e0d\u5141\u8bb8\u4fee\u6539\u7ed3\u7b97\u65e5\u671f\u3002", (String)"SettleRecordList_4", (String)"fi-ap-formplugin", (Object[])new Object[]{seq}) + "\n").collect(Collectors.toList())), MessageTypes.Default);
            return;
        }
        InitHelper init = new InitHelper(((Long)orgPks.iterator().next()).longValue(), "ap_init");
        Date currentDate = init.getCurrentDate();
        if (!ObjectUtils.isEmpty((Object)currentDate)) {
            HashSet<Long> billPks = new HashSet<Long>();
            for (DynamicObject data : datas) {
                Date settleDate = data.getDate("settledate");
                if (DateUtils.getDiffDays((Date)settleDate, (Date)currentDate) <= 0) continue;
                billPks.add(data.getLong("id"));
            }
            if (billPks.size() == pks.length) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ed3\u7b97\u8bb0\u5f55\u65e5\u671f\u5df2\u7ecf\u5173\u8d26\uff0c\u65e0\u6cd5\u4fee\u6539\u3002", (String)"SettleRecordList_5", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ap_modifysettledate");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "updateSettleDate"));
        showParameter.getCustomParams().put("org", orgPks.iterator().next());
        showParameter.getCustomParams().put("initentity", "ap_init");
        showParameter.getCustomParams().put("maxDate", maxDate.getTime());
        this.getView().showForm(showParameter);
    }

    public Date getMaxBizDate(DynamicObject data, Map<String, Set<Long>> billIdsMap, Date maxDate) {
        String billEntity = data.getString("billentity");
        Date mainBizDate = data.getDate("mainbizdate");
        String entryBillEntity = data.getString("entry.e_billentity");
        Date entryBizDate = data.getDate("entry.billdate");
        maxDate = mainBizDate.after(entryBizDate) ? (maxDate.after(mainBizDate) ? maxDate : mainBizDate) : (maxDate.after(entryBizDate) ? maxDate : entryBizDate);
        this.getBIllIdsMap(billEntity, data, billIdsMap, "mainbillid");
        this.getBIllIdsMap(entryBillEntity, data, billIdsMap, "entry.billid");
        return maxDate;
    }

    public Date getMaxBookDate(Map<String, Set<Long>> billIdsMap, Date maxDate) {
        DynamicObjectCollection finApBills;
        Date bookDate;
        DynamicObjectCollection finArBills;
        if (billIdsMap.get("ar_finarbill") != null && (finArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,bookdate", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdsMap.get("ar_finarbill"))}, (String)"bookdate desc", (int)1)).size() > 0 && (bookDate = ((DynamicObject)finArBills.get(0)).getDate("bookdate")) != null) {
            Date date = maxDate = maxDate.after(bookDate) ? maxDate : bookDate;
        }
        if (billIdsMap.get("ap_finapbill") != null && (finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,bookdate", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdsMap.get("ap_finapbill"))}, (String)"bookdate desc", (int)1)).size() > 0 && (bookDate = ((DynamicObject)finApBills.get(0)).getDate("bookdate")) != null) {
            maxDate = maxDate.after(bookDate) ? maxDate : bookDate;
        }
        return maxDate;
    }

    private Map<String, Set<Long>> getBIllIdsMap(String billEntity, DynamicObject data, Map<String, Set<Long>> billIdsMap, String billId) {
        Set<Long> billIds = billIdsMap.get(billEntity);
        if (billIds != null) {
            billIds.add(data.getLong(billId));
        } else {
            billIds = new HashSet<Long>(16);
            billIds.add(data.getLong(billId));
            billIdsMap.put(billEntity, billIds);
        }
        return billIdsMap;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Object org = listShowParameter.getCustomParam("org");
        Object checkKey = listShowParameter.getCustomParam("checkKey");
        if (org != null) {
            e.setMainOrgQFilter(new QFilter("org", "=", (Object)Long.valueOf(org.toString())));
            List qFilters = e.getQFilters();
            String settleSeqJson = (String)listShowParameter.getCustomParam("settleseq");
            if (!StringUtils.isEmpty((String)settleSeqJson)) {
                List settleSeqs = SerializationUtils.fromJsonStringToList((String)settleSeqJson, Long.class);
                qFilters.add(new QFilter("settleseq", "in", (Object)settleSeqs));
                long userId = RequestContext.get().getCurrUserId();
                qFilters.add(new QFilter("creator", "=", (Object)userId));
            } else {
                listShowParameter.getCustomParams().remove("org");
                this.getView().cacheFormShowParameter();
            }
        }
        if (EmptyUtils.isEmpty((Object)checkKey)) {
            ArrayList<String> settleRelations = new ArrayList<String>();
            settleRelations.add(SettleRelationEnum.APPAYSETTLE.getValue());
            settleRelations.add(SettleRelationEnum.APSELF.getValue());
            settleRelations.add(SettleRelationEnum.PAYSELF.getValue());
            settleRelations.add(SettleRelationEnum.APLIQUIDATIONSETTLE.getValue());
            settleRelations.add(SettleRelationEnum.APARSETTLE.getValue());
            settleRelations.add(SettleRelationEnum.PAYTRANS.getValue());
            settleRelations.add(SettleRelationEnum.APWRITEOFF.getValue());
            settleRelations.add(SettleRelationEnum.PAYRECSETTLE.getValue());
            settleRelations.add(SettleRelationEnum.APRECSETTLE.getValue());
            settleRelations.add(SettleRelationEnum.PREMSETTLE.getValue());
            settleRelations.add(SettleRelationEnum.PAYCLEARINGSETTLE.getValue());
            e.getQFilters().add(new QFilter("settlerelation", "in", settleRelations));
        } else if (this.getView().getPageCache().get("iswriteoff") != null) {
            for (QFilter qFilter : e.getQFilters()) {
                String property = qFilter.getProperty();
                if (!"id".equals(property)) continue;
                Set ids = (Set)qFilter.getValue();
                Map tarBillIdMap = BOTPHelper.loadDirtTarBillIds((String)"ap_settlerecord", (Long[])ids.toArray(new Long[0]), (String)"ap_settlerecord");
                Set tarBillIds = tarBillIdMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
                ids.addAll(tarBillIds);
                break;
            }
            this.getView().cacheFormShowParameter();
            this.getView().getPageCache().remove("iswriteoff");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        int rowIndex = args.getHyperLinkClickEvent().getRowIndex();
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object pkId = billList.getFocusRowPkId();
        DynamicObject rowData = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"ap_settlerecord", (String)"id,mainbilltype,mainbillid,billentity,entry.id,entry.billtype,entry.billid,entry.e_billentity");
        if ("billno".equals(fieldName)) {
            args.setCancel(true);
            BillShowParameter param = new BillShowParameter();
            param.setPkId(rowData.get("mainbillid"));
            param.setStatus(OperationStatus.VIEW);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String billEntity = rowData.getString("billentity");
            if (ObjectUtils.isEmpty((Object)billEntity)) {
                String mainBillType = rowData.getString("mainbilltype");
                billEntity = this.getFormIdByType(mainBillType);
            }
            param.setFormId(billEntity);
            this.getView().showForm((FormShowParameter)param);
        } else if ("billnum".equals(fieldName)) {
            args.setCancel(true);
            BillList list = (BillList)this.getControl("billlistap");
            long rowId = 0L;
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            int indexOffset = -1;
            for (ListSelectedRow row : selectedRows) {
                int rowKey = row.getRowKey();
                if (rowKey == -1) {
                    if (rowIndex != ++indexOffset) continue;
                    rowId = (Long)row.getEntryPrimaryKeyValue();
                    break;
                }
                if (rowIndex == rowKey) {
                    rowId = (Long)row.getEntryPrimaryKeyValue();
                    break;
                }
                indexOffset = rowKey;
            }
            DynamicObjectCollection entryColl = rowData.getDynamicObjectCollection("entry");
            DynamicObject entry = null;
            for (DynamicObject entryObj : entryColl) {
                long entryId = (Long)entryObj.getPkValue();
                if (rowId != entryId) continue;
                entry = entryObj;
                break;
            }
            if (entry != null && !ObjectUtils.isEmpty((Object)entry.getString("billtype"))) {
                String billEntity = entry.getString("e_billentity");
                if (ObjectUtils.isEmpty((Object)billEntity)) {
                    billEntity = this.getFormIdByType(entry.getString("billtype"));
                }
                BillShowParameter param = new BillShowParameter();
                param.setPkId(entry.get("billid"));
                param.setStatus(OperationStatus.VIEW);
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setFormId(billEntity);
                this.getView().showForm((FormShowParameter)param);
            }
        }
    }

    private String getFormIdByType(String billType) {
        String formId = null;
        if (SettleBillTypeEnum.APPAY.getValue().equals(billType) || SettleBillTypeEnum.OTHERPAY.getValue().equals(billType)) {
            formId = "cas_paybill";
        } else if (SettleBillTypeEnum.PAID.getValue().equals(billType)) {
            formId = "ap_paidbill";
        } else if (SettleBillTypeEnum.LIQUIDATION.getValue().equals(billType)) {
            formId = "ap_liquidation";
        } else if (SettleBillTypeEnum.PURCHASE.getValue().equals(billType) || SettleBillTypeEnum.FEE.getValue().equals(billType) || SettleBillTypeEnum.TRANSPAY.getValue().equals(billType) || SettleBillTypeEnum.OTHERAP.getValue().equals(billType) || SettleBillTypeEnum.PURFEEAP.getValue().equals(billType)) {
            formId = "ap_finapbill";
        } else if (SettleBillTypeEnum.STANDARD.getValue().equals(billType) || SettleBillTypeEnum.EXPENSE.getValue().equals(billType) || SettleBillTypeEnum.OTHERAR.getValue().equals(billType)) {
            formId = "ar_finarbill";
        } else if (SettleBillTypeEnum.APBORROW.getValue().equals(billType)) {
            formId = "ap_finapbill";
        } else if (SettleBillTypeEnum.ARBORROW.getValue().equals(billType)) {
            formId = "ar_finarbill";
        }
        return formId;
    }
}

