/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.fi.arapcommon.helper.OrgHelper;

public class SettleSchemeList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(SettleSchemeList.class);
    private static final Long groupId_v2 = 4L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("viewlog".equals(evt.getItemKey())) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            logger.info("\u9009\u4e2d\u884cselectedRows:" + selectedRows.size());
            Object[] primaryKeys = selectedRows.getPrimaryKeyValues();
            logger.info("\u9009\u4e2d\u884cprimaryKeys\u6570\u7ec4:" + primaryKeys.length);
            if (primaryKeys.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"SettleSchemeList_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            } else if (primaryKeys.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8054\u67e5\u3002", (String)"SettleSchemeList_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            } else {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId("ap_settlelog");
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                long pk = (Long)selectedRows.get(0).getPrimaryKeyValue();
                listShowParameter.setCustomParam("schemePk", (Object)pk);
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("settle".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            if (selectedRows != null) {
                Object[] pks = selectedRows.getPrimaryKeyValues();
                for (int i = 0; i < pks.length; ++i) {
                    DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)pks[i], (String)"ap_settlescheme", (String)"enable");
                    if (!"0".equals(obj.getString("enable"))) continue;
                    return;
                }
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u6848\u6267\u884c\u6210\u529f\u3002", (String)"SettleSchemeList_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
    }

    public void setFilter(SetFilterEvent e) {
        if (this.hasNoLicense(null)) {
            e.getQFilters().add(new QFilter("1", "!=", (Object)"1"));
        }
        List orgIds = OrgHelper.getAuthorizedBankOrgIds((String)"ap", (String)"ap_settlescheme", (String)"47150e89000000ac");
        e.getCustomQFilters().add(new QFilter("orgentry.org.id", "in", (Object)orgIds));
        super.setFilter(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        AbstractOperate op = (AbstractOperate)e.getSource();
        String operateKey = op.getOperateKey();
        if ("new".equals(operateKey) && this.hasNoLicense(null)) {
            e.setCancel(true);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (this.hasNoLicense(e)) {
            e.setCancel(true);
        }
    }

    private boolean hasNoLicense(PreOpenFormEventArgs e) {
        String productVersion = LicenseServiceHelper.getProductVersion();
        logger.info("\u5f53\u524d\u8bb8\u53ef\u8bc1\u53f7:\t" + productVersion);
        if ("3.0".equals(productVersion) || "2.0".equals(productVersion)) {
            LicenseCheckResult resultv2 = LicenseServiceHelper.checkUserInGroup((Long)RequestContext.get().getCurrUserId(), (Long)groupId_v2);
            logger.info("resultv2\u8fd4\u56de\u7ed3\u679c:\t" + resultv2.getHasLicense());
            if (!resultv2.getHasLicense().booleanValue()) {
                String msg = resultv2.getMsg();
                if (e != null) {
                    e.setCancelMessage(msg);
                    e.setCancelFormShowParameter(resultv2.getCancelFormShowParameter());
                } else {
                    this.getView().showMessage(msg);
                }
                return true;
            }
        } else {
            LicenseCheckResult result = LicenseServiceHelper.checkByAppAndBizObj((String)"+HKZHSKFXOX", (String)"ap_settlescheme", (Long)RequestContext.get().getCurrUserId());
            logger.info("result\u8fd4\u56de\u7ed3\u679c: \t" + result.getHasLicense());
            if (!result.getHasLicense().booleanValue()) {
                if (e != null) {
                    e.setCancelMessage(result.getMsg());
                    e.setCancelFormShowParameter(result.getCancelFormShowParameter());
                } else {
                    this.getView().showMessage(result.getMsg());
                }
                return true;
            }
        }
        return false;
    }
}

