/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.formplugin.formservice.TransferPayEditController;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.AsstactHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class TransferAllEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"t_payeebanknum"});
        this.filterAsstact();
        this.filterPayproperty();
    }

    private void filterAsstact() {
        ItemClassEdit asstactF7 = (ItemClassEdit)this.getControl("t_asstact");
        asstactF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            EntryGrid tagentry = (EntryGrid)this.getControl("tagentry");
            int[] selectRows = tagentry.getSelectRows();
            String asstactType = this.getModel().getValue("t_asstacttype", selectRows[0]).toString();
            if ("bd_supplier".equals(asstactType)) {
                QFilter filter = new QFilter("bizfunction", "ilike", (Object)"%2%");
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter);
            }
        });
    }

    private void filterPayproperty() {
        BasedataEdit paypropertyF7 = (BasedataEdit)this.getControl("t_payproperty");
        paypropertyF7.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (entryEntity == null || entryEntity.size() < 1) {
                return;
            }
            Long srcId = (Long)this.getModel().getValue("id", 0);
            QFilter idFilter = new QFilter("id", "=", (Object)srcId);
            DynamicObject bill = QueryServiceHelper.queryOne((String)"ap_finapbill", (String)"payproperty.isbasedonamt", (QFilter[])idFilter.toArray());
            if (bill == null) {
                return;
            }
            ListFilterParameter lfp = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            lfp.getQFilters().add(new QFilter("isbasedonamt", "=", (Object)bill.getBoolean("payproperty.isbasedonamt")));
        });
    }

    protected TransferPayEditController getFormController() {
        return (TransferPayEditController)BeanFactory.getBean(TransferPayEditController.class, (Object[])new Object[0]);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getFormController().fillModelBySameKey(this.getModel(), this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int currentIndex = changeData[0].getRowIndex();
        switch (key) {
            case "head_asstacttype": {
                int i;
                DynamicObjectCollection tagentry = this.getModel().getEntryEntity("tagentry");
                for (i = 0; i < tagentry.size(); ++i) {
                    this.getModel().setValue("t_asstact", null, i);
                    this.getModel().setValue("t_payeebanknum", null, i);
                    this.getModel().setValue("t_bebank", null, i);
                }
                for (i = 0; i < tagentry.size(); ++i) {
                    this.getModel().setValue("t_asstacttype", newValue, i);
                }
                break;
            }
            case "t_asstact": {
                if (newValue == null) {
                    this.getModel().setValue("t_payeebanknum", null, currentIndex);
                    this.getModel().setValue("t_bebank", null, currentIndex);
                    this.getModel().setValue("paycond", null, currentIndex);
                    this.getModel().setValue("settlementtype", null, currentIndex);
                    break;
                }
                DynamicObject asstact = (DynamicObject)newValue;
                Map map = AsstactHelper.getaccbebankMap((DynamicObject)((DynamicObject)newValue));
                this.getModel().setValue("t_payeebanknum", map.get("account"), currentIndex);
                this.getModel().setValue("t_bebank", map.get("bebank"), currentIndex);
                this.getModel().setValue("settlementtype", map.get("settlementtypeid"), currentIndex);
                DynamicObject asstactFieldValue = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"paycond", (QFilter[])new QFilter[]{new QFilter("id", "=", asstact.getPkValue())});
                if (asstactFieldValue == null) {
                    this.getModel().setValue("paycond", null, currentIndex);
                    return;
                }
                long paycondId = asstactFieldValue.getLong("paycond");
                if (paycondId == 0L) {
                    this.getModel().setValue("paycond", null, currentIndex);
                    return;
                }
                DynamicObject paycondition = QueryServiceHelper.queryOne((String)"bd_paycondition", (String)"paybill,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)paycondId)});
                if (paycondition == null) {
                    this.getModel().setValue("paycond", null, currentIndex);
                    return;
                }
                if (paycondition.getBoolean("paybill") && StringUtils.equals((CharSequence)"1", (CharSequence)((String)paycondition.get("enable")))) {
                    this.getModel().setValue("paycond", (Object)paycondId, currentIndex);
                    break;
                }
                this.getModel().setValue("paycond", null, currentIndex);
                break;
            }
            case "exratetable": 
            case "exratedate": {
                if (newValue != null) break;
                FormServiceHelper.recoverOldValue((IFormView)this.getView(), (String)key, (Object)oldValue);
                return;
            }
            case "head_exchangerate": {
                if (!EmptyUtils.isEmpty((Object)newValue)) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"TransferAllEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object newValue = e.getValue();
        int index = e.getRowIndex();
        if (index == -1) {
            return;
        }
        if (newValue == null && Arrays.asList("transamount", "transtax").contains(key)) {
            newValue = BigDecimal.ZERO;
        }
        switch (key) {
            case "transamount": 
            case "transtax": {
                BigDecimal srcPriceTaxTotal = (BigDecimal)this.getModel().getValue("pricetaxtotal", 0);
                if (ArApHelper.getBigDecimal((Object)newValue).signum() == 0 || ArApHelper.getBigDecimal((Object)newValue).signum() == srcPriceTaxTotal.signum()) break;
                this.getView().showErrorNotification(srcPriceTaxTotal.signum() > 0 ? ResManager.loadKDString((String)"\u8f6c\u4ed8\u91d1\u989d\u548c\u8f6c\u4ed8\u7a0e\u989d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"TransferAllEdit_6", (String)"fi-ap-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8f6c\u4ed8\u91d1\u989d\u548c\u8f6c\u4ed8\u7a0e\u989d\u5fc5\u987b\u5c0f\u4e8e0\u3002", (String)"TransferAllEdit_7", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key, index);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("t_payeebanknum".equals(key)) {
            this.assacctShowF7();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        if ("tagentry".equals(entryProp.getName())) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity row : rowDataEntities = e.getRowDataEntities()) {
                this.getModel().setValue("t_asstacttype", this.getModel().getValue("head_asstacttype"), row.getRowIndex());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("transferall".equals(key)) {
            DynamicObject transferInfo = this.getModel().getDataEntity();
            BigDecimal fromAmt = transferInfo.getBigDecimal("transferamount");
            DynamicObjectCollection transferFromInfos = this.getModel().getEntryEntity("entryentity");
            List transferFromIds = transferFromInfos.stream().map(info -> info.getLong("id")).collect(Collectors.toList());
            DynamicObject[] srcFinBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,unlockamt", (QFilter[])new QFilter[]{new QFilter("id", "in", transferFromIds)});
            BigDecimal sumUnLockAmt = BigDecimal.ZERO;
            for (DynamicObject srcFinBill : srcFinBills) {
                DynamicObjectCollection entrys = srcFinBill.getDynamicObjectCollection("detailentry");
                for (DynamicObject entry : entrys) {
                    BigDecimal unLockAmt = entry.getBigDecimal("unlockamt");
                    sumUnLockAmt = sumUnLockAmt.add(unLockAmt);
                }
            }
            if (sumUnLockAmt.compareTo(fromAmt) != 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f6c\u51fa\u65b9\u4fe1\u606f\u4e2d\u7684\u53ef\u8f6c\u79fb\u91d1\u989d\u4e0e\u5355\u636e\u672a\u9501\u5b9a\u91d1\u989d\u6c47\u603b\u4e0d\u76f8\u7b49\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"TransferAllEdit_3", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                this.getFormController().fillModelBySameKey(this.getModel(), this.getView());
                args.setCancel(true);
            }
            Set transferFromIdSet = transferFromIds.stream().collect(Collectors.toSet());
            ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0018", null, (Object[])new Object[]{transferFromIdSet});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String opKey = closedCallBackEvent.getActionId();
        if (EmptyUtils.isEmpty((Object)closedCallBackEvent.getReturnData())) {
            return;
        }
        if ("transferall_import".equals(opKey)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            this.fillTagEntryByImport(returnData);
        } else if ("assaccount".equals(opKey)) {
            this.closeassaccountF7(closedCallBackEvent.getReturnData());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("transferall".equals(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u8f6c\u4ed8\u6210\u529f\u3002", (String)"TransferAllEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
        if ("transferall_import".equals(e.getOperateKey())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ap_transferall_import");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            boolean isBaseAmt = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(0)).getBoolean("payproperty.isbasedonamt");
            showParameter.setCustomParam("isBaseAmt", (Object)isBaseAmt);
            showParameter.setCustomParam("asstacttype", this.getModel().getValue("head_asstacttype"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "transferall_import"));
            this.getView().showForm(showParameter);
        }
    }

    private void assacctShowF7() {
        int index = this.getModel().getEntryCurrentRowIndex("tagentry");
        DynamicObject basedata = (DynamicObject)this.getModel().getValue("t_asstact", index);
        AsstactHelper.assacctShowF7((DynamicObject)basedata, (IFormView)this.getView(), (String)this.getPluginName());
    }

    private void closeassaccountF7(Object returnData) {
        String assacttype = this.getModel().getValue("t_asstacttype").toString();
        ListSelectedRowCollection returnColl = (ListSelectedRowCollection)returnData;
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("tagentry");
        if (!ObjectUtils.isEmpty((Object)returnColl)) {
            ListSelectedRow rowInfo = returnColl.get(0);
            Object entryKey = rowInfo.getEntryPrimaryKeyValue();
            Object pk = rowInfo.getPrimaryKeyValue();
            if (assacttype.equals("bd_customer") || assacttype.equals("bd_supplier")) {
                DynamicObject cutstomer = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)assacttype, (String)"bankaccount,accountname,bank,name,entry_bank");
                DynamicObjectCollection bankEntry = cutstomer.getDynamicObjectCollection("entry_bank");
                for (DynamicObject row : bankEntry) {
                    if (!row.getPkValue().equals(entryKey)) continue;
                    this.getModel().setValue("t_payeebanknum", (Object)row.getString("bankaccount"), currentRowIndex);
                    this.getModel().setValue("t_bebank", (Object)row.getLong("bank.id"), currentRowIndex);
                    break;
                }
            } else if (assacttype.equals("bos_user")) {
                DynamicObject payeerInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"er_payeer", (String)"id,payerbank,payeraccount");
                if (!ObjectUtils.isEmpty((Object)payeerInfo)) {
                    this.getModel().setValue("t_payeebanknum", (Object)payeerInfo.getString("payeraccount"), currentRowIndex);
                    this.getModel().setValue("t_bebank", payeerInfo.getDynamicObject("payerbank").getPkValue(), currentRowIndex);
                }
            } else {
                DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"bd_accountbanks", (String)"id,bankaccountnumber,bank.id,bank.bebank");
                if (!ObjectUtils.isEmpty((Object)account)) {
                    this.getModel().setValue("t_payeebanknum", (Object)account.getString("bankaccountnumber"), currentRowIndex);
                    this.getModel().setValue("t_bebank", account.getDynamicObject("bank.bebank").getPkValue(), currentRowIndex);
                }
            }
        }
    }

    private void fillTagEntryByImport(Map<String, Object> returnData) {
        List importDatas = (List)returnData.get("rowDatas");
        this.getModel().deleteEntryData("tagentry");
        HashMap<String, String> operatorInfoMap = new HashMap<String, String>();
        for (Map newRow : importDatas) {
            int rowIndex = this.getModel().createNewEntryRow("tagentry");
            this.getModel().setEntryCurrentRowIndex("tagentry", rowIndex);
            if (!EmptyUtils.isEmpty(newRow.get("asstactype"))) {
                this.getModel().setItemValueByNumber("t_asstactype", newRow.get("asstactype").toString(), rowIndex);
            }
            if (!EmptyUtils.isEmpty(newRow.get("asstact.number"))) {
                this.getModel().setItemValueByNumber("t_asstact", newRow.get("asstact.number").toString(), rowIndex);
            }
            if (!EmptyUtils.isEmpty(newRow.get("payeebanknum"))) {
                this.getModel().setValue("t_payeebanknum", (Object)newRow.get("payeebanknum").toString(), rowIndex);
            }
            if (!EmptyUtils.isEmpty(newRow.get("bebank.number"))) {
                this.getModel().setItemValueByNumber("t_bebank", newRow.get("bebank.number").toString(), rowIndex);
            }
            if (!EmptyUtils.isEmpty(newRow.get("settlementtype.number"))) {
                this.getModel().setItemValueByNumber("settlementtype", newRow.get("settlementtype.number").toString(), rowIndex);
            }
            if (!EmptyUtils.isEmpty(newRow.get("paycond.number"))) {
                this.getModel().setItemValueByNumber("paycond", newRow.get("paycond.number").toString(), rowIndex);
            }
            if (!EmptyUtils.isEmpty(newRow.get("purorg.number"))) {
                this.getModel().setItemValueByNumber("purorg", newRow.get("purorg.number").toString(), rowIndex);
                Map operatorGroupMap = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"number", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1')), new QFilter("operatorgrouptype", "=", (Object)"CGZ"), new QFilter("ctrlstrategy", "!=", (Object)"7").or(new QFilter("createorg.number", "=", (Object)newRow.get("purorg.number").toString()))});
                ArrayList<String> groupNos = new ArrayList<String>(operatorGroupMap.size());
                for (Map.Entry entrySet : operatorGroupMap.entrySet()) {
                    DynamicObject operatorGroup = (DynamicObject)entrySet.getValue();
                    groupNos.add(operatorGroup.getString("number"));
                }
                QFilter filter = new QFilter("opergrptype", "=", (Object)"CGZ");
                filter.and(new QFilter("opergrpnumber", "in", groupNos));
                filter.and(new QFilter("invalid", "=", (Object)"0"));
                Map operatorMap = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (String)"operatornumber,opergrpnumber", (QFilter[])new QFilter[]{filter});
                for (Map.Entry entrySet : operatorMap.entrySet()) {
                    DynamicObject operator = (DynamicObject)entrySet.getValue();
                    operatorInfoMap.put(operator.getString("operatornumber"), operator.getString("opergrpnumber"));
                }
                if (!EmptyUtils.isEmpty(newRow.get("purchaser.operatornumber")) && operatorInfoMap.containsKey(newRow.get("purchaser.operatornumber").toString())) {
                    this.getModel().setItemValueByNumber("purchaser", newRow.get("purchaser.operatornumber").toString(), rowIndex);
                    this.getModel().setItemValueByNumber("purdept", (String)operatorInfoMap.get(newRow.get("purchaser.operatornumber").toString()), rowIndex);
                    if (!EmptyUtils.isEmpty(newRow.get("purdept.number")) && operatorInfoMap.containsValue(newRow.get("purdept.number").toString())) {
                        this.getModel().setItemValueByNumber("purdept", newRow.get("purdept.number").toString(), rowIndex);
                    }
                }
            }
            if (!EmptyUtils.isEmpty(newRow.get("payproperty.number"))) {
                this.getModel().setItemValueByNumber("t_payproperty", newRow.get("payproperty.number").toString(), rowIndex);
            }
            this.getModel().setValue("transamount", (Object)BigDecimal.ZERO, rowIndex);
            if (!EmptyUtils.isEmpty(newRow.get("amount"))) {
                this.getModel().setValue("transamount", newRow.get("amount"), rowIndex);
            }
            this.getModel().setValue("transtax", (Object)BigDecimal.ZERO, rowIndex);
            if (!EmptyUtils.isEmpty(newRow.get("tax"))) {
                this.getModel().setValue("transtax", newRow.get("tax"), rowIndex);
            }
            this.getModel().setValue("transpricetaxtotal", (Object)((BigDecimal)this.getModel().getValue("transamount")).add((BigDecimal)this.getModel().getValue("transtax")), rowIndex);
            if (EmptyUtils.isEmpty(newRow.get("remark"))) continue;
            this.getModel().setValue("remark", (Object)newRow.get("remark").toString(), rowIndex);
        }
    }
}

