/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.helper.ArApOperateCheckHelper;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.util.OrmFacade;

public class VerifyRecordList
extends AbstractListPlugin {
    private final OrmFacade ormFacade = new OrmFacade();

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("asstact.name".equals(fieldName) || "e_asstact.name".equals(fieldName) || "material.number".equals(fieldName)) {
            args.getQfilters().add(new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1")));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter para = (ListShowParameter)this.getView().getFormShowParameter();
        if (para.getCustomParam("openMode") != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{""});
            String orgId = (String)para.getCustomParam("org");
            String asstactType = (String)para.getCustomParam("asstacttype");
            List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
            for (FilterColumn column : filterColumnList) {
                if (orgId != null && "org.id".equals(column.getFieldName())) {
                    column.setDefaultValue(orgId);
                    continue;
                }
                if (asstactType != null && "asstacttype".equals(column.getFieldName())) {
                    column.setDefaultValue(asstactType);
                    continue;
                }
                if (!"billdate".equals(column.getFieldName()) || !"history".equals(para.getCustomParam("openMode"))) continue;
                column.setDefaultValue("63");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String ignoreCheck = this.getPageCache().get("ignoreCheck");
        if (Objects.equals("true", ignoreCheck)) {
            this.getPageCache().put("ignoreCheck", null);
        } else {
            ArApOperateCheckHelper.operateCheck((IFormView)this.getView(), (BeforeDoOperationEventArgs)args, (String)"SZJK-PRE-0057");
        }
        FormOperate operate = (FormOperate)args.getSource();
        operate.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (Objects.equals(callBackID, "opcheck") && isOK) {
            String operateKey = e.getCustomVaule();
            this.getPageCache().put("ignoreCheck", "true");
            this.getView().invokeOperation(operateKey);
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] billNos = selectedRows.stream().map(selectedRow -> selectedRow.getBillNo()).toArray();
            LogUtil.addOpLog((String)"ap_verifyrecord", (Object)(billNos.length > 0 ? billNos[0] : null), (String)operateKey, (String)("billnos\uff1a" + JSONObject.toJSONString((Object)billNos) + "execute non-standard operations\uff1a" + operateKey), (boolean)true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("unverify".equals(args.getOperateKey())) {
            if (args.getOperationResult().isSuccess()) {
                List successPkIds = args.getOperationResult().getSuccessPkIds();
                if (!ObjectUtils.isEmpty((Object)successPkIds) && successPkIds.size() > 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u6838\u9500\u6210\u529f\u3002", (String)"VerifyRecordList_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showErrorNotification(args.getOperationResult().getMessage());
                }
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        int rowIndex = args.getHyperLinkClickEvent().getRowIndex();
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object pkId = billList.getFocusRowPkId();
        DynamicObject rowData = this.ormFacade.loadSingle(pkId, "ap_verifyrecord", "id,billid,billtype,entry.id,entry.e_billid,entry.e_billtype");
        if ("billno".equals(fieldName)) {
            args.setCancel(true);
            BillShowParameter param = new BillShowParameter();
            param.setPkId(rowData.get("billid"));
            param.setStatus(OperationStatus.VIEW);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setFormId(rowData.getString("billtype"));
            this.getView().showForm((FormShowParameter)param);
        } else if ("e_billno".equals(fieldName)) {
            args.setCancel(true);
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            long entryKey = 0L;
            for (ListSelectedRow selectedRow : selectedRows) {
                if (rowIndex != selectedRow.getRowKey()) continue;
                entryKey = (Long)selectedRow.getEntryPrimaryKeyValue();
                break;
            }
            DynamicObjectCollection entryColl = rowData.getDynamicObjectCollection("entry");
            DynamicObject entry = new DynamicObject();
            for (DynamicObject entryObj : entryColl) {
                long entryId = (Long)entryObj.getPkValue();
                if (entryKey != entryId) continue;
                entry = entryObj;
                break;
            }
            if (!ObjectUtils.isEmpty((Object)entry)) {
                BillShowParameter param = new BillShowParameter();
                param.setPkId(entry.get("e_billid"));
                param.setStatus(OperationStatus.VIEW);
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setFormId(entry.getString("e_billtype"));
                this.getView().showForm((FormShowParameter)param);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter filter = new QFilter("writeofftypeid", "=", (Object)0);
        filter.or(new QFilter("writeofftypeid", "is null", null));
        qFilters.add(filter);
        ListShowParameter para = (ListShowParameter)this.getView().getFormShowParameter();
        Object billId = para.getCustomParam("billId");
        if (!ObjectUtils.isEmpty((Object)billId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap"});
        }
    }
}

