/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.botp.cv;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.helper.BOTPHelper;

public class ApplyPay2PayBillConvertPlugin
extends AbstractConvertPlugIn {
    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        BillEntityType srcMainType = this.getSrcMainType();
        String srcMainTypeName = srcMainType.getExtendName();
        if ("ap_payapply".equals(srcMainTypeName)) {
            List selectedRows = e.getSelectedRows();
            Set<Long> applyIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            Map applyChangeMap = BOTPHelper.findTargetBills((String)"ap_payapply", (Long[])applyIds.toArray(new Long[0]));
            HashSet changeTarBillIds = (HashSet)applyChangeMap.get("ap_payapplychange");
            DynamicObjectCollection applyChangeBills = QueryServiceHelper.query((String)"ap_payapplychange", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)changeTarBillIds)});
            for (DynamicObject changeBill : applyChangeBills) {
                String billStatus = changeBill.getString("billstatus");
                if ("C".equals(billStatus)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5ba1\u6838\u3001\u51bb\u7ed3\u72b6\u6001=\u672a\u51bb\u7ed3\u3001\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u672a\u8d85\u8fc7\u6838\u51c6\u91d1\u989d\u6298\u7ed3\u7b97\u5e01\u4e14\u4e0b\u6e38\u4e0d\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u5355\u7684\u6570\u636e\u3002", (String)"ApplyPay2PayBillConvertPlugin_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
            }
            ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0119", null, (Object[])new Object[]{applyIds});
        }
        e.setCustFilterExpression(" e_closestatus != 'B' and e_freezestate='unfreeze' ");
        QFilter qFilter = new QFilter("entry.e_closestatus", "!=", (Object)"B");
        qFilter.and(new QFilter("entry.e_freezestate", "=", (Object)"unfreeze"));
        e.getCustQFilters().add(qFilter);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey("cas_paybill");
        HashMap<String, Map> payeeTypeCacheMap = new HashMap<String, Map>(8);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject payBill = entity.getDataEntity();
            if (payBill.get("bizdate") == null) {
                payBill.set("bizdate", (Object)new Date());
            }
            DynamicObject accountBank = payBill.getDynamicObject("payeracctbank");
            DynamicObject bank = payBill.getDynamicObject("payerbank");
            if (bank == null && accountBank != null) {
                bank = accountBank.getDynamicObject("bank");
                payBill.set("payerbank", (Object)bank);
            }
            long payeeId = payBill.getLong("payee");
            String payeeType = payBill.getString("payeeformid");
            if (!ObjectUtils.isEmpty((Object)payeeType)) {
                Map payeeTypeMap = payeeTypeCacheMap.getOrDefault(payeeType, new HashMap(8));
                DynamicObject payee = (DynamicObject)payeeTypeMap.get(payeeId);
                if (payee == null) {
                    payee = BusinessDataServiceHelper.loadSingle((String)payeeType, (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)payeeId)});
                    payeeTypeMap.put(payeeId, payee);
                    payeeTypeCacheMap.put(payeeType, payeeTypeMap);
                }
                if (payee != null) {
                    payBill.set("payeename", (Object)payee.getLocaleString("name"));
                }
            }
            DynamicObjectCollection entries = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                BigDecimal amount = entry.getBigDecimal("e_payableamt");
                entry.set("e_unlockamt", (Object)amount);
                entry.set("e_unsettledamt", (Object)amount);
            }
        }
    }

    private void handleAmount(DynamicObject payBill, BigDecimal exchangeRate) {
        DynamicObjectCollection entries = payBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            BigDecimal amount = entry.getBigDecimal("e_payableamt");
            entry.set("e_payableamt", (Object)amount);
            entry.set("e_payablelocamt", (Object)amount.multiply(exchangeRate));
            entry.set("e_actamt", (Object)amount);
            entry.set("e_localamt", (Object)amount.multiply(exchangeRate));
            entry.set("e_unlockamt", (Object)amount);
            entry.set("e_unsettledamt", (Object)amount);
        }
        payBill.set("localamt", (Object)payBill.getBigDecimal("actpayamt").multiply(exchangeRate));
    }
}

