/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.botp.cv;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildGroupModeEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.helper.OrgHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.AsstactHelper;
import kd.fi.arapcommon.helper.BOTPHelper;

public class FinAp2ApplyPayConvertPlugin
extends AbstractConvertPlugIn {
    private Map<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>();

    public void beforeBuildGroupMode(BeforeBuildGroupModeEventArgs e) {
        BOTPHelper.checkGroupByModeStrategy((ConvertRuleElement)this.getRule());
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        String srcEntityName = this.getSrcMainType().getName();
        if (!"ap_finapbill".equals(srcEntityName)) {
            return;
        }
        List filters = e.getQFilters();
        for (QFilter filter : filters) {
            if (!"id".equals(filter.getProperty())) continue;
            Set billIds = (Set)filter.getValue();
            DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,asstacttype,asstact", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIds)});
            if (ObjectUtils.isEmpty((Object)finApBills)) {
                return;
            }
            Set supplierIds = finApBills.stream().filter(supplier -> "bd_supplier".equals(supplier.get("asstacttype"))).map(supplier -> supplier.get("asstact")).collect(Collectors.toSet());
            List payHoldSupplierPks = QueryServiceHelper.queryPrimaryKeys((String)"bd_supplier", (QFilter[])new QFilter[]{new QFilter("payhold", "=", (Object)Boolean.TRUE), new QFilter("id", "in", supplierIds)}, (String)"", (int)-1);
            for (DynamicObject finApBill : finApBills) {
                if (!"bd_supplier".equals(finApBill.getString("asstacttype")) || !payHoldSupplierPks.contains(finApBill.getLong("asstact"))) continue;
                billIds.remove(finApBill.getLong("id"));
            }
            filter.__setValue((Object)billIds);
            return;
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey("ap_payapply");
        Set settleorgIdSet = Arrays.stream(entitys).map(t -> t.getDataEntity().getLong("settleorg.id")).collect(Collectors.toSet());
        Map settleParamMap = ArApHelper.batchGetApSettleParam(settleorgIdSet);
        ArrayList<DynamicObject> planSettleApplyBills = new ArrayList<DynamicObject>(8);
        for (ExtendedDataEntity entity : entitys) {
            BigDecimal exchangeRate;
            DynamicObject applypayBill = entity.getDataEntity();
            Long settleorgId = applypayBill.getLong("settleorg.id");
            if (!ObjectUtils.isEmpty((Object)settleorgId)) {
                Integer param;
                if (ObjectUtils.isEmpty((Object)applypayBill.getDynamicObject("settlecurrency"))) {
                    DynamicObject settleCurrency = OrgHelper.getBaseCurrency((long)settleorgId);
                    applypayBill.set("settlecurrency", (Object)settleCurrency);
                }
                if ((param = (Integer)settleParamMap.get(settleorgId)) == 2) {
                    planSettleApplyBills.add(applypayBill);
                }
            }
            if (BigDecimal.ZERO.compareTo(exchangeRate = applypayBill.getBigDecimal("exchangeRate")) == 0) {
                exchangeRate = BigDecimal.ONE;
            }
            applypayBill.set("exchangeRate", (Object)exchangeRate);
            this.handleAmount(applypayBill, exchangeRate);
            this.setOrgByUser(applypayBill);
        }
        this.setCoreAndConFieldValues(planSettleApplyBills);
        AsstactHelper.setAccountBankField((ExtendedDataEntity[])entitys, (String)"entry", (String)"e_asstacttype", (String)"e_asstact", (String)"e_assacct", (String)"e_bebank");
    }

    private void setOrgByUser(DynamicObject bill) {
        DynamicObject applyOrg = (DynamicObject)bill.get("applyorg");
        if (applyOrg == null) {
            return;
        }
        long orgId = applyOrg.getLong("id");
        DynamicObject org = this.orgMap.get(orgId);
        if (org == null) {
            org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)});
            this.orgMap.put(orgId, org);
        }
        if (bill.get("settleorg") == null && org.getBoolean("fisaccounting")) {
            bill.set("settleorg", (Object)org);
        }
        if (bill.get("purorg") == null && org.getBoolean("fispurchase")) {
            bill.set("purorg", (Object)org);
        }
        if (bill.get("payorg") == null && org.getBoolean("fisbankroll")) {
            bill.set("payorg", (Object)org);
        }
    }

    private void handleAmount(DynamicObject applypayBill, BigDecimal exchangeRate) {
        DynamicObjectCollection entry = applypayBill.getDynamicObjectCollection("entry");
        BigDecimal applyAmount = BigDecimal.ZERO;
        BigDecimal applySettleAmt = BigDecimal.ZERO;
        for (DynamicObject row : entry) {
            BigDecimal amount = row.getBigDecimal("e_applyamount");
            applyAmount = applyAmount.add(amount);
            row.set("e_applyamount", (Object)amount);
            row.set("e_approvedamt", (Object)amount);
            BigDecimal settleAmt = amount.multiply(exchangeRate);
            applySettleAmt = applySettleAmt.add(settleAmt);
            row.set("e_appseleamount", (Object)settleAmt);
            row.set("e_approvedseleamt", (Object)settleAmt);
        }
        applypayBill.set("applyamount", (Object)applyAmount);
        applypayBill.set("appseleamount", (Object)applySettleAmt);
        applypayBill.set("approvalamount", (Object)applyAmount);
        applypayBill.set("aprseleamount", (Object)applySettleAmt);
    }

    private boolean settingCorebillno(DynamicObjectCollection entrys) {
        boolean flag = false;
        for (DynamicObject entry : entrys) {
            if (ObjectUtils.isEmpty((Object)entry.get("e_corebillno"))) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void setCoreAndConFieldValues(List<DynamicObject> planSettleApplyBills) {
        QFilter filter;
        String selector;
        if (ObjectUtils.isEmpty(planSettleApplyBills)) {
            return;
        }
        HashSet<Long> finArBillIds = new HashSet<Long>(64);
        HashSet<Long> finApBillIds = new HashSet<Long>(64);
        for (DynamicObject apply : planSettleApplyBills) {
            String sourceBillType = apply.getString("sourcebilltype");
            DynamicObjectCollection entry = apply.getDynamicObjectCollection("entry");
            for (Object row : entry) {
                DynamicObjectCollection entrylk = row.getDynamicObjectCollection("entry_lk");
                if (ObjectUtils.isEmpty((Object)entrylk)) continue;
                Long billId = (Long)((DynamicObject)entrylk.get(0)).get("entry_lk_sbillid");
                if ("ap_finapbill".equals(sourceBillType)) {
                    finApBillIds.add(billId);
                    continue;
                }
                if (!"ar_finarbill".equals(sourceBillType)) continue;
                finArBillIds.add(billId);
            }
        }
        HashMap<Long, DynamicObject> finApRowMap = new HashMap<Long, DynamicObject>(64);
        HashMap<Long, DynamicObject> finArRowMap = new HashMap<Long, DynamicObject>(64);
        if (!finApBillIds.isEmpty()) {
            selector = "id,detailentry.corebillid,detailentry.corebillno,detailentry.corebilltype,detailentry.e_conbillentity,detailentry.e_conbillnumber,detailentry.e_conbillrownum,detailentry.e_conbillid,detailentry.e_conbillentryid,detailentry.e_contract,detailentry.project";
            filter = new QFilter("id", "in", finApBillIds);
            filter.and("detailentry.seq", "in", Arrays.asList(0, 1));
            DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)selector, (QFilter[])new QFilter[]{filter});
            for (DynamicObject finApBill : finApBills) {
                finApRowMap.putIfAbsent(finApBill.getLong("id"), finApBill);
            }
        }
        if (!finArBillIds.isEmpty()) {
            selector = "id,entry.e_corebilltype";
            filter = new QFilter("id", "in", finArBillIds);
            filter.and("entry.seq", "in", Arrays.asList(0, 1));
            DynamicObjectCollection finArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)selector, (QFilter[])new QFilter[]{filter});
            for (DynamicObject finArBill : finArBills) {
                finArRowMap.putIfAbsent(finArBill.getLong("id"), finArBill);
            }
        }
        for (DynamicObject applyBill : planSettleApplyBills) {
            String sourceBillType = applyBill.getString("sourcebilltype");
            DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
            boolean settingCoreBillNo = this.settingCorebillno(entry);
            for (DynamicObject applyRow : entry) {
                DynamicObjectCollection entryLK = applyRow.getDynamicObjectCollection("entry_lk");
                if (ObjectUtils.isEmpty((Object)entryLK)) continue;
                Long billId = (Long)((DynamicObject)entryLK.get(0)).get("entry_lk_sbillid");
                if ("ar_finarbill".equals(sourceBillType) && finArRowMap.get(billId) != null) {
                    DynamicObject finArRow = (DynamicObject)finArRowMap.get(billId);
                    applyRow.set("e_corebilltype", finArRow.get("entry.e_corebilltype"));
                    continue;
                }
                if (!"ap_finapbill".equals(sourceBillType) || finApRowMap.get(billId) == null) continue;
                DynamicObject finApRow = (DynamicObject)finApRowMap.get(billId);
                long coreBillId = finApRow.getLong("detailentry.corebillid");
                String coreBillNo = finApRow.getString("detailentry.corebillno");
                if (coreBillId != 0L || !ObjectUtils.isEmpty((Object)coreBillNo)) {
                    applyRow.set("e_corebilltype", (Object)finApRow.getString("detailentry.corebilltype"));
                    if (!settingCoreBillNo) {
                        applyRow.set("e_corebillid", (Object)coreBillId);
                        applyRow.set("e_corebillno", (Object)coreBillNo);
                    }
                }
                if (ObjectUtils.isEmpty((Object)applyRow.get("project"))) {
                    applyRow.set("project_id", finApRow.get("detailentry.project"));
                }
                if (ObjectUtils.isEmpty((Object)applyRow.get("e_contract"))) {
                    applyRow.set("e_contract", finApRow.get("detailentry.e_contract"));
                }
                if (ObjectUtils.isEmpty((Object)applyRow.get("e_conbillentity"))) {
                    applyRow.set("e_conbillentity_id", finApRow.get("detailentry.e_conbillentity"));
                }
                if (ObjectUtils.isEmpty((Object)applyRow.get("e_conbillnumber"))) {
                    applyRow.set("e_conbillnumber", finApRow.get("detailentry.e_conbillnumber"));
                }
                if (!ObjectUtils.isEmpty((Object)applyRow.get("e_conbillid"))) continue;
                applyRow.set("e_conbillid", finApRow.get("detailentry.e_conbillid"));
            }
        }
    }
}

