/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.botp.cv;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.fi.arapcommon.convert.InitConvertHelper;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.invoice.FillIssueInfoHelper;
import kd.fi.arapcommon.util.StringUtils;

public class InvoiceConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey("ap_invoice");
        HashMap<Long, List> billByOrgId = new HashMap<Long, List>(4);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            Long orgId = bill.getLong("org.id");
            if (ObjectUtils.isEmpty((Object)orgId)) {
                return;
            }
            List bills = billByOrgId.computeIfAbsent(orgId, a -> new ArrayList(64));
            bills.add(bill);
        }
        new InitConvertHelper("ap_init", this.getRule(), billByOrgId);
        FillIssueInfoHelper.fillInfo((boolean)true, (ExtendedDataEntity[])entitys);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject invoiceTypef7;
            String f7Number;
            String invoiceType;
            DynamicObject invoice = entity.getDataEntity();
            DynamicObject org = invoice.getDynamicObject("org");
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal localamt = BigDecimal.ZERO;
            BigDecimal tax = BigDecimal.ZERO;
            BigDecimal recamount = BigDecimal.ZERO;
            BigDecimal unrelatedamt = BigDecimal.ZERO;
            BigDecimal reclocalamt = BigDecimal.ZERO;
            BigDecimal exchangerate = invoice.getBigDecimal("exchangerate");
            String quotation = invoice.getString("quotation");
            if (exchangerate.compareTo(BigDecimal.ZERO) == 0 && "1".equals(quotation)) {
                quotation = "0";
            }
            int localprecision = invoice.getDynamicObject("basecurrency").getInt("amtprecision");
            DynamicObjectCollection entrys = invoice.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                BigDecimal localpricetaxtotal;
                BigDecimal localrowamt;
                BigDecimal rowamount = entry.getBigDecimal("e_amount");
                BigDecimal rowtax = entry.getBigDecimal("e_tax");
                BigDecimal pricetaxtotal = entry.getBigDecimal("e_pricetaxtotal");
                BigDecimal rowunrelatedamt = entry.getBigDecimal("e_unrelatedamt");
                if ("1".equals(quotation)) {
                    localrowamt = rowamount.divide(exchangerate, localprecision, RoundingMode.HALF_UP);
                    localpricetaxtotal = pricetaxtotal.divide(exchangerate, localprecision, RoundingMode.HALF_UP);
                    entry.set("e_amountbase", (Object)localrowamt);
                    entry.set("e_pricetaxtotalbase", (Object)localpricetaxtotal);
                } else {
                    localrowamt = rowamount.multiply(exchangerate).setScale(localprecision, RoundingMode.HALF_UP);
                    localpricetaxtotal = pricetaxtotal.multiply(exchangerate).setScale(localprecision, RoundingMode.HALF_UP);
                    entry.set("e_amountbase", (Object)localrowamt);
                    entry.set("e_pricetaxtotalbase", (Object)localpricetaxtotal);
                }
                String discountMode = entry.getString("discountmode");
                int precision = invoice.getInt("currency.amtprecision");
                BigDecimal quantity = entry.getBigDecimal("quantity");
                BigDecimal disCountRate = entry.getBigDecimal("discountrate");
                if ("TOTAL".equals(discountMode) && disCountRate.compareTo(BigDecimal.ZERO) != 0) {
                    Boolean isIncludetax = invoice.getBoolean("isincludetax");
                    BigDecimal taxRate = entry.getBigDecimal("taxrate");
                    if (isIncludetax.booleanValue()) {
                        entry.set("discountamt", (Object)disCountRate.multiply(quantity).setScale(precision, RoundingMode.HALF_UP));
                    } else {
                        entry.set("discountamt", (Object)disCountRate.multiply(quantity).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
                    }
                }
                amount = amount.add(rowamount);
                tax = tax.add(rowtax);
                recamount = recamount.add(pricetaxtotal);
                localamt = localamt.add(localrowamt);
                reclocalamt = reclocalamt.add(localpricetaxtotal);
                unrelatedamt = unrelatedamt.add(rowunrelatedamt);
            }
            invoice.set("amount", (Object)amount);
            invoice.set("amountbase", (Object)localamt);
            invoice.set("tax", (Object)tax);
            invoice.set("pricetaxtotal", (Object)recamount);
            invoice.set("pricetaxtotalbase", (Object)reclocalamt);
            invoice.set("unrelatedamt", (Object)unrelatedamt);
            invoice.set("unmatchamt", (Object)unrelatedamt);
            String firmName = org.getString("ffirmname");
            if (StringUtils.isEmpty((String)firmName)) {
                invoice.set("buyername", (Object)org.getLocaleString("name"));
            } else {
                invoice.set("buyername", (Object)firmName);
            }
            DynamicObject asstact = invoice.getDynamicObject("asstact");
            if (asstact != null) {
                invoice.set("asstactname", (Object)asstact.getString("name"));
            }
            if ("SP".equals(invoiceType = InvoiceType.getValue((String)(f7Number = (invoiceTypef7 = invoice.getDynamicObject("invoicetypef7")).getString("number")))) || "SE".equals(invoiceType) || "MAELETIC".equals(invoiceType)) {
                invoice.set("istaxdeduction", (Object)Boolean.TRUE);
            } else {
                invoice.set("istaxdeduction", (Object)Boolean.FALSE);
            }
            Date receivedate = invoice.getDate("receivedate");
            Date issuedate = invoice.getDate("issuedate");
            if (!ObjectUtils.isEmpty((Object)receivedate) && !receivedate.before(issuedate)) continue;
            invoice.set("receivedate", (Object)issuedate);
        }
    }
}

