/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.check;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.formplugin.check.FinApCheckSumAmtUtil;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.helper.BOTPHelper;

public class FinApPurQtyDataCheck
extends AbstractDataCheck {
    public String getEntityName() {
        return "im_purinbill";
    }

    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("billentry.id");
        selector.add("billentry.qty");
        selector.add("billentry.seq");
        return selector;
    }

    public QFilter getExtendQFilter() {
        return this.getBaseFilter();
    }

    public boolean isBatch() {
        return true;
    }

    public DataCheckResult dataCheck(DynamicObject bill) {
        return null;
    }

    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        ArrayList<DataCheckResult> results = new ArrayList<DataCheckResult>(billList.size());
        return this.dataCheckApBills(billList, results, "ap_busbill");
    }

    public List<DataCheckResult> dataCheckApBills(List<DynamicObject> billList, List<DataCheckResult> results, String billFormId) {
        Long entryId;
        billList.forEach(t -> {
            DataCheckResult result = new DataCheckResult();
            result.setSuccess(true);
            results.add(result);
        });
        ArrayList<Long> billIds = new ArrayList<Long>(10);
        DynamicObjectCollection allEntryColls = new DynamicObjectCollection();
        for (DynamicObject bill : billList) {
            DynamicObjectCollection entryColls = bill.getDynamicObjectCollection("billentry");
            allEntryColls.addAll((Collection)entryColls);
            billIds.add(bill.getLong("id"));
        }
        List<Long> allEntryIds = allEntryColls.stream().map(t -> t.getLong("id")).collect(Collectors.toList());
        Map targetRowIdsMap = BOTPHelper.loadTargetRowIdsMap((String)"im_purinbill", (String)"billentry", (Long[])allEntryIds.toArray(new Long[0]), (String)"ap_busbill");
        ArrayList allTarEntryIds = new ArrayList();
        for (Map.Entry it : targetRowIdsMap.entrySet()) {
            Set tarIds = (Set)it.getValue();
            if (tarIds == null) continue;
            allTarEntryIds.addAll(tarIds);
        }
        QFilter filter = new QFilter("entry.id", "in", allTarEntryIds);
        filter.and(new QFilter("id", "in", billIds));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection apBills = QueryServiceHelper.query((String)"ap_busbill", (String)"id,entry.seq,entry.e_quantity,entry.id", (QFilter[])filters);
        HashMap<Long, BigDecimal> compareMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry it : targetRowIdsMap.entrySet()) {
            Long sourEntryId = (Long)it.getKey();
            Set tarIds = (Set)it.getValue();
            ArrayList<DynamicObject> tarBills = new ArrayList<DynamicObject>();
            for (int i = 0; i < apBills.size(); ++i) {
                entryId = ((DynamicObject)apBills.get(i)).getLong("entry.id");
                if (!tarIds.contains(entryId)) continue;
                tarBills.add((DynamicObject)apBills.get(i));
            }
            if (tarBills == null || tarBills.size() <= 0) continue;
            BigDecimal allQty = FinApCheckSumAmtUtil.sumAmt(tarBills, "entry.e_quantity");
            compareMap.put(sourEntryId, allQty);
        }
        block4: for (int i = 0; i < billList.size(); ++i) {
            DynamicObject bill = billList.get(i);
            DataCheckResult result = results.get(i);
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntrys) {
                BigDecimal allQty;
                entryId = entry.getLong("id");
                BigDecimal qty = entry.getBigDecimal("qty");
                if (compareMap.get(entryId) == null || (allQty = (BigDecimal)compareMap.get(entryId)).compareTo(qty) <= 0) continue;
                result.setSuccess(false);
                String msg = String.format(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u4ed8\u7684\u6570\u91cf\u8d85\u8fc7\u5355\u636e\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u91c7\u8d2d\u5165\u5e93\u5355\u7b2c%2$s\u884c\u5206\u5f55\u7684\u6570\u91cf\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApPurQtyDataCheck_0", (String)"fi-ap-formplugin", (Object[])new Object[0]), bill.getString("billno"), entry.get("seq"));
                result.setErrorMessage(msg);
                continue block4;
            }
        }
        return results;
    }
}

