/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.formservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import kd.bos.entity.datamodel.IDataModel;
import kd.fi.arapcommon.util.EmptyUtils;

public class PremiumEditController {
    private IDataModel model;
    private boolean isNeedRecalculatePremiumAmount = true;
    private boolean isNeedRecalculatePremiumRate = true;

    public PremiumEditController(IDataModel model) {
        this.model = model;
    }

    public void amountChanged(BigDecimal amount) {
        if (amount.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal premiumAmount = (BigDecimal)this.model.getValue("premiumamt");
            if (EmptyUtils.isEmpty((Object)premiumAmount)) {
                BigDecimal premiumRate = (BigDecimal)this.model.getValue("premiumrate");
                this.model.setValue("premiumamt", (Object)amount.multiply(premiumRate.divide(new BigDecimal(100))));
            } else {
                DecimalFormat df = new DecimalFormat("#.00");
                BigDecimal premiumAmt = (BigDecimal)this.model.getValue("premiumamt");
                BigDecimal premiumRate = premiumAmt.multiply(new BigDecimal(100).divide(amount, 10, RoundingMode.HALF_UP));
                this.model.setValue("premiumrate", (Object)df.format(premiumRate));
            }
        } else {
            this.model.setValue("premiumamt", (Object)BigDecimal.ZERO);
            this.model.setValue("premiumrate", (Object)BigDecimal.ZERO);
        }
    }

    public void premiumAmountChanged(BigDecimal premiumAmount) {
        BigDecimal totalAmt;
        this.isNeedRecalculatePremiumAmount = false;
        if (this.isNeedRecalculatePremiumRate && (totalAmt = (BigDecimal)this.model.getValue("pricetaxtotal")).compareTo(BigDecimal.ZERO) != 0) {
            DecimalFormat df = new DecimalFormat("#.00");
            BigDecimal premiumRate = premiumAmount.multiply(new BigDecimal(100).divide(totalAmt, 10, RoundingMode.HALF_UP));
            this.model.setValue("premiumrate", (Object)df.format(premiumRate));
        }
    }

    public void premiumRateChanged(BigDecimal premiumRate) {
        this.isNeedRecalculatePremiumRate = false;
        if (this.isNeedRecalculatePremiumAmount) {
            BigDecimal amount = (BigDecimal)this.model.getValue("pricetaxtotal");
            this.model.setValue("premiumamt", (Object)amount.multiply(premiumRate.divide(new BigDecimal(100))));
        }
    }
}

