/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.formservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.consts.Constants;
import kd.fi.arapcommon.dev.beanfactory.Scope;
import kd.fi.arapcommon.dev.beanfactory.Service;
import kd.fi.arapcommon.helper.ArApTransferHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.EmptyUtils;

@KSObject
@Service(scope=Scope.Prototype)
public class TransferPayEditController {
    private DataSet queryFinBills(List<Object> pkIds, Map<String, Set<String>> extendFieldMap) {
        Set<String> headExtendFields = extendFieldMap.get("head");
        Set<String> detailExtendFields = extendFieldMap.get("detailentry");
        String selectorHead = "id,billno,bizdate,org,purorg,purchaser,purdept,asstacttype,asstact,payproperty,exratedate,exratetable,currency,basecurrency,exchangerate,amount,tax,pricetaxtotal";
        HashSet<String> needAddFields = new HashSet<String>(64);
        needAddFields.addAll(headExtendFields);
        needAddFields.addAll(detailExtendFields);
        if (!needAddFields.isEmpty()) {
            selectorHead = selectorHead + "," + String.join((CharSequence)",", needAddFields);
        }
        QFilter qFilter = new QFilter("id", "in", pkIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"TransferPayQueryfin", (String)"ap_finapbill", (String)(selectorHead + ",detailentry.unlockamt"), (QFilter[])new QFilter[]{qFilter}, (String)"id");
        dataSet = dataSet.groupBy(selectorHead.split(",")).sum("detailentry.unlockamt").finish();
        return dataSet;
    }

    private void fillModelCommon(IDataModel model, IFormView view, List<Row> srcBills, Map<String, Set<String>> extendFieldMap) {
        Row srcBill = srcBills.get(0);
        Long orgId = srcBill.getLong("org");
        InitHelper init = new InitHelper(orgId.longValue(), "ap_init");
        model.setValue("org", (Object)orgId);
        model.setValue("head_asstacttype", (Object)srcBill.getString("asstacttype"));
        HashSet<Date> dates = new HashSet<Date>(2);
        for (Row row : srcBills) {
            dates.add(row.getDate("exratedate"));
            if (dates.size() <= 1) continue;
            break;
        }
        if (dates.size() == 1) {
            model.setValue("exratedate", (Object)srcBill.getDate("exratedate"));
        } else {
            model.setValue("exratedate", (Object)new Date());
        }
        HashSet<Long> exratetableIds = new HashSet<Long>(2);
        for (Row fin : srcBills) {
            Long exratetableId = fin.getLong("exratetable");
            exratetableIds.add(exratetableId);
            if (exratetableIds.size() <= 1) continue;
            break;
        }
        if (exratetableIds.size() == 1) {
            model.setValue("exratetable", srcBill.get("exratetable"));
        } else {
            model.setValue("exratetable", (Object)init.getExrateTable());
        }
        Date date = ObjectUtils.isEmpty((Object)init.getCurrentDate()) ? init.getStartDate() : init.getCurrentDate();
        Date bizDate = new Date();
        if (date.after(bizDate)) {
            model.setValue("transdate", (Object)date);
            model.setValue("duedate", (Object)date);
        }
        DateEdit transDate = (DateEdit)view.getControl("transdate");
        transDate.setMinDate(date);
        long currencyId = srcBill.getLong("currency");
        long baseCurrencyId = srcBill.getLong("basecurrency");
        model.setValue("fincurrency", (Object)currencyId);
        model.setValue("basecurrency", (Object)baseCurrencyId);
        if (currencyId == baseCurrencyId) {
            view.setVisible(Boolean.FALSE, new String[]{"head_exchangerate", "translocalamount"});
            model.setValue("head_exchangerate", (Object)1);
            model.setValue("quotation", (Object)"0");
        } else {
            this.getExchangeRate(model, view);
        }
        int tagentry = model.getEntryRowCount("tagentry");
        Set<String> headExtendFields = extendFieldMap.get("head");
        Set<String> detailExtendFields = extendFieldMap.get("detailentry");
        if (tagentry == 1) {
            model.setValue("t_asstacttype", model.getValue("head_asstacttype"), 0);
            Set purorgs = srcBills.stream().map(e -> e.getLong("purorg")).collect(Collectors.toSet());
            Set purchasers = srcBills.stream().map(e -> e.getLong("purchaser")).collect(Collectors.toSet());
            if (purorgs.size() == 1) {
                model.setValue("purorg", (Object)srcBill.getLong("purorg"), 0);
                if (purchasers.size() == 1) {
                    model.setValue("purchaser", (Object)srcBill.getLong("purchaser"), 0);
                    model.setValue("purdept", (Object)srcBill.getLong("purdept"), 0);
                }
            }
            HashSet<Long> payPropertyIds = new HashSet<Long>(8);
            for (Row row : srcBills) {
                payPropertyIds.add(row.getLong("payproperty"));
            }
            if (payPropertyIds.size() == 1) {
                model.setValue("t_payproperty", (Object)srcBill.getLong("payproperty"), 0);
            }
            for (String detailExtendField : detailExtendFields) {
                HashSet<Object> sameValues = new HashSet<Object>(8);
                for (Row row : srcBills) {
                    sameValues.add(row.get(detailExtendField));
                }
                if (sameValues.size() != 1) continue;
                model.setValue(detailExtendField, srcBill.get(detailExtendField), 0);
            }
        }
        for (String headExtendField : headExtendFields) {
            HashSet<Object> sameValues = new HashSet<Object>(64);
            for (Row fin : srcBills) {
                sameValues.add(fin.get(headExtendField));
            }
            if (sameValues.size() != 1) continue;
            model.setValue(headExtendField, srcBill.get(headExtendField));
        }
    }

    public void fillModelBySameKey(IDataModel model, IFormView view) {
        Map extendFieldMap;
        Map customParams = view.getFormShowParameter().getCustomParams();
        List pkIds = (List)customParams.get("pkIds");
        DataSet dataSet = this.queryFinBills(pkIds, extendFieldMap = ArApTransferHelper.getTransferExtendFields((String)"ap_transferall"));
        if (dataSet.isEmpty()) {
            return;
        }
        ArrayList<Row> srcBills = new ArrayList<Row>(16);
        if (dataSet.hasNext()) {
            for (Row row : dataSet) {
                srcBills.add(row);
            }
        }
        this.fillModelCommon(model, view, srcBills, extendFieldMap);
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", pkIds.size());
        EntryGrid entry = (EntryGrid)view.getControl("entryentity");
        int index = 0;
        BigDecimal transferAmt = BigDecimal.ZERO;
        for (Row row : srcBills) {
            for (FieldEdit fieldEdit : entry.getFieldEdits()) {
                Object value;
                String key = fieldEdit.getKey();
                if ("cantransferamt".equals(key)) {
                    value = row.get("detailentry.unlockamt");
                    transferAmt = transferAmt.add((BigDecimal)value);
                } else {
                    value = row.get(key);
                }
                if (ObjectUtils.isEmpty((Object)value)) continue;
                model.setValue(key, value, index);
            }
            ++index;
        }
        model.setValue("transferamount", (Object)transferAmt);
    }

    @KSMethod
    public void fillModel(IDataModel model, IFormView view) {
        Date bizDate;
        Map customParams = view.getFormShowParameter().getCustomParams();
        List pkIds = (List)customParams.get("pkIds");
        Map extendFieldMap = ArApTransferHelper.getTransferExtendFields((String)"transferpaybill");
        QFilter qFilter = new QFilter("id", "in", (Object)pkIds);
        qFilter.and(new QFilter("detailentry.unlockamt", "!=", (Object)Constants.ZERO));
        DynamicObjectCollection finBills = QueryServiceHelper.query((String)"ap_finapbill", (String)this.getQueryMaterialFields(extendFieldMap, false), (QFilter[])new QFilter[]{qFilter}, (String)"billno,detailentry.seq");
        if (finBills.isEmpty()) {
            return;
        }
        Set purorgs = finBills.stream().map(e -> e.getLong("purorg")).collect(Collectors.toSet());
        Set purchasers = finBills.stream().map(e -> e.getLong("purchaser")).collect(Collectors.toSet());
        DynamicObject billObj = (DynamicObject)finBills.get(0);
        model.setValue("org", (Object)billObj.getLong("org"));
        if (purorgs.size() == 1) {
            model.setValue("purorg", (Object)billObj.getLong("purorg"));
            if (purchasers.size() == 1) {
                model.setValue("purchaser", (Object)billObj.getLong("purchaser"));
                model.setValue("purdept", (Object)billObj.getLong("purdept"));
            }
        }
        InitHelper init = new InitHelper(((Long)((DynamicObject)model.getValue("org")).getPkValue()).longValue(), "ap_init");
        HashSet<Date> dates = new HashSet<Date>(2);
        for (Object fin : finBills) {
            dates.add(fin.getDate("exratedate"));
            if (dates.size() <= 1) continue;
            break;
        }
        if (dates.size() == 1) {
            model.setValue("exratedate", (Object)billObj.getDate("exratedate"));
        } else {
            model.setValue("exratedate", (Object)new Date());
        }
        HashSet<Long> exratetableIds = new HashSet<Long>(2);
        for (DynamicObject fin : finBills) {
            Long exratetableId = fin.getLong("exratetable");
            exratetableIds.add(exratetableId);
            if (exratetableIds.size() <= 1) continue;
            break;
        }
        if (exratetableIds.size() == 1) {
            model.setValue("exratetable", billObj.get("exratetable"));
        } else {
            model.setValue("exratetable", (Object)init.getExrateTable());
        }
        Long currencyId = billObj.getLong("currency");
        model.setValue("fincurrency", (Object)currencyId);
        Long basecurrencyId = billObj.getLong("basecurrency");
        model.setValue("basecurrency", (Object)basecurrencyId);
        if (billObj.getLong("currency") == billObj.getLong("basecurrency")) {
            view.setVisible(Boolean.FALSE, new String[]{"head_exchangerate", "translocalamount"});
            model.setValue("head_exchangerate", (Object)1);
            model.setValue("quotation", (Object)"0");
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"head_exchangerate", "translocalamount"});
            view.setEnable(Boolean.TRUE, new String[]{"head_exchangerate"});
            this.getExchangeRate(model, view);
        }
        Date currentDate = init.getCurrentDate();
        if (ObjectUtils.isEmpty((Object)currentDate)) {
            currentDate = init.getStartDate();
        }
        if (currentDate.after(bizDate = new Date())) {
            model.setValue("transdate", (Object)currentDate);
            model.setValue("duedate", (Object)currentDate);
            model.setValue("exratedate", (Object)currentDate);
        }
        DateEdit transDate = (DateEdit)view.getControl("transdate");
        transDate.setMinDate(currentDate);
        Set headExtendFields = (Set)extendFieldMap.get("head");
        for (String headExtendField : headExtendFields) {
            HashSet<Object> sameValues = new HashSet<Object>(8);
            for (DynamicObject finBill : finBills) {
                sameValues.add(finBill.get(headExtendField));
            }
            if (sameValues.size() != 1) continue;
            model.setValue(headExtendField, ((DynamicObject)finBills.get(0)).get(headExtendField));
        }
        model.setValue("asstacttype", billObj.get("asstacttype"));
        QFilter planFilter = new QFilter("id", "in", (Object)pkIds);
        planFilter.and("planentity.unplanlockamt", "!=", (Object)BigDecimal.ZERO);
        DynamicObjectCollection finPlanRows = QueryServiceHelper.query((String)"ap_finapbill", (String)this.getQueryMaterialFields(extendFieldMap, true), (QFilter[])new QFilter[]{planFilter}, (String)"billno,planentity.seq");
        this.addTransDetailRow(model, finBills, extendFieldMap);
        this.addTransPlanRow(model, extendFieldMap, finPlanRows);
    }

    private void addTransDetailRow(IDataModel model, DynamicObjectCollection finBills, Map<String, Set<String>> extendFieldMap) {
        HashSet<Long> currencySet = new HashSet<Long>(2);
        HashSet<Object> billtypeSet = new HashSet<Object>(2);
        DynamicObject billObj = (DynamicObject)finBills.get(0);
        for (DynamicObject finBill : finBills) {
            int entryIndex = model.createNewEntryRow("entry") - 1;
            model.setValue("asstactname", (Object)finBill.getString("asstact.name"), entryIndex);
            model.setValue("billnumber", (Object)finBill.getString("billno"), entryIndex);
            model.setValue("bizdate", (Object)finBill.getDate("bizdate"), entryIndex);
            model.setValue("transqty", (Object)finBill.getBigDecimal("detailentry.quantity"), entryIndex);
            currencySet.add(finBill.getLong("currency"));
            billtypeSet.add(finBill.get("billtypeid.id"));
            model.setValue("entrycurrency", (Object)finBill.getLong("currency"), entryIndex);
            DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)finBill.getLong("currency"), (String)"bd_currency", (String)"id,amtprecision,priceprecision");
            int precision = 2;
            if (currency != null) {
                precision = currency.getInt("amtprecision");
            }
            model.setValue("exchangerate", (Object)finBill.getBigDecimal("exchangerate"), entryIndex);
            model.setValue("material", (Object)finBill.getLong("detailentry.material"), entryIndex);
            model.setValue("expenseitem", (Object)finBill.getLong("detailentry.expenseitem"), entryIndex);
            model.setValue("spectype", (Object)finBill.getString("detailentry.spectype"), entryIndex);
            model.setValue("e_assistantattr", finBill.get("detailentry.e_assistantattr"), entryIndex);
            BigDecimal unlockamt = finBill.getBigDecimal("detailentry.unlockamt");
            BigDecimal taxrate = finBill.getBigDecimal("detailentry.taxrate").divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP);
            model.setValue("e_pricetaxtotal", (Object)finBill.getBigDecimal("detailentry.e_pricetaxtotal"), entryIndex);
            model.setValue("unsettleamt", (Object)unlockamt, entryIndex);
            BigDecimal eTax = unlockamt.multiply(taxrate).divide(BigDecimal.valueOf(1L).add(taxrate), 10, RoundingMode.HALF_UP).setScale(precision, RoundingMode.HALF_UP);
            model.setValue("transtax", (Object)eTax, entryIndex);
            model.setValue("transamount", (Object)unlockamt.subtract(eTax), entryIndex);
            model.setValue("transpricetaxtotal", (Object)unlockamt, entryIndex);
            BigDecimal exchangeRate = (BigDecimal)model.getValue("head_exchangerate");
            String quotation = (String)model.getValue("quotation");
            BigDecimal translocalamount = BigDecimal.ZERO;
            if (!EmptyUtils.isEmpty((Object)exchangeRate)) {
                translocalamount = "1".equals(quotation) ? unlockamt.divide(exchangeRate, precision, RoundingMode.HALF_UP) : unlockamt.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
            }
            model.setValue("translocalamount", (Object)translocalamount, entryIndex);
            model.setValue("measureunit", (Object)finBill.getLong("detailentry.measureunit"), entryIndex);
            model.setValue("taxrateid", (Object)finBill.getLong("detailentry.taxrateid"), entryIndex);
            model.setValue("finbillid", finBill.get("id"), entryIndex);
            model.setValue("finentryid", finBill.get("detailentry.id"), entryIndex);
            model.setValue("e_splitdimensionid", finBill.get("detailentry.e_splitdimensionid"), entryIndex);
            Set<String> materialExtendFields = extendFieldMap.get("detailentry");
            for (String materialExtendField : materialExtendFields) {
                model.setValue(materialExtendField, finBill.get("detailentry." + materialExtendField), entryIndex);
            }
        }
        int count = model.getEntryRowCount("entry");
        model.deleteEntryRow("entry", count - 1);
        if (currencySet.size() < 2) {
            model.setValue("isdfcurrency", (Object)Boolean.FALSE);
            model.setValue("fincurrency", (Object)billObj.getLong("currency"));
        } else {
            model.setValue("isdfcurrency", (Object)Boolean.TRUE);
        }
        if (billtypeSet.size() > 1) {
            model.setValue("isdfcurrency", (Object)Boolean.TRUE);
        }
    }

    private void addTransPlanRow(IDataModel model, Map<String, Set<String>> extendFieldMap, DynamicObjectCollection finPlanRows) {
        if (ObjectUtils.isEmpty((Object)finPlanRows)) {
            return;
        }
        model.getEntryEntity("planentry").clear();
        for (DynamicObject finPlanRow : finPlanRows) {
            int index = model.createNewEntryRow("planentry");
            model.setValue("p_billno", finPlanRow.get("billno"), index);
            model.setValue("p_billid", finPlanRow.get("id"), index);
            model.setValue("p_entryid", finPlanRow.get("planentity.id"), index);
            model.setValue("p_transpricetaxtotal", finPlanRow.get("planentity.unplanlockamt"), index);
            model.setValue("planpricetax", finPlanRow.get("planentity.planpricetax"), index);
            model.setValue("p_splitdimensionid", finPlanRow.get("planentity.p_splitdimensionid"), index);
            model.setValue("p_payrate", finPlanRow.get("planentity.p_payrate"), index);
            Set<String> planExtendFields = extendFieldMap.get("planentity");
            for (String planExtendField : planExtendFields) {
                model.setValue(planExtendField, finPlanRow.get("planentity." + planExtendField), index);
            }
        }
    }

    public void getExchangeRate(IDataModel model, IFormView view) {
        DynamicObject srcCurrency = (DynamicObject)model.getValue("fincurrency");
        DynamicObject destCurrency = (DynamicObject)model.getValue("basecurrency");
        DynamicObject exrateTable = (DynamicObject)model.getValue("exratetable");
        long srcCurrencyId = srcCurrency.getLong("id");
        long destCurrencyId = destCurrency.getLong("id");
        long exrateTableId = exrateTable.getLong("id");
        Date exrateDate = (Date)model.getValue("exratedate");
        Map exrateMap = BaseDataHelper.getExchangeRateMap((Long)exrateTableId, (Long)srcCurrencyId, (Long)destCurrencyId, (Date)exrateDate);
        if (exrateMap != null) {
            boolean quoteType = (Boolean)exrateMap.get("quoteType");
            String quotation = quoteType ? "1" : "0";
            model.setValue("quotation", (Object)quotation);
            Object exchangeRate = exrateMap.get("exchangeRate");
            if (EmptyUtils.isEmpty(exchangeRate)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8be5\u7ed3\u7b97\u5e01\u7684\u201c\u6c47\u7387\u201d\u3002", (String)"TransferEditController_0", (String)"fi-ar-formplugin", (Object[])new Object[0]));
                return;
            }
            model.setValue("head_exchangerate", (Object)((BigDecimal)exchangeRate));
        }
    }

    private String getQueryMaterialFields(Map<String, Set<String>> extendFieldMap, boolean isPlan) {
        HashSet<String> selectors = new HashSet<String>(64);
        selectors.add("splitscheme");
        selectors.add("duedate");
        selectors.add("bizdate");
        selectors.add("exchangerate");
        selectors.add("exratedate");
        selectors.add("exratetable");
        selectors.add("basecurrency");
        selectors.add("currency");
        selectors.add("asstacttype");
        selectors.add("asstact.name");
        selectors.add("id");
        selectors.add("billno");
        selectors.add("org");
        selectors.add("purorg");
        selectors.add("purchaser");
        selectors.add("purdept");
        selectors.addAll((Collection)extendFieldMap.get("head"));
        if (isPlan) {
            selectors.add("planentity.id");
            Set<String> planExtendFields = extendFieldMap.get("planentity");
            for (String planExtendField : planExtendFields) {
                selectors.add("planentity." + planExtendField);
            }
            selectors.add("planentity.p_splitdimensionid");
            selectors.add("planentity.p_payrate");
        } else {
            selectors.add("detailentry.id");
            selectors.add("detailentry.spectype");
            selectors.add("detailentry.unlockamt");
            selectors.add("detailentry.material");
            selectors.add("detailentry.e_assistantattr");
            selectors.add("detailentry.expenseitem");
            selectors.add("detailentry.quantity");
            selectors.add("detailentry.measureunit");
            selectors.add("detailentry.taxrate");
            selectors.add("detailentry.taxrateid");
            selectors.add("detailentry.e_pricetaxtotal");
            Set<String> materialExtendFields = extendFieldMap.get("detailentry");
            for (String materialExtendField : materialExtendFields) {
                selectors.add("detailentry." + materialExtendField);
            }
            selectors.add("detailentry.e_splitdimensionid");
        }
        return String.join((CharSequence)",", selectors);
    }
}

