/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.formservice.bus;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.enums.DiscountModeEnum;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.QuotationHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.impt.AbstractBillImport;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.MaterialRow;

public class BusApBillImportHelper
extends AbstractBillImport {
    private final List<String> headFields = this.headRemoveFields();
    private final List<String> entryFields = this.entryRemoveFields();
    private final List<String> allocationEntryFields = this.allocationEntryRemoveFields();
    private final List<String> headUpdFields = this.headRemoveUpFields();
    private final List<String> entryUpdFields = this.entryRemoveUpFields();
    private final List<String> allocationEntryUpdFields = this.allocationEntryUpdRemoveFields();
    private Map<String, BigDecimal> convertRateMap = new HashMap<String, BigDecimal>(8);
    private static Log logger = LogFactory.getLog(BusApBillImportHelper.class);
    private QuotationHelper quotationHelper;

    public BusApBillImportHelper(IDataModel model, IPageCache pageCache) {
        this.model = model;
        this.pageCache = pageCache;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        String url = RequestContext.get().getClientUrl();
        if (!ObjectUtils.isEmpty((Object)url) && url.contains("appendentryrows")) {
            return;
        }
        Map sourceData = e.getSourceData();
        boolean isNew = false;
        String importType = (String)e.getOption().get("importtype");
        if ("overridenew".equals(importType) || importType == null) {
            isNew = ObjectUtils.isEmpty(sourceData.get("_pkid_"));
        } else if ("new".equals(importType)) {
            isNew = true;
        }
        boolean includeTax = sourceData.containsKey("isincludetax") ? ((Boolean)sourceData.get("isincludetax")).booleanValue() : ((Boolean)this.model.getValue("isincludetax")).booleanValue();
        boolean ispricetotal = sourceData.containsKey("ispricetotal") ? ((Boolean)sourceData.get("ispricetotal")).booleanValue() : ((Boolean)this.model.getValue("ispricetotal")).booleanValue();
        if (!isNew && !EmptyUtils.isEmpty(sourceData.get("sourcebillid"))) {
            this.removeNoAssignField(sourceData, this.headUpdFields);
        } else {
            this.checkNull("currency", ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01", (String)"BusApBillImportHelper_12", (String)"fi-ap-formplugin", (Object[])new Object[0]), sourceData);
            this.removeNoAssignField(sourceData, this.headFields);
        }
        this.removeNoAssignField(sourceData, new String[]{"planentity"});
        List entryList = null;
        if (sourceData.get("entry") != null) {
            entryList = (List)sourceData.get("entry");
        }
        if (entryList != null) {
            for (int i = 0; i < entryList.size(); ++i) {
                boolean ispresent;
                Map entry = (Map)entryList.get(i);
                this.checkDeducRate(entry, i);
                boolean bl = ispresent = entry.get("e_ispresent") != null ? (Boolean)entry.get("e_ispresent") : false;
                if (!isNew && !EmptyUtils.isEmpty(sourceData.get("sourcebillid"))) {
                    this.removeNoAssignField(entry, this.entryUpdFields);
                } else {
                    this.removeNoAssignField(entry, this.entryFields);
                }
                this.checkPriceandAmount(ispresent, includeTax, ispricetotal, entry, i);
                this.removeNoAssignField(entry, new String[]{"subentryentity"});
                this.checkDiscountMode(includeTax, entry, i);
            }
        }
        List allocationentryList = null;
        if (sourceData.get("allocationentry") != null) {
            allocationentryList = (List)sourceData.get("allocationentry");
        }
        if (allocationentryList != null) {
            for (int i = 0; i < allocationentryList.size(); ++i) {
                Map allocationEntry = (Map)allocationentryList.get(i);
                if (!isNew && !EmptyUtils.isEmpty(sourceData.get("sourcebillid"))) {
                    this.removeNoAssignField(allocationEntry, this.allocationEntryUpdFields);
                    continue;
                }
                this.removeNoAssignField(allocationEntry, this.allocationEntryFields);
            }
        }
        if (!isNew && !EmptyUtils.isEmpty(sourceData.get("sourcebillid"))) {
            this.removeNoAssignField(sourceData, new String[]{"isincludetax"});
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject org;
        super.afterImportData(e);
        Map sourceData = e.getSourceData();
        String url = RequestContext.get().getClientUrl();
        if (!ObjectUtils.isEmpty((Object)url) && url.contains("appendentryrows")) {
            return;
        }
        Map opMap = e.getOption();
        String type = (String)opMap.get("importtype");
        if (BillSrcTypeEnum.MANUAL.getValue().equals(this.model.getValue("billsrctype"))) {
            this.model.setValue("billsrctype", (Object)BillSrcTypeEnum.IMPORT.getValue());
        }
        if (ObjectUtils.isEmpty((Object)(org = (DynamicObject)this.model.getValue("org")))) {
            return;
        }
        Long orgPk = (Long)org.getPkValue();
        this.init = (InitHelper)this.initMap.get(orgPk);
        if (ObjectUtils.isEmpty((Object)this.init)) {
            this.init = new InitHelper(orgPk.longValue(), "ap_init");
            this.initMap.put(orgPk, this.init);
        }
        if (ObjectUtils.isEmpty((Object)this.init.getInit())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u201c%s\u201d\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"BusApBillImportHelper_0", (String)"fi-ap-formplugin", (Object[])new Object[0]), org.getString("name")));
        }
        this.init.checkInit();
        BookDateHelper.checkBookDate((IDataModel)this.model, (boolean)false, (Map)this.cacheDateMap, (InitHelper)this.init);
        DynamicObject currency = (DynamicObject)this.model.getValue("currency");
        if (ObjectUtils.isEmpty((Object)currency)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusApBillImportHelper_13", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        this.costsAndPrePaidNotBothTrue();
        this.createByInit();
        this.setCalculatorAmt(this.model, type, sourceData);
    }

    private QuotationHelper getQuotationHelper() {
        if (this.quotationHelper == null) {
            this.quotationHelper = new QuotationHelper();
        }
        return this.quotationHelper;
    }

    private void setCalculatorAmt(IDataModel m, String type, Map<String, Object> sourceData) {
        boolean isWebAPI;
        int count = m.getEntryEntity("entry").size();
        BigDecimal recamount = BigDecimal.ZERO;
        BigDecimal reclocalamt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localamt = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxlocamt = BigDecimal.ZERO;
        BigDecimal invoicedamt = BigDecimal.ZERO;
        BigDecimal invoicedlocamt = BigDecimal.ZERO;
        BigDecimal uninvoicedamt = BigDecimal.ZERO;
        BigDecimal uninvoicedlocamt = BigDecimal.ZERO;
        BigDecimal unwoffamt = BigDecimal.ZERO;
        BigDecimal unwofflocamt = BigDecimal.ZERO;
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        boolean ispricetotal = (Boolean)m.getValue("ispricetotal");
        DynamicObject currency = (DynamicObject)m.getValue("currency");
        int precision = currency.getInt("amtprecision");
        int localprecision = this.getLocalPrecision();
        String quotation = (String)m.getValue("quotation");
        BigDecimal rate = (BigDecimal)m.getValue("exchangerate");
        if ("1".equals(quotation) && rate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        HashMap<String, MaterialRow> rowMap = new HashMap<String, MaterialRow>(8);
        for (int i = 0; i < count; ++i) {
            DynamicObject taxrateid;
            Boolean isPresent;
            DynamicObject material = (DynamicObject)m.getValue("e_material", i);
            if (!ObjectUtils.isEmpty((Object)material)) {
                BigDecimal deRate;
                m.setValue("e_spectype", (Object)material.getString("modelnum"), i);
                BigDecimal decRate = (BigDecimal)m.getValue("deductiblerate", i);
                boolean isFarm = (Boolean)m.getValue("e_farmproducts", i);
                boolean farmProducts = material.getBoolean("farmproducts");
                if (!isFarm && decRate.compareTo(BigDecimal.ZERO) == 0) {
                    deRate = farmProducts ? material.getBigDecimal("deductiblerate") : (BigDecimal)m.getValue("e_taxrate", i);
                    m.setValue("deductiblerate", (Object)deRate, i);
                    m.setValue("e_farmproducts", (Object)farmProducts, i);
                } else if (!isFarm && decRate.compareTo(BigDecimal.ZERO) != 0) {
                    m.setValue("e_farmproducts", (Object)farmProducts, i);
                } else if (isFarm && decRate.compareTo(BigDecimal.ZERO) == 0) {
                    deRate = farmProducts ? material.getBigDecimal("deductiblerate") : (BigDecimal)m.getValue("e_taxrate", i);
                    m.setValue("deductiblerate", (Object)deRate, i);
                }
                DynamicObject baseunit = material.getDynamicObject("baseunit");
                if (baseunit != null) {
                    Object baseunitPk = baseunit.getPkValue();
                    m.setValue("e_baseunit", baseunitPk, i);
                    if (ObjectUtils.isEmpty((Object)m.getValue("e_measureunit", i))) {
                        m.setValue("e_measureunit", baseunitPk, i);
                    }
                } else {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%s\u7269\u6599\u7684\u57fa\u672c\u5355\u4f4d\u3002", (String)"BusApBillImportHelper_10", (String)"fi-ap-formplugin", (Object[])new Object[0]), material.getString("name")));
                }
                DynamicObject measureUnit = (DynamicObject)m.getValue("e_measureunit", i);
                long materialID = (Long)material.getPkValue();
                long measureUnitID = (Long)measureUnit.getPkValue();
                String key = materialID + "-" + measureUnitID;
                MaterialRow row = null;
                if (!rowMap.containsKey(key)) {
                    row = this.buildMaterialRow(material, baseunit, measureUnitID);
                    rowMap.put(key, row);
                } else {
                    row = (MaterialRow)rowMap.get(key);
                }
                this.setMaterialRow(m, row, i);
                BigDecimal quantity = (BigDecimal)m.getValue("e_quantity", i);
                m.setValue("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)row.getUnitCoefficient(), (DynamicObject)baseunit), i);
                if (ObjectUtils.isEmpty((Object)m.getValue("taxrateid", i)) && material.getDynamicObject("taxrate") != null) {
                    Object taxrateId = material.getDynamicObject("taxrate").getPkValue();
                    m.setValue("taxrateid", taxrateId, i);
                }
            }
            if ((isPresent = (Boolean)this.model.getValue("e_ispresent", i)).booleanValue()) {
                BigDecimal rice = (BigDecimal)m.getValue("e_unitprice", i);
                BigDecimal priceTax = (BigDecimal)m.getValue("e_taxunitprice", i);
                if (BigDecimal.ZERO.compareTo(rice) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0) {
                    m.setValue("e_discountmode", (Object)"PERCENT", i);
                    m.setValue("e_discountrate", (Object)new BigDecimal(100), i);
                } else {
                    m.setValue("e_discountmode", (Object)"NULL", i);
                    m.setValue("e_discountrate", (Object)BigDecimal.ZERO, i);
                }
            }
            if (!ObjectUtils.isEmpty((Object)(taxrateid = (DynamicObject)m.getValue("taxrateid", i))) && EmptyUtils.isEmpty((Object)m.getValue("e_taxrate", i))) {
                m.setValue("e_taxrate", (Object)taxrateid.getBigDecimal("taxrate"), i);
            }
            Object disCountType = m.getValue("e_discountmode", i);
            BigDecimal disCountAmt = (BigDecimal)m.getValue("e_discountamount", i);
            BigDecimal qty = (BigDecimal)m.getValue("e_quantity", i);
            int pricePrecision = 4;
            if (DiscountModeEnum.NULL.getValue().equals(m.getValue("e_discountmode", i)) || DiscountModeEnum.TOTAL.getValue().equals(disCountType) && disCountAmt.compareTo(BigDecimal.ZERO) == 0) {
                m.setValue("e_discountrate", (Object)BigDecimal.ZERO, i);
            } else if (DiscountModeEnum.TOTAL.getValue().equals(disCountType) && disCountAmt.compareTo(BigDecimal.ZERO) != 0) {
                pricePrecision = currency.getInt("priceprecision");
                BigDecimal taxRate = (BigDecimal)m.getValue("e_taxrate", i);
                taxRate = taxRate.divide(BigDecimal.valueOf(100L));
                BigDecimal discountRate = includeTax ? disCountAmt.divide(qty, pricePrecision, RoundingMode.HALF_UP) : disCountAmt.divide(qty, 10, RoundingMode.HALF_UP).divide(BigDecimal.ONE.add(taxRate), pricePrecision, RoundingMode.HALF_UP);
                m.setValue("e_discountrate", (Object)discountRate, i);
            }
            if (ispricetotal && isPresent.booleanValue()) {
                this.resetEntryPropForPresent(m, includeTax, rate, precision, localprecision, i, quotation);
            } else {
                this.calculatorEntryAmt(m, includeTax, ispricetotal, rate, precision, localprecision, i, quotation);
            }
            recamount = recamount.add((BigDecimal)m.getValue("e_pricetaxtotal", i));
            reclocalamt = reclocalamt.add((BigDecimal)m.getValue("e_pricetaxtotalbase", i));
            amount = amount.add((BigDecimal)m.getValue("e_amount", i));
            localamt = localamt.add((BigDecimal)m.getValue("e_localamt", i));
            tax = tax.add((BigDecimal)m.getValue("e_tax", i));
            taxlocamt = taxlocamt.add((BigDecimal)m.getValue("e_taxlocalamt", i));
            invoicedamt = invoicedamt.add((BigDecimal)m.getValue("e_invoicedamt", i));
            invoicedlocamt = invoicedlocamt.add((BigDecimal)m.getValue("e_invoicedlocamt", i));
            uninvoicedamt = uninvoicedamt.add((BigDecimal)m.getValue("e_uninvoicedamt", i));
            uninvoicedlocamt = uninvoicedlocamt.add((BigDecimal)m.getValue("e_uninvoicedlocamt", i));
            unwoffamt = unwoffamt.add((BigDecimal)m.getValue("e_unwoffamt", i));
            unwofflocamt = unwofflocamt.add((BigDecimal)m.getValue("e_unwofflocamt", i));
        }
        m.setValue("pricetaxtotal", (Object)recamount);
        m.setValue("pricetaxtotalbase", (Object)reclocalamt);
        m.setValue("amount", (Object)amount);
        m.setValue("localamt", (Object)localamt);
        m.setValue("tax", (Object)tax);
        m.setValue("taxlocamt", (Object)taxlocamt);
        m.setValue("invoicedamt", (Object)invoicedamt);
        m.setValue("invoicedlocamt", (Object)invoicedlocamt);
        m.setValue("uninvoicedamt", (Object)uninvoicedamt);
        m.setValue("uninvoicedlocamt", (Object)uninvoicedlocamt);
        m.setValue("unwoffamt", (Object)unwoffamt);
        m.setValue("unwofflocamt", (Object)unwofflocamt);
        m.setValue("unwoffnotaxamt", (Object)amount);
        m.setValue("unwoffnotaxlocamt", (Object)localamt);
        m.setValue("unwofftax", (Object)tax);
        m.setValue("unwofftaxlocal", (Object)taxlocamt);
        boolean bl = isWebAPI = type == null;
        if (!isWebAPI) {
            JSONArray allocationEntry = (JSONArray)sourceData.get("allocationentry");
            if (((Boolean)m.getValue("isexpensealloc")).booleanValue() && EmptyUtils.isNotEmpty((Object)allocationEntry) && amount.compareTo(BigDecimal.ZERO) != 0) {
                logger.info("\u6682\u4f30\u5e94\u4ed8\u5f15\u5165\u6821\u9a8c,\u8d39\u7528\u5206\u644a");
                for (int i = 0; i < allocationEntry.size(); ++i) {
                    BigDecimal alocalamt;
                    JSONObject row = (JSONObject)allocationEntry.get(i);
                    BigDecimal allocationper = (BigDecimal)m.getValue("a_allocationper", i);
                    BigDecimal allocationamt = (BigDecimal)m.getValue("a_allocationamt", i);
                    logger.info(String.format("\u6682\u4f30\u5e94\u4ed8\u5f15\u5165\u6821\u9a8c,\u8d39\u7528\u5206\u644a,\u6bd4\u4f8b%s,\u91d1\u989d%s", allocationper, allocationamt));
                    if (row.get((Object)"a_allocationper") == null) {
                        String key = allocationper.toPlainString();
                        if (key.contains(".")) {
                            int cont = key.length() - key.indexOf(46) - 1;
                            allocationper = allocationamt.divide(amount, cont + 2, 4);
                        } else {
                            allocationper = allocationamt.divide(amount, 4);
                        }
                        allocationamt = amount.multiply(allocationper);
                        alocalamt = localamt.multiply(allocationper);
                        allocationper = allocationper.multiply(new BigDecimal(100));
                        m.setValue("a_allocationper", (Object)allocationper, i);
                        m.setValue("a_allocationamt", (Object)allocationamt, i);
                        m.setValue("a_localamt", (Object)alocalamt, i);
                        continue;
                    }
                    allocationamt = amount.multiply(allocationper.divide(new BigDecimal(100)));
                    alocalamt = localamt.multiply(allocationper.divide(new BigDecimal(100)));
                    m.setValue("a_allocationamt", (Object)allocationamt, i);
                    m.setValue("a_localamt", (Object)alocalamt, i);
                }
            }
        }
    }

    private void resetEntryPropForPresent(IDataModel m, boolean includeTax, BigDecimal rate, int precision, int localprecision, int i, String quotation) {
        BigDecimal price;
        BigDecimal quantity = (BigDecimal)m.getValue("e_quantity", i);
        m.setValue("e_uninvoicedqty", (Object)quantity, i);
        m.setValue("e_unwoffqty", (Object)quantity, i);
        if (includeTax) {
            price = (BigDecimal)m.getValue("e_taxunitprice", i);
            m.setValue("e_unitprice", (Object)price, i);
        } else {
            price = (BigDecimal)m.getValue("e_unitprice", i);
            m.setValue("e_taxunitprice", (Object)price, i);
        }
        m.setValue("e_actunitprice", (Object)price, i);
        m.setValue("e_acttaxunitprice", (Object)price, i);
        m.setValue("e_amount", (Object)BigDecimal.ZERO, i);
        m.setValue("e_localamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_tax", (Object)BigDecimal.ZERO, i);
        m.setValue("e_taxlocalamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_pricetaxtotal", (Object)BigDecimal.ZERO, i);
        m.setValue("e_pricetaxtotalbase", (Object)BigDecimal.ZERO, i);
        m.setValue("e_uninvoicedamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_uninvoicedlocamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unwoffamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unwofflocamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unwoffnotaxamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unwoffnotaxlocamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unwofftax", (Object)BigDecimal.ZERO, i);
        m.setValue("e_unwofftaxlocal", (Object)BigDecimal.ZERO, i);
        m.setValue("e_uninvnotaxamt", (Object)BigDecimal.ZERO, i);
        m.setValue("e_uninvnotaxlocalamt", (Object)BigDecimal.ZERO, i);
        BigDecimal discountAmout = price.multiply(quantity).setScale(precision, RoundingMode.HALF_UP);
        BigDecimal discountLocalAmt = "0".equals(quotation) ? discountAmout.multiply(rate).setScale(localprecision, RoundingMode.HALF_UP) : discountAmout.divide(rate, localprecision, RoundingMode.HALF_UP);
        m.setValue("e_discountamount", (Object)discountAmout, i);
        m.setValue("e_discountlocalamt", (Object)discountLocalAmt, i);
    }

    private MaterialRow buildMaterialRow(DynamicObject material, DynamicObject baseunit, long measureUnitID) {
        MaterialRow row = new MaterialRow();
        row.setMaterialPk(((Long)material.getPkValue()).longValue());
        row.setSpecType(material.getString("modelnum"));
        row.setBaseUnitPk(baseunit != null ? (Long)baseunit.getPkValue() : measureUnitID);
        row.setMeasureUnitPk(measureUnitID);
        BigDecimal convertRate = this.getConvertRate(row.getMaterialPk(), row.getMeasureUnitPk(), row.getBaseUnitPk());
        row.setUnitCoefficient(convertRate != null ? convertRate : BigDecimal.ONE);
        DynamicObject taxrate = material.getDynamicObject("taxrate");
        if (!ObjectUtils.isEmpty((Object)taxrate)) {
            row.setTaxRatePk(((Long)taxrate.getPkValue()).longValue());
        }
        return row;
    }

    protected void calculatorEntryAmt(IDataModel m, boolean includeTax, boolean isPriceTotal, BigDecimal rate, int precision, int localprecision, int index, String quotation) {
        BigDecimal qty = (BigDecimal)m.getValue("e_quantity", index);
        BigDecimal taxRate = (BigDecimal)m.getValue("e_taxrate", index);
        String discountMode = (String)m.getValue("e_discountmode", index);
        BigDecimal discountRate = (BigDecimal)m.getValue("e_discountrate", index);
        BigDecimal discountAmt = (BigDecimal)m.getValue("e_discountamount", index);
        TaxUnitPriceCalculator calculator = null;
        if (includeTax && !isPriceTotal) {
            BigDecimal taxUnitPrice = (BigDecimal)m.getValue("e_taxunitprice", index);
            calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        } else if (!includeTax && !isPriceTotal) {
            BigDecimal unitPrice = (BigDecimal)m.getValue("e_unitprice", index);
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        } else if (!includeTax && isPriceTotal) {
            BigDecimal amount = (BigDecimal)m.getValue("e_amount", index);
            calculator = new PriceTotalCalculator(qty, amount, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        } else if (includeTax && isPriceTotal) {
            BigDecimal priceTaxTotal = (BigDecimal)m.getValue("e_pricetaxtotal", index);
            calculator = new PriceTaxTotalCalculator(qty, priceTaxTotal, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator(calculator, rate, localprecision, quotation);
        localCalculator.calculate();
        this.resetEntryProp(m, localCalculator, index);
    }

    private void resetEntryProp(IDataModel m, PriceLocalCalculator localCalculator, int index) {
        m.setValue("e_unitprice", (Object)localCalculator.getUnitprice(), index);
        m.setValue("e_taxunitprice", (Object)localCalculator.getTaxunitprice(), index);
        m.setValue("e_actunitprice", (Object)localCalculator.getActunitprice(), index);
        m.setValue("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice(), index);
        BigDecimal amount = localCalculator.getAmount();
        m.setValue("e_amount", (Object)amount, index);
        m.setValue("e_localamt", (Object)localCalculator.getAmountlocal(), index);
        m.setValue("e_tax", (Object)localCalculator.getTax(), index);
        m.setValue("e_taxlocalamt", (Object)localCalculator.getTaxlocal(), index);
        m.setValue("e_discountamount", (Object)localCalculator.getDiscountamount(), index);
        m.setValue("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal(), index);
        BigDecimal recamount = localCalculator.getPricetaxtotal();
        m.setValue("e_pricetaxtotal", (Object)recamount, index);
        BigDecimal reclocalamt = localCalculator.getPricetaxtotallocal();
        m.setValue("e_pricetaxtotalbase", (Object)reclocalamt, index);
        m.setValue("e_uninvoicedamt", (Object)recamount, index);
        m.setValue("e_uninvoicedqty", m.getValue("e_quantity", index), index);
        m.setValue("e_uninvoicedlocamt", (Object)reclocalamt, index);
        m.setValue("e_unwoffqty", m.getValue("e_quantity", index), index);
        m.setValue("e_unwoffamt", (Object)recamount, index);
        m.setValue("e_unwofflocamt", (Object)reclocalamt, index);
        m.setValue("e_unwoffnotaxamt", (Object)amount, index);
        m.setValue("e_unwoffnotaxlocamt", (Object)localCalculator.getAmountlocal(), index);
        m.setValue("e_unwofftax", (Object)localCalculator.getTax(), index);
        m.setValue("e_unwofftaxlocal", (Object)localCalculator.getTaxlocal(), index);
        m.setValue("e_uninvnotaxamt", (Object)amount, index);
        m.setValue("e_uninvnotaxlocalamt", (Object)localCalculator.getAmountlocal(), index);
    }

    private void setMaterialRow(IDataModel m, MaterialRow row, int iRow) {
        m.setValue("e_spectype", (Object)row.getSpecType(), iRow);
        m.setValue("e_baseunit", (Object)row.getBaseUnitPk(), iRow);
        m.setValue("e_measureunit", (Object)row.getMeasureUnitPk(), iRow);
        m.setValue("e_unitcoefficient", (Object)row.getUnitCoefficient(), iRow);
        if (EmptyUtils.isNotEmpty((Object)row.getTaxRatePk()) && EmptyUtils.isEmpty((Object)m.getValue("taxrateid", iRow))) {
            m.setValue("taxrateid", (Object)row.getTaxRatePk(), iRow);
        }
    }

    protected int getLocalPrecision() {
        int localPrecision = 2;
        DynamicObject baseCurrency = (DynamicObject)this.model.getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)baseCurrency)) {
            localPrecision = baseCurrency.getInt("amtprecision");
        }
        return localPrecision;
    }

    private BigDecimal getConvertRate(Long materialId, Long srcUnitId, Long desUnitId) {
        String key = materialId + "_" + srcUnitId + "_" + desUnitId;
        BigDecimal value = this.convertRateMap.get(key);
        if (value != null) {
            return value;
        }
        BigDecimal unitRateConv = UnitConvertHelper.getUnitRateConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        this.convertRateMap.put(key, unitRateConv);
        return unitRateConv;
    }

    private void checkDeducRate(Map<String, Object> entry, int index) {
        BigDecimal deRate = BusApBillImportHelper.getEntryBigDecimal(entry, (String)"deductiblerate");
        BigDecimal cueDeAmt = BusApBillImportHelper.getEntryBigDecimal(entry, (String)"curdeductibleamt");
        if (EmptyUtils.isEmpty((Object)deRate) && EmptyUtils.isNotEmpty((Object)cueDeAmt)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\uff0c\u53ef\u62b5\u6263\u989d\u6709\u503c\uff0c\u53ef\u62b5\u6263\u7387\u65e0\u503c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BusApBillImportHelper_1", (String)"fi-ap-formplugin", (Object[])new Object[0]), index + 1));
        }
    }

    private void checkPriceandAmount(boolean ispresent, boolean includetax, boolean ispricetotal, Map entry, int index) {
        if (!ispresent) {
            if (includetax && !ispricetotal) {
                this.checkEntryNull(entry.get("e_taxunitprice"), ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7", (String)"BusApBillImportHelper_2", (String)"fi-ap-formplugin", (Object[])new Object[0]), index + 1);
            } else if (!includetax && !ispricetotal) {
                this.checkEntryNull(entry.get("e_unitprice"), ResManager.loadKDString((String)"\u5355\u4ef7", (String)"BusApBillImportHelper_3", (String)"fi-ap-formplugin", (Object[])new Object[0]), index + 1);
            } else if (!includetax && ispricetotal) {
                this.checkEntryNull(entry.get("e_amount"), ResManager.loadKDString((String)"\u91d1\u989d", (String)"BusApBillImportHelper_4", (String)"fi-ap-formplugin", (Object[])new Object[0]), index + 1);
            } else if (includetax && ispricetotal) {
                this.checkEntryNull(entry.get("e_pricetaxtotal"), ResManager.loadKDString((String)"\u5e94\u4ed8\u91d1\u989d", (String)"BusApBillImportHelper_5", (String)"fi-ap-formplugin", (Object[])new Object[0]), index + 1);
            }
        }
    }

    private void checkEntryNull(Object value, String title, int index) {
        if (!this.isNull(value)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u4f53\u201d\u7b2c%1$s\u884c\uff1a\u8bf7\u8865\u5145\u201c%2$s\u201d\u3002", (String)"BusApBillImportHelper_6", (String)"fi-ap-formplugin", (Object[])new Object[0]), index, title));
        }
    }

    private boolean isNull(Object value) {
        boolean notNull = false;
        if (!ObjectUtils.isEmpty((Object)value)) {
            if (value instanceof Map) {
                Map vData = (Map)value;
                String importprop = (String)vData.get("importprop");
                if (StringUtils.isNotEmpty((String)importprop) && StringUtils.isNotEmpty((String)((String)vData.get(importprop)))) {
                    notNull = true;
                } else {
                    String vNum = (String)vData.get("number");
                    String vName = (String)vData.get("name");
                    if (!StringUtils.isEmpty((String)vNum) || !StringUtils.isEmpty((String)vName)) {
                        notNull = true;
                    }
                }
            }
            if (value instanceof String) {
                notNull = true;
            }
            if (value instanceof BigDecimal) {
                notNull = true;
            }
            if (value instanceof Double) {
                notNull = true;
            }
            if (value instanceof Integer) {
                notNull = true;
            }
        }
        return notNull;
    }

    private void checkDiscountMode(Boolean includetax, Map entry, int index) {
        boolean ispresent;
        boolean bl = ispresent = entry.get("e_ispresent") != null ? (Boolean)entry.get("e_ispresent") : false;
        if (ispresent) {
            return;
        }
        String discountMode = (String)entry.get("e_discountmode");
        BigDecimal discountRate = BusApBillImportHelper.getEntryBigDecimal((Map)entry, (String)"e_discountrate");
        if (discountMode != null && discountRate != null) {
            if (discountMode.equals("PERCENT") && (discountRate.compareTo(BigDecimal.ZERO) < 0 || discountRate.compareTo(new BigDecimal(100)) > 0)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u660e\u7ec6\u201d\u7b2c%d\u884c\uff0c\u201c\u6298\u6263\u65b9\u5f0f\u201d\u4e3a\u201c\u6298\u6263\u7387\u201d\u65f6\uff0c\u6298\u6263\u7387\u8303\u56f4\u4e3a[0,100]\u3002", (String)"BusApBillImportHelper_7", (String)"fi-ap-formplugin", (Object[])new Object[0]), index + 1));
            }
            if (discountMode.equals("PERUNIT")) {
                if (includetax.booleanValue() && (discountRate.compareTo(BigDecimal.ZERO) < 0 || discountRate.compareTo(BusApBillImportHelper.getEntryBigDecimal((Map)entry, (String)"e_taxunitprice")) > 0)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f55\u5165\u542b\u7a0e\u5355\u4ef7\u65f6\uff0c\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u9700\u6ee1\u8db3\u89c4\u5219\uff1a0\u2264\u5355\u4f4d\u6298\u6263\u989d\u2264\u542b\u7a0e\u5355\u4ef7\u3002", (String)"BusApBillImportHelper_8", (String)"fi-ap-formplugin", (Object[])new Object[0]), new Object[0]));
                }
                if (!(includetax.booleanValue() || discountRate.compareTo(BigDecimal.ZERO) >= 0 && discountRate.compareTo(BusApBillImportHelper.getEntryBigDecimal((Map)entry, (String)"e_unitprice")) <= 0)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5f55\u5165\u542b\u7a0e\u5355\u4ef7\u65f6\uff0c\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u9700\u6ee1\u8db3\u89c4\u5219\uff1a0\u2264\u5355\u4f4d\u6298\u6263\u989d\u2264\u5355\u4ef7\u3002", (String)"BusApBillImportHelper_9", (String)"fi-ap-formplugin", (Object[])new Object[0]), new Object[0]));
                }
            }
        }
    }

    private void createByInit() {
        DynamicObject currency = this.init.getStandardCurrency();
        this.model.setValue("basecurrency", currency.getPkValue());
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exchangerate"))) {
            this.model.setValue("exchangerate", (Object)1);
        }
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exratetable"))) {
            this.model.setValue("exratetable", this.init.getExrateTable().getPkValue());
        }
        FormServiceHelper.checkMeasureUnitRange((IDataModel)this.model, (String)"entry", (String)"e_material", (String)"e_measureunit");
        DynamicObject srcCurrency = (DynamicObject)this.model.getValue("currency");
        DynamicObject baseCurrency = (DynamicObject)this.model.getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)srcCurrency) && !ObjectUtils.isEmpty((Object)baseCurrency) && srcCurrency.getPkValue().equals(baseCurrency.getPkValue())) {
            this.model.setValue("quotation", (Object)"0");
            this.model.setValue("exchangerate", (Object)BigDecimal.ONE);
        } else {
            this.getQuotationHelper().getExchangeRate4Import(this.model);
        }
        if (!"true".equals(this.pageCache.get("isWebApi"))) {
            Date currentDate = this.init.getCurrentDate();
            if (ObjectUtils.isEmpty((Object)currentDate)) {
                currentDate = this.init.getStartDate();
            }
            if (new Date().after(currentDate)) {
                this.model.setValue("bizdate", (Object)new Date());
                if (EmptyUtils.isEmpty((Object)this.model.getValue("duedate"))) {
                    this.model.setValue("duedate", (Object)new Date());
                }
            } else {
                this.model.setValue("bizdate", (Object)currentDate);
                if (EmptyUtils.isEmpty((Object)this.model.getValue("duedate"))) {
                    this.model.setValue("duedate", (Object)currentDate);
                }
            }
        }
    }

    private final List<String> headRemoveFields() {
        ArrayList<String> headFields = new ArrayList<String>(15);
        headFields.add("pricetaxtotal");
        headFields.add("pricetaxtotalbase");
        headFields.add("amount");
        headFields.add("localamt");
        headFields.add("tax");
        headFields.add("taxlocamt");
        headFields.add("invoicedamt");
        headFields.add("invoicedlocamt");
        headFields.add("uninvoicedamt");
        headFields.add("uninvoicedlocamt");
        headFields.add("unwoffamt");
        headFields.add("unwofflocamt");
        headFields.add("unwoffnotaxamt");
        headFields.add("unwoffnotaxlocamt");
        headFields.add("unwofftax");
        headFields.add("unwofftaxlocal");
        return headFields;
    }

    private final List<String> entryRemoveFields() {
        ArrayList<String> entryFields = new ArrayList<String>(22);
        entryFields.add("e_actunitprice");
        entryFields.add("e_acttaxunitprice");
        entryFields.add("e_allocatedamt");
        entryFields.add("e_unallocatedamt");
        entryFields.add("e_unwoffqty");
        entryFields.add("e_unwoffamt");
        entryFields.add("e_unwofflocamt");
        entryFields.add("e_unwoffnotaxamt");
        entryFields.add("e_unwoffnotaxlocamt");
        entryFields.add("e_unwofftax");
        entryFields.add("e_unwofftaxlocal");
        entryFields.add("e_invoicedamt");
        entryFields.add("e_uninvoicedamt");
        entryFields.add("e_invoicedqty");
        entryFields.add("e_uninvoicedqty");
        entryFields.add("e_invoicednotaxamt");
        entryFields.add("e_invnotaxlocalamt");
        entryFields.add("e_uninvnotaxamt");
        entryFields.add("e_uninvnotaxlocalamt");
        entryFields.add("e_uninvoicedlocamt");
        entryFields.add("e_invoicedlocamt");
        entryFields.add("subentryentity");
        return entryFields;
    }

    private final List<String> allocationEntryRemoveFields() {
        ArrayList<String> allocationEntryFields = new ArrayList<String>(2);
        allocationEntryFields.add("a_srcentryid");
        allocationEntryFields.add("a_srcbillid");
        return allocationEntryFields;
    }

    private final List<String> headRemoveUpFields() {
        ArrayList<String> headUpdFields = new ArrayList<String>(15);
        headUpdFields.add("isadjust");
        headUpdFields.add("isselfwoff");
        headUpdFields.add("currency");
        headUpdFields.add("pricetaxtotal");
        headUpdFields.add("amount");
        headUpdFields.add("tax");
        headUpdFields.add("pricetaxtotalbase");
        headUpdFields.add("localamt");
        headUpdFields.add("taxlocamt");
        headUpdFields.add("invoicedamt");
        headUpdFields.add("invoicedlocamt");
        headUpdFields.add("uninvoicedamt");
        headUpdFields.add("uninvoicedlocamt");
        headUpdFields.add("isfullinvoice");
        headUpdFields.add("billstatus");
        headUpdFields.addAll(this.headFields);
        return headUpdFields;
    }

    private final List<String> entryRemoveUpFields() {
        ArrayList<String> entryUpdFields = new ArrayList<String>(7);
        entryUpdFields.add("e_material");
        entryUpdFields.add("e_measureunit");
        entryUpdFields.add("e_invoicedamt");
        entryUpdFields.add("e_invoicedlocamt");
        entryUpdFields.add("isallocate");
        entryUpdFields.add("e_iswriteoff");
        entryUpdFields.add("e_invoicedqty");
        entryUpdFields.add("e_allocatedamt");
        entryUpdFields.add("e_unallocatedamt");
        entryUpdFields.add("e_expensebillids");
        entryUpdFields.add("e_expensebillids_tag");
        entryUpdFields.addAll(this.entryFields);
        return entryUpdFields;
    }

    private final List<String> allocationEntryUpdRemoveFields() {
        ArrayList<String> allocationEntryUpdFields = new ArrayList<String>(2);
        allocationEntryUpdFields.add("a_srcentryid");
        allocationEntryUpdFields.add("a_srcbillid");
        return allocationEntryUpdFields;
    }

    private void costsAndPrePaidNotBothTrue() {
        int count = this.model.getEntryEntity("entry").size();
        for (int i = 0; i < count; ++i) {
            boolean contractCosts = (Boolean)this.model.getValue("e_contractcost", i);
            boolean prePaid = (Boolean)this.model.getValue("e_prepaid", i);
            if (!contractCosts || !prePaid) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u540c\u5c65\u7ea6\u6210\u672c\u548c\u4ee3\u57ab\u6807\u8bc6\u4e0d\u80fd\u540c\u65f6\u6253\u5f00\u3002", (String)"BusApBillImportHelper_11", (String)"fi-ap-formplugin", (Object[])new Object[0]), new Object[0]));
        }
    }
}

