/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.formservice.invoice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.fi.ap.enums.DiscountModeEnum;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;
import kd.fi.arapcommon.helper.QuotationHelper;
import kd.fi.arapcommon.impt.AbstractBillImport;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.InstantUtils;

public class ApInvoiceBillImportHelper
extends AbstractBillImport {
    private final List<String> headFields = this.headRemoveFields();
    private final List<String> entryFields = this.entryRemoveFields();
    private static final String[] ENTRY = new String[]{"price", "e_amount", "e_amountbase", "e_tax", "discountamt", "discountlocalamt", "e_pricetaxtotal", "e_pricetaxtotalbase", "e_relatedamt", "e_unrelatedamt", "e_unmatchamt", "e_unmatchqty"};
    private static final String[] HEAD = new String[]{"pricetaxtotal", "pricetaxtotalbase", "amount", "amountbase", "tax", "unrelatedamt", "unmatchamt"};
    private QuotationHelper quotationHelper;

    private QuotationHelper getQuotationHelper() {
        if (this.quotationHelper == null) {
            this.quotationHelper = new QuotationHelper();
        }
        return this.quotationHelper;
    }

    public ApInvoiceBillImportHelper(IDataModel model, IPageCache pageCache) {
        this.model = model;
        this.pageCache = pageCache;
    }

    public ApInvoiceBillImportHelper(IFormView view, IPageCache pageCache) {
        this.view = view;
        this.model = view.getModel();
        this.pageCache = pageCache;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        boolean isIncludeTax = sourceData.get("isincludetax") == null ? false : (Boolean)sourceData.get("isincludetax");
        this.checkNull("currency", ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01", (String)"ApInvoiceBillImportHelper_4", (String)"fi-ap-formplugin", (Object[])new Object[0]), sourceData);
        this.removeNoAssignField(sourceData, this.headFields);
        List entryList = null;
        if (sourceData.get("entry") != null) {
            entryList = (List)sourceData.get("entry");
        }
        if (entryList != null) {
            for (int i = 0; i < entryList.size(); ++i) {
                Map entry = (Map)entryList.get(i);
                this.removeNoAssignField(entry, this.entryFields);
                this.checkIncludeTax(entry, isIncludeTax);
                this.checkDiscountMode(entry, i);
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        Map sourceData = e.getSourceData();
        DynamicObject org = (DynamicObject)this.model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        Long orgPk = (Long)org.getPkValue();
        this.init = (InitHelper)this.initMap.get(orgPk);
        if (ObjectUtils.isEmpty((Object)this.init)) {
            this.init = new InitHelper(orgPk.longValue(), "ap_init");
            this.initMap.put(orgPk, this.init);
        }
        if (ObjectUtils.isEmpty((Object)this.init.getInit())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ApInvoiceBillImportHelper_0", (String)"fi-ap-formplugin", (Object[])new Object[0]), org.getString("name")));
        }
        this.init.checkInit();
        DynamicObject currency = (DynamicObject)this.model.getValue("currency");
        if (ObjectUtils.isEmpty((Object)currency)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApInvoiceBillImportHelper_5", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        this.createByInit(sourceData);
        this.setDefaultSourceValue(sourceData);
        this.setMaterialandExpenseAbout();
        this.setTaxRate();
        this.setTaxDeduction();
        this.setIsPresent();
        this.calculatePrice(sourceData);
    }

    private void checkIncludeTax(Map entry, Boolean isIncludeTax) {
        boolean isPresent;
        boolean bl = isPresent = entry.get("e_ispresent") != null ? (Boolean)entry.get("e_ispresent") : false;
        if (isPresent) {
            return;
        }
        if (isIncludeTax.booleanValue()) {
            Object pricetaxtotal = entry.get("e_pricetaxtotal");
            if (!ObjectUtils.isEmpty(pricetaxtotal)) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u5f55\u5165\u4ef7\u7a0e\u5408\u8ba1,\u5f55\u5165\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a", (String)"ApInvoiceBillImportHelper_1", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        Object price = entry.get("price");
        if (!ObjectUtils.isEmpty(price)) {
            return;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5f55\u5165\u4ef7\u7a0e\u5408\u8ba1,\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", (String)"ApInvoiceBillImportHelper_2", (String)"fi-ap-formplugin", (Object[])new Object[0]));
    }

    private void checkDiscountMode(Map entry, int index) {
        String discountMode = (String)entry.get("discountmode");
        if (DiscountModeEnum.PERCENT.getValue().equals(discountMode)) {
            BigDecimal discountRate = new BigDecimal(entry.get("discountrate").toString());
            if (EmptyUtils.isEmpty((Object)discountRate)) {
                return;
            }
            if (discountRate.compareTo(new BigDecimal(100)) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u6298\u6263\u7387\u4e0b\u5355\u4f4d\u6298\u6263\u7387\u503c\u4e0d\u80fd\u5927\u4e8e100", (String)"ApInvoiceBillImportHelper_3", (String)"fi-ap-formplugin", (Object[])new Object[]{index + 1}));
            }
        } else if (DiscountModeEnum.NULL.getValue().equals(discountMode) || DiscountModeEnum.TOTAL.getValue().equals(discountMode)) {
            entry.remove("discountrate");
        }
    }

    private void createByInit(Map sourceData) {
        boolean isBankOrg;
        DynamicObject headOrg = this.model.getDataEntity().getDynamicObject("org");
        boolean isPurOrg = headOrg.getBoolean("fispurchase");
        if (isPurOrg && EmptyUtils.isEmpty(sourceData.get("purorg"))) {
            this.model.setValue("purorg", (Object)headOrg.getLong("id"));
        }
        if ((isBankOrg = headOrg.getBoolean("fisbankroll")) && EmptyUtils.isEmpty(sourceData.get("payorg"))) {
            this.model.setValue("payorg", (Object)headOrg.getLong("id"));
        }
        DynamicObject cur = this.init.getStandardCurrency();
        this.model.setValue("basecurrency", cur.getPkValue());
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exchangerate")) || BigDecimal.ZERO.compareTo((BigDecimal)this.model.getValue("exchangerate")) == 0) {
            this.model.setValue("exchangerate", (Object)1);
        }
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exratetable"))) {
            this.model.setValue("exratetable", this.init.getExrateTable().getPkValue());
        }
        DynamicObject srcCurrency = (DynamicObject)this.model.getValue("currency");
        DynamicObject destCurrency = (DynamicObject)this.model.getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)srcCurrency) && !ObjectUtils.isEmpty((Object)destCurrency) && srcCurrency.getPkValue().equals(destCurrency.getPkValue())) {
            this.model.setValue("exchangerate", (Object)BigDecimal.ONE);
            this.model.setValue("quotation", (Object)"0");
        } else {
            this.getQuotationHelper().getExchangeRate4Import(this.model);
        }
    }

    private void setDefaultSourceValue(Map<String, Object> sourceData) {
        DynamicObject asstact;
        DynamicObject buyer;
        if (EmptyUtils.isEmpty((Object)this.model.getValue("buyername")) && Objects.nonNull(buyer = (DynamicObject)this.model.getValue("buyer"))) {
            this.model.setValue("buyername", buyer.get("name"));
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("asstactname")) && Objects.nonNull(asstact = (DynamicObject)this.model.getValue("asstact"))) {
            this.model.setValue("asstactname", asstact.get("name"));
        }
        if (EmptyUtils.isEmpty((Object)this.model.getValue("exratedate"))) {
            this.model.setValue("exratedate", (Object)InstantUtils.getInstantString((Instant)Instant.now(), (String)"yyyy-MM-dd"));
        }
        this.model.setValue("businesssource", (Object)" ");
        this.model.setValue("isreffin", (Object)Boolean.FALSE);
    }

    private void setMaterialandExpenseAbout() {
        DynamicObjectCollection entries = this.model.getEntryEntity("entry");
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject productline;
            DynamicObject entry = (DynamicObject)entries.get(i);
            DynamicObject material = entry.getDynamicObject("material");
            String billtype = (String)this.model.getValue("biztype");
            if (EmptyUtils.isEmpty((Object)material) || !"PUR".equals(billtype)) continue;
            if (EmptyUtils.isEmpty((Object)entry.getString("e_invname"))) {
                this.model.setValue("e_invname", (Object)material.getString("name"), i);
            }
            if (EmptyUtils.isEmpty((Object)entry.getString("spectype"))) {
                this.model.setValue("spectype", material.get("modelnum"), i);
            }
            if (EmptyUtils.isEmpty((Object)entry.get("measureunit"))) {
                this.model.setValue("measureunit", material.get("baseunit"), i);
            }
            if ((productline = material.getDynamicObject("productline")) == null || !ObjectUtils.isEmpty((Object)this.model.getValue("e_productline", i))) continue;
            this.model.setValue("e_productline", productline.getPkValue(), i);
        }
    }

    private void setTaxRate() {
        DynamicObjectCollection entries = this.model.getEntryEntity("entry");
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            DynamicObject taxRateId = entry.getDynamicObject("taxrateid");
            if (EmptyUtils.isEmpty((Object)taxRateId) || EmptyUtils.isEmpty((Object)taxRateId.get("taxrate")) || taxRateId.get("taxrate") == entry.get("taxrate")) continue;
            this.model.setValue("taxrate", taxRateId.get("taxrate"), i);
        }
    }

    private void setTaxDeduction() {
        String invoiceType = (String)this.model.getValue("invoicetype");
        if (EmptyUtils.isEmpty((Object)invoiceType)) {
            return;
        }
        String typeNo = InvoiceType.getTypeNo((String)invoiceType);
        if (EmptyUtils.isEmpty((Object)typeNo)) {
            typeNo = invoiceType;
        }
        this.model.setValue("invoicetypef7", (Object)InvoiceTypeHelper.getInvoiceTypePK((String)typeNo));
        if ("SP".equals(invoiceType) || "SE".equals(invoiceType)) {
            this.model.setValue("istaxdeduction", (Object)Boolean.TRUE);
        } else {
            this.model.setValue("istaxdeduction", (Object)Boolean.FALSE);
        }
    }

    private void setIsPresent() {
        DynamicObjectCollection entries = this.model.getEntryEntity("entry");
        for (int i = 0; i < entries.size(); ++i) {
            Boolean isPresent = (Boolean)this.model.getValue("ispresent", i);
            if (isPresent == null || !isPresent.booleanValue()) continue;
            BigDecimal price = (BigDecimal)this.model.getValue("price", i);
            if (BigDecimal.ZERO.compareTo(price) != 0) {
                this.model.setValue("discountmode", (Object)"PERCENT", i);
                this.model.setValue("discountrate", (Object)new BigDecimal(100), i);
                continue;
            }
            this.model.setValue("discountmode", (Object)"NULL", i);
            this.model.setValue("discountrate", (Object)BigDecimal.ZERO, i);
        }
    }

    private void calculatePrice(Map sourceData) {
        DynamicObjectCollection entries = this.model.getEntryEntity("entry");
        int count = entries.size();
        for (int i = 0; i < count; ++i) {
            this.calculateAmt(this.model, i);
        }
    }

    private void calculateAmt(IDataModel m, int index) {
        m.beginInit();
        if (index != -1) {
            this.calculatorEntryAmt(m, index, false);
        } else {
            for (int i = 0; i < m.getEntryRowCount("entry"); ++i) {
                this.calculatorEntryAmt(m, i, false);
            }
        }
        this.setHeadAmount();
        m.endInit();
        IFormView v = this.view;
        if (index != -1) {
            for (String e : ENTRY) {
                v.updateView(e, index);
            }
        } else {
            for (int i = 0; i < m.getEntryRowCount("entry"); ++i) {
                String[] stringArray = ENTRY;
                int n = stringArray.length;
                for (int e = 0; e < n; ++e) {
                    String e2 = stringArray[e];
                    v.updateView(e2, i);
                }
            }
        }
        for (String h : HEAD) {
            v.updateView(h);
        }
    }

    private void calculatorEntryAmt(IDataModel m, int index, boolean isbotpPush) {
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        DynamicObject currency = (DynamicObject)m.getValue("currency");
        int precision = ObjectUtils.isEmpty((Object)currency) ? 2 : currency.getInt("amtprecision");
        DynamicObject basecurrency = (DynamicObject)m.getValue("basecurrency");
        int localprecision = ObjectUtils.isEmpty((Object)basecurrency) ? 2 : basecurrency.getInt("amtprecision");
        BigDecimal rate = (BigDecimal)m.getValue("exchangerate");
        String quotation = (String)m.getValue("quotation");
        if ("1".equals(quotation) && rate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        BigDecimal qty = (BigDecimal)m.getValue("quantity", index);
        BigDecimal taxRate = (BigDecimal)m.getValue("taxrate", index);
        String discountMode = (String)m.getValue("discountmode", index);
        BigDecimal discountRate = (BigDecimal)m.getValue("discountrate", index);
        BigDecimal discountAmt = (BigDecimal)m.getValue("discountamt", index);
        BigDecimal unitPrice = (BigDecimal)m.getValue("price", index);
        UnitPriceCalculator calculator = null;
        if (includeTax) {
            BigDecimal pricetaxtotal = (BigDecimal)m.getValue("e_pricetaxtotal", index);
            calculator = new PriceTaxTotalCalculator(isbotpPush, unitPrice, BigDecimal.ZERO, qty, pricetaxtotal, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        } else {
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, localprecision, quotation);
        localCalculator.calculate();
        this.resetEntryProp(m, localCalculator, index);
    }

    private void setHeadAmount() {
        IDataModel model = this.model;
        int rowCount = model.getEntryRowCount("entry");
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountbase = BigDecimal.ZERO;
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        BigDecimal unrelatedamt = BigDecimal.ZERO;
        BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            amount = amount.add((BigDecimal)model.getValue("e_amount", rowIndex));
            amountbase = amountbase.add((BigDecimal)model.getValue("e_amountbase", rowIndex));
            pricetaxtotal = pricetaxtotal.add((BigDecimal)model.getValue("e_pricetaxtotal", rowIndex));
            pricetaxtotalbase = pricetaxtotalbase.add((BigDecimal)model.getValue("e_pricetaxtotalbase", rowIndex));
            tax = tax.add((BigDecimal)model.getValue("e_tax", rowIndex));
            unrelatedamt = unrelatedamt.add((BigDecimal)model.getValue("e_unrelatedamt", rowIndex));
        }
        model.setValue("amount", (Object)amount);
        model.setValue("amountbase", (Object)amountbase);
        model.setValue("pricetaxtotal", (Object)pricetaxtotal);
        model.setValue("unrelatedamt", (Object)unrelatedamt);
        model.setValue("unmatchamt", (Object)unrelatedamt);
        model.setValue("pricetaxtotalbase", (Object)pricetaxtotalbase);
        model.setValue("tax", (Object)tax);
    }

    private void resetEntryProp(IDataModel m, PriceLocalCalculator localCalculator, int index) {
        boolean isFx = (Boolean)m.getValue("isfx");
        BigDecimal priceTaxTotal = localCalculator.getPricetaxtotal();
        m.setValue("price", (Object)localCalculator.getUnitprice(), index);
        m.setValue("actprice", (Object)localCalculator.getActunitprice(), index);
        m.setValue("actpricetax", (Object)localCalculator.getActtaxunitprice(), index);
        BigDecimal e_amount = (BigDecimal)m.getValue("e_amount", index);
        BigDecimal e_tax = (BigDecimal)m.getValue("e_tax", index);
        BigDecimal e_pricetaxtotal = (BigDecimal)m.getValue("e_pricetaxtotal", index);
        if (isFx && e_amount.add(e_tax).compareTo(e_pricetaxtotal) == 0) {
            DynamicObject baseCurrency = (DynamicObject)m.getValue("basecurrency");
            int localPrecision = baseCurrency.getInt("amtprecision");
            BigDecimal exchangeRate = (BigDecimal)m.getValue("exchangerate");
            BigDecimal amountbase = BigDecimal.ZERO;
            amountbase = "1".equals(m.getValue("quotation")) ? e_amount.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP) : e_amount.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
            m.setValue("e_amountbase", (Object)amountbase, index);
        } else {
            m.setValue("e_tax", (Object)localCalculator.getTax(), index);
            m.setValue("e_amount", (Object)localCalculator.getAmount(), index);
            m.setValue("e_amountbase", (Object)localCalculator.getAmountlocal(), index);
        }
        m.setValue("discountamt", (Object)localCalculator.getDiscountamount(), index);
        m.setValue("discountlocalamt", (Object)localCalculator.getDiscountamountlocal(), index);
        m.setValue("e_pricetaxtotal", (Object)priceTaxTotal, index);
        m.setValue("e_unrelatedamt", (Object)priceTaxTotal, index);
        m.setValue("e_unmatchamt", (Object)priceTaxTotal, index);
        m.setValue("e_unmatchqty", (Object)localCalculator.getQuantity(), index);
        m.setValue("e_pricetaxtotalbase", (Object)localCalculator.getPricetaxtotallocal(), index);
    }

    private final List<String> headRemoveFields() {
        ArrayList<String> headFields = new ArrayList<String>(7);
        headFields.add("pricetaxtotal");
        headFields.add("pricetaxtotalbase");
        headFields.add("amount");
        headFields.add("amountbase");
        headFields.add("tax");
        headFields.add("unrelatedamt");
        headFields.add("unmatchamt");
        headFields.add("quotation");
        return headFields;
    }

    private final List<String> entryRemoveFields() {
        ArrayList<String> entryFields = new ArrayList<String>(2);
        entryFields.add("actprice");
        entryFields.add("actpricetax");
        entryFields.add("e_relatedamt");
        entryFields.add("e_unrelatedamt");
        entryFields.add("e_unmatchamt");
        entryFields.add("e_unmatchqty");
        return entryFields;
    }
}

