/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.formservice.paid;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.QuotationHelper;
import kd.fi.arapcommon.impt.AbstractBillImport;

public class PaidBillImportHelper
extends AbstractBillImport {
    private final List<String> headFields = this.headRemoveFields();
    private final List<String> entryFields = this.entryRemoveFields();
    private QuotationHelper quotationHelper;

    public PaidBillImportHelper(IDataModel model, IPageCache pageCache) {
        this.model = model;
        this.pageCache = pageCache;
    }

    public PaidBillImportHelper(IFormView view, IPageCache pageCache) {
        this.view = view;
        this.model = view.getModel();
        this.pageCache = pageCache;
    }

    private QuotationHelper getQuotationHelper() {
        if (this.quotationHelper == null) {
            this.quotationHelper = new QuotationHelper();
        }
        return this.quotationHelper;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        String url = RequestContext.get().getClientUrl();
        if (!ObjectUtils.isEmpty((Object)url) && url.contains("appendentryrows")) {
            return;
        }
        Map sourceData = e.getSourceData();
        Object currency = sourceData.get("currency");
        if (ObjectUtils.isEmpty(currency)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaidBillImportHelper_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        this.removeNoAssignField(sourceData, this.headFields);
        Object asstacttype = sourceData.get("payeetype");
        if (asstacttype == null) {
            sourceData.put("payeetype", "bd_supplier");
        }
        List entryList = null;
        if (sourceData.get("entry") != null) {
            entryList = (List)sourceData.get("entry");
        }
        if (entryList != null) {
            for (int i = 0; i < entryList.size(); ++i) {
                Map entry = (Map)entryList.get(i);
                this.removeNoAssignField(entry, this.entryFields);
                Object actPayAmt = entry.get("e_actamt");
                if (!ObjectUtils.isEmpty(actPayAmt)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u4f53\u201d\u7b2c%1$s\u884c\uff0c\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaidBillImportHelper_1", (String)"fi-ap-formplugin", (Object[])new Object[0]), i + 1));
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        String url = RequestContext.get().getClientUrl();
        if (!ObjectUtils.isEmpty((Object)url) && url.contains("appendentryrows")) {
            return;
        }
        Map sourceData = e.getSourceData();
        boolean isNew = false;
        String importType = (String)e.getOption().get("importtype");
        if ("overridenew".equals(importType) || importType == null) {
            isNew = ObjectUtils.isEmpty(sourceData.get("_pkid_"));
        } else if ("new".equals(importType)) {
            isNew = true;
        }
        DynamicObject org = (DynamicObject)this.model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        Long orgPk = (Long)org.getPkValue();
        this.init = (InitHelper)this.initMap.get(orgPk);
        if (ObjectUtils.isEmpty((Object)this.init)) {
            this.init = new InitHelper(orgPk.longValue(), "ap_init");
            this.initMap.put(orgPk, this.init);
        }
        if (ObjectUtils.isEmpty((Object)this.init.getInit())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"PaidBillImportHelper_2", (String)"fi-ap-formplugin", (Object[])new Object[0]), org.getString("name")));
        }
        this.init.checkInit();
        if (this.init.isFinishInit()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"PaidBillImportHelper_3", (String)"fi-ap-formplugin", (Object[])new Object[0]), org.getString("name")));
        }
        DynamicObject currency = (DynamicObject)this.model.getValue("currency");
        if (ObjectUtils.isEmpty((Object)currency)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaidBillImportHelper_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
        }
        this.createByInit();
        this.createDefaultField();
        this.setCalculatorAmt();
    }

    private void createByInit() {
        DynamicObject currency;
        DynamicObject baseCurrency = this.init.getStandardCurrency();
        this.model.setValue("basecurrency", (Object)baseCurrency);
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exratetable"))) {
            this.model.setValue("exratetable", this.init.getExrateTable().getPkValue());
        }
        if (!ObjectUtils.isEmpty((Object)(currency = (DynamicObject)this.model.getValue("currency"))) && !ObjectUtils.isEmpty((Object)baseCurrency) && currency.getPkValue().equals(baseCurrency.getPkValue())) {
            this.model.setValue("quotation", (Object)"0");
            this.model.setValue("exchangerate", (Object)BigDecimal.ONE);
        } else if (((BigDecimal)this.model.getValue("exchangerate")).compareTo(BigDecimal.ZERO) == 0) {
            this.getQuotationHelper().getExchangeRate4Import(this.model);
        }
    }

    private void createDefaultField() {
        Object biztype = this.model.getValue("biztype");
        if (biztype == null) {
            this.model.setValue("biztype", (Object)"10");
        }
    }

    private void setCalculatorAmt() {
        DynamicObject baseCurrency = (DynamicObject)this.model.getValue("basecurrency");
        int precision = 2;
        if (baseCurrency != null) {
            precision = baseCurrency.getInt("amtprecision");
        }
        BigDecimal exchangeRate = (BigDecimal)this.model.getValue("exchangerate");
        String quotation = (String)this.model.getValue("quotation");
        if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        BigDecimal actPayAmt = BigDecimal.ZERO;
        BigDecimal localAmt = BigDecimal.ZERO;
        int count = this.model.getEntryRowCount("entry");
        for (int i = 0; i < count; ++i) {
            BigDecimal e_actAmt = (BigDecimal)this.model.getValue("e_actamt", i);
            BigDecimal e_localAmt = "1".equals(quotation) ? e_actAmt.divide(exchangeRate, precision, 4) : e_actAmt.multiply(exchangeRate).setScale(precision, 4);
            this.model.setValue("e_localamt", (Object)e_localAmt, i);
            this.model.setValue("e_unsettledamt", (Object)e_actAmt, i);
            localAmt = localAmt.add(e_localAmt);
            actPayAmt = actPayAmt.add(e_actAmt);
        }
        this.model.setValue("actpayamt", (Object)actPayAmt);
        this.model.setValue("localamt", (Object)localAmt);
    }

    private final List<String> headRemoveFields() {
        ArrayList<String> headFields = new ArrayList<String>(2);
        headFields.add("actpayamt");
        headFields.add("localamt");
        return headFields;
    }

    private final List<String> entryRemoveFields() {
        ArrayList<String> entryFields = new ArrayList<String>(5);
        entryFields.add("e_localamt");
        entryFields.add("e_settledamt");
        entryFields.add("e_unsettledamt");
        return entryFields;
    }
}

