/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.impt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.impt.BillImportPlugin;
import kd.fi.arapcommon.util.EmptyUtils;

public class ApBusBillImport
extends BillImportPlugin {
    private final List<String> headFields = this.headRemoveFields();
    private final List<String> entryFields = this.entryRemoveFields();
    private final List<String> allocationEntryFields = this.allocationEntryRemoveFields();
    private final List<String> headUpdFields = this.headRemoveUpFields();
    private final List<String> entryUpdFields = this.entryRemoveUpFields();
    private final List<String> allocationEntryUpdFields = this.allocationEntryUpdRemoveFields();
    private String importType = "";

    public ApBusBillImport() {
        super(false);
    }

    private void judgeAndRemoveField(JSONObject data, List<String> field) {
        for (int i = 0; i < field.size(); ++i) {
            if (!data.containsKey((Object)field.get(i))) continue;
            data.remove((Object)field.get(i));
        }
    }

    private void judgeAndRemoveEntryField(JSONObject data, List<String> field, JSONArray entries) {
        if (ObjectUtils.isEmpty((Object)entries)) {
            return;
        }
        for (int i = 0; i < entries.size(); ++i) {
            JSONObject row = (JSONObject)entries.get(i);
            for (int j = 0; j < field.size(); ++j) {
                if (!row.containsKey((Object)field.get(j))) continue;
                row.remove((Object)field.get(j));
            }
        }
    }

    private void judgeAndRemoveAllocationEntryField(JSONObject data, List<String> field, JSONArray allocationEntries) {
        if (ObjectUtils.isEmpty((Object)allocationEntries)) {
            return;
        }
        for (int i = 0; i < allocationEntries.size(); ++i) {
            JSONObject row = (JSONObject)allocationEntries.get(i);
            for (int j = 0; j < field.size(); ++j) {
                if (!row.containsKey((Object)field.get(j))) continue;
                row.remove((Object)field.get(j));
            }
        }
    }

    protected String bizCheck(JSONObject data) {
        String message = null;
        try {
            JSONArray entries = (JSONArray)data.get((Object)"entry");
            if (EmptyUtils.isNotEmpty((Object)entries)) {
                for (int i = 0; i < entries.size(); ++i) {
                    JSONObject row = (JSONObject)entries.get(i);
                    if (!row.containsKey((Object)"e_ispresent")) {
                        row.put("e_ispresent", (Object)Boolean.FALSE);
                    }
                    if (!row.containsKey((Object)"subentryentity")) continue;
                    row.remove((Object)"subentryentity");
                }
            }
            if (!data.containsKey((Object)"isperiod")) {
                data.put("isperiod", (Object)Boolean.FALSE);
            }
            if (StringUtils.isEmpty((String)this.importType)) {
                this.importType = this.ctx.getOption().get("importtype").toString();
            }
            JSONArray allocationEntries = (JSONArray)data.get((Object)"allocationentry");
            if ("override".equals(this.importType) && EmptyUtils.isNotEmpty((Object)data.get((Object)"sourcebillid"))) {
                this.judgeAndRemoveField(data, this.headUpdFields);
                this.judgeAndRemoveEntryField(data, this.entryUpdFields, entries);
                this.judgeAndRemoveAllocationEntryField(data, this.allocationEntryFields, allocationEntries);
            } else {
                this.judgeAndRemoveField(data, this.headFields);
                this.judgeAndRemoveEntryField(data, this.entryFields, entries);
                this.judgeAndRemoveAllocationEntryField(data, this.allocationEntryUpdFields, allocationEntries);
            }
            if (data.containsKey((Object)"settlementtype")) {
                Map settlementTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_settlementtype", (String)"id,enable", null);
                ArrayList<Object> disenableTypes = new ArrayList<Object>(settlementTypeMap.size());
                ArrayList<Object> enableTypes = new ArrayList<Object>(settlementTypeMap.size());
                for (Object settlementType : settlementTypeMap.values()) {
                    if (settlementType.getBoolean("enable")) {
                        enableTypes.add(settlementType);
                        continue;
                    }
                    disenableTypes.add(settlementType);
                }
                JSONObject settlementType = (JSONObject)data.get((Object)"settlementtype");
                for (DynamicObject dynamicObject : disenableTypes) {
                    if (!settlementType.getString("number").equals(dynamicObject.getString("number"))) continue;
                    return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"ApBusBillImport_2", (String)"fi-ap-formplugin", (Object[])new Object[0]), settlementType.getString("number"));
                }
                boolean containSign = false;
                for (DynamicObject dynamicObject : enableTypes) {
                    if (!settlementType.getString("number").equals(dynamicObject.getString("number"))) continue;
                    containSign = true;
                    break;
                }
                if (!containSign) {
                    return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7ed3\u7b97\u65b9\u5f0f\u5728\u7cfb\u7edf\u5185\u4e0d\u5b58\u5728\u3002", (String)"ApBusBillImport_3", (String)"fi-ap-formplugin", (Object[])new Object[0]), settlementType.getString("number"));
                }
            }
            if ("override".equals(this.importType) && EmptyUtils.isNotEmpty((Object)data.get((Object)"sourcebillid"))) {
                data.remove((Object)"isincludetax");
            }
            if (data.containsKey((Object)"isfullinvoice")) {
                data.put("isfullinvoice", (Object)Boolean.FALSE);
            }
            if (data.containsKey((Object)"planentity")) {
                data.remove((Object)"planentity");
            }
            message = this.checkOperatorAndgroup(data, "purchaser", "purdept");
        }
        catch (KDBizException e) {
            message = e.getMessage();
        }
        return message;
    }

    private final List<String> headRemoveFields() {
        ArrayList<String> headFields = new ArrayList<String>(1);
        return headFields;
    }

    private final List<String> entryRemoveFields() {
        ArrayList<String> entryFields = new ArrayList<String>(1);
        return entryFields;
    }

    private final List<String> allocationEntryRemoveFields() {
        ArrayList<String> allocationEntryFields = new ArrayList<String>(1);
        return allocationEntryFields;
    }

    private final List<String> headRemoveUpFields() {
        ArrayList<String> headUpdFields = new ArrayList<String>(1);
        return headUpdFields;
    }

    private final List<String> entryRemoveUpFields() {
        ArrayList<String> entryUpdFields = new ArrayList<String>(1);
        return entryUpdFields;
    }

    private final List<String> allocationEntryUpdRemoveFields() {
        ArrayList<String> allocationEntryUpdFields = new ArrayList<String>(1);
        return allocationEntryUpdFields;
    }
}

