/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.tolerance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.formplugin.tolerance.IToleranceSchemeAssign;
import kd.fi.arapcommon.helper.OrgHelper;

public abstract class AbstractToleranceSchemeAssign
extends AbstractFormPlugin
implements IToleranceSchemeAssign,
SearchEnterListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"cancelassign", "assign", "assign_query"});
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    @Override
    public void loadTreeData() {
        TreeView view = (TreeView)this.getControl("assigntree");
        view.deleteAllNodes();
        view.setMulti(this.isMulti());
        String value = (String)this.getModel().getValue("assigntype");
        List<Object> assignTreeDatas = new ArrayList();
        QFilter[] filters = new QFilter[]{new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1")};
        switch (value) {
            case "org": {
                value = ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"AbstractToleranceSchemeAssign_0", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                assignTreeDatas = OrgHelper.getAuthorizedInitializedOrgs((String)"ar_finarbill", (String)"47150e89000000ac", (boolean)false);
                break;
            }
            case "sup": {
                value = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"AbstractToleranceSchemeAssign_1", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                assignTreeDatas = Arrays.asList(BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,name", (QFilter[])filters));
                break;
            }
            case "mat": {
                value = ResManager.loadKDString((String)"\u7269\u6599", (String)"AbstractToleranceSchemeAssign_2", (String)"fi-ap-formplugin", (Object[])new Object[0]);
                assignTreeDatas = Arrays.asList(BusinessDataServiceHelper.load((String)"bd_material", (String)"id,name", (QFilter[])filters));
                break;
            }
        }
        String rootId = (String)this.getModel().getValue("assigntype");
        TreeNode rootNode = new TreeNode(null, rootId, value, true);
        rootNode.setIsOpened(true);
        for (DynamicObject dynamicObject : assignTreeDatas) {
            TreeNode tn = new TreeNode(rootId, dynamicObject.getPkValue().toString(), dynamicObject.getString("name"), false);
            rootNode.addChild(tn);
        }
        view.addNode(rootNode);
        this.getView().getPageCache().put("rootnode", SerializationUtils.toJsonString((Object)rootNode));
    }

    public abstract boolean isMulti();

    public void search(SearchEnterEvent evt) {
        List treeNodes;
        String searchText = evt.getText();
        TreeView treeView = (TreeView)this.getControl("assigntree");
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("rootnode"), TreeNode.class);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = root.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = root.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879", (String)"SettleConsoleLeftTreeHandler_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        } else {
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache == treeNodes.size()) {
                    indexCache = 0;
                }
                treeView.showNode(((TreeNode)treeNodes.get(indexCache)).getParentid());
                treeView.focusNode((TreeNode)treeNodes.get(indexCache));
                treeView.treeNodeClick(((TreeNode)treeNodes.get(indexCache)).getParentid(), ((TreeNode)treeNodes.get(indexCache)).getId());
                pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
            } else {
                treeView.showNode(((TreeNode)treeNodes.get(0)).getParentid());
                treeView.focusNode((TreeNode)treeNodes.get(0));
                treeView.treeNodeClick(((TreeNode)treeNodes.get(0)).getParentid(), ((TreeNode)treeNodes.get(0)).getId());
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }
}

