/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.tolerance;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.formplugin.tolerance.AbstractToleranceSchemeAssign;

public class ToleranceSchemeAssignEdit
extends AbstractToleranceSchemeAssign {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        DynamicObject[] datas = grid.getEntryData().getDataEntitys();
        int[] rowIndex = new int[datas.length];
        for (int i = 0; i < datas.length; ++i) {
            rowIndex[i] = i;
        }
        grid.selectRows(rowIndex, 0);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List schemeList = (List)customParams.get("schemeids");
        ArrayList<Long> schemeids = new ArrayList<Long>(10);
        for (Map map : schemeList) {
            schemeids.add((Long)map.get("primaryKeyValue"));
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", schemeids)};
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"ap_tolerance_scheme", (String)"id,number,name,controlpoint,controlmode", (QFilter[])filters);
        for (DynamicObject scheme : schemes) {
            int index = model.createNewEntryRow("entryentity");
            model.setValue("schemeid", scheme.get(0), index);
            model.setValue("number", scheme.get(1), index);
            model.setValue("name", scheme.get(2), index);
            model.setValue("controlpoint", scheme.get(3), index);
            model.setValue("controlmode", scheme.get(4), index);
        }
        this.loadTreeData();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int currentIndex = changeData[0].getRowIndex();
        switch (key) {
            case "assigntype": {
                this.loadTreeData();
                break;
            }
        }
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        String key = button.getKey();
        if ("assign".equals(key)) {
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            int[] rows = grid.getSelectRows();
            if (rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u201c\u5bb9\u5dee\u65b9\u6848\u201d\u3002", (String)"ToleranceSchemeAssignEdit_0", (String)"fi-ap-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeView treeView = (TreeView)this.getView().getControl("assigntree");
            List typepks = treeView.getTreeState().getCheckedNodeIds();
            ArrayList<String> rootList = new ArrayList<String>(10);
            rootList.add("org");
            rootList.add("sup");
            rootList.add("mat");
            typepks.removeAll(rootList);
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("rootnode"), TreeNode.class);
            String rootText = root.getText();
            if (typepks.size() == 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u201c%s\u201d\u3002", (String)"ToleranceSchemeAssignEdit_1", (String)"fi-ap-formplugin", (Object[])new Object[0]), rootText));
                return;
            }
            List<String> queryAssignSchemes = this.queryAssignSchemes();
            ArrayList<String> schemepks = new ArrayList<String>(10);
            for (int i : rows) {
                schemepks.add(grid.getEntryData().getDataEntitys()[i].getString("schemeid"));
            }
            String assigntype = this.getModel().getValue("assigntype").toString();
            ArrayList<DynamicObject> newObjList = new ArrayList<DynamicObject>(10);
            String keyString = "";
            for (String typepk : typepks) {
                for (String schemepk : schemepks) {
                    DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)"ap_tolerance_assign");
                    newObj.set("assigndate", (Object)new Date());
                    newObj.set("assigntype", (Object)assigntype);
                    newObj.set("typepk", (Object)typepk);
                    newObj.set("schemepk", (Object)schemepk);
                    keyString = assigntype + '_' + typepk + '_' + schemepk;
                    if (queryAssignSchemes.contains(keyString)) continue;
                    newObjList.add(newObj);
                }
            }
            Object[] save = SaveServiceHelper.save((DynamicObject[])newObjList.toArray(new DynamicObject[0]));
            if (save.length == newObjList.size()) {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\uff1a\u4e3a\u5f53\u524d\u201c%1$s\u201d\u4e2a\u5206\u914d\u7c7b\u578b\uff0c\u5171\u5206\u914d\u201c%2$s\u201d\u4e2a\u65b9\u6848", (String)"ToleranceSchemeAssignEdit_2", (String)"fi-ap-formplugin", (Object[])new Object[0]), typepks.size(), save.length, 5000));
            }
        }
        if ("assign_query".equals(key)) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("ap_scheme_assign_query");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    public List<String> queryAssignSchemes() {
        ArrayList<String> assignSchemeList = new ArrayList<String>();
        DynamicObject[] assignSchemes = BusinessDataServiceHelper.load((String)"ap_tolerance_assign", (String)"assigntype,typepk,schemepk", null);
        if (assignSchemes != null && assignSchemes.length > 0) {
            for (DynamicObject assignScheme : assignSchemes) {
                StringBuilder keyString = new StringBuilder();
                keyString.append(assignScheme.getString("assigntype")).append('_').append(assignScheme.getString("typepk")).append('_').append(assignScheme.getString("schemepk"));
                assignSchemeList.add(keyString.toString());
            }
        }
        return assignSchemeList;
    }
}

