/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.tolerance;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.operate.bizrule.OpBizRuleType;
import kd.bos.entity.operate.bizrule.OpBizRuleTypeLoader;
import kd.bos.entity.operate.bizrule.OpBizRuleTypes;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;

public class ToleranceServiceRegisterEdit
extends AbstractBillPlugIn {
    private static Map<String, String> ruleMap = new HashMap<String, String>();
    private static Map<String, String> operationMap = new HashMap<String, String>();

    public void afterBindData(EventObject e) {
        this.initOpBizRules();
        DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtype");
        if (billtype != null) {
            this.setOperation();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        switch (key) {
            case "billtype": {
                if (newValue != null) {
                    this.setOperation();
                    break;
                }
                this.getModel().setValue("operationname", null);
                break;
            }
            case "servicetype": {
                if (newValue != null) {
                    String servicetype = (String)this.getModel().getValue("servicetype");
                    this.getModel().setValue("servicetypename", (Object)ruleMap.get(servicetype));
                } else {
                    this.getModel().setValue("servicetypename", null);
                }
            }
            case "operationcode": {
                String[] operationcodes;
                if (newValue == null) break;
                String operationcode = (String)this.getModel().getValue("operationcode");
                StringBuilder builder = new StringBuilder();
                if (operationcode == null) break;
                for (String code : operationcodes = operationcode.substring(1, operationcode.lastIndexOf(44)).split(",")) {
                    builder.append(operationMap.get(code)).append("   ");
                }
                this.getModel().setValue("operationname", (Object)builder.toString());
            }
        }
    }

    private void initOpBizRules() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        OpBizRuleTypes opBizRuleTypes = OpBizRuleTypeLoader.load();
        List rules = opBizRuleTypes.getRuleTypes();
        for (OpBizRuleType rule : rules) {
            ComboItem item = new ComboItem(rule.getName(), rule.getId());
            items.add(item);
            ruleMap.put(rule.getId(), rule.getName().toString());
        }
        ComboEdit edit = (ComboEdit)this.getView().getControl("servicetype");
        edit.setComboItems(items);
    }

    private void setOperation() {
        DynamicObject bill = (DynamicObject)this.getModel().getValue("billtype");
        String entityKey = bill.getString("id");
        LinkedList<ComboItem> operationItems = new LinkedList<ComboItem>();
        List entityOperates = EntityMetadataCache.getDataEntityOperate((String)entityKey);
        for (Map op : entityOperates) {
            String opType = (String)op.get("type");
            if (!OperationTypeCache.isEntityOperation((String)opType)) continue;
            String opKey = (String)op.get("key");
            Map mapLocaleString = (Map)op.get("name");
            String opName = opKey;
            if (mapLocaleString != null) {
                operationMap.put(opKey, LocaleString.fromMap((Map)mapLocaleString).toString());
                opName = LocaleString.fromMap((Map)mapLocaleString).toString() + "(" + opKey + ")";
            }
            ComboItem comboItem = new ComboItem(new LocaleString(opName), opKey);
            operationItems.add(comboItem);
        }
        ComboEdit operationName = (ComboEdit)this.getControl("operationcode");
        operationName.setComboItems(operationItems);
    }
}

