/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.writeback;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;

public class PurInWriteBackByFinApPlugin
extends AbstractWriteBackPlugIn {
    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        e.getFieldKeys().add("billentry.qty");
        e.getFieldKeys().add("billentry.baseqty");
        e.getFieldKeys().add("billentry.remainjoinpriceqty");
        e.getFieldKeys().add("billentry.remainjoinpricebaseqty");
        e.getFieldKeys().add("billentry.joinpriceqty");
        e.getFieldKeys().add("billentry.joinpricebaseqty");
    }

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        super.afterCommitAmount(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String srcBillName = srcSubMainType.getName();
        if (!"im_purreceivebill".equalsIgnoreCase(srcBillName) && !"im_purinbill".equalsIgnoreCase(srcBillName)) {
            return;
        }
        DynamicObject srcActiveRow = e.getSrcActiveRow();
        DynamicObject targetActiveRow = e.getTargetActiveRow();
        if (srcActiveRow == null || targetActiveRow == null) {
            return;
        }
        String srcFieldKey = e.getSrcFieldKey();
        BigDecimal realVal = e.getRealVal();
        BigDecimal currVal = e.getCurrVal();
        boolean isAudit = true;
        if (BigDecimal.ZERO.compareTo(realVal) == 0) {
            isAudit = false;
        }
        if (!isAudit) {
            BigDecimal newJoinPriceBaseQty;
            BigDecimal joinPriceBaseQty;
            if ("joinpriceqty".equals(srcFieldKey)) {
                BigDecimal newJoinPriceQty = srcActiveRow.getBigDecimal("joinpriceqty");
                BigDecimal joinPriceQty = newJoinPriceQty.subtract(currVal);
                if (joinPriceQty.abs().compareTo(currVal.abs()) < 0) {
                    srcActiveRow.set(srcFieldKey, (Object)BigDecimal.ZERO);
                }
            } else if ("joinpricebaseqty".equals(srcFieldKey) && (joinPriceBaseQty = (newJoinPriceBaseQty = srcActiveRow.getBigDecimal("joinpricebaseqty")).subtract(currVal)).abs().compareTo(currVal.abs()) < 0) {
                srcActiveRow.set(srcFieldKey, (Object)BigDecimal.ZERO);
            }
        }
    }
}

