/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.formplugin.writeback;

import java.math.BigDecimal;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class PurOrder2FinApBillWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final String QTY = "qty";
    private static final String BASEUNIT = "baseunit";
    private static final String UNIT = "unit";
    private static final String JOINPAYABLEPRICEQTY = "joinpayablepriceqty";
    private static final String MASTERID = "material";
    private static final String JOINPAYABLEBASEQTY = "joinpayablebaseqty";
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final String CONV_NUMERATOR = "numerator";
    private static final String CONV_DENOMINATOR = "denominator";
    private static final String UNIT_PRECISION = "precision";
    private static final String UNIT_PRECISIONTYPE = "precisionaccount";

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        String opType = this.getOpType();
        if ("pm_purorderbill".equals(e.getSrcMainType().getName()) && ("save".equalsIgnoreCase(opType) || "audit".equalsIgnoreCase(opType) || "unaudit".equalsIgnoreCase(opType))) {
            e.getFieldKeys().add(UNIT);
            e.getFieldKeys().add(JOINPAYABLEPRICEQTY);
            e.getFieldKeys().add(JOINPAYABLEBASEQTY);
            e.getFieldKeys().add(BASEUNIT);
            e.getFieldKeys().add(MASTERID);
            e.getFieldKeys().add(QTY);
        }
    }

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        super.afterCommitAmount(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        if ("pm_purorderbill".equals(srcSubMainType.getName())) {
            DynamicObject srcActiveRow = e.getSrcActiveRow();
            String opType = this.getOpType();
            if (opType == null) {
                return;
            }
            String srcFieldKey = e.getSrcFieldKey();
            if (JOINPAYABLEPRICEQTY.equals(srcFieldKey)) {
                switch (opType.toLowerCase(Locale.ENGLISH)) {
                    case "save": 
                    case "audit": 
                    case "unaudit": {
                        Long masterId;
                        BigDecimal baseQty;
                        DynamicObject baseUnit = srcActiveRow.getDynamicObject(BASEUNIT);
                        DynamicObject unit = srcActiveRow.getDynamicObject(UNIT);
                        BigDecimal joinPayBaseQty = PurOrder2FinApBillWriteBackPlugin.getNotNull(srcActiveRow.getBigDecimal(JOINPAYABLEBASEQTY));
                        BigDecimal joinpayableqty = PurOrder2FinApBillWriteBackPlugin.getNotNull(srcActiveRow.getBigDecimal(JOINPAYABLEPRICEQTY));
                        DynamicObject master = srcActiveRow.getDynamicObject(MASTERID);
                        DynamicObject masterid = master.getDynamicObject("masterid");
                        if (baseUnit == null || masterid == null || unit == null || (baseQty = PurOrder2FinApBillWriteBackPlugin.getDesQtyConv(masterId = (Long)masterid.getPkValue(), unit, joinpayableqty, baseUnit)).compareTo(joinPayBaseQty) == 0) break;
                        srcActiveRow.set(JOINPAYABLEBASEQTY, (Object)baseQty);
                        break;
                    }
                }
            }
        }
    }

    private static BigDecimal getNotNull(Object object) {
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        return ZERO;
    }

    private static BigDecimal getDesQtyConv(Long materialId, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal desQty = ZERO;
        if (materialId != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                desQty = srcQty;
            } else {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
                if (muConv != null) {
                    int numberator = muConv.getInt(CONV_NUMERATOR);
                    int denominator = muConv.getInt(CONV_DENOMINATOR);
                    if (denominator != 0) {
                        desQty = srcQty.multiply(new BigDecimal(numberator)).divide(new BigDecimal(denominator), PurOrder2FinApBillWriteBackPlugin.getPrecision(desUnit), PurOrder2FinApBillWriteBackPlugin.getPrecisionType(desUnit));
                    }
                }
            }
        }
        return desQty;
    }

    private static int getPrecision(DynamicObject unit) {
        int precision = 10;
        if (unit != null) {
            precision = unit.getInt(UNIT_PRECISION);
        }
        return precision;
    }

    private static int getPrecisionType(DynamicObject unit) {
        int precisionType = 4;
        if (unit != null && StringUtils.isNotBlank((Object)unit.get(UNIT_PRECISIONTYPE))) {
            String precisionAccount;
            switch (precisionAccount = unit.getString(UNIT_PRECISIONTYPE)) {
                case "1": {
                    precisionType = 4;
                    break;
                }
                case "2": {
                    precisionType = 1;
                    break;
                }
                case "3": {
                    precisionType = 0;
                    break;
                }
            }
        }
        return precisionType;
    }
}

