/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.api;

import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;

@KSObject
public class LoadRecordApi
implements IBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(LoadRecordApi.class);

    @KSMethod
    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        try {
            String recordEntity = (String)params.get("recordEntity");
            String billId = (String)params.get("billId");
            logger.info("---LoadRecordApi param---- recordEntity = " + recordEntity + ", billId = " + billId);
            if (ObjectUtils.isEmpty((Object)recordEntity) || ObjectUtils.isEmpty((Object)billId)) {
                result = ApiResult.fail((String)"Incomplete parameters");
            } else {
                Long billID = Long.parseLong(billId);
                if ("ap_settlerecord".equals(recordEntity) || "ar_settlerecord".equals(recordEntity)) {
                    QFilter filter = new QFilter("mainbillid", "=", (Object)billID);
                    filter.or(new QFilter("entry.billid", "=", (Object)billID));
                    DynamicObject[] records = BusinessDataServiceHelper.load((String)recordEntity, (String)"billno,mainpayableamt,totalsettleamt,localtotalsettleamt,settlerelation,mainbillid,mainbillentryid,billentity,entry.billnum,entry.payableamt,entry.settleamt,entry.localsettleamt,entry.billid,entry.billentryid,entry.e_billentity", (QFilter[])new QFilter[]{filter});
                    result = ApiResult.success((Object)records);
                } else if ("ap_verifyrecord".equals(recordEntity) || "ar_verifyrecord".equals(recordEntity)) {
                    QFilter filter = new QFilter("billid", "=", (Object)billID);
                    filter.or(new QFilter("entry.e_billid", "=", (Object)billID));
                    DynamicObject[] records = BusinessDataServiceHelper.load((String)recordEntity, (String)"billno,qty,baseqty,verifyqty,verifybaseqty,payableamount,verifyamount,localverifyamt,verifyrelation,billid,billentryid,billtype,entry.e_billno,entry.e_qty,entry.e_baseqty,entry.e_verifyqty,entry.e_verifybaseqty,entry.e_verifyamount,entry.e_localverifyamt,entry.e_billid,entry.e_billentryid,entry.e_billtype", (QFilter[])new QFilter[]{filter});
                    result = ApiResult.success((Object)records);
                }
            }
        }
        catch (Exception e) {
            result = ApiResult.ex((Throwable)e);
        }
        return result;
    }
}

