/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.api.board;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class CapacityBoardSkillRunnable
implements ISkillRunnable {
    private static final Log logger = LogFactory.getLog(CapacityBoardSkillRunnable.class);
    private Integer totalCount = 0;
    private Integer failCount = 0;

    public SkillRunResult pullData(SkillRunContext runContext) {
        ArrayList<Object> queryArgs = new ArrayList<Object>(2);
        queryArgs.add(runContext.getStartTime());
        queryArgs.add(runContext.getEndTime());
        ArrayList<Object> nearlyMonthQueryArgs = new ArrayList<Object>(2);
        nearlyMonthQueryArgs.add(DateUtils.getNextDay(runContext.getStartTime(), -30));
        nearlyMonthQueryArgs.add(runContext.getEndTime());
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(3);
        String skillNum = runContext.getSkillNum();
        logger.info("skillNum:" + skillNum);
        switch (skillNum) {
            case "ysyfjs": {
                this.getSttleSchemeData(list, queryArgs, nearlyMonthQueryArgs, false);
                break;
            }
            case "ysznjs": {
                this.getSttleSchemeData(list, queryArgs, nearlyMonthQueryArgs, true);
                break;
            }
            case "zdfpwctz": {
                this.getInvoiceAutoRepairData(list, queryArgs, nearlyMonthQueryArgs);
                break;
            }
            case "fpcj": {
                this.getInvoiceCollectData(list, queryArgs, nearlyMonthQueryArgs);
            }
        }
        logger.info("totalCount:" + this.totalCount);
        logger.info("failCount:" + this.failCount);
        SkillRunResult skillResult = runContext.getSkillResult();
        skillResult.setData(list);
        skillResult.setDate(runContext.getStartTime());
        skillResult.setSkillNum(skillNum);
        skillResult.setFailCount(this.failCount);
        skillResult.setTotalCount(this.totalCount);
        return skillResult;
    }

    private void getInvoiceCollectData(List<Map<String, String>> list, List<Object> queryArgs, List<Object> nearlyMonthQueryArgs) {
        String sql = "select count(1) as count from t_ap_invoice a left join t_ap_invoice_e b on a.fid=b.fid where a.fisreffin='1' and b.freceivedate >= ? and b.freceivedate <= ?";
        this.totalCount = (Integer)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])queryArgs.toArray(), e -> {
            if (e.next()) {
                return e.getInt("count");
            }
            return 0;
        });
        Integer count = (Integer)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])nearlyMonthQueryArgs.toArray(), e -> {
            if (e.next()) {
                return e.getInt("count");
            }
            return 0;
        });
        HashMap<String, String> param1Map = new HashMap<String, String>(2);
        param1Map.put("number", "fpcjcgbs");
        param1Map.put("name", ResManager.loadKDString((String)"\u53d1\u7968\u91c7\u96c6\u6210\u529f\u7b14\u6570", (String)"CapacityBoardSkillRunnable_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        param1Map.put("value", count.toString());
        param1Map.put("valueType", "0");
        list.add(param1Map);
    }

    private void getInvoiceAutoRepairData(List<Map<String, String>> list, List<Object> queryArgs, List<Object> nearlyMonthQueryArgs) {
        String sql = "select count(1) as count from t_ap_oplog where fopname='afterRepairTailData' and foptime >= ? and foptime <= ?";
        Integer successCount = (Integer)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])queryArgs.toArray(), e -> {
            if (e.next()) {
                return e.getInt("count");
            }
            return 0;
        });
        this.failCount = this.getInvoiceAutoRepairFailCount(queryArgs);
        this.totalCount = successCount + this.failCount;
        Integer nearlyMonthSuccessCount = (Integer)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])nearlyMonthQueryArgs.toArray(), e -> {
            if (e.next()) {
                return e.getInt("count");
            }
            return 0;
        });
        Integer nearlyMonthFailCount = this.getInvoiceAutoRepairFailCount(nearlyMonthQueryArgs);
        HashMap<String, String> param1Map = new HashMap<String, String>(2);
        param1Map.put("number", "zdtcbs");
        param1Map.put("name", ResManager.loadKDString((String)"\u81ea\u52a8\u8c03\u5dee\u7b14\u6570", (String)"CapacityBoardSkillRunnable_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        param1Map.put("value", nearlyMonthSuccessCount.toString());
        param1Map.put("valueType", "0");
        HashMap<String, String> param2Map = new HashMap<String, String>(2);
        param2Map.put("number", "wcgtcbs");
        param2Map.put("name", ResManager.loadKDString((String)"\u672a\u6210\u529f\u8c03\u5dee\u7b14\u6570", (String)"CapacityBoardSkillRunnable_6", (String)"fi-arapcommon", (Object[])new Object[0]));
        param2Map.put("value", nearlyMonthFailCount.toString());
        param2Map.put("valueType", "0");
        list.add(param1Map);
        list.add(param2Map);
    }

    private void getSttleSchemeData(List<Map<String, String>> list, List<Object> queryArgs, List<Object> nearlyMonthQueryArgs, boolean isAr) {
        String apSql = "select count(1) as executecount,sum(b.fsettlerecordcount) as settlerecordcount,sum(b.fmainentrycount) as mainentrycount from t_ap_settlelog a left join t_ap_settlelogentry b on a.fid=b.fid where a.fendtime >= ? and a.fendtime <= ?";
        String arSql = "select count(1) as executecount,sum(b.fsettlerecordcount) as settlerecordcount,sum(b.fmainentrycount) as mainentrycount from t_ar_settlelog a left join t_ar_settlelogentry b on a.fid=b.fid where a.fendtime >= ? and a.fendtime <= ?";
        String sql = isAr ? arSql : apSql;
        Map<String, Integer> settleSchemeInfoMap = this.getSettleSchemeInfoMap(queryArgs, sql);
        String apRpaSql = "select count(1) as executecount,sum(fsettlerecordcount) as settlerecordcount,sum(fmainentrycount) as mainentrycount from t_ap_rpasettlelog where fendtime >= ? and fendtime <= ?";
        String arRpaSql = "select count(1) as executecount,sum(fsettlerecordcount) as settlerecordcount,sum(fmainentrycount) as mainentrycount from t_ar_rpasettlelog where fendtime >= ? and fendtime <= ?";
        String rpaSql = isAr ? arRpaSql : apRpaSql;
        Map<String, Integer> rpaSettleSchemeInfoMap = this.getRpaSettleSchemeInfoMap(queryArgs, rpaSql);
        Integer mainEntryCount = settleSchemeInfoMap.get("mainentrycount") + rpaSettleSchemeInfoMap.get("mainentrycount");
        Integer settleRecordCount = settleSchemeInfoMap.get("settlerecordcount") + rpaSettleSchemeInfoMap.get("settlerecordcount");
        this.totalCount = mainEntryCount;
        this.failCount = mainEntryCount - settleRecordCount;
        Map<String, Integer> nearlyMonthSettleInfoMap = this.getNearlyMonthSettleSchemeInfoMap(nearlyMonthQueryArgs, sql);
        Map<String, Integer> nearlyMonthRpaSettleInfoMap = this.getNearlyMonthRpaSettleSchemeInfoMap(nearlyMonthQueryArgs, rpaSql);
        int nearlyMonthExecuteCount = nearlyMonthSettleInfoMap.get("executecount") + nearlyMonthRpaSettleInfoMap.get("executecount");
        Integer nearlyMonthMainEntryCount = nearlyMonthSettleInfoMap.get("mainentrycount") + nearlyMonthRpaSettleInfoMap.get("mainentrycount");
        Integer nearlyMonthSettleRecordCount = nearlyMonthSettleInfoMap.get("settlerecordcount") + nearlyMonthRpaSettleInfoMap.get("settlerecordcount");
        int nearlyUnSettleCount = nearlyMonthMainEntryCount - nearlyMonthSettleRecordCount;
        HashMap<String, String> param1Map = new HashMap<String, String>(2);
        param1Map.put("number", "zxcs");
        param1Map.put("name", ResManager.loadKDString((String)"\u6267\u884c\u6b21\u6570", (String)"CapacityBoardSkillRunnable_3", (String)"fi-arapcommon", (Object[])new Object[0]));
        param1Map.put("value", Integer.toString(nearlyMonthExecuteCount));
        param1Map.put("valueType", "0");
        HashMap<String, String> param2Map = new HashMap<String, String>(2);
        param2Map.put("number", "jscgbs");
        param2Map.put("name", ResManager.loadKDString((String)"\u7ed3\u7b97\u6210\u529f\u7b14\u6570", (String)"CapacityBoardSkillRunnable_4", (String)"fi-arapcommon", (Object[])new Object[0]));
        param2Map.put("value", nearlyMonthSettleRecordCount.toString());
        param2Map.put("valueType", "0");
        HashMap<String, String> param3Map = new HashMap<String, String>(2);
        param3Map.put("number", "wjsbs");
        param3Map.put("name", ResManager.loadKDString((String)"\u672a\u7ed3\u7b97\u7b14\u6570", (String)"CapacityBoardSkillRunnable_5", (String)"fi-arapcommon", (Object[])new Object[0]));
        param3Map.put("value", Integer.toString(nearlyUnSettleCount));
        param3Map.put("valueType", "0");
        list.add(param1Map);
        list.add(param2Map);
        list.add(param3Map);
    }

    private Integer getInvoiceAutoRepairFailCount(List<Object> queryArgs) {
        QFilter[] queryFilter = new QFilter[]{new QFilter("entry.e_uninvoicedamt", "=", (Object)0), new QFilter("isvoucher", "=", (Object)Boolean.TRUE), new QFilter("createtime", ">=", queryArgs.get(0)), new QFilter("createtime", "<=", queryArgs.get(1))};
        HashSet<Long> needWarnFinArBill = new HashSet<Long>(64);
        DynamicObjectCollection allFinArBill = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,org,entry.id entryId,entry.e_amount e_amount,entry.e_localamt e_localamt", (QFilter[])queryFilter);
        if (EmptyUtils.isNotEmpty(allFinArBill)) {
            Long[] arEntryIdArray = (Long[])allFinArBill.stream().map(finar -> finar.getLong("entryId")).toArray(Long[]::new);
            List<Long> finArOrgIds = allFinArBill.stream().map(finar -> finar.getLong("org")).distinct().collect(Collectors.toList());
            Map<Long, Object> ar026Map = SystemParameterHelper.batchGetAppParameter(Boolean.TRUE, finArOrgIds, "ar_026");
            Map<Long, Set<Long>> targetRowIdsMap = BOTPHelper.loadTargetRowIdsMap("ar_finarbill", "entry", arEntryIdArray, "sim_original_bill");
            Map<Long, DynamicObject> simEntryObjMap = this.prepareSimBills(targetRowIdsMap);
            if (EmptyUtils.isNotEmpty(simEntryObjMap)) {
                for (DynamicObject finAr : allFinArBill) {
                    Set<Long> simEntryIds = targetRowIdsMap.get(finAr.getLong("entryId"));
                    Object ar026 = ar026Map.get(finAr.getLong("org"));
                    if (EmptyUtils.isEmpty(simEntryIds) || ar026 == null || !((Boolean)ar026).booleanValue()) continue;
                    BigDecimal hasOpenInvAmt = BigDecimal.ZERO;
                    BigDecimal hasOpenInvLocAmt = BigDecimal.ZERO;
                    for (Long simEntryId : simEntryIds) {
                        DynamicObject simEntry = simEntryObjMap.get(simEntryId);
                        if (simEntry == null) continue;
                        hasOpenInvAmt = hasOpenInvAmt.add(simEntry.getBigDecimal("issuedamount"));
                        hasOpenInvLocAmt = hasOpenInvLocAmt.add(simEntry.getBigDecimal("fromissuedamount"));
                    }
                    if (hasOpenInvAmt.compareTo(finAr.getBigDecimal("e_amount")) == 0 && hasOpenInvLocAmt.compareTo(finAr.getBigDecimal("e_localamt")) == 0) continue;
                    needWarnFinArBill.add(finAr.getLong("id"));
                }
            }
        }
        return needWarnFinArBill.size();
    }

    private Map<Long, DynamicObject> prepareSimBills(Map<Long, Set<Long>> targetRowIdsMap) {
        if (EmptyUtils.isEmpty(targetRowIdsMap)) {
            return null;
        }
        Set simBillEntryId = targetRowIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        DynamicObjectCollection simBillEntry = QueryServiceHelper.query((String)"sim_original_bill", (String)"sim_original_bill_item.id entryId,sim_original_bill_item.issuedamount issuedamount,sim_original_bill_item.fromissuedamount fromissuedamount", (QFilter[])new QFilter[]{new QFilter("sim_original_bill_item.id", "in", simBillEntryId)});
        return simBillEntry.stream().collect(Collectors.toMap(sim -> sim.getLong("entryId"), sim -> sim));
    }

    private Map<String, Integer> getSettleSchemeInfoMap(List<Object> queryArgs, String sql) {
        return (Map)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])queryArgs.toArray(), e -> {
            HashMap<String, Integer> settleInfo = new HashMap<String, Integer>(2);
            while (e.next()) {
                settleInfo.put("executecount", e.getInt("executecount"));
                settleInfo.put("settlerecordcount", e.getInt("settlerecordcount"));
                settleInfo.put("mainentrycount", e.getInt("mainentrycount"));
            }
            return settleInfo;
        });
    }

    private Map<String, Integer> getRpaSettleSchemeInfoMap(List<Object> queryArgs, String sql) {
        return (Map)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])queryArgs.toArray(), e -> {
            HashMap<String, Integer> settleInfo = new HashMap<String, Integer>(2);
            while (e.next()) {
                settleInfo.put("executecount", e.getInt("executecount"));
                settleInfo.put("settlerecordcount", e.getInt("settlerecordcount"));
                settleInfo.put("mainentrycount", e.getInt("mainentrycount"));
            }
            return settleInfo;
        });
    }

    private Map<String, Integer> getNearlyMonthSettleSchemeInfoMap(List<Object> nearlyMonthQueryArgs, String sql) {
        return (Map)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])nearlyMonthQueryArgs.toArray(), e -> {
            HashMap<String, Integer> settleInfo = new HashMap<String, Integer>(2);
            while (e.next()) {
                settleInfo.put("executecount", e.getInt("executecount"));
                settleInfo.put("settlerecordcount", e.getInt("settlerecordcount"));
                settleInfo.put("mainentrycount", e.getInt("mainentrycount"));
            }
            return settleInfo;
        });
    }

    private Map<String, Integer> getNearlyMonthRpaSettleSchemeInfoMap(List<Object> nearlyMonthQueryArgs, String sql) {
        return (Map)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])nearlyMonthQueryArgs.toArray(), e -> {
            HashMap<String, Integer> settleInfo = new HashMap<String, Integer>(2);
            while (e.next()) {
                settleInfo.put("executecount", e.getInt("executecount"));
                settleInfo.put("settlerecordcount", e.getInt("settlerecordcount"));
                settleInfo.put("mainentrycount", e.getInt("mainentrycount"));
            }
            return settleInfo;
        });
    }
}

