/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.api.freeze;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.api.freeze.IFreezeService;
import kd.fi.arapcommon.api.param.FreezeParam;
import kd.fi.arapcommon.vo.FreezeLogVo;

public abstract class AbstractBillFrezzeService
implements IFreezeService {
    protected static final Log logger = LogFactory.getLog(AbstractBillFrezzeService.class);

    @Override
    public void freeze(List<FreezeParam> params, boolean freeze) {
        if (params.size() == 0) {
            return;
        }
        try (TXHandle tx = TX.required((String)"freeze");){
            try {
                logger.info("----freeze\u51bb\u7ed3\u5f00\u59cb----");
                DynamicObject[] freezeBills = this.loadNeedFreezeBills(params);
                List<DynamicObject> freezeLogDyns = this.upDataBillFreezeStatusAndbulidFreezeLogVo(params, freezeBills, freeze);
                SaveServiceHelper.update((DynamicObject[])freezeBills);
                SaveServiceHelper.save((DynamicObject[])freezeLogDyns.toArray(new DynamicObject[0]));
                logger.info("----freeze\u51bb\u7ed3\u5b8c\u6210----");
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public List<DynamicObject> convertVoToDyn(List<FreezeLogVo> freezeLogVos) {
        ArrayList<DynamicObject> freezeDyns = new ArrayList<DynamicObject>(16);
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        for (FreezeLogVo vo : freezeLogVos) {
            DynamicObject freezeDyn = BusinessDataServiceHelper.newDynamicObject((String)"ap_freezelog");
            freezeDyn.set("billstatus", (Object)"A");
            freezeDyn.set("creator", (Object)userId);
            freezeDyn.set("optime", (Object)new Date());
            freezeDyn.set("billtype", (Object)vo.getBillType());
            freezeDyn.set("billno", (Object)vo.getBillNo());
            freezeDyn.set("asstacttype", (Object)vo.getAsstactType());
            freezeDyn.set("asstact", (Object)vo.getAsstactId());
            freezeDyn.set("org", (Object)vo.getOrg());
            freezeDyn.set("billid", (Object)vo.getBillId());
            freezeDyn.set("businessop", (Object)vo.getBusinessOp());
            freezeDyn.set("oprange", (Object)vo.getOpRange());
            freezeDyn.set("freezereason", (Object)vo.getFreezeReason());
            freezeDyn.set("optype", (Object)vo.getOpType());
            if (vo.getBillEntryId() != null) {
                freezeDyn.set("billentryid", (Object)vo.getBillEntryId());
                freezeDyn.set("lineno", (Object)vo.getLineNo());
            }
            freezeDyns.add(freezeDyn);
        }
        return freezeDyns;
    }

    public void setBillFreezeStatus(DynamicObject bill, boolean freeze) {
        String entryName = this.getEntryName();
        DynamicObjectCollection entry = bill.getDynamicObjectCollection(entryName);
        if (freeze) {
            boolean hadUnFreezeEntry = false;
            for (DynamicObject row : entry) {
                String freezeStatus = row.getString("e_freezestate");
                if (!"unfreeze".equals(freezeStatus)) continue;
                hadUnFreezeEntry = true;
                break;
            }
            bill.set("freezestate", (Object)(hadUnFreezeEntry ? "partfreeze" : "allfreeze"));
        } else {
            boolean hadFreezeEntry = false;
            for (DynamicObject row : entry) {
                String freezeStatus = row.getString("e_freezestate");
                if (!"allfreeze".equals(freezeStatus)) continue;
                hadFreezeEntry = true;
                break;
            }
            bill.set("freezestate", (Object)(hadFreezeEntry ? "partfreeze" : "unfreeze"));
        }
    }

    protected abstract String getEntryName();

    protected abstract DynamicObject[] loadNeedFreezeBills(List<FreezeParam> var1);

    protected abstract List<DynamicObject> upDataBillFreezeStatusAndbulidFreezeLogVo(List<FreezeParam> var1, DynamicObject[] var2, boolean var3);
}

