/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.api.helper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.util.DateUtils;

public class CustomerArBalanceQuerier {
    private long orgId;
    private long asstactId;
    private long currencyId;
    BigDecimal finBalance = BigDecimal.ZERO;
    BigDecimal finBalancecontainsUnAudit = BigDecimal.ZERO;
    BigDecimal busBalance = BigDecimal.ZERO;
    BigDecimal overdueFinBalance = BigDecimal.ZERO;
    BigDecimal receivedBalance = BigDecimal.ZERO;

    public CustomerArBalanceQuerier() {
    }

    public CustomerArBalanceQuerier(long orgId, long asstactId, long currencyId) {
        this.orgId = orgId;
        this.asstactId = asstactId;
        this.currencyId = currencyId;
    }

    public JSONObject queryArBalance() {
        this.queryFinBill();
        this.queryBusBill();
        this.queryReceivedBill();
        this.queryRecBill();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orgid", (Object)this.orgId);
        jsonObject.put("asstactid", (Object)this.asstactId);
        jsonObject.put("currencyid", (Object)this.currencyId);
        jsonObject.put("finbalance", (Object)this.finBalance);
        jsonObject.put("finbalancecontainsunaudit", (Object)this.finBalancecontainsUnAudit);
        jsonObject.put("finandbusbalance", (Object)this.finBalance.add(this.busBalance));
        jsonObject.put("overduefinbalance", (Object)this.overdueFinBalance);
        jsonObject.put("receivedbalance", (Object)this.receivedBalance);
        return jsonObject;
    }

    private void queryFinBill() {
        QFilter orgFilter = new QFilter("org", "=", (Object)this.orgId);
        QFilter asstactFilter = new QFilter("asstact", "=", (Object)this.asstactId);
        QFilter currencyFilter = new QFilter("currency", "=", (Object)this.currencyId);
        QFilter settleStatusFilter = new QFilter("settlestatus", "in", Arrays.asList("unsettle", "partsettle"));
        DataSet finBills = QueryServiceHelper.queryDataSet((String)"CustomerArBalanceQuerier.queryFinBill", (String)"ar_finarbill", (String)"billstatus,duedate,unsettleamount", (QFilter[])new QFilter[]{orgFilter, asstactFilter, currencyFilter, settleStatusFilter}, null);
        Date newDate = DateUtils.getDataFormat(new Date(), true);
        for (Row finBill : finBills) {
            BigDecimal unsettleAmt = finBill.getBigDecimal("unsettleamount");
            this.finBalancecontainsUnAudit = this.finBalancecontainsUnAudit.add(unsettleAmt);
            if (!"C".equals(finBill.getString("billstatus"))) continue;
            this.finBalance = this.finBalance.add(unsettleAmt);
            Date dueDate = finBill.getDate("duedate");
            if ((dueDate = DateUtils.getDataFormat(dueDate, true)).compareTo(newDate) > 0) continue;
            this.overdueFinBalance = this.overdueFinBalance.add(unsettleAmt);
        }
    }

    private void queryBusBill() {
        QFilter orgFilter = new QFilter("org", "=", (Object)this.orgId);
        QFilter asstactFilter = new QFilter("asstact", "=", (Object)this.asstactId);
        QFilter currencyFilter = new QFilter("currency", "=", (Object)this.currencyId);
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter unwoffAmtFilter = new QFilter("unwoffamt", "<>", (Object)BigDecimal.ZERO);
        QFilter isadjustFilter = new QFilter("isadjust", "=", (Object)Boolean.FALSE);
        DataSet busBills = QueryServiceHelper.queryDataSet((String)"CustomerArBalanceQuerier.queryBusBill", (String)"ar_busbill", (String)"asstact,unwoffamt", (QFilter[])new QFilter[]{orgFilter, asstactFilter, currencyFilter, billStatusFilter, unwoffAmtFilter, isadjustFilter}, null);
        busBills = busBills.groupBy(new String[]{"asstact"}).sum("unwoffamt").finish();
        for (Row busBill : busBills) {
            this.busBalance = this.busBalance.add(busBill.getBigDecimal("unwoffamt"));
        }
    }

    private void queryReceivedBill() {
        QFilter orgFilter = new QFilter("org", "=", (Object)this.orgId);
        QFilter asstactFilter = new QFilter("asstact", "=", (Object)this.asstactId);
        QFilter currencyFilter = new QFilter("currency", "=", (Object)this.currencyId);
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter recTypeFilter = new QFilter("rectype.ispartreceivable", "=", (Object)Boolean.TRUE);
        QFilter unsettledAmtFilter = new QFilter("entry.e_unsettledamt", "<>", (Object)0);
        DataSet receivedBills = QueryServiceHelper.queryDataSet((String)"CustomerArBalanceQuerier.queryReceivedBill", (String)"ar_receivedbill", (String)"asstact,entry.e_unsettledamt", (QFilter[])new QFilter[]{orgFilter, asstactFilter, currencyFilter, billStatusFilter, recTypeFilter, unsettledAmtFilter}, null);
        receivedBills = receivedBills.groupBy(new String[]{"asstact"}).sum("entry.e_unsettledamt").finish();
        for (Row receivedBill : receivedBills) {
            this.receivedBalance = this.receivedBalance.add(receivedBill.getBigDecimal("entry.e_unsettledamt"));
        }
    }

    private void queryRecBill() {
        QFilter orgFilter = new QFilter("entry.e_settleorg", "=", (Object)this.orgId);
        QFilter asstactFilter = new QFilter("payer", "=", (Object)this.asstactId);
        QFilter currencyFilter = new QFilter("currency", "=", (Object)this.currencyId);
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"D");
        QFilter receivingTypeFilter = new QFilter("receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE);
        QFilter unsettledAmtFilter = new QFilter("entry.e_unsettledamt", "<>", (Object)0);
        DataSet recBills = QueryServiceHelper.queryDataSet((String)"CustomerArBalanceQuerier.queryRecBill", (String)"cas_recbill", (String)"payer,entry.e_unsettledamt", (QFilter[])new QFilter[]{orgFilter, asstactFilter, currencyFilter, billStatusFilter, receivingTypeFilter, unsettledAmtFilter}, null);
        recBills = recBills.groupBy(new String[]{"payer"}).sum("entry.e_unsettledamt").finish();
        for (Row recBill : recBills) {
            this.receivedBalance = this.receivedBalance.add(recBill.getBigDecimal("entry.e_unsettledamt"));
        }
    }
}

