/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.api.push;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.api.param.AssignBillPushParam;
import kd.fi.arapcommon.api.param.BillHeadAmtParam;
import kd.fi.arapcommon.api.push.AbstractPushBillService;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.model.LiquidationBillModel;

@KSObject
public abstract class AbstractPushLiquidationService
extends AbstractPushBillService {
    protected LiquidationBillModel LiquidationBillModel = new LiquidationBillModel();

    @Override
    @KSMethod
    public List<Object> assignBillEntryPush(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId) {
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u6e05\u9879\u6e05\u7406\u5355\u6682\u4e0d\u652f\u6301\u6307\u5b9a\u5206\u5f55\u4e0b\u63a8\u3002", (String)"AbstractPushLiquidationService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    @Override
    protected List<BillHeadAmtParam> reCalculateEntryField(List<DynamicObject> targetBills, List<AssignBillPushParam> paramList) {
        ArrayList<BillHeadAmtParam> billHeadAmtParamList = new ArrayList<BillHeadAmtParam>(targetBills.size());
        for (DynamicObject targetBill : targetBills) {
            BillHeadAmtParam billHeadAmtParam = new BillHeadAmtParam(targetBill.getLong("id"));
            String quotation = targetBill.getString(this.LiquidationBillModel.HEAD_QUOTATION);
            int baseCurrencyPrecision = targetBill.getInt(this.LiquidationBillModel.HEAD_BASECURRENCY + ".amtprecision");
            BigDecimal exchangerate = targetBill.getBigDecimal(this.LiquidationBillModel.HEAD_EXCHANGERATE);
            DynamicObjectCollection targetBillEntries = targetBill.getDynamicObjectCollection(this.getTargetEntryEntity());
            for (DynamicObject targetBillEntry : targetBillEntries) {
                BigDecimal liquidationamt = targetBillEntry.getBigDecimal(this.LiquidationBillModel.E_LIQUIDATIONAMT);
                BigDecimal liquidationlocalamt = this.getLocalAmt(liquidationamt, quotation, exchangerate, baseCurrencyPrecision);
                targetBillEntry.set(this.LiquidationBillModel.E_LIQUIDATIONLOCALAMT, (Object)liquidationlocalamt);
                billHeadAmtParam.setPriceTaxTotalLocal(billHeadAmtParam.getPriceTaxTotalLocal().add(liquidationlocalamt));
            }
            billHeadAmtParamList.add(billHeadAmtParam);
        }
        return billHeadAmtParamList;
    }

    @Override
    protected List<String> canModifyFields() {
        ArrayList<String> canModifyFields = new ArrayList<String>();
        canModifyFields.add(this.LiquidationBillModel.HEAD_BIZDATE);
        canModifyFields.add(this.LiquidationBillModel.HEAD_EXCHANGERATE);
        canModifyFields.add(this.LiquidationBillModel.HEAD_REMARK);
        Map<String, List<String>> sdkExtendFieldMap = BizExtendHelper.invoicePushAssignFieldCallback();
        List extendFieldList = sdkExtendFieldMap.getOrDefault(this.getServiceName(), new ArrayList(2));
        canModifyFields.addAll(extendFieldList);
        return canModifyFields;
    }

    @Override
    protected void resetHeadAmtField(DynamicObject targetBill, BillHeadAmtParam billHeadAmtParam) {
        targetBill.set(this.LiquidationBillModel.HEAD_LIQUIDATIONLOCALAMT, (Object)billHeadAmtParam.getPriceTaxTotalLocal());
    }

    @Override
    protected List<Object> saveTargetBills(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId, List<DynamicObject> targetBills) {
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"submit", (String)this.getTargetEntity(), (DynamicObject[])targetBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(saveResult);
        return saveResult.getSuccessPkIds();
    }

    protected BigDecimal getLocalAmt(BigDecimal amount, String quotation, BigDecimal exchange, int precision) {
        if ("1".equals(quotation)) {
            return amount.divide(exchange, precision, RoundingMode.HALF_UP);
        }
        return amount.multiply(exchange).setScale(precision, RoundingMode.HALF_UP);
    }
}

