/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.api.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.fi.arapcommon.api.helper.ServiceCheckHelper;
import kd.fi.arapcommon.api.param.AssignSettleParam;
import kd.fi.arapcommon.api.param.BaseSettleParam;
import kd.fi.arapcommon.api.param.NoAssignSettleParam;
import kd.fi.arapcommon.api.param.ServiceNameEnum;
import kd.fi.arapcommon.api.param.SettleDetailParam;
import kd.fi.arapcommon.api.param.SettleResult;
import kd.fi.arapcommon.api.settle.ISettleService;
import kd.fi.arapcommon.api.settle.IUpdateSettleDateService;
import kd.fi.arapcommon.enums.SettleDetailTypeEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.exception.SettleServiceBizException;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.service.helper.SettleLogHelper;
import kd.fi.arapcommon.service.log.OpLogInfo;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public abstract class AbstractSettleService
implements ISettleService {
    @Override
    public SettleResult settle(long orgId, long mainBillId, long asstBillId) {
        return this.settle(orgId, mainBillId, "", asstBillId);
    }

    @Override
    public SettleResult settle(long orgId, long mainBillId, String asstEntity, long asstBillId) {
        return this.settle(orgId, "", mainBillId, asstEntity, asstBillId);
    }

    @Override
    public SettleResult settle(long orgId, String mainEntity, long mainBillId, String asstEntity, long asstBillId) {
        NoAssignSettleParam param = new NoAssignSettleParam(orgId, SettleTypeEnum.AUTO.getValue());
        param.setMainEntity(mainEntity);
        param.getMainBillIds().add(mainBillId);
        param.setAsstEntity(asstEntity);
        param.getAsstBillIds().add(asstBillId);
        return this.settle(param);
    }

    @Override
    public SettleResult settle(long orgId, Set<Long> mainBillIdSet, Set<Long> asstBillIdSet) {
        return this.settle(orgId, "", mainBillIdSet, "", asstBillIdSet);
    }

    @Override
    public SettleResult settle(long orgId, Set<Long> mainBillIdSet, String asstEntity, Set<Long> asstBillIdSet) {
        return this.settle(orgId, "", mainBillIdSet, asstEntity, asstBillIdSet);
    }

    @Override
    public SettleResult settle(long orgId, String mainEntity, Set<Long> mainBillIdSet, String asstEntity, Set<Long> asstBillIdSet) {
        NoAssignSettleParam param = new NoAssignSettleParam(orgId, SettleTypeEnum.AUTO.getValue());
        param.setMainEntity(mainEntity);
        param.setMainBillIds(mainBillIdSet);
        param.setAsstEntity(asstEntity);
        param.setAsstBillIds(asstBillIdSet);
        return this.settle(param);
    }

    @Override
    public SettleResult settle(NoAssignSettleParam param) {
        this.checkNoAssignParam(param);
        Set<Long> mainBillIds = param.getMainBillIds();
        Set<Long> asstBillIds = param.getAsstBillIds();
        this.checkBaseParam(param, mainBillIds, asstBillIds);
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"settle");){
            CommonSettleServiceHelper.settleAddMutexCtrlInTX(mainBillIds, param.getMainEntity(), asstBillIds, param.getAsstEntity(), param.isLockWait());
            SettleResult result = this.doSettle(param);
            this.afterSettle(param, result);
            SettleResult settleResult = result;
            return settleResult;
        }
        catch (Throwable e) {
            try {
                tx.markRollback();
                this.logSettleException(param, e);
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public SettleResult assignSettle(long orgId, long mainBillId, BigDecimal mainSettleAmt, long asstBillId, BigDecimal asstSettleAmt) {
        return this.assignSettle(orgId, mainBillId, mainSettleAmt, "", asstBillId, asstSettleAmt);
    }

    @Override
    public SettleResult assignSettle(long orgId, long mainBillId, BigDecimal mainSettleAmt, String asstEntity, long asstBillId, BigDecimal asstSettleAmt) {
        return this.assignSettle(orgId, "", mainBillId, mainSettleAmt, asstEntity, asstBillId, asstSettleAmt);
    }

    @Override
    public SettleResult assignSettle(long orgId, String mainEntity, long mainBillId, BigDecimal mainSettleAmt, String asstEntity, long asstBillId, BigDecimal asstSettleAmt) {
        AssignSettleParam param = new AssignSettleParam(orgId, SettleTypeEnum.AUTO.getValue(), SettleDetailTypeEnum.BYHEAD.getValue());
        param.setMainEntity(mainEntity);
        param.getMainDetailParamList().add(new SettleDetailParam(mainBillId, mainSettleAmt));
        param.setAsstEntity(asstEntity);
        param.getAsstDetailParamList().add(new SettleDetailParam(asstBillId, asstSettleAmt));
        return this.assignSettle(param);
    }

    @Override
    public SettleResult assignSettle(long orgId, long mainBillId, long mainBillEntryId, BigDecimal mainSettleAmt, long asstBillId, long asstBillEntryId, BigDecimal asstSettleAmt) {
        return this.assignSettle(orgId, mainBillId, mainBillEntryId, mainSettleAmt, "", asstBillId, asstBillEntryId, asstSettleAmt);
    }

    @Override
    public SettleResult assignSettle(long orgId, long mainBillId, long mainBillEntryId, BigDecimal mainSettleAmt, String asstEntity, long asstBillId, long asstBillEntryId, BigDecimal asstSettleAmt) {
        return this.assignSettle(orgId, "", mainBillId, mainBillEntryId, mainSettleAmt, asstEntity, asstBillId, asstBillEntryId, asstSettleAmt);
    }

    @Override
    public SettleResult assignSettle(long orgId, String mainEntity, long mainBillId, long mainBillEntryId, BigDecimal mainSettleAmt, String asstEntity, long asstBillId, long asstBillEntryId, BigDecimal asstSettleAmt) {
        AssignSettleParam param = new AssignSettleParam(orgId, SettleTypeEnum.AUTO.getValue(), SettleDetailTypeEnum.BYENTRY.getValue());
        param.setMainEntity(mainEntity);
        param.getMainDetailParamList().add(new SettleDetailParam(mainBillId, mainBillEntryId, mainSettleAmt));
        param.setAsstEntity(asstEntity);
        param.getAsstDetailParamList().add(new SettleDetailParam(asstBillId, asstBillEntryId, asstSettleAmt));
        return this.assignSettle(param);
    }

    @Override
    public SettleResult assignSettle(AssignSettleParam param) {
        this.checkAssignParam(param);
        List<SettleDetailParam> mainDetailParamList = param.getMainDetailParamList();
        List<SettleDetailParam> asstDetailParamList = param.getAsstDetailParamList();
        Set<Long> mainBillIds = mainDetailParamList.stream().map(SettleDetailParam::getBillId).collect(Collectors.toSet());
        Set<Long> asstBillIds = asstDetailParamList.stream().map(SettleDetailParam::getBillId).collect(Collectors.toSet());
        this.checkBaseParam(param, mainBillIds, asstBillIds);
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"assignSettle");){
            if (!param.isNotNeedLock()) {
                CommonSettleServiceHelper.settleAddMutexCtrlInTX(mainBillIds, param.getMainEntity(), asstBillIds, param.getAsstEntity(), param.isLockWait());
                if (param.isContainPre()) {
                    String asstEntity = "appaysettle".equals(param.getAsstEntity()) ? "ap_paidbill" : "ar_receivedbill";
                    CommonSettleServiceHelper.settleAddMutexCtrlInTX(mainBillIds, param.getMainEntity(), asstBillIds, asstEntity, param.isLockWait());
                }
            }
            SettleResult result = this.doAssignSettle(param);
            this.afterSettle(param, result);
            SettleResult settleResult = result;
            return settleResult;
        }
        catch (Throwable e) {
            try {
                tx.markRollback();
                this.logSettleException(param, e);
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected void checkNoAssignParam(NoAssignSettleParam param) {
        if (param == null || ObjectUtils.isEmpty(param.getMainBillIds()) || ObjectUtils.isEmpty(param.getAsstBillIds())) {
            throw new SettleServiceBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u53c2\u6570\u4ee5\u53ca\u4e3b\u8f85\u65b9\u5355\u636e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractSettleService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    protected void checkAssignParam(AssignSettleParam param) {
        if (param == null || ObjectUtils.isEmpty(param.getMainDetailParamList()) || ObjectUtils.isEmpty(param.getAsstDetailParamList())) {
            throw new SettleServiceBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u53c2\u6570\u4ee5\u53ca\u4e3b\u8f85\u65b9\u5355\u636e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractSettleService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        List<SettleDetailParam> mainDetailParamList = param.getMainDetailParamList();
        Optional<SettleDetailParam> mainZeroOptional = mainDetailParamList.stream().filter(settleDetailParam -> settleDetailParam.getSettleAmt().compareTo(BigDecimal.ZERO) == 0).findFirst();
        if (mainZeroOptional.isPresent()) {
            throw new SettleServiceBizException(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u4f20\u5165\u7684\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"AbstractSettleService_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        List<SettleDetailParam> asstDetailParamList = param.getAsstDetailParamList();
        Optional<SettleDetailParam> asstZeroOptional = asstDetailParamList.stream().filter(settleDetailParam -> settleDetailParam.getSettleAmt().compareTo(BigDecimal.ZERO) == 0).findFirst();
        if (asstZeroOptional.isPresent()) {
            throw new SettleServiceBizException(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u4f20\u5165\u7684\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"AbstractSettleService_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    protected void checkAssignAmtDirection(AssignSettleParam param) {
        List<SettleDetailParam> mainDetailParamList = param.getMainDetailParamList();
        List<SettleDetailParam> asstDetailParamList = param.getAsstDetailParamList();
        Optional<SettleDetailParam> mainErrorParam = mainDetailParamList.stream().filter(detailParam -> detailParam.getSettleAmt().compareTo(BigDecimal.ZERO) < 0).findFirst();
        if (mainErrorParam.isPresent()) {
            throw new SettleServiceBizException(ResManager.loadKDString((String)"\u7ea2\u84dd\u5bf9\u51b2\u7ed3\u7b97\u5173\u7cfb\u4e3b\u65b9\u6307\u5b9a\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"AbstractSettleService_3", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        Optional<SettleDetailParam> asstErrorParam = asstDetailParamList.stream().filter(detailParam -> detailParam.getSettleAmt().compareTo(BigDecimal.ZERO) > 0).findFirst();
        if (asstErrorParam.isPresent()) {
            throw new SettleServiceBizException(ResManager.loadKDString((String)"\u7ea2\u84dd\u5bf9\u51b2\u7ed3\u7b97\u5173\u7cfb\u8f85\u65b9\u6307\u5b9a\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e0\u3002", (String)"AbstractSettleService_4", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    protected void checkBaseParam(BaseSettleParam param, Set<Long> mainBillIds, Set<Long> asstBillIds) {
        String asstEntity;
        long asstPreCurrencyId;
        if (StringUtils.isEmpty((CharSequence)param.getMainEntity())) {
            param.setMainEntity(this.getMainEntity());
        }
        if (StringUtils.isEmpty((CharSequence)param.getAsstEntity())) {
            param.setAsstEntity(this.getAsstEntity());
        }
        if (param.isOnlyByCoreBill() || param.isOnlyByConBill() || param instanceof NoAssignSettleParam && ((NoAssignSettleParam)param).isOnlyByBotp() || param.isClaim()) {
            return;
        }
        ServiceCheckHelper.checkOrg(param.getOrgId());
        ServiceCheckHelper.checkOrgEqual(param.getOrgId(), param.getMainEntity(), mainBillIds);
        ServiceCheckHelper.checkOrgEqual(param.getOrgId(), param.getAsstEntity(), asstBillIds);
        if (param.isContainPre()) {
            String asstEntity2 = "cas_paybill".equals(param.getAsstEntity()) ? "ap_paidbill" : "ar_receivedbill";
            ServiceCheckHelper.checkOrgEqual(param.getOrgId(), asstEntity2, asstBillIds);
        }
        long mainCurrencyId = ServiceCheckHelper.checkCurrencyEqual(param.getMainEntity(), mainBillIds);
        long asstCurrencyId = ServiceCheckHelper.checkCurrencyEqual(param.getAsstEntity(), asstBillIds);
        if (param.isContainPre() && asstCurrencyId != (asstPreCurrencyId = ServiceCheckHelper.checkCurrencyEqual(asstEntity = "cas_paybill".equals(param.getAsstEntity()) ? "ap_paidbill" : "ar_receivedbill", asstBillIds))) {
            throw new SettleServiceBizException(ResManager.loadKDString((String)"\u540c\u4e00\u65b9\u5355\u636e\u7684\u5e01\u79cd\u5fc5\u987b\u4e00\u81f4\u3002", (String)"AbstractSettleService_9", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (param.isDiffCurrencySettle()) {
            if (mainCurrencyId == asstCurrencyId) {
                throw new SettleServiceBizException(ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u4e3a\u5f02\u5e01\u79cd\u7ed3\u7b97\uff0c\u4f46\u662f\u4e3b\u8f85\u65b9\u5355\u636e\u5e01\u79cd\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractSettleService_7", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        } else if (mainCurrencyId != asstCurrencyId) {
            throw new SettleServiceBizException(ResManager.loadKDString((String)"\u4e3b\u8f85\u65b9\u5355\u636e\u5e01\u79cd\u4e0d\u540c\uff0c\u4f46\u662f\u53c2\u6570\u672a\u8bbe\u7f6e\u5f02\u5e01\u79cd\u7ed3\u7b97\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractSettleService_8", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    protected SettleResult doSettle(NoAssignSettleParam settleParam) {
        DynamicObject[] mains = this.getMainBills(settleParam, settleParam.getMainBillIds());
        DynamicObject[] assts = this.getAsstBills(settleParam, settleParam.getAsstBillIds());
        this.checkBillNotNull(mains, assts);
        SettleSchemeVO scheme = settleParam.genSchemeVO();
        AbstractSettleTemplate service = this.getService();
        service.settle(mains, assts, scheme, settleParam.getSettleType());
        SettleResult result = new SettleResult();
        result.setSettleRecordPKs(scheme.getRecordPks());
        return result;
    }

    protected SettleResult doAssignSettle(AssignSettleParam assignSettleParam) {
        Set<Long> mainBillIds = assignSettleParam.getMainDetailParamList().stream().map(SettleDetailParam::getBillId).collect(Collectors.toSet());
        Set<Long> asstBillIds = assignSettleParam.getAsstDetailParamList().stream().map(SettleDetailParam::getBillId).collect(Collectors.toSet());
        DynamicObject[] mains = this.getMainBills(assignSettleParam, mainBillIds);
        DynamicObject[] assts = this.getAsstBills(assignSettleParam, asstBillIds);
        this.checkBillNotNull(mains, assts);
        int settleModel = this.getSettleModel(assignSettleParam.getMainEntity(), assignSettleParam.getOrgId());
        this.processMainBillByDetailParam(assignSettleParam, mains, assignSettleParam.getMainDetailParamList(), settleModel);
        this.processBillField(mains, assignSettleParam.getMainDetailParamList());
        this.processAsstBillByDetailParam(assignSettleParam, assts, assignSettleParam.getAsstDetailParamList(), settleModel);
        this.processBillField(assts, assignSettleParam.getAsstDetailParamList());
        SettleSchemeVO scheme = assignSettleParam.genSchemeVO();
        scheme.setSettleEntryParam(settleModel);
        List<BillSettleVO> mainList = this.getMainSettleVOList(mains, scheme);
        List<BillSettleVO> asstList = this.getAsstSettleVOList(assts, scheme);
        this.checkBillNotNull(mainList, asstList);
        this.processMatchField(mainList, assignSettleParam.getMainDetailParamList());
        this.processMatchField(asstList, assignSettleParam.getAsstDetailParamList());
        AbstractSettleTemplate service = this.getService();
        service.settleByVO(mainList, asstList, scheme, assignSettleParam.getSettleType());
        SettleResult result = new SettleResult();
        result.setSettleRecordPKs(scheme.getRecordPks());
        return result;
    }

    protected void processBillField(DynamicObject[] bills, List<SettleDetailParam> detailParamList) {
        if (ObjectUtils.isEmpty((Object[])bills) || ObjectUtils.isEmpty(detailParamList)) {
            return;
        }
        List paramListWithField = detailParamList.stream().filter(param -> param.getBillFieldValueMap() != null).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(paramListWithField)) {
            return;
        }
        for (DynamicObject bill : bills) {
            long id = bill.getLong("id");
            Optional<SettleDetailParam> optional = paramListWithField.stream().filter(param -> param.getBillId() == id).findAny();
            if (!optional.isPresent()) continue;
            SettleDetailParam settleDetailParam = optional.get();
            Map<String, Object> billFieldValueMap = settleDetailParam.getBillFieldValueMap();
            for (Map.Entry<String, Object> entry : billFieldValueMap.entrySet()) {
                String fieldKey = entry.getKey();
                Object fieldValue = entry.getValue();
                if (!EntityMetadataUtils.isExistProperty(bill, fieldKey)) continue;
                bill.set(fieldKey, fieldValue);
            }
        }
    }

    protected void processMatchField(List<BillSettleVO> settleVOList, List<SettleDetailParam> detailParamList) {
        if (ObjectUtils.isEmpty(settleVOList) || ObjectUtils.isEmpty(detailParamList)) {
            return;
        }
        List paramWithMatchList = detailParamList.stream().filter(settleDetailParam -> !ObjectUtils.isEmpty(settleDetailParam.getMatchFieldValueMap())).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(paramWithMatchList)) {
            return;
        }
        Object importSettleFlag = detailParamList.get(0).getMatchFieldValueMap().get("importBillId");
        if (importSettleFlag != null) {
            Map<Long, List<BillSettleVO>> billSettleVOMap = settleVOList.stream().collect(Collectors.groupingBy(v -> v.getId()));
            Map<Long, List<SettleDetailParam>> paramListGroupByBillIdMap = detailParamList.stream().collect(Collectors.groupingBy(v -> v.getBillId()));
            settleVOList.clear();
            for (Map.Entry<Long, List<SettleDetailParam>> entrySet : paramListGroupByBillIdMap.entrySet()) {
                Long billId = entrySet.getKey();
                List<SettleDetailParam> sp = entrySet.getValue();
                List<BillSettleVO> vos = billSettleVOMap.get(billId);
                block1: for (SettleDetailParam param : sp) {
                    BigDecimal currentSettleAmt = param.getSettleAmt();
                    if (currentSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    int curSettleAmtDirection = currentSettleAmt.signum();
                    for (BillSettleVO vo : vos) {
                        Map<String, Object> extFields;
                        Long importSettleId;
                        Map<String, Object> resultExtMap;
                        BillSettleVO newVo;
                        int entryDirection;
                        BigDecimal entryUnSettleAmt = vo.getEntryUnSettleAmt();
                        if (entryUnSettleAmt.compareTo(BigDecimal.ZERO) == 0 || curSettleAmtDirection != (entryDirection = entryUnSettleAmt.signum())) continue;
                        if (currentSettleAmt.abs().compareTo(entryUnSettleAmt.abs()) >= 0) {
                            currentSettleAmt = currentSettleAmt.subtract(entryUnSettleAmt);
                            vo.setEntryUnSettleAmt(BigDecimal.ZERO);
                            newVo = (BillSettleVO)vo.clone();
                            resultExtMap = param.getMatchFieldValueMap();
                            importSettleId = (Long)resultExtMap.get("importBillId");
                            extFields = newVo.getExtFields();
                            if (extFields != null) {
                                resultExtMap.putAll(extFields);
                                resultExtMap.put("matchkey", importSettleId.toString());
                            }
                            newVo.setExtFields(resultExtMap);
                            newVo.setImportSettleId(importSettleId);
                            newVo.setEntryUnSettleAmt(entryUnSettleAmt);
                            settleVOList.add(newVo);
                            if (currentSettleAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                            continue block1;
                        }
                        vo.setEntryUnSettleAmt(entryUnSettleAmt.subtract(currentSettleAmt));
                        newVo = (BillSettleVO)vo.clone();
                        resultExtMap = param.getMatchFieldValueMap();
                        importSettleId = (Long)resultExtMap.get("importBillId");
                        extFields = newVo.getExtFields();
                        if (extFields != null) {
                            resultExtMap.putAll(extFields);
                            resultExtMap.put("matchkey", importSettleId.toString());
                        }
                        newVo.setExtFields(resultExtMap);
                        newVo.setImportSettleId(importSettleId);
                        newVo.setEntryUnSettleAmt(currentSettleAmt);
                        settleVOList.add(newVo);
                        continue block1;
                    }
                }
            }
        } else {
            boolean isAccurateSettle = detailParamList.get(0).isAccuRateSettle();
            if (isAccurateSettle) {
                ArrayList<BillSettleVO> splitSettleVoList = new ArrayList<BillSettleVO>(16);
                for (SettleDetailParam settleDetailParam2 : paramWithMatchList) {
                    long billEntryId = settleDetailParam2.getBillEntryId();
                    Map<String, Object> resultExtMap = settleDetailParam2.getMatchFieldValueMap();
                    List matchSettleVOList = null;
                    if (billEntryId != 0L) {
                        matchSettleVOList = settleVOList.stream().filter(billSettleVO -> billSettleVO.getEntryId() == billEntryId).collect(Collectors.toList());
                    }
                    if (matchSettleVOList == null) continue;
                    for (BillSettleVO billSettleVO2 : matchSettleVOList) {
                        BillSettleVO newVo = (BillSettleVO)billSettleVO2.clone();
                        Map<String, Object> extFields = newVo.getExtFields();
                        newVo.setEntryUnSettleAmt(settleDetailParam2.getSettleAmt());
                        if (extFields != null) {
                            resultExtMap.putAll(extFields);
                        }
                        newVo.setExtFields(resultExtMap);
                        splitSettleVoList.add(newVo);
                    }
                }
                settleVOList.clear();
                settleVOList.addAll(splitSettleVoList);
            } else {
                for (SettleDetailParam settleDetailParam3 : paramWithMatchList) {
                    long billEntryId = settleDetailParam3.getBillEntryId();
                    long billId = settleDetailParam3.getBillId();
                    Map<String, Object> matchFieldValueMap = settleDetailParam3.getMatchFieldValueMap();
                    List matchSettleVOList = null;
                    if (billEntryId != 0L) {
                        matchSettleVOList = settleVOList.stream().filter(billSettleVO -> billSettleVO.getEntryId() == billEntryId).collect(Collectors.toList());
                    } else if (billId != 0L) {
                        matchSettleVOList = settleVOList.stream().filter(billSettleVO -> billSettleVO.getId() == billId).collect(Collectors.toList());
                    }
                    if (matchSettleVOList == null) continue;
                    for (BillSettleVO billSettleVO3 : matchSettleVOList) {
                        Map<String, Object> extFields = billSettleVO3.getExtFields();
                        if (extFields == null) {
                            billSettleVO3.setExtFields(matchFieldValueMap);
                            continue;
                        }
                        billSettleVO3.getExtFields().putAll(matchFieldValueMap);
                    }
                }
            }
        }
    }

    protected void afterSettle(BaseSettleParam param, SettleResult result) {
        this.updateSettleDate(param, result);
        this.logSettle(param, result);
    }

    protected int getSettleModel(String entity, long orgId) {
        if ("ap_finapbill".equals(entity)) {
            return ArApHelper.getApSettleParam(orgId);
        }
        if ("ar_finarbill".equals(entity)) {
            return ArApHelper.getArSettleParam(orgId);
        }
        return 0;
    }

    private void checkBillNotNull(DynamicObject[] mains, DynamicObject[] assts) {
        if (ObjectUtils.isEmpty((Object[])mains)) {
            throw new SettleServiceBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u53ef\u53c2\u4e0e\u7ed3\u7b97\u7684\u4e3b\u65b9\u5355\u636e\u3002", (String)"AbstractSettleService_5", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object[])assts)) {
            throw new SettleServiceBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u53ef\u53c2\u4e0e\u7ed3\u7b97\u7684\u8f85\u65b9\u5355\u636e\u3002", (String)"AbstractSettleService_6", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private void checkBillNotNull(List<BillSettleVO> mainList, List<BillSettleVO> asstList) {
        if (ObjectUtils.isEmpty(mainList)) {
            throw new SettleServiceBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u53ef\u53c2\u4e0e\u7ed3\u7b97\u7684\u4e3b\u65b9\u5355\u636e\u3002", (String)"AbstractSettleService_5", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty(asstList)) {
            throw new SettleServiceBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u53ef\u53c2\u4e0e\u7ed3\u7b97\u7684\u8f85\u65b9\u5355\u636e\u3002", (String)"AbstractSettleService_6", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private void updateSettleDate(BaseSettleParam param, SettleResult result) {
        Date settleDate = param.getSettleDate();
        List<Object> settleRecordPKs = result.getSettleRecordPKs();
        if (settleDate == null || ObjectUtils.isEmpty(settleRecordPKs)) {
            return;
        }
        String mainEntity = param.getMainEntity();
        IUpdateSettleDateService updateSettleDateService = null;
        updateSettleDateService = "ap_finapbill".equals(mainEntity) || "cas_paybill".equals(mainEntity) || "ap_paidbill".equals(mainEntity) ? ArApServiceAPIFactory.getUpdateSettleDateService(ServiceNameEnum.APUPDATESETTLEDATE.getValue()) : ArApServiceAPIFactory.getUpdateSettleDateService(ServiceNameEnum.ARUPDATESETTLEDATE.getValue());
        HashSet<Long> ids = new HashSet<Long>(settleRecordPKs.size());
        for (Object settleRecordPK : settleRecordPKs) {
            ids.add(Long.parseLong(settleRecordPK.toString()));
        }
        updateSettleDateService.updateSettleDate(param.getOrgId(), ids, settleDate);
    }

    private void logSettle(BaseSettleParam param, SettleResult result) {
        OpLogInfo log = new OpLogInfo();
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        sb.append("stackTrace--");
        for (int i = 0; i < 10; ++i) {
            sb.append(stackTrace[i]);
            sb.append('\n');
        }
        sb.append(result);
        log.setOpName("settleapi-invoke").setOpDescription(param.toString()).setObjJsonStr(sb.toString()).setIgnoreLogParam(true);
        OpLogServiceHelper.addLog(log);
    }

    private void logSettleException(BaseSettleParam param, Throwable e) {
        OpLogInfo log = new OpLogInfo();
        log.setOpName("settleapi-invoike-exception").setOpDescription(param.toString()).setObjJsonStr(SettleLogHelper.getStackTraceMessage(e)).setIgnoreLogParam(true);
        OpLogServiceHelper.addLog(log);
    }

    protected abstract String getMainEntity();

    protected abstract String getAsstEntity();

    protected abstract DynamicObject[] getMainBills(BaseSettleParam var1, Set<Long> var2);

    protected abstract DynamicObject[] getAsstBills(BaseSettleParam var1, Set<Long> var2);

    protected abstract void processMainBillByDetailParam(AssignSettleParam var1, DynamicObject[] var2, List<SettleDetailParam> var3, int var4);

    protected abstract void processAsstBillByDetailParam(AssignSettleParam var1, DynamicObject[] var2, List<SettleDetailParam> var3, int var4);

    protected abstract List<BillSettleVO> getMainSettleVOList(DynamicObject[] var1, SettleSchemeVO var2);

    protected abstract List<BillSettleVO> getAsstSettleVOList(DynamicObject[] var1, SettleSchemeVO var2);

    protected abstract AbstractSettleTemplate getService();
}

