/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.api.verify;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.arapcommon.api.param.NoAssignSettleParam;
import kd.fi.arapcommon.api.param.SettleResult;
import kd.fi.arapcommon.api.verify.IVerifyService;
import kd.fi.arapcommon.service.AbstractVerifyTemplate;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public abstract class AbstractVerifyService
implements IVerifyService {
    @Override
    public SettleResult verifyByBotp(Set<Long> mainIds, Set<Long> asstIds) {
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setOnlyByBotp(true);
        DynamicObject[] mains = this.getMainBills(mainIds);
        DynamicObject[] assts = this.getAsstBills(asstIds);
        AbstractVerifyTemplate service = this.getService();
        service.verify(mains, assts, scheme, "auto");
        SettleResult result = new SettleResult();
        result.setSettleRecordPKs(scheme.getRecordPks());
        return result;
    }

    @Override
    public SettleResult verifyByBotp(long mainBillId, long asstBillId) {
        return null;
    }

    @Override
    public SettleResult verifyByCore(Set<Long> mainIds, Set<Long> asstIds) {
        SettleSchemeVO scheme = new SettleSchemeVO();
        scheme.setOnlyByCoreBill(true);
        DynamicObject[] mains = this.getMainBills(mainIds);
        DynamicObject[] assts = this.getAsstBills(asstIds);
        AbstractVerifyTemplate service = this.getService();
        service.verify(mains, assts, scheme, "auto");
        SettleResult result = new SettleResult();
        result.setSettleRecordPKs(scheme.getRecordPks());
        return result;
    }

    @Override
    public SettleResult verifyByCore(long mainBillId, long asstBillId) {
        return null;
    }

    @Override
    public SettleResult settle(NoAssignSettleParam settleParam, SettleSchemeVO scheme) {
        DynamicObject[] mains = this.getMainBills(settleParam.getMainBillIds());
        DynamicObject[] assts = this.getAsstBills(settleParam.getAsstBillIds());
        AbstractVerifyTemplate service = this.getService();
        service.verify(mains, assts, scheme, "auto");
        SettleResult result = new SettleResult();
        result.setSettleRecordPKs(scheme.getRecordPks());
        return result;
    }

    protected abstract DynamicObject[] getMainBills(Set<Long> var1);

    protected abstract DynamicObject[] getAsstBills(Set<Long> var1);

    protected abstract AbstractVerifyTemplate getService();

    protected abstract List<BillSettleVO> getMainSettleVOList(DynamicObject[] var1, SettleSchemeVO var2);

    protected abstract List<BillSettleVO> getAsstSettleVOList(DynamicObject[] var1, SettleSchemeVO var2);
}

