/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.balance;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.balance.BalJouMapper;
import kd.fi.arapcommon.balance.BalanceCalculateParam;
import kd.fi.arapcommon.balance.BalanceFormula;
import kd.fi.arapcommon.balance.BalanceSettingParser;
import kd.fi.arapcommon.util.CollectionUtils;
import kd.fi.arapcommon.util.DataSetUtils;
import kd.fi.arapcommon.util.DateUtils;

public class BalanceCalculator {
    private BalJouMapper balJouMapper;
    private BalanceSettingParser balanceSettingParser;
    private BalanceCalculateParam balanceQueryParam;
    private Map<String, String> journalAliasMap = new TreeMap<String, String>();

    public BalanceCalculator(BalJouMapper balJouMapper) {
        this.balJouMapper = balJouMapper;
        this.balanceSettingParser = new BalanceSettingParser(balJouMapper);
    }

    public DataSet calculateBalance(BalanceCalculateParam balanceQueryParam) {
        this.balanceQueryParam = balanceQueryParam;
        List<BalanceFormula> balanceFormulas = balanceQueryParam.getBalanceFormulas();
        DataSet balanceDataSet = null;
        DataSet journalDataSet = this.queryJournals();
        DataSet previousBalanceData = this.queryPreviousBalanceData();
        if (previousBalanceData != null) {
            balanceDataSet = this.mergePreviousBalance(journalDataSet, previousBalanceData);
        } else {
            LinkedList<String> aliasExchangeExp = new LinkedList<String>();
            for (Map.Entry<String, String> entry : this.journalAliasMap.entrySet()) {
                String journalField = entry.getKey();
                String journalAlias = entry.getValue();
                List<String> balanceFields = this.balanceSettingParser.getBalanceFields(journalField);
                for (String balanceField : balanceFields) {
                    aliasExchangeExp.add(journalAlias + " " + balanceField);
                }
            }
            balanceDataSet = journalDataSet.select(String.join((CharSequence)",", aliasExchangeExp));
            List<BalanceFormula> previousFormulas = this.getPreviousFormulas(balanceFormulas);
            for (BalanceFormula bf : previousFormulas) {
                balanceDataSet = balanceDataSet.addField("0", bf.getBalanceKey());
            }
        }
        for (BalanceFormula formula : balanceFormulas) {
            if (formula.isPreviousFunc()) continue;
            balanceDataSet = balanceDataSet.addField(formula.getFormula(), formula.getBalanceKey());
        }
        return balanceDataSet;
    }

    private DataSet mergePreviousBalance(DataSet journalDataSet, DataSet previousBalanceData) {
        List<BalanceFormula> previousFormulas = this.getPreviousFormulas(this.balanceQueryParam.getBalanceFormulas());
        for (BalanceFormula f : previousFormulas) {
            previousBalanceData = previousBalanceData.addField(f.getFormula(), f.getBalanceKey());
        }
        List<String> journalSelectedFields = DataSetUtils.getSelectedFields(journalDataSet, new String[0]);
        LinkedList<String> previousBalanceSelectedFields = new LinkedList<String>();
        List<String> balanceDimensions = this.balanceQueryParam.getBalanceDimensions();
        previousBalanceSelectedFields.addAll(balanceDimensions);
        previousBalanceSelectedFields.addAll(previousFormulas.stream().map(BalanceFormula::getBalanceKey).collect(Collectors.toList()));
        JoinDataSet join = journalDataSet.join(previousBalanceData, JoinType.FULL);
        for (String balanceField : balanceDimensions) {
            String journalField = this.balJouMapper.getJournalField(balanceField);
            join = join.on(this.journalAliasMap.get(journalField), balanceField);
        }
        DataSet balanceDataSet = join.select(journalSelectedFields.toArray(new String[0]), previousBalanceSelectedFields.toArray(new String[0])).finish();
        List<String> selectedFields = DataSetUtils.getSelectedFields(balanceDataSet, new String[0]);
        LinkedList<String> notNullSelectExp = new LinkedList<String>();
        for (Map.Entry<String, String> entry : this.journalAliasMap.entrySet()) {
            String journalField = entry.getKey();
            String journalAlias = entry.getValue();
            List<String> balanceFields = this.balanceSettingParser.getBalanceFields(journalField);
            for (String balanceField : balanceFields) {
                if (balanceDimensions.contains(balanceField)) {
                    notNullSelectExp.add(String.format("case when %s=null then %s else %s end as %s", journalAlias, balanceField, journalAlias, balanceField));
                } else {
                    notNullSelectExp.add(String.format("case when %s=null then 0 else %s end as %s", journalAlias, journalAlias, balanceField));
                }
                CollectionUtils.removeIgnoreCase(selectedFields, journalAlias, balanceField, journalField);
            }
        }
        notNullSelectExp.addAll(selectedFields);
        return balanceDataSet.select(String.join((CharSequence)",", notNullSelectExp));
    }

    private DataSet queryJournals() {
        String alias;
        ArrayList<String> journalGroupByFields = new ArrayList<String>(64);
        for (String balanceField : this.balanceQueryParam.getBalanceDimensions()) {
            journalGroupByFields.add(this.balJouMapper.getJournalField(balanceField));
        }
        List<String> journalSumFields = this.balanceSettingParser.getJournalSumFields();
        ArrayList<String> journalSelectors = new ArrayList<String>(64);
        for (String gbf : journalGroupByFields) {
            alias = gbf + "2";
            journalSelectors.add(gbf + " " + alias);
            this.journalAliasMap.put(gbf, alias);
        }
        for (String gbf : journalSumFields) {
            alias = gbf + "2";
            journalSelectors.add(gbf + " " + alias);
            this.journalAliasMap.put(gbf, alias);
        }
        String selectorExp = String.join((CharSequence)",", journalSelectors);
        DataSet rawJournalDataSet = null;
        QFilter orgFilter = new QFilter("org", "=", (Object)this.balanceQueryParam.getOrgId());
        QFilter endDateFilter = new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat(this.balanceQueryParam.getBalanceDate(), false));
        List<QFilter> filters = this.convertBalanceFiltersToJournalFilters(this.balanceQueryParam.getCustomFilters());
        filters.add(orgFilter);
        filters.add(endDateFilter);
        if (this.balanceQueryParam.getLastCloseDate() != null) {
            QFilter beginDateFilter = new QFilter("bizdate", ">", (Object)DateUtils.getDataFormat(this.balanceQueryParam.getLastCloseDate(), false));
            filters.add(beginDateFilter);
        }
        rawJournalDataSet = QueryServiceHelper.queryDataSet((String)"commonquery", (String)this.balJouMapper.getJournalEntityKey(), (String)selectorExp, (QFilter[])filters.toArray(new QFilter[0]), null);
        ArrayList<String> journalGroupByFieldsAlias = new ArrayList<String>(64);
        for (String b : journalGroupByFields) {
            journalGroupByFieldsAlias.add(this.journalAliasMap.get(b));
        }
        GroupbyDataSet groupbyDataSet = rawJournalDataSet.groupBy(journalGroupByFieldsAlias.toArray(new String[0]));
        for (String sumField : journalSumFields) {
            groupbyDataSet = groupbyDataSet.sum(this.journalAliasMap.get(sumField));
        }
        return groupbyDataSet.finish();
    }

    private List<QFilter> convertBalanceFiltersToJournalFilters(List<QFilter> balanceFilters) {
        ArrayList<QFilter> journalFilters = new ArrayList<QFilter>(64);
        for (QFilter filter : balanceFilters) {
            QFilter filterCopy = filter.copy();
            String journalField = this.balJouMapper.getJournalField(filter.getProperty().toLowerCase());
            filterCopy.__setProperty(journalField);
            journalFilters.add(filterCopy);
        }
        return journalFilters;
    }

    private DataSet queryPreviousBalanceData() {
        if (this.balanceQueryParam.getLastCloseId() == null) {
            return null;
        }
        List<BalanceFormula> previousFormulas = this.getPreviousFormulas(this.balanceQueryParam.getBalanceFormulas());
        LinkedList<String> previousFormulaKeys = new LinkedList<String>();
        for (BalanceFormula f : previousFormulas) {
            previousFormulaKeys.addAll(f.getFormulaKeys());
        }
        LinkedList<String> selectors = new LinkedList<String>();
        selectors.addAll(this.balanceQueryParam.getBalanceDimensions());
        selectors.addAll(previousFormulaKeys);
        QFilter orgFilter = new QFilter("org", "=", (Object)this.balanceQueryParam.getOrgId());
        QFilter closeSeqFilter = new QFilter("closeid", "=", (Object)this.balanceQueryParam.getLastCloseId());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(this.balanceQueryParam.getCustomFilters().size());
        filters.add(orgFilter);
        filters.add(closeSeqFilter);
        filters.addAll(this.balanceQueryParam.getCustomFilters());
        DataSet previousBalanceData = QueryServiceHelper.queryDataSet((String)"commonquery", (String)this.balJouMapper.getBalanceEntityKey(), (String)String.join((CharSequence)",", selectors), (QFilter[])filters.toArray(new QFilter[0]), null);
        GroupbyDataSet groupBy = previousBalanceData.groupBy(this.balanceQueryParam.getBalanceDimensions().toArray(new String[0]));
        for (String amtField : previousFormulaKeys) {
            groupBy.sum(amtField);
        }
        return groupBy.finish();
    }

    private List<BalanceFormula> getPreviousFormulas(List<BalanceFormula> formulas) {
        return formulas.stream().filter(BalanceFormula::isPreviousFunc).collect(Collectors.toList());
    }
}

