/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.balance;

import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.balance.BalJouMapper;
import kd.fi.arapcommon.balance.BalanceCalculateParam;
import kd.fi.arapcommon.balance.BalanceCalculator;
import kd.fi.arapcommon.balance.BalanceFormula;
import kd.fi.arapcommon.balance.BalanceSettingParser;
import kd.fi.arapcommon.balance.BalanceType;
import kd.fi.arapcommon.service.CloseRecordService;
import kd.fi.arapcommon.util.DateUtils;

public class BalanceQuerier {
    private boolean isAp;
    private BalanceType balanceType;

    public BalanceQuerier(BalanceType balanceType) {
        this.isAp = balanceType.isAp();
        this.balanceType = balanceType;
    }

    public DataSet queryBalance(List<Long> orgIds, Date queryDate, List<String> balanceDimensions, List<QFilter> customFilters) {
        DataSet ds = null;
        CloseRecordService closeRecordService = new CloseRecordService(this.isAp);
        Date balanceDate = DateUtils.getLastDay(queryDate, 1);
        BalJouMapper mapper = BalJouMapper.getMapper(this.isAp);
        for (Long orgId : orgIds) {
            DynamicObject closeRecord = closeRecordService.queryCloseRecord(orgId, balanceDate);
            BalanceCalculateParam balanceCalculateParam = new BalanceCalculateParam();
            balanceCalculateParam.setOrgId(orgId);
            balanceCalculateParam.setBalanceDimensions(balanceDimensions);
            balanceCalculateParam.setBalanceDate(balanceDate);
            if (closeRecord != null) {
                balanceCalculateParam.setLastCloseDate(closeRecord.getDate("closedate"));
                balanceCalculateParam.setLastCloseId(closeRecord.getLong("id"));
            }
            balanceCalculateParam.setCustomFilters(customFilters);
            BalanceSettingParser balanceSettingParser = new BalanceSettingParser(mapper);
            LinkedList<BalanceFormula> balanceFormulas = new LinkedList<BalanceFormula>();
            balanceFormulas.addAll(balanceSettingParser.getBalanceFormulas());
            balanceFormulas.addAll(this.getBalanceFormulas(this.balanceType));
            balanceCalculateParam.setBalanceFormulas(balanceFormulas);
            BalanceCalculator balanceCalculator = new BalanceCalculator(mapper);
            DataSet calculateBalanceDataSet = balanceCalculator.calculateBalance(balanceCalculateParam);
            if (ds == null) {
                ds = calculateBalanceDataSet;
                continue;
            }
            ds = ds.union(calculateBalanceDataSet);
        }
        if (orgIds.size() > 1 && ds != null) {
            DataSet result = ds.groupBy(balanceDimensions.toArray(new String[0])).sum("periodamt").sum("localperiodamt").finish();
            ds.close();
            return result;
        }
        return ds;
    }

    private List<BalanceFormula> getBalanceFormulas(BalanceType balanceType) {
        BalanceFormula balanceFormula = null;
        BalanceFormula localBalanceFormula = null;
        String periodAmtFieldName = "periodamt";
        String localperiodamtFieldName = "localperiodamt";
        switch (balanceType) {
            case AP_FIN: {
                balanceFormula = new BalanceFormula(periodAmtFieldName, "finbalance");
                localBalanceFormula = new BalanceFormula(localperiodamtFieldName, "localfinbalance");
                break;
            }
            case AP_BUS: {
                balanceFormula = new BalanceFormula(periodAmtFieldName, "busbalance");
                localBalanceFormula = new BalanceFormula(localperiodamtFieldName, "localbusbalance");
                break;
            }
            case AP_FIN_BUS: {
                balanceFormula = new BalanceFormula(periodAmtFieldName, "finbalance+busbalance");
                localBalanceFormula = new BalanceFormula(localperiodamtFieldName, "localfinbalance+localbusbalance");
                break;
            }
            case AP_FIN_PREPAID: {
                balanceFormula = new BalanceFormula(periodAmtFieldName, "finbalance-prepaidbalance");
                localBalanceFormula = new BalanceFormula(localperiodamtFieldName, "localfinbalance-localprepaidbalance");
                break;
            }
            case AP_BUS_PREPAID: {
                balanceFormula = new BalanceFormula(periodAmtFieldName, "busbalance-prepaidbalance");
                localBalanceFormula = new BalanceFormula(localperiodamtFieldName, "localbusbalance-localprepaidbalance");
                break;
            }
            case AP_FIN_BUS_PREPAID: {
                balanceFormula = new BalanceFormula(periodAmtFieldName, "finbalance+busbalance-prepaidbalance");
                localBalanceFormula = new BalanceFormula(localperiodamtFieldName, "localfinbalance+localbusbalance-localprepaidbalance");
                break;
            }
            case AR_FIN: {
                balanceFormula = new BalanceFormula(periodAmtFieldName, "finbalance");
                localBalanceFormula = new BalanceFormula(localperiodamtFieldName, "localfinbalance");
                break;
            }
            case AR_BUS: {
                balanceFormula = new BalanceFormula(periodAmtFieldName, "busbalance");
                localBalanceFormula = new BalanceFormula(localperiodamtFieldName, "localbusbalance");
                break;
            }
            case AR_FIN_BUS: {
                balanceFormula = new BalanceFormula(periodAmtFieldName, "finbalance+busbalance");
                localBalanceFormula = new BalanceFormula(localperiodamtFieldName, "localfinbalance+localbusbalance");
                break;
            }
            case AR_FIN_RECEIVED: {
                balanceFormula = new BalanceFormula(periodAmtFieldName, "finbalance-receivedbalance");
                localBalanceFormula = new BalanceFormula(localperiodamtFieldName, "localfinbalance-localreceivedbalance");
                break;
            }
            case AR_BUS_RECEIVED: {
                balanceFormula = new BalanceFormula(periodAmtFieldName, "busbalance-receivedbalance");
                localBalanceFormula = new BalanceFormula(localperiodamtFieldName, "localbusbalance-localreceivedbalance");
                break;
            }
            case AR_FIN_BUS_RECEIVED: {
                balanceFormula = new BalanceFormula(periodAmtFieldName, "finbalance+busbalance-receivedbalance");
                localBalanceFormula = new BalanceFormula(localperiodamtFieldName, "localfinbalance+localbusbalance-localreceivedbalance");
                break;
            }
            default: {
                throw new RuntimeException("Balance Type NOT Supported Yet:" + (Object)((Object)balanceType));
            }
        }
        return Arrays.asList(balanceFormula, localBalanceFormula);
    }
}

