/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.business.piaozone.kingdee;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.dev.beanfactory.Scope;
import kd.fi.arapcommon.dev.beanfactory.Service;
import kd.fi.arapcommon.util.ErStdConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

@Service(scope=Scope.Singleton)
public class HttpServiceHelper {
    private static Log logger = LogFactory.getLog(HttpServiceHelper.class);
    private static final int DEFAULT_OVERTIME = 180000;

    public String doGet(String url, Map<String, Object> paramMap) {
        CloseableHttpClient httpClient = HttpServiceHelper.createHttpClient(url);
        try {
            if (url.contains("http://")) {
                url = StringUtils.replace((String)url, (String)"http://", (String)"");
                url = StringUtils.prependIfMissing((String)StringUtils.replace((String)url, (String)"https://", (String)""), (CharSequence)"http://", (CharSequence[])new CharSequence[0]);
            } else {
                url = StringUtils.prependIfMissing((String)StringUtils.replace((String)url, (String)"https://", (String)""), (CharSequence)"https://", (CharSequence[])new CharSequence[0]);
            }
            logger.info("Get Request FINAL URL : " + url);
            URIBuilder uriBuilder = new URIBuilder(url);
            if (paramMap != null) {
                for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                    uriBuilder.setParameter(entry.getKey(), entry.getValue().toString());
                }
            }
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            httpGet.setConfig(HttpServiceHelper.getRequestConfig());
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity responseEntity = httpResponse.getEntity();
            if (responseEntity != null) {
                String resultStr = EntityUtils.toString((HttpEntity)responseEntity);
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    logger.info("Http Get Response:" + resultStr);
                    return resultStr;
                }
                throw new KDBizException("HttpInvokeError.  URL=" + url + "  STATUS=" + statusCode);
            }
            throw new KDBizException("Http Get Response is Null");
        }
        catch (IOException | URISyntaxException e) {
            logger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static RequestConfig getRequestConfig() {
        RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(1000).setSocketTimeout(180000);
        logger.info("RequestConfig DEFAULT_OVERTIME(ms): 180000");
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doPost_returnOriginResponse(String url, String params) {
        String fmt = ResManager.loadKDString((String)"\u53d1\u8d77post\u8bf7\u6c42 -- url:%1$s\uff0c params:%2$s", (String)"HttpServiceHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]);
        logger.info(String.format(fmt, url, params));
        try (CloseableHttpClient httpClient = HttpServiceHelper.createHttpClient(url);){
            StringEntity reqFromEntity = new StringEntity(params, ContentType.APPLICATION_JSON);
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)reqFromEntity);
            httpPost.setConfig(HttpServiceHelper.getRequestConfig());
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity == null) return null;
            String resultStr = EntityUtils.toString((HttpEntity)responseEntity);
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = resultStr;
                return string;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u8fd4\u56de\u5931\u8d25\u4fe1\u606f\uff1a%s", (String)"HttpServiceHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]), resultStr));
        }
        catch (IOException e) {
            logger.info("doPost_returnOriginResponse-\u8bf7\u6c42\u5931\u8d25\uff1a" + e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6c42\u5931\u8d25\uff1a\u8c03\u7528\u53d1\u7968\u4e91\u63a5\u53e3\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u63a5\u53e3\u7f51\u7edc\u662f\u5426\u901a\u7545\u3002", (String)"HttpServiceHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private static CloseableHttpClient createHttpClient(String url) {
        HttpClientBuilder custom = HttpClients.custom();
        ErStdConfig.ProxyAddr proxyAddr = ErStdConfig.getHttpProxy();
        String nonProxyhHosts = ErStdConfig.get("nonproxyhosts");
        Boolean isProxy = Boolean.TRUE;
        if (nonProxyhHosts != null) {
            Set hostSet = Arrays.stream(nonProxyhHosts.split("\\|")).collect(Collectors.toSet());
            for (String host : hostSet) {
                String trimHost = host.trim();
                if ("".equals(trimHost) || !url.contains(trimHost)) continue;
                isProxy = Boolean.FALSE;
            }
        }
        if (isProxy.booleanValue() && proxyAddr != null) {
            HttpHost proxy = new HttpHost(proxyAddr.hostname, proxyAddr.port);
            custom.setProxy(proxy);
        }
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            }).build();
            NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            return custom.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (NoSuchAlgorithmException e) {
            logger.info(e.getMessage());
        }
        catch (KeyManagementException e) {
            logger.info(e.getMessage());
        }
        catch (KeyStoreException e) {
            logger.info(e.getMessage());
        }
        return custom.build();
    }

    public static Map<String, Object> doGetInputStream(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            logger.info("HttpServiceHelper_doGetInputStream>>> url \u4e3a\u7a7a");
            return null;
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>(2);
        Object in = null;
        try {
            if (url.toLowerCase(Locale.ENGLISH).startsWith("http://")) {
                URL location = new URL(url);
                URLConnection openConnection = location.openConnection();
                returnData.put("in", openConnection.getInputStream());
                returnData.put("size", openConnection.getContentLengthLong());
                logger.info("HttpServiceHelper_doGetInputStream>>> http");
            } else {
                HttpURLConnection httpsConnection = HttpServiceHelper.getHttpsConnection(url);
                returnData.put("in", httpsConnection.getInputStream());
                returnData.put("size", httpsConnection.getContentLengthLong());
                logger.info("HttpServiceHelper_doGetInputStream>>> https");
            }
        }
        catch (IOException e) {
            logger.error("HttpServiceHelper_doGetInputStream>>>", (Throwable)e);
        }
        return returnData;
    }

    private static HttpURLConnection getHttpsConnection(String url) throws IOException {
        HttpURLConnection con = null;
        URL u = new URL(url);
        ErStdConfig.ProxyAddr httpProxy = ErStdConfig.getHttpProxy();
        if (httpProxy != null) {
            InetSocketAddress addr = new InetSocketAddress(httpProxy.hostname, httpProxy.port);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
            con = (HttpURLConnection)u.openConnection(proxy);
        } else {
            con = (HttpURLConnection)u.openConnection();
        }
        return con;
    }
}

