/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.business.piaozone.kingdee;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.arapcommon.business.piaozone.info.InvoiceCloudCfg;
import kd.fi.arapcommon.util.CommonUtils;
import org.apache.commons.lang3.StringUtils;

enum InvoiceConfigPattern {
    orgPattern{

        @Override
        InvoiceCloudCfg getConfig(Long invoiceOrgId) {
            QFilter[] filters = new QFilter[]{new QFilter("org.id", "=", (Object)invoiceOrgId), new QFilter("enable", "=", (Object)Boolean.TRUE)};
            DynamicObject config = BusinessDataServiceHelper.loadSingleFromCache((String)"er_bd_kdinvoicecloudcfg", (QFilter[])filters);
            if (config == null) {
                return null;
            }
            InvoiceCloudCfg invoiceCloudCfgBO = 1.transferCfgInfo(config);
            invoiceCloudCfgBO.setInvoiceOrgId(invoiceOrgId);
            return invoiceCloudCfgBO;
        }
    }
    ,
    groupPattern{

        @Override
        InvoiceCloudCfg getConfig(Long invoiceOrgId) {
            QFilter enableQFilter;
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_bd_kdinvoicecloudcfgct", (Long)invoiceOrgId);
            Map configMap = BusinessDataServiceHelper.loadFromCache((String)"er_bd_kdinvoicecloudcfgct", (QFilter[])new QFilter[]{baseDataFilter, enableQFilter = new QFilter("enable", "=", (Object)Boolean.TRUE)});
            if (configMap == null || configMap.isEmpty()) {
                return null;
            }
            Collection configs = configMap.values();
            List sortList = configs.stream().sorted((c1, c2) -> {
                Long createOrg1 = CommonUtils.getPk(c1.getDynamicObject("createorg"));
                Long createOrg2 = CommonUtils.getPk(c2.getDynamicObject("createorg"));
                if (Objects.equals(createOrg1, invoiceOrgId) && !Objects.equals(createOrg2, invoiceOrgId)) {
                    return -1;
                }
                if (Objects.equals(createOrg2, invoiceOrgId) && !Objects.equals(createOrg1, invoiceOrgId)) {
                    return 1;
                }
                String ctlStrategy1 = c1.getString("ctrlstrategy");
                String ctlStrategy2 = c2.getString("ctrlstrategy");
                if (StringUtils.equals((CharSequence)ctlStrategy1, (CharSequence)"7") && !StringUtils.equals((CharSequence)ctlStrategy2, (CharSequence)"7")) {
                    return -1;
                }
                if (StringUtils.equals((CharSequence)ctlStrategy2, (CharSequence)"7") && !StringUtils.equals((CharSequence)ctlStrategy1, (CharSequence)"7")) {
                    return 1;
                }
                Date modifyDate1 = c1.getDate("modifytime");
                Date modifyDate2 = c2.getDate("modifytime");
                return 2.dateCompare(modifyDate2, modifyDate1);
            }).collect(Collectors.toList());
            DynamicObject mainConfig = sortList.stream().findFirst().orElse(null);
            InvoiceCloudCfg invoiceCloudCfgBO = 2.transferCfgInfo(mainConfig);
            if (invoiceCloudCfgBO != null) {
                invoiceCloudCfgBO.setInvoiceOrgId(invoiceOrgId);
                String taxRegNums = sortList.stream().map(config -> (String)StringUtils.defaultIfBlank((CharSequence)config.getString("taxregnum"), (CharSequence)"")).collect(Collectors.joining("="));
                String firmnames = sortList.stream().map(config -> (String)StringUtils.defaultIfBlank((CharSequence)config.getString("firmname"), (CharSequence)"")).collect(Collectors.joining("="));
                invoiceCloudCfgBO.setTaxRegnum(taxRegNums);
                invoiceCloudCfgBO.setFirmname(firmnames);
            }
            return invoiceCloudCfgBO;
        }
    };


    abstract InvoiceCloudCfg getConfig(Long var1);

    static int dateCompare(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return 0;
        }
        if (d1 == null) {
            return -1;
        }
        if (d2 == null) {
            return 1;
        }
        return d1.compareTo(d2);
    }

    public static InvoiceCloudCfg transferCfgInfo(DynamicObject config) {
        if (config == null) {
            return null;
        }
        InvoiceCloudCfg invoiceCloudCfgBO = new InvoiceCloudCfg();
        invoiceCloudCfgBO.setTaxRegnum(config.getString("taxregnum"));
        invoiceCloudCfgBO.setClientId(config.getString("client_id").trim());
        invoiceCloudCfgBO.setClientSecret(config.getString("client_secret").trim());
        invoiceCloudCfgBO.setEncryptKey(config.getString("encrypt_key").trim());
        invoiceCloudCfgBO.setReimedCi(config.getBoolean("reimed_ci"));
        invoiceCloudCfgBO.setNameNotMatchCi(config.getBoolean("namenotmatch_ci"));
        invoiceCloudCfgBO.setTaxNumNotMatchCi(config.getBoolean("taxnumnotmatch_ci"));
        invoiceCloudCfgBO.setCheckNotPassCi(config.getBoolean("checknotpass_ci"));
        invoiceCloudCfgBO.setBuyerNameLessEqual5Ci(config.getBoolean("buyernamele5_ci"));
        invoiceCloudCfgBO.setFirmname(config.getString("firmname"));
        return invoiceCloudCfgBO;
    }
}

