/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.business.piaozone.kingdee;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.arapcommon.business.piaozone.info.InvoiceCloudCfg;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.business.piaozone.kingdee.HttpServiceHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.InvoiceConfigPattern;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.ErStdConfig;
import kd.fi.arapcommon.util.StringUtils;

public class KingdeeInvoiceCloudConfig {
    private static Log logger = LogFactory.getLog(HttpServiceHelper.class);
    public static final String METADATA_NUMBER = "er_bd_kdinvoicecloudcfg";
    public static final String METADATA_GROUPNUMBER = "er_bd_kdinvoicecloudcfgct";
    private static final String ER_STDCONFIG = "er_stdconfig";
    private static final String NOT_PROD = "invoicecloud.not_prod";
    private static final String DOMAIN_TEST = "invoicecloud.domain_test";
    private static final String DOMAIN_PROD = "invoicecloud.domain_prod";
    private static final String DOMAIN_ARISSUE = "invoicecloud.domain_arissue";
    private static final String DOMAIN_APCOLLECT = "invoicecloud.domain_apcollect";

    public static String getDomain() {
        String domain = ConfigCache.get("er_stdconfig::invoicecloud", "domain", String.class);
        if (ObjectUtils.isEmpty((Object)domain)) {
            Map<String, String> stdconfigMap = KingdeeInvoiceCloudConfig.loadConfigs();
            if (ObjectUtils.isEmpty((Object)stdconfigMap.get(DOMAIN_ARISSUE))) {
                boolean not_prod = false;
                if (!ObjectUtils.isEmpty((Object)stdconfigMap.get(NOT_PROD))) {
                    not_prod = Boolean.parseBoolean(stdconfigMap.get(NOT_PROD));
                }
                String domain_test = stdconfigMap.get(DOMAIN_TEST);
                String domain_prod = stdconfigMap.get(DOMAIN_PROD);
                domain = not_prod ? domain_test : domain_prod;
                domain = "https://" + domain;
            } else {
                domain = stdconfigMap.get(DOMAIN_ARISSUE);
            }
            ConfigCache.put("er_stdconfig::invoicecloud", "domain", domain);
        }
        return domain;
    }

    public static String getDomain4AP() {
        String domain = ConfigCache.get("er_stdconfig::invoicecloud", "apdomain", String.class);
        if (ObjectUtils.isEmpty((Object)domain)) {
            Map<String, String> stdconfigMap = KingdeeInvoiceCloudConfig.loadConfigs();
            if (ObjectUtils.isEmpty((Object)stdconfigMap.get(DOMAIN_APCOLLECT))) {
                boolean not_prod = false;
                if (!ObjectUtils.isEmpty((Object)stdconfigMap.get(NOT_PROD))) {
                    not_prod = Boolean.parseBoolean(stdconfigMap.get(NOT_PROD));
                }
                String domain_test = stdconfigMap.get(DOMAIN_TEST);
                String domain_prod = stdconfigMap.get(DOMAIN_PROD);
                domain = not_prod ? domain_test : domain_prod;
                domain = "https://" + domain;
            } else {
                domain = stdconfigMap.get(DOMAIN_APCOLLECT);
            }
            ConfigCache.put("er_stdconfig::invoicecloud", "apdomain", domain);
        }
        return domain;
    }

    public static Map<String, String> loadConfigs() {
        ArrayList<String> keys = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        keys.add(NOT_PROD);
        keys.add(DOMAIN_TEST);
        keys.add(DOMAIN_PROD);
        keys.add(DOMAIN_ARISSUE);
        keys.add(DOMAIN_APCOLLECT);
        QFilter qf = new QFilter("key", "in", keys);
        Map stdconfigMap = BusinessDataServiceHelper.loadFromCache((String)ER_STDCONFIG, (String)"key, value", (QFilter[])new QFilter[]{qf});
        if (!ObjectUtils.isEmpty((Object)stdconfigMap)) {
            for (DynamicObject stdconfig : stdconfigMap.values()) {
                String key = stdconfig.getString("key");
                String value = stdconfig.getString("value");
                if (value != null) {
                    value = value.trim();
                }
                map.put(key, value);
            }
        }
        return map;
    }

    public static DynamicObject getClientConfig(String taxRegNum) {
        InvoiceCloudCfg vo = KingdeeInvoiceCloudConfig.getConfig(taxRegNum);
        DynamicObject config = null;
        if (vo != null) {
            logger.info("getClientConfig.vo:" + vo.getClientId() + "," + vo.getEncryptKey());
            config = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)METADATA_NUMBER));
            config.set("taxregnum", (Object)vo.getTaxRegnum());
            config.set("client_id", (Object)vo.getClientId());
            config.set("client_secret", (Object)vo.getClientSecret());
            config.set("encrypt_key", (Object)vo.getEncryptKey());
            config.set("reimed_ci", (Object)vo.getReimedCi());
            config.set("namenotmatch_ci", (Object)vo.getNameNotMatchCi());
            config.set("taxnumnotmatch_ci", (Object)vo.getTaxNumNotMatchCi());
            config.set("checknotpass_ci", (Object)vo.getCheckNotPassCi());
            config.set("buyernamele5_ci", (Object)vo.getBuyerNameLessEqual5Ci());
            config.set("firmname", (Object)vo.getFirmname());
            logger.info("getClientConfig.config:" + config.getString("client_id") + "," + config.getString("encrypt_key"));
            if (StringUtils.isEmpty(config.getString("client_id")) || StringUtils.isEmpty(config.getString("client_secret")) || StringUtils.isEmpty(config.getString("encrypt_key"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u57fa\u7840\u8d44\u6599>\u8d22\u52a1\u6570\u636e>\u53d1\u7968\u4e91\u914d\u7f6e\u201d\u7ef4\u62a4\u4f01\u4e1a\u7a0e\u53f7\u201c%s\u201d\u7684\u76f8\u5173\u914d\u7f6e\u4fe1\u606f\u3002", (String)"KingdeeInvoiceCloudConfig_0", (String)"fi-arapcommon", (Object[])new Object[0]), taxRegNum));
            }
        }
        return config;
    }

    public static String getTicketParam(String taxRegNum) {
        InvoiceCloudCfg configBO = KingdeeInvoiceCloudConfig.getConfig(taxRegNum);
        return (configBO.getReimedCi() != false ? "1" : "0") + (configBO.getNameNotMatchCi() != false ? "1" : "0") + (configBO.getTaxNumNotMatchCi() != false ? "1" : "0") + (configBO.getCheckNotPassCi() != false ? "1" : "0") + (configBO.getBuyerNameLessEqual5Ci() != false ? "1" : "0");
    }

    public static String getTicketParam(Long companyId) {
        InvoiceCloudCfg configBO = KingdeeInvoiceCloudConfig.getConfig(companyId);
        return (configBO.getReimedCi() != false ? "1" : "0") + (configBO.getNameNotMatchCi() != false ? "1" : "0") + (configBO.getTaxNumNotMatchCi() != false ? "1" : "0") + (configBO.getCheckNotPassCi() != false ? "1" : "0") + (configBO.getBuyerNameLessEqual5Ci() != false ? "1" : "0");
    }

    public static InvoiceCloudCfg getConfig(String taxRegNum) {
        return KingdeeInvoiceCloudConfig.getConfig(taxRegNum, null);
    }

    public static InvoiceCloudCfg getConfig(String taxRegNum, Long orgId) {
        InvoiceCloudCfg invoiceCloudCfgBO = ConfigCache.get("er_bd_kdinvoicecloudcfg::taxregnum", taxRegNum, InvoiceCloudCfg.class);
        QFilter[] filters = new QFilter[]{new QFilter("taxregnum", "=", (Object)taxRegNum), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObject config = null;
        if (KingdeeInvoiceCloudConfig.isGroupPattern()) {
            config = BusinessDataServiceHelper.loadSingleFromCache((String)METADATA_GROUPNUMBER, (QFilter[])filters);
        } else {
            if (invoiceCloudCfgBO != null) {
                return invoiceCloudCfgBO;
            }
            config = BusinessDataServiceHelper.loadSingleFromCache((String)METADATA_NUMBER, (QFilter[])filters);
        }
        if (orgId != null && EmptyUtils.isEmpty(config)) {
            return KingdeeInvoiceCloudConfig.getConfig(orgId);
        }
        if (config == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u7a0e\u53f7\u201c%s\u201d\u7684\u53d1\u7968\u4e91\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"KingdeeInvoiceCloudConfig_2", (String)"fi-arapcommon", (Object[])new Object[0]), taxRegNum));
        }
        invoiceCloudCfgBO = KingdeeInvoiceCloudConfig.transferCfgInfo(config);
        ConfigCache.put("er_bd_kdinvoicecloudcfg::taxregnum", taxRegNum, invoiceCloudCfgBO);
        return invoiceCloudCfgBO;
    }

    public static InvoiceCloudCfg getConfig(DynamicObject org) {
        InvoiceCloudCfg invoiceCloudCfgBO;
        logger.info("getConfig org\u5bf9\u8c61\u65b9\u6cd5");
        long orgPk = (Long)org.getPkValue();
        String taxRegNum = ConfigCache.get("er_bd_kdinvoicecloudcfg::org", String.valueOf(orgPk), String.class);
        if (!ObjectUtils.isEmpty((Object)taxRegNum) && (invoiceCloudCfgBO = ConfigCache.get("er_bd_kdinvoicecloudcfg::taxregnum", taxRegNum, InvoiceCloudCfg.class)) != null) {
            return invoiceCloudCfgBO;
        }
        QFilter[] filters = new QFilter[]{new QFilter("org.id", "=", (Object)orgPk), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObject config = BusinessDataServiceHelper.loadSingleFromCache((String)METADATA_NUMBER, (QFilter[])filters);
        if (config == null) {
            String s = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s \uff0c\u672a\u5bf9\u63a5\u53d1\u7968\u4e91\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"KingdeeInvoiceCloudConfig_1", (String)"fi-arapcommon", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue());
            throw new KDBizException(s);
        }
        InvoiceCloudCfg invoiceCloudCfgBO2 = KingdeeInvoiceCloudConfig.transferCfgInfo(config);
        ConfigCache.put("er_bd_kdinvoicecloudcfg::org", String.valueOf(orgPk), invoiceCloudCfgBO2.getTaxRegnum());
        ConfigCache.put("er_bd_kdinvoicecloudcfg::taxregnum", invoiceCloudCfgBO2.getTaxRegnum(), invoiceCloudCfgBO2);
        return invoiceCloudCfgBO2;
    }

    public static InvoiceCloudCfg transferCfgInfo(DynamicObject config) {
        InvoiceCloudCfg invoiceCloudCfgBO = new InvoiceCloudCfg();
        invoiceCloudCfgBO.setTaxRegnum(config.getString("taxregnum"));
        invoiceCloudCfgBO.setClientId(config.getString("client_id").trim());
        invoiceCloudCfgBO.setClientSecret(config.getString("client_secret").trim());
        invoiceCloudCfgBO.setEncryptKey(config.getString("encrypt_key").trim());
        invoiceCloudCfgBO.setReimedCi(config.getBoolean("reimed_ci"));
        invoiceCloudCfgBO.setNameNotMatchCi(config.getBoolean("namenotmatch_ci"));
        invoiceCloudCfgBO.setTaxNumNotMatchCi(config.getBoolean("taxnumnotmatch_ci"));
        invoiceCloudCfgBO.setCheckNotPassCi(config.getBoolean("checknotpass_ci"));
        invoiceCloudCfgBO.setBuyerNameLessEqual5Ci(config.getBoolean("buyernamele5_ci"));
        invoiceCloudCfgBO.setFirmname(config.getString("firmname"));
        return invoiceCloudCfgBO;
    }

    public static InvoiceConfigPattern getInvoiceConfigPattern() {
        String result = ErStdConfig.get("invoicecloud.configpattern");
        logger.info("InvoiceConfigPattern: " + result);
        if (KingdeeInvoiceCloudConfig.isGroupPattern()) {
            return InvoiceConfigPattern.groupPattern;
        }
        return InvoiceConfigPattern.orgPattern;
    }

    public static boolean isGroupPattern() {
        String result = ErStdConfig.get("invoicecloud.configpattern");
        logger.info("InvoiceConfigPattern: " + result);
        return StringUtils.isNotEmpty(result) && "2".equals(result.trim());
    }

    public static InvoiceCloudCfg getConfig(Long companyId) {
        logger.info("getConfig \u7ec4\u7ec7id\u65b9\u6cd5\u89e6\u53d1");
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getInvoiceConfigPattern().getConfig(companyId);
        if (config == null) {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)companyId, (String)"bos_org");
            String s = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s \uff0c\u672a\u5bf9\u63a5\u53d1\u7968\u4e91\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"KingdeeInvoiceCloudConfig_1", (String)"fi-arapcommon", (Object[])new Object[0]), org.getString("name"));
            throw new KDBizException(s);
        }
        logger.info(config.toString());
        return config;
    }

    public static boolean syncInvoiceAttachmentToBill() {
        return ErStdConfig.getBoolean("invoicecloud.syncattachmenttobill");
    }

    public static String getInvoiceAttachmentAPIURL() {
        boolean notProd = ErStdConfig.getBoolean(NOT_PROD);
        return notProd ? ErStdConfig.get("invoicecloud.attachmentapi_test") : ErStdConfig.get("invoicecloud.attachmentapi_prod");
    }

    public static Map<Long, DynamicObject> getErConfigByOrg(Set<Long> orgIds) {
        Map configMap;
        if (!KingdeeInvoiceCloudConfig.isGroupPattern()) {
            QFilter[] filters = new QFilter[]{new QFilter("org.id", "in", orgIds), new QFilter("enable", "=", (Object)Boolean.TRUE)};
            configMap = BusinessDataServiceHelper.loadFromCache((String)METADATA_NUMBER, (String)"identicalpartyinvcom,org", (QFilter[])filters);
        } else {
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)METADATA_GROUPNUMBER, new ArrayList<Long>(orgIds), (boolean)Boolean.TRUE);
            QFilter enableQFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            configMap = BusinessDataServiceHelper.loadFromCache((String)METADATA_GROUPNUMBER, (String)"identicalpartyinvcom,org", (QFilter[])new QFilter[]{baseDataFilter, enableQFilter}, (String)"org,modifytime");
        }
        HashMap<Long, DynamicObject> configByOrg = new HashMap<Long, DynamicObject>(8);
        for (Map.Entry configEntry : configMap.entrySet()) {
            DynamicObject config = (DynamicObject)configEntry.getValue();
            configByOrg.put(config.getLong("org.id"), config);
        }
        return configByOrg;
    }
}

