/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.business.piaozone.kingdee.action;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AbstractAction;
import kd.fi.arapcommon.helper.InvoiceCloudLocalHelper;
import kd.fi.arapcommon.util.AES128;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class InvDownloadAction
extends AbstractAction {
    private int pageNo;
    private int pageSize;
    private Date startTime;
    private Date endTime;
    private String invoiceTypes;
    private String authenticateFlags;
    private String salerTaxNo;
    private String buyerTaxNo;
    private String invoiceStatus;

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public InvDownloadAction(int pageNo, int pageSize, Date startTime, Date endTime, String invoiceTypes, String authenticateFlags, String salerTaxNo, String buyerTaxNo, String invoiceStatus) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.startTime = startTime;
        this.endTime = endTime;
        this.invoiceTypes = invoiceTypes;
        this.authenticateFlags = authenticateFlags;
        this.salerTaxNo = salerTaxNo;
        this.buyerTaxNo = buyerTaxNo;
        this.invoiceStatus = invoiceStatus;
    }

    @Override
    public String execute() {
        String invoiceJson = InvoiceCloudLocalHelper.invoiceDebugJson();
        if (EmptyUtils.isNotEmpty(invoiceJson)) {
            return invoiceJson;
        }
        String domain = KingdeeInvoiceCloudConfig.getDomain4AP();
        DynamicObject clientConfig = KingdeeInvoiceCloudConfig.getClientConfig(this.buyerTaxNo);
        String encrypt_key = clientConfig.getString("encrypt_key");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String url = domain + "/m6/bill/invoice/query?encry_type=GCM&access_token=" + this.token;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("pageNo", this.pageNo);
        param.put("pageSize", this.pageSize);
        param.put("startTime", sdf.format(this.startTime));
        param.put("endTime", sdf.format(this.endTime));
        param.put("invoiceTypes", this.invoiceTypes);
        param.put("authenticateFlags", this.authenticateFlags);
        param.put("salerTaxNo", this.salerTaxNo);
        param.put("buyerTaxNo", this.buyerTaxNo);
        param.put("invoiceStatus", this.invoiceStatus);
        String jsonEncrypt = null;
        logger.info("---json.param---" + JSON.toJSONString(param));
        try {
            jsonEncrypt = AES128.encrypt4Download(JSON.toJSONString(param), encrypt_key);
            if (StringUtils.isEmpty(jsonEncrypt)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u914d\u7f6e\u4e2d\u7684encrypt_Key\u957f\u5ea6\u4e0d\u662f16\u4f4d", (String)"InvDownloadAction_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error("---AES128.encrypt is error:" + e);
            throw new KDBizException(e.getMessage());
        }
        String raw_response = "";
        try {
            raw_response = this.doPost(url, jsonEncrypt);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u4e0b\u8f7d\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"InvDownloadAction_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        return raw_response;
    }

    @Override
    public String desc() {
        return ResManager.loadKDString((String)"\u4e0b\u8f7d\u53d1\u7968", (String)"InvDownloadAction_2", (String)"fi-arapcommon", (Object[])new Object[0]);
    }
}

