/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.business.piaozone.kingdee.action;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.business.piaozone.info.InvoiceCloudCfg;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AbstractAction;
import kd.fi.arapcommon.util.MD5;

public class UpdateAction
extends AbstractAction {
    private static Log logger = LogFactory.getLog(UpdateAction.class);
    private Object pk;
    private String billNo;
    private long timestamp = new Date().getTime();
    private String userID = String.valueOf(RequestContext.get().getCurrUserId());
    private InvoiceCloudCfg config;
    private Map<String, Object> extendParam = new HashMap<String, Object>(8);

    public UpdateAction(InvoiceCloudCfg config, Object pk, String billNo) {
        this.pk = pk;
        this.billNo = billNo;
        this.config = config;
    }

    public UpdateAction(InvoiceCloudCfg config, Object pk, String billNo, Map<String, Object> extenParam) {
        this.pk = pk;
        this.billNo = billNo;
        this.config = config;
        this.extendParam = extenParam;
    }

    @Override
    public String execute() {
        String domain = KingdeeInvoiceCloudConfig.getDomain4AP();
        String url = domain + "/m4/fpzs/expense/invoice/status/update";
        url = this.addDefaultProtocal(url);
        logger.info("\u66f4\u65b0\u5355\u636e\u63a5\u53e3\uff1a" + url);
        HashMap<String, Object> param = new HashMap<String, Object>();
        String taxNo = this.config.getTaxRegnum();
        param.put("userKey", "");
        param.put("timestamp", this.timestamp);
        param.put("tin", this.config.getTaxRegnum());
        param.put("sign", MD5.md5crypt(this.config.getClientId() + this.config.getClientSecret() + this.timestamp));
        param.put("client_id", this.config.getClientId());
        param.put("expenseStatus", "30");
        param.put("billnumber", this.billNo);
        param.put("bxd_key", "ap_invoice_" + this.pk);
        param.put("eid", this.userID);
        param.put("billTypeId", "");
        if (!ObjectUtils.isEmpty(this.extendParam)) {
            param.putAll(this.extendParam);
        }
        String raw_response = "";
        try {
            raw_response = this.doPost(url, JSON.toJSONString(param));
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u66f4\u65b0\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"UpdateAction_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        logger.info("response : " + raw_response);
        Map response = (Map)JSON.parseObject((String)raw_response, Map.class);
        Object errCode = response.get("errcode");
        if ("0000".equals(errCode)) {
            logger.info("update is success!");
        } else {
            Object desc = response.get("description");
            logger.info("update is error! " + desc + "(" + errCode + ")");
        }
        return raw_response;
    }

    @Override
    public String desc() {
        return "Update Action";
    }
}

