/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.business.piaozone.kingdee.action;

import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.arapcommon.business.piaozone.info.InvoiceCloudCfg;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.IAction;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.util.MD5;

public class UserKeyAction
implements IAction {
    private long timestamp = new Date().getTime();
    private DynamicObject invoice;
    private boolean isAr = true;

    public UserKeyAction(DynamicObject invoice) {
        this.invoice = invoice;
        String extendName = invoice.getDataEntityType().getName();
        if ("ap_invoice".equals(extendName)) {
            this.isAr = false;
        }
    }

    @Override
    public String execute() {
        String domain = KingdeeInvoiceCloudConfig.getDomain4AP();
        String taxRegNum = "";
        if (this.isAr) {
            taxRegNum = this.invoice.getString("sellertin");
        } else {
            InvoiceCloudCfg cfg = KingdeeInvoiceCloudConfig.getConfig(this.invoice.getDynamicObject("org"));
            taxRegNum = cfg.getTaxRegnum();
        }
        DynamicObject clientConfig = KingdeeInvoiceCloudConfig.getClientConfig(taxRegNum);
        String client_id = clientConfig.getString("client_id");
        String client_secret = clientConfig.getString("client_secret");
        String url = domain + "/m4/fpzs/getUserKey";
        String raw_sign = client_id + client_secret + this.timestamp;
        String sign = MD5.md5crypt(raw_sign);
        String billtype = "";
        if ("SAL".equals(this.invoice.get("biztype"))) {
            billtype = "Pur";
        }
        String eid = "";
        DynamicObject org = this.invoice.getDynamicObject("org");
        if (org != null) {
            eid = org.getPkValue().toString();
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("client_id", client_id);
        m.put("sign", sign);
        m.put("timestamp", this.timestamp);
        m.put("tin", taxRegNum);
        m.put("ghf_mc", this.invoice.get(this.isAr ? "sellername" : "buyername"));
        m.put("eid", eid);
        m.put("billNumber", this.invoice.get("billno"));
        m.put("bxd_key", this.invoice.get("billno"));
        m.put("random", String.valueOf(new SecureRandom().nextDouble()));
        m.put("ticketParam", "1101");
        m.put("billType", billtype);
        String jsonStr = JsonUtils.objToJson(m);
        String raw_response = "";
        try {
            raw_response = this.doPost(url, jsonStr);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91userkey\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"UserKeyAction_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        return raw_response;
    }

    @Override
    public String desc() {
        return "UserKeyAction: To get userKey...";
    }
}

