/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.util.DataCheckUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArApJournalExistsDataCheck
extends AbstractDataCheck {
    @Override
    public String getEntityName() {
        return null;
    }

    @Override
    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("sourcebilltype");
        selector.add("sourcebillid");
        return selector;
    }

    @Override
    public QFilter getExtendQFilter() {
        return new QFilter("sourcebillid", ">", (Object)0);
    }

    @Override
    public void setQFilter(QFilter filter) {
        if (EmptyUtils.isEmpty(filter)) {
            return;
        }
        this.defaultFilter = DataCheckUtils.generateNewJournalQFilter(filter);
    }

    @Override
    public boolean isBatch() {
        return true;
    }

    @Override
    public DataCheckResult dataCheck(DynamicObject bill) {
        return null;
    }

    @Override
    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        ArrayList<DataCheckResult> results = new ArrayList<DataCheckResult>(16);
        Map<Long, String> existSourceBillIdMap = this.listExistSourceBillId(billList);
        for (DynamicObject bill : billList) {
            long sourceBillId = bill.getLong("sourcebillid");
            if (!existSourceBillIdMap.containsKey(sourceBillId)) {
                results.add(new DataCheckResult(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5355\u636e\u4fe1\u606f\u3002", (String)"ArApJournalExistsDataCheck_0", (String)"fi-arapcommon", (Object[])new Object[0])));
                continue;
            }
            if (!"D".equals(existSourceBillIdMap.get(sourceBillId)) && !"C".equals(existSourceBillIdMap.get(sourceBillId))) {
                results.add(new DataCheckResult(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u6b63\u786e\u3002", (String)"ArApJournalExistsDataCheck_1", (String)"fi-arapcommon", (Object[])new Object[0])));
                continue;
            }
            results.add(new DataCheckResult());
        }
        return results;
    }

    private Map<Long, String> listExistSourceBillId(List<DynamicObject> billList) {
        Map<String, Set<Long>> billEntityNameToBillIdsMap = this.getBillEntityNameToBillIdsMap(billList);
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        for (Map.Entry<String, Set<Long>> entry : billEntityNameToBillIdsMap.entrySet()) {
            if (EmptyUtils.isEmpty(entry.getKey())) continue;
            QFilter filter = new QFilter("id", "in", entry.getValue());
            DynamicObjectCollection bills = QueryServiceHelper.query((String)entry.getKey(), (String)"id, billstatus", (QFilter[])filter.toArray());
            bills.forEach(bill -> result.put(bill.getLong("id"), bill.getString("billstatus")));
        }
        return result;
    }

    private Map<String, Set<Long>> getBillEntityNameToBillIdsMap(List<DynamicObject> billList) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(16);
        for (DynamicObject bill : billList) {
            String billEntity = bill.getString("sourcebilltype");
            Set values = result.getOrDefault(billEntity, new HashSet(16));
            values.add(bill.getLong("sourcebillid"));
            result.put(billEntity, values);
        }
        return result;
    }
}

